#include "../tl_array.h"
#include "../tl_async_io.h"
#include "../tl_handle.h"
#include "../tl_slice.h"
#include "../tl_string.h"
#include "../tl_async_io.h"

#if defined(WEBSOCKETS_SUPPORT)

namespace tool { namespace async {

// web socket connection
class websocket_connection : public pipe_connection 
{

public:
  enum opcode_t {
    CONTINUATION = 0x0,
    TEXT_FRAME = 0x1,
    BINARY_FRAME = 0x2,
    CLOSE = 8,
    PING = 9,
    PONG = 0xA,
  };

protected:

  typedef pipe_connection super;
  

  struct wsheader_t
  {
    unsigned header_size;
    bool     fin;
    bool     mask;
    opcode_t opcode;
    int    N0;
    uint64 N;
    byte   masking_key[4];
  };

  tool::url   url;
  opcode_t    rxopcode; // stored initial frame opcode
  array<byte> rxdata;
  array<byte> rxbuf;
  array<byte> txbuf;

  bool        use_mask = true;
  bool        is_sending = false;
  bool        is_receiving = false;

  virtual void handle_connect(void) override;
          void handle_initial_read(bytes data);
  virtual void handle_read(bytes data) override;
  virtual void handle_write(void) override;
  virtual void handle_close(void) override;
  virtual void handle_error(int er) override { this->on_error(result_to_string(er)); }

public:
  TOOL_INTERFACE_1(tool, websocket_connection, pipe_connection)

  websocket_connection() {}

  bool connect(tool::url u) {
    this->url = u;
    bool tls = u.protocol == CHARS("wss");
    if(!this->url.port)
      this->url.port = tls ? 443 : 80;
    return super::connect(this->url.hostname, this->url.port, tls);
  }

  bool send_message(bytes out, opcode_t ft);
  
  virtual void on_connected() = 0;
  virtual void on_text(wchars data) = 0;
  virtual void on_data(bytes data) = 0;
  virtual void on_closed() = 0;
  virtual void on_error(chars errm) = 0;
};
} // namespace async
} // namespace tool

#endif