if(NOT sciter_tool_dir)
isl_pwd(sciter_tool_dir)

file(GLOB sciter_tool_sources ${sciter_tool_dir}/*.cpp)
file(GLOB sciter_tool_headers ${sciter_tool_dir}/*.h)

list(REMOVE_ITEM sciter_tool_sources ${sciter_tool_dir}/tl_file_monitor.cpp ${sciter_tool_dir}/tl_lzf.cpp ${sciter_tool_dir}/tl_regexp.cpp)
list(APPEND sciter_tool_sources ${sciter_tool_dir}/ucdata/ucdata_data.inl ${sciter_tool_dir}/ucdata/ucdata_lt.cpp ${sciter_tool_dir}/ucdata/ucpgba_lt.cpp)
list(APPEND sciter_tool_sources ${sciter_tool_dir}/eval/tl_eval_vm.cpp ${sciter_tool_dir}/eval/tl_eval_parser.cpp)

list(REMOVE_ITEM sciter_tool_headers ${sciter_tool_dir}/tl_lzf.h ${sciter_tool_dir}/tl_file_monitor.h ${sciter_tool_dir}/tl_avltree.h ${sciter_tool_dir}/tl_array_bh.h ${sciter_tool_dir}/html_entities_ph.h)
list(APPEND sciter_tool_headers ${sciter_tool_dir}/eval/tl_eval.h ${sciter_tool_dir}/eval/tl_eval_bc.h ${sciter_tool_dir}/eval/tl_eval_parse.h ${sciter_tool_dir}/../config.h)
list(APPEND sciter_tool_headers ${sciter_tool_dir}/ucdata/ucdata_lt.h ${sciter_tool_dir}/ucdata/ucpgba_lt.h)

add_library(tool STATIC ${sciter_tool_sources} ${sciter_tool_headers})

isl_add_cflag(tool "-I${sciter_tool_dir}/../external/zlib/")

isl_add_cflag(tool "-D_LIB")
isl_add_cflag(tool "-D_CRT_SECURE_NO_WARNINGS")
isl_add_cflag(tool "-D_WINDOWS")
isl_add_cflag(tool "-D_WIN32")

endif(NOT sciter_tool_dir)