//|
//|
//| Copyright (c) 2001-2007
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| zip/unzip in memory utils
//|
//|

#ifndef __tl_zip_h
#define __tl_zip_h

#include "tl_array.h"
#include "tl_basic.h"
#include "tl_handle.h"
#include "tl_hash_table.h"
#include "tl_string.h"
#include "tl_ustring.h"

namespace tool {

bool gzip_uncompress(bytes compressed, array<byte> &uncompressed);
bool gzip(bool compress, bytes src, array<byte>& dst, bool gz_format);

#if defined(ZIP_SUPPORT)

struct cabinet : public resource {
  struct item : public resource {
    bool        is_dir;
    string      name;
    array<byte> data;
  };

  hash_table<string, handle<item>> items;
  string                           url;

public:
  static bool is_zip_data(bytes data);

  bool is_empty() const { return items.size() == 0; }
  void clear() {
    url.clear();
    items.clear();
  }

  int unzip(array<byte> &data, const string &url, const char *password = 0);
  int zip(array<byte> &data, const char *password = 0);

  bool exist(const string &path) const { return items.exists(path); }

  bool fetch(const string &path, bytes &data, bool &is_dir) {
    handle<item> itm;
    if (!items.find(path, itm))
      return false;
    data   = itm->data();
    is_dir = itm->is_dir;
    return true;
  }
  bool fetch_file(const string &path, bytes &data) {
    bytes dt;
    bool  is_dir;
    if (fetch(path, dt, is_dir)) {
      if (!is_dir) {
        data = dt;
        return true;
      }
    }
    return false;
  }

  //bool copy(const string &path, const array<byte> &data, bool is_dir);
  bool move(const string &path, array<byte> &data, bool is_dir) {
    handle<item> itm = new item();
    itm->data.swap(data);
    itm->is_dir = is_dir;
    itm->name   = path;
    items[path] = itm;
    return true;
  }
};
#endif
} // namespace tool

#endif