//|
//|
//| Copyright (c) 2001-2017
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| mutex, event, critical_section primitives
//|
//|

#ifndef __tl_sync_h__
#define __tl_sync_h__

#include "external/uv/include/uv.h"

#include "tl_basic.h"
#include "tl_handle.h"

#include <thread>

namespace tool {

  template <class T> class thread_context {
  public:
    void set(T obj) { uv_key_set(&key, obj); }
    T    get() { return static_cast<T>(uv_key_get(&key)); }
    template<typename CTOR> 
    T get(CTOR ctor) {
      T t = get(); 
      if (!t) set(t = ctor());
      return t;
    }


    thread_context() { uv_key_create(&key); }
    ~thread_context() { uv_key_delete(&key); }

  private:
    uv_key_t key;
  };

  /*struct event {
    uv_sem_t h;

    event() { uv_sem_init(&h,0); }
    ~event() { uv_sem_destroy(&h); }
    void signal() { uv_sem(h); }
    //void pulse() { PulseEvent(h); }

    void wait(mutex &m) {
      m.unlock();
      WaitForSingleObject(h, INFINITE);
      m.lock();
    }
    void wait() { WaitForSingleObject(h, INFINITE); }
    void wait(uint timeout) { WaitForSingleObject(h, timeout); }
    NONCOPYABLE(event);
  };*/


  class mutex {
    uv_mutex_t mtx;
    NONCOPYABLE(mutex);
  public:
    void lock() { uv_mutex_lock(&mtx); }
    void unlock() { uv_mutex_unlock(&mtx); }
    mutex() { uv_mutex_init_recursive(&mtx); }
    ~mutex() { uv_mutex_destroy(&mtx); }
  };

  class critical_section {
    mutex &_m;
    NONCOPYABLE(critical_section);
  public:
    critical_section(mutex &m) : _m(m) { _m.lock(); }
    ~critical_section() { _m.unlock(); }
  };

  class semaphore {
    NONCOPYABLE(semaphore);
    uv_sem_t sem;
  public:
    semaphore(uint val) { uv_sem_init(&sem, val); }
    ~semaphore() { uv_sem_destroy(&sem); }

    void signal() { uv_sem_post(&sem); }
    void wait() { uv_sem_wait(&sem); }
    void try_wait() { uv_sem_trywait(&sem); }
  };


#if defined(WINDOWS)
  inline void yield() { ::Sleep(1); }
#else
  inline void yield() { std::this_thread::yield(); }
#endif

  extern mutex lock;
  
}

#endif
