//|
//|
//| Copyright (c) 2001-2005
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| COW ascii string impl.
//|
//|

#include "tool.h"
#include "config.h"

#include "tl_basic.h"
#include "tl_slice.h"
#include "tl_string.h"
#include "tl_ustring.h"
#include <ctype.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#if defined(ANDROID)
  #define _vsnprintf vsnprintf
#elif !defined(WINDOWS)
  #define HAS_UUID
  #define _vsnprintf vsnprintf
  #include <uuid/uuid.h>
#else
  #include <objbase.h>
#endif

namespace tool {

template<>
  void string_t<char, wchar>::set(wchars s) {
    if (s.length) {
#ifdef UTF8_CHARS
      array<byte> out;
      u8::from_utf16(s, out);
      this->operator=(out());
#else
      const int mblength = WideCharToMultiByte(CP_THREAD_ACP, 0, s.start, s.size(), 0, 0, 0, 0);
      if (set_length(mblength))
        WideCharToMultiByte(CP_ACP, 0, s.start, s.size(), buffer(), mblength, 0,0);
#endif
    }
    else
      set_length(0);
  }

template<>
  string_t<char,wchar> string_t<char, wchar>::format_args(const char *fmt, va_list args) 
  {
    struct os : public printf_output_stream {
      tool::array<char> buffer;
      virtual bool      out(int c) {
        buffer.push((char)c);
        return true;
      }
    } os;
    do_vsprintf_os(&os, fmt, args);
    return os.buffer();
  }


// roman digits

const char *Roman_1       = "i";
const char *Roman_5       = "v";
const char *Roman_10      = "x";
const char *Roman_50      = "l";
const char *Roman_100     = "c";
const char *Roman_500     = "d";
const char *Roman_1000    = "m";
const char *Roman_5000    = "v_";
const char *Roman_10000   = "x_";
const char *Roman_50000   = "l_";
const char *Roman_100000  = "c_";
const char *Roman_500000  = "d_";
const char *Roman_1000000 = "m_";

static void roman_digit(const char *one, const char *five, const char *ten,
                        size_t n, string &buf) {
  size_t i;
  switch (n) {
  case 1:
  case 2:
  case 3:
    for (i = 0; i < n; i++)
      buf += one;
    break;
  case 4:
    buf += one;
    buf += five;
    break;
  case 5:
  case 6:
  case 7:
  case 8:
    buf += five;
    for (i = 0; i < n - 5; i++)
      buf += one;
    break;
  case 9:
    buf += one;
    buf += ten;
    break;
  }
}

template<>
string string::roman(uint num, bool ucase) {
  if (num > 3999999)
    return "???";

  string buf;
  roman_digit(Roman_1000000, " ", " ", num / 1000000, buf);
  num %= 1000000;
  roman_digit(Roman_100000, Roman_500000, Roman_1000000, num / 100000, buf);
  num %= 100000;
  roman_digit(Roman_10000, Roman_50000, Roman_100000, num / 10000, buf);
  num %= 10000;
  roman_digit(Roman_1000, Roman_5000, Roman_10000, num / 1000, buf);
  num %= 1000;
  roman_digit(Roman_100, Roman_500, Roman_1000, num / 100, buf);
  num %= 100;
  roman_digit(Roman_10, Roman_50, Roman_100, num / 10, buf);
  num %= 10;
  roman_digit(Roman_1, Roman_5, Roman_10, num, buf);

  if (ucase)
    buf.to_upper();

  return buf;
}

template<>
string string::alpha(uint num, bool ucase) {
  string buf;
  do {
    string t = string(char((num % 26) + 'a' - 1), 1) + buf;
    buf      = t;
    num /= 26;
  } while (num);
  if (ucase)
    buf.to_upper();
  return buf;
}

string unique_id() {
#if defined(WINDOWS)
  char   buffer[80];
  string r;
  UUID   uuid;
  CoCreateGuid(&uuid);
  dword *p = (dword *)&uuid;
  for (uint n = 0; n < sizeof(uuid) / sizeof(dword); n++)
    r += _itoa(p[n], buffer, 36);
  r.to_upper();
  return r;
#elif defined(HAS_UUID)
   uuid_t uu;
   uuid_generate(uu);
   char buffer[80];
   uuid_unparse(uu, buffer);
   return buffer;
#else
  static int count = 12345;
#pragma TODO("uuid generation!")
  return string::format("%X", ++count);
#endif
}


} // namespace tool
