#ifndef __tl_str_s_h__
#define __tl_str_s_h__

#include "tl_config.h"

#ifndef HAS_STR_S

template <size_t size>
inline int strcpy_s(char (&dest)[size], const char *src) {
  if (!src)
    return -1;
  strncpy(dest, src, size);
  return 0;
}
template <size_t size>
inline int wcscpy_s(wchar_t (&dest)[size], const wchar_t *src) {
  if (!src)
    return -1;
  wcsncpy(dest, src, size);
  return 0;
}

template <size_t size>
inline int strncpy_s(char (&dest)[size], const char *src, size_t count) {
  if (!src)
    return -1;
  strncpy(dest, src, min(size, count));
  return 0;
}
template <size_t size>
inline int wcsncpy_s(wchar_t (&dest)[size], const wchar_t *src, size_t count) {
  if (!src)
    return -1;
  wcsncpy(dest, src, min(size, count));
  return 0;
}

template <size_t size>
inline int strcat_s(char (&dest)[size], const char *src) {
  if (!src)
    return -1;
  size_t sz = strlen(dest);
  if (sz >= size)
    return -1;
  strncpy(dest + sz, src, size - sz);
  return 0;
}
template <size_t size>
inline int wcscat_s(char (&dest)[size], const char *src) {
  if (!src)
    return -1;
  size_t sz = wcslen(dest);
  if (sz >= size)
    return -1;
  wcsncpy(dest + sz, src, size - sz);
  return 0;
}

template <size_t size>
inline int vsprintf_s(char (&buffer)[size], const char *format,
                      va_list argptr) {
  return vsnprintf(buffer, size, format, argptr);
}
template <size_t size>
inline int vswprintf_s(char (&buffer)[size], const char *format,
                       va_list argptr) {
  return vswprintf(buffer, size, format, argptr);
}

#define sscanf_s sscan
#define swscanf_s swscanf

#endif

#endif