//|
//|
//| Copyright (c) 2001-2014
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| sciter archive, cab alike thing
//|
//|

#ifndef __tl_sar_h
#define __tl_sar_h

#include "tl_basic.h"
#include "tl_ternary_tree.h"

namespace tool {

class sar {
  struct item_loc {
    uint offset;  // "file" offset
    uint length;  // "file" length
    uint ulength; // "file" original, unpacked length
  };

  lookup_tbl<ustring, true, item_loc> ltbl;
  array<array<byte>>                  udata; // incompressed data
  bytes                               mem;

  bool unpack(bytes data);
  void pack(wchars path, wchars inclusions, wchars exclusions, function<uint(bytes)> out);

  sar() {}

public:
  sar(bytes data) : mem(data) { unpack(mem); }
  bytes get(const wchar *relpath);

  uint nitems() const { return uint(ltbl.items.length()); }

  static void pack_folder(wchars path, wchars inclusions, wchars exclusions,
                          function<uint(bytes)> out) {
    sar t;
    t.pack(path, inclusions, exclusions, out);
  }
};

} // namespace tool

#endif