//|
//|
//| Copyright (c) 2001-2005
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| Memory mapped file
//|
//|

#include "config.h"
#include "tool.h"

#include <stdio.h>

#include "tl_basic.h"
#include "tl_mm_file.h"
#include "tl_ustring.h"

#ifdef POSIX
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/uio.h>
#endif

#if defined(WINDOWS)

#include "win/win-delayload.h"

DLOADV(_GetFinalPathNameByHandleW, GetFinalPathNameByHandleW, kernel32.dll,
       DWORD(WINAPI *)(__in HANDLE                      hFile,
                       __out_ecount(cchFilePath) LPWSTR lpszFilePath,
                       __in DWORD cchFilePath, __in DWORD dwFlags));

#endif

namespace tool {

#if defined(WINDOWS)

void *mm_file::open(const wchar *in_path, bool to_write) {
  read_only = !to_write;

  ustring path = url::file_url_to_path(ustring(in_path));

  hfile = INVALID_HANDLE_VALUE;
  hmap  = INVALID_HANDLE_VALUE;
  ptr   = 0;

#if defined(PLATFORM_WINCE)
  hfile = CreateFileForMapping(
      path, GENERIC_READ | (read_only ? 0 : GENERIC_WRITE),
      FILE_SHARE_READ | (read_only ? 0 : FILE_SHARE_WRITE), nullptr,
      read_only ? OPEN_EXISTING : CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, nullptr);
#else
  hfile = CreateFileW(path, GENERIC_READ | (read_only ? 0 : GENERIC_WRITE),
                      FILE_SHARE_READ | (read_only ? 0 : FILE_SHARE_WRITE),
                      nullptr, read_only ? OPEN_EXISTING : CREATE_ALWAYS,
                      FILE_ATTRIBUTE_NORMAL, nullptr);
#endif

  if (hfile != INVALID_HANDLE_VALUE) {
    if (_GetFinalPathNameByHandleW) {
      wchar buf[MAX_PATH] = {0};
      _GetFinalPathNameByHandleW()(hfile, buf, MAX_PATH, VOLUME_NAME_DOS);
      real_file_name = buf + 4;
    } else
      real_file_name = path;
    length = GetFileSize(hfile, 0);
    hmap   = CreateFileMapping(hfile, nullptr,
                             read_only ? PAGE_READONLY : PAGE_READWRITE, 0,
                             read_only ? 0 : 0x10000000, nullptr);
  } else {
#ifdef _DEBUG
    DWORD erno = GetLastError();
    dbg_printf("ERROR: mm file open <%S> failed %x\n", path.c_str(), erno);
#endif
    return 0;
  }

  if (hfile != INVALID_HANDLE_VALUE && hmap == nullptr) {
    close();
    return 0;
  } else {
    if (hmap != nullptr)
      ptr = MapViewOfFile(hmap, read_only ? FILE_MAP_READ : FILE_MAP_WRITE, 0,
                          0, 0);
    if (ptr == 0) {
#ifdef _DEBUG
      DWORD erno = GetLastError();
      printf("ERROR: map file %x\n", erno);
#endif
      close();
    }
  }
  return ptr;
}

void mm_file::close() {
  if (hfile && hmap && ptr) {

    if (!read_only && length)
      if (!FlushViewOfFile(ptr, length)) {
        printf("Could not flush memory to disk.\n");
      }

    UnmapViewOfFile(ptr);
    ptr = 0;
  }
  if (hmap) {
    CloseHandle(hmap);
    hmap = 0;
  }
  if (hfile && hfile != INVALID_HANDLE_VALUE) {
    if (!read_only && length) {
      SetFilePointer(hfile, LONG(length), 0, FILE_BEGIN);
      SetEndOfFile(hfile);
    }
    CloseHandle(hfile);
    hfile = 0;
  }
}

#elif defined(POSIX)

void *mm_file::open(const wchar *wpath, bool to_write) {
  
  ustring upath = ustring(wpath);

  read_only = !to_write;

  hfile = wopen(upath, to_write ? O_RDWR : O_RDONLY, 0666);
  ptr   = 0;

  if (!hfile || hfile == size_t(-1))
    return 0;

  length = lseek(hfile, 0, SEEK_END);
  lseek(hfile, 0, SEEK_SET);

  ptr = mmap(nullptr, length, PROT_READ | (to_write ? PROT_WRITE : 0),
             MAP_FILE | MAP_SHARED, hfile, 0);
  if (ptr != MAP_FAILED)
    return ptr;

  /*
      int ern = errno;
      ern = EACCES;
  */
  length = 0;
  ptr    = 0;
  close();
  return 0;
}

void mm_file::close() {
  if (ptr)
    munmap(ptr, length);
  ptr    = 0;
  length = 0;
  if (hfile) {
    ::close(hfile);
    hfile = 0;
  }
}

#endif

const char *match(const char *str, const char *pattern) {
  const char ANY    = '*';
  const char ANYONE = '?';
  struct charset {
    bool codes[0x100];
    void set(int from, int to, bool v) {
      for (int i = from; i <= to; i++)
        codes[i] = v;
    }

    void parse(const char **pp) {
      const unsigned char *p   = (const unsigned char *)*pp;
      bool                 inv = *p == '^';
      if (inv) {
        ++p;
      }
      set(0, 0xff, inv);
      if (*p == '-')
        codes['-'] = !inv;
      while (*p) {
        if (p[0] == ']') {
          p++;
          break;
        }
        if (p[1] == '-' && p[2] != 0) {
          set(p[0], p[2], !inv);
          p += 3;
        } else
          codes[*p++] = !inv;
      }
      *pp = (const char *)p;
    }
    bool valid(unsigned char c) { return codes[c]; }
  };
  const char *wildcard = 0;
  const char *strpos   = 0;
  const char *matchpos = 0;
  charset     cset;

  while (true) {
    if (*str == '\0')
      return (*pattern == '\0') ? matchpos : 0;

    if (*pattern == ANY) {
      wildcard = ++pattern;
      strpos   = str;
      if (!matchpos)
        matchpos = str;
    } else if (*pattern == '[') {
      ++pattern;
      cset.parse(&pattern);
      if (!cset.valid((unsigned char)*str))
        return 0;
      if (!matchpos)
        matchpos = str;
      str += 1;
    } else if (*str == *pattern || *pattern == ANYONE) {
      if (!matchpos)
        matchpos = str;
      ++str;
      ++pattern;
    } else if (wildcard) {
      str     = ++strpos;
      pattern = wildcard;
    } else
      break;
  }
  return 0;
}
};
