#ifndef __tl_lsf_h
#define __tl_lsf_h

#include "tl_array.h"
#include "tl_slice.h"

namespace tool {

unsigned int lzf_compress(const void *const in_data, unsigned int in_len,
                          void *out_data, unsigned int out_len);

unsigned int lzf_decompress(const void *const in_data, unsigned int in_len,
                            void *out_data, unsigned int out_len);

namespace lzf {
inline void pack(uint n, array<byte> &out) {
  out.push((byte)(n >> 24));
  out.push((byte)(n >> 16));
  out.push((byte)(n >> 8));
  out.push((byte)(n));
}

inline bool unpack(bytes &in, uint &n) {
  if (in.length < 4)
    return false;
  n = (uint)in++ << 24;
  n |= (uint)in++ << 16;
  n |= (uint)in++ << 8;
  n |= (uint)in++;
  return true;
}

inline uint compress(bytes in, array<byte> &out) {
  pack(uint(in.length), out);
  out.length(4 + in.length * 3 / 2);
  uint compressed_len = lzf_compress(in.start, (uint)in.length, out.begin() + 4,
                                     (uint)out.length() - 4);
  out.length(4 + compressed_len);
  return compressed_len;
}
inline bool decompress(bytes in, array<byte> &out) {
  uint original_length;
  if (!unpack(in, original_length))
    return false;
  out.length(original_length);
  size_t decompressed_len = lzf_decompress(in.start, (uint)in.length,
                                           out.begin(), (uint)out.length());
  return decompressed_len == out.length();
}
} // namespace lzf

}; // namespace tool

#endif
