#ifndef __tl_generator_h__
#define __tl_generator_h__

#include "tl_slice.h"

namespace tool {
//++ coroutine, generator, continuation for C++

struct _generator {
protected:
  int _line;

public:
  _generator() { rewind(); }
  void rewind() { _line = 0; }

  NONCOPYABLE(_generator)
};

#define $generator(NAME) struct NAME : public tool::_generator

#define $emit(T)                                                               \
  bool operator()(T &_rv) {                                                    \
    switch (_line) {                                                           \
    case 0:;
#define $emit2(T1, T2)                                                         \
  bool operator()(T1 &_rv1, T2 &_rv2) {                                        \
    switch (_line) {                                                           \
    case 0:;
#define $emit4(T1, T2, T3, T4)                                                 \
  bool operator()(T1 &_rv1, T2 &_rv2, T3 &_rv3, T4 &_rv4) {                    \
    switch (_line) {                                                           \
    case 0:;

#define $yield(V)                                                              \
  {                                                                            \
    _line = __LINE__;                                                          \
    _rv   = (V);                                                               \
    return true;                                                               \
  case __LINE__:                                                               \
    _line = __LINE__;                                                          \
  }
#define $yield2(V1, V2)                                                        \
  {                                                                            \
    _line = __LINE__;                                                          \
    _rv1  = (V1);                                                              \
    _rv2  = (V2);                                                              \
    return true;                                                               \
  case __LINE__:                                                               \
    _line = __LINE__;                                                          \
  }
#define $yield4(V1, V2, V3, V4)                                                \
  {                                                                            \
    _line = __LINE__;                                                          \
    _rv1  = (V1);                                                              \
    _rv2  = (V2);                                                              \
    _rv3  = (V3);                                                              \
    _rv4  = (V4);                                                              \
    return true;                                                               \
  case __LINE__:                                                               \
    _line = __LINE__;                                                          \
  }

#define $stop                                                                  \
  }                                                                            \
  _line = 0;                                                                   \
  return false;                                                                \
  }

//-- coroutine, generator, continuation for C++

template <typename T> $generator(each) {
  slice<T> r;
  int      n;
  bool     back;
  each(slice<T> range, bool backward = false) : r(range), back(backward) {
    rewind();
  }
  void rewind() {
    if (back)
      n = int(r.length) - 1;
    else
      n = 0;
  }
  $emit(T) rewind();
  if (back) // back
    for (; n >= 0; --n) {
      $yield(r[n]);
    }
  else // forward
    for (; n < int(r.length); ++n) {
      $yield(r[n]);
    }

  $stop
};

} // namespace tool

#endif
