
//#if defined(SCITER)
//#include "osx-sciter.h"
//#endif

#include "tool/tool.h"

extern tool::ustring osx_user_name();
extern tool::ustring osx_user_language();
extern tool::ustring osx_user_region();
extern tool::ustring osx_display_language();
extern tool::ustring osx_os_name();

namespace tool {
    
 bool exec_async(dispatch_queue_t queue, function<bool()>&& f, bool wait)
 {
     function<bool(void)> to_exec = std::move(f);
     if( wait )
        dispatch_sync(queue, ^() {to_exec();});
      else
        dispatch_async(queue, ^() {to_exec();});
      return true;
    }
    
    dispatch_queue_t get_current_dispatch_queue() {
        return dispatch_get_current_queue();
    }

 namespace environment {

    ustring user_name() 
    {
      //return ustring::utf8(jus::bytes_of(juce::SystemStats::getLogonName()));
      return osx_user_name();
    }

    ustring machine_name(bool full) 
    {
      char name [256] = { 0 };
      if (gethostname (name, sizeof (name) - 1) == 0)
          return tool::chars_of(name).r_head(CHARS(".local"));
      return ustring();
    }

    bool get_lang_country(ustring& lang,ustring& country, bool for_user)
    {
        ustring t = osx_display_language().to_lower();
        country = t().tail('-');
        lang = t().head('-');
        //country = osx_user_region();
        return true;
    }

    int get_os_version() {
        return SOME_OSX;
   }

    const char* get_os_version_name()
    {
      static string osname = osx_os_name();
      return osname;
    }
  }

    
    
}
