#ifndef __tiscript_internal_h__
#define __tiscript_internal_h__

#include "cs.h"
#include "tiscript.h"
#include "tool.h"

typedef INT CALLBACK HS_input(LPVOID tag);
typedef INT CALLBACK HS_output(LPVOID tag, int v);



struct xstream: public tis::stream
{
  bool        _binary;
  void *      _tag;
  HS_input*   _in;
  HS_output*  _out;
  tool::ustring name;

  virtual bool is_output_stream() const { return _out != 0; }
  virtual bool is_input_stream() const { return _in != 0; }

  xstream(void *t = 0, HS_input *i = 0, HS_output *o = 0, bool b = false)
  {
    _in = i;
    _out = o;
    _tag = t;
    _binary = b;
  }

  virtual const wchar* stream_name() const { return name; }
  
  virtual int  get() 
  { 
    if( !_in )
      return EOS; 
    return _in(_tag);
  }
  virtual bool put(int ch) { 
    if( !_out)
      return false; 
    return _out(_tag,ch) != 0;
  }
  virtual bool is_file_stream() const { return _binary; }
};

/*struct ext_method: public tis::c_method
{
  tool::string name_buffer;
  func_impl*   pfunc;
  void*        tag;

  ext_method(  const wchar* nm, func_impl *pf, void* t )
  {
    tis::CsInitCMethod(this);
    name_buffer = tool::string(nm);
    name = name_buffer;
    handler = call_handler;
    pfunc = pf;
    tag = t;
  }

  tis::value call(tis::VM *c);

  static tis::value call_handler(tis::VM *c); 

}; */

extern tis::value native_method_invoke(tis::VM *c, tis::value self, void* tag);
extern tis::value native_ctor_invoke(tis::VM *c, tis::value self, void* tag);

struct native_method_def: tis::c_method
{
   native_method_def* next;
   native_method_def(const char* name, TIS_native_method_t* pnm ): 
      tis::c_method((char*)name, strcmp(name, "this") == 0? &native_ctor_invoke: &native_method_invoke,pnm), 
        next(0) {}
};

extern tis::value native_get_invoke(tis::VM *c,tis::value obj, void* tag);
extern void       native_set_invoke(tis::VM *c,tis::value obj, tis::value value, void* tag);

struct native_property_def: public tis::vp_method
{
   native_property_def* next;

   native_property_def(const char* name, TIS_native_property_t* pnp ): 
       tis::vp_method((char*)name,&native_get_invoke, &native_set_invoke, pnp), next(0) {}
};


struct xVM: public tis::VM
{
  xstream _stdin;
  xstream _stdout;
  xstream _stderr;
  void *  _tag;

  native_method_def* methods_top;
  native_property_def* properties_top;

  xVM(void *t, unsigned int flags): tis::VM(flags), _tag(t) 
  {
    methods_top = 0;
    properties_top = 0;
    standardInput = &_stdin;
    standardOutput = &_stdout;
    standardError = &_stdout;  
  }
  ~xVM() 
  {
    native_property_def* pt = properties_top;
    while(pt)
    {
      native_property_def* t = pt;
      pt = pt->next;
      delete t;
    }
    native_method_def* pm = methods_top;
    while(pm)
    {
      native_method_def* t = pm;
      pm = pm->next;
      delete t;
    }
  }

  /*void add_ext_function(const wchar* nm, func_impl* pf, void* t) 
  {
    ext_method* em = new ext_method(nm,pf,t);
    ext_functions.push(em);
    tis::CsEnterFunction(tis::CsGlobalScope(this),em);
  }*/

};






#endif
