
// test, translates all "<thing>" into "[thing]"
function xml_scanner_test(instream)
{
  var xscan = new XMLScanner(instream);
  var t;
  while( true )
  {
    t = xscan.token();
    switch( t )
    {
      case XMLScanner.ERROR: 
          throw "Some error here..."; // need to make this more human friendly
      case XMLScanner.EOF: 
          return; // done!
      case XMLScanner.HEAD:
          stdout << "[" << xscan.tag << " "; 
          break;
      case XMLScanner.EMPTY_HEAD_END: 
          stdout << "/]"; 
          break;
      case XMLScanner.HEAD_END: 
          stdout << "]"; 
          break;
      case XMLScanner.TAIL: 
          stdout << "[/" << xscan.tag << "]"; 
          break;
      case XMLScanner.ATTR: 
          stdout << xscan.attribute << "=\"" << xscan.value << "\" "; 
          break;
      case XMLScanner.TEXT: 
          stdout << xscan.value.htmlEscape(); 
          break;
      case XMLScanner.CDATA: 
          stdout << "[![CDATA[" << xscan.value << "]]]"; 
          break;
      case XMLScanner.PI: 
          stdout << "[?" << xscan.value << "?]"; 
          break;
      default:
          stdout << "!!!!!!!!argh!!!!!!!!!!"; 
          break;
    }
  }
}

var sin = Stream.openFile( "test.xml", "r" );
//var sin = Stream.openString( "<something>anything</something>" );

xml_scanner_test(sin);

stdout << "\ndone!\n";