/* huge test */

function DumpObj( obj )
{
  stdout.printf( "Dumping obj: %V\n", obj);
  return;

  stdout << "dumping object: \n" ;

  for(var n in obj )
  {
    stdout << "Property: '" << n << "'\tValue: typeof '" << typeof(obj[n]) << "' value '" << obj[n] << "'\n";
    
    if(typeof(obj[n]) == "object")
    {
      stdout << "\tsub-object\n";
      DumpObj(obj[n]);
      stdout << "\tend of sub-object\n";
    }
    if(typeof(obj[n]) == "date")
    {
      stdout << "\t\tdate: " << obj[n].toString() << "\n" ;
    }
    
  }
}

// class declaration
var ObjClass = 
{

  constructor : function (obj)
  {
  },
  
  details : function()
  {
    return "ObjClass details ...";
  }
}

function CreateSimpleObj(id)
{
  var obj = { id: id,
          desc1 : "description :)", 
          str2 : "string" + id.toString(),
          int3 : 123,
          date4 : new Date(),
          prototype : ObjClass
          };
          
  return obj;
}



function HugeTest(dbName, recCount)
{
 stdout << "\nTEST: HugeTest\n";
  var s = Storage.open( dbName );
  if(s == null)
  {
    stdout << "FAILED: can't open db for writing\n";
    throw "FAILED: can't open db for writing\n";
  }
  s.registerClass("objclass", ObjClass);
  
  var idx = s.createIndex(#integer);
  var obj = { desc: "root object",
              idx: idx
            };
  
  var i = 0;
  for(i = 0; i < recCount; i++)
  {
    if( !(i%1000) )
      stdout << "creating " << i << " obj\n";
    idx[i] = CreateSimpleObj(i);
  }
  stdout << "created " << idx.length << " objects in index\n";

  s.root = obj;
  s.close();


  
  
  var s1 = Storage.open( dbName, false );
  if(s1 == null)
  {
    stdout << "FAILED: can't open db for reading\n";
    throw "FAILED: can't open db for reading\n";
  }
  s1.registerClass("objclass", ObjClass);
  stdout << "reading root from storage: \n";
  var root = s1.root;
  if( null == root )
  {
    stdout << "FAILED: reading root\n";
    throw "FAILED: reading root\n";
  }
  stdout << "OK loading root\n";
  
  DumpObj(root);
  
  var idx1 = root.idx;
  if( idx1 == null )
  {
    stdout << "Error loading index from storage";
    throw "FAILED";
  }
  stdout << "OK loading index from storage\n";
  
  var count = idx1.length;
  stdout << "number of objs in index = " << count << "\n";
  
  i = 0;
  

  var id = 0;
  for(var obj in root.idx)
  { 
    if( !(i%1000) )
    {
      stdout << "reading " << i << " obj\t";
      stdout << "obj.id " << obj.id << "\t"
      stdout << "Object details: '" << obj.details() << "'\n";
    }
    
    if(obj.id != i)
    {
      stdout << "incorrect data in index\tExpected '" << i << "' got '" << obj.id << "'\n";
      throw "incorrect data in index\n";
    }
    
    i++;
  }
  stdout << "Done with index idx1, last obj: " << i << "\n";

  
  s1.close();
  
  stdout << "OK HugeTest test \n";
}



HugeTest("huge.db", 100000 );
