/* unit test for storage */

function DumpObj( obj )
{
  stdout.printf( "Dumping obj: %V\n", obj);
  return;

  stdout << "dumping object: \n" ;

  for(var n in obj )
  {
    stdout << "Property: '" << n << "'\tValue: typeof '" << typeof(obj[n]) << "' value '" << obj[n] << "'\n";
    
    if(typeof(obj[n]) == "object")
    {
      stdout << "\tsub-object\n";
      DumpObj(obj[n]);
      stdout << "\tend of sub-object\n";
    }
    if(typeof(obj[n]) == "date")
    {
      stdout << "\t\tdate: " << obj[n].toString() << "\n" ;
    }
    
  }
}

function CreateComplexObj()
{
/*  return { desc1 : "description :)", 
          str2 : "string",
          arr3 : [1, 2, 3, "five", 8, 13],
          date4 : new Date(),
          child : {desc : "Child", 
              gender : "boy", 
              age : 10, 
              hobby: "soccer", 
              school: "Secondary", 
              address: "Vancouver",  
              avrScore: 9.5,
              dateBirth: new Date(),
              justBool: true
              }
          };
*/
  return { desc1 : "description :)", 
          str2 : "string",
          arr3 : [1, 2, 3, "five", 8, 13],
          date4 : new Date(),
          child : {desc : "Child", 
              gender : "boy", 
              age : 10, 
              hobby: "soccer", 
              school: "Secondary", 
              address: "Vancouver",  
              avrScore: 9.5,
              dateBirth: new Date(),
              justBool: true
              },
          prototype : ObjClass
          };

}

function CreateSimpleObj(id)
{
  return { id: id,
          desc1 : "description :)", 
          str2 : "string",
          int3 : 123,
          date4 : new Date()
          };
}

// class declaration
type ObjClass 
{ 
  function this(obj)
  {
  }
  function details()
  {
    return "ObjClass details ...";
  }
}

function CreateRootAsObj( dbName )
{
  stdout << "\nTEST CreateRootAsObj() ...\n";
  
  var root = CreateComplexObj();
  DumpObj (root);
  
  var s = Storage.open( dbName );
  
  s.root = root;
  s.close();
  s = null;

  var s1 = Storage.open(dbName);
  //s1.registerClass("objclass", ObjClass);
  var root1 = s1.root;

  DumpObj(root1);
  stdout << "checking a prototype ... " << root1.details() << "  OK!";
  s1.close();
  
  stdout << "TEST CreateRootAsObj() OK\n";
}


function CreateRootAsArray(dbName)
{
  stdout << "\nTEST: create root as an array\n";
  var a = [1, 2, 3, "five", 8, 13];
  
  stdout << "setting root as: \n";
  DumpObj( a );
  
  var s = Storage.open( dbName );
  if(s == null)
    stdout << "FAILED: can't open db for writing\n";
  s.root = a;
  s.close();
  
  
  s = Storage.open( dbName );
  if(s == null)
  {
    stdout << "FAILED: can't open db for reading\n";
    return;
  }
  stdout << "reading root from storage: \n";
  if( null == s.root )
  {
    stdout << "FAILED: creating root as an array\n";
    return;
  }
  DumpObj( s.root );
  s.close();
  
  stdout << "OK creating root as an array\n";
}


function CreateRootAsIndex(dbName)
{
  stdout << "\nTEST: create root as an index\n";
  var s = Storage.open( dbName );
  if(s == null)
    throw "FAILED: can't open db for writing\n";
    
  var idx = s.createIndex(#integer);
  for(var i = 0; i < 10; i++)
    idx[i] = CreateSimpleObj(i);
  
  s.root = idx;
  s.close();
  
  
  s = Storage.open( dbName );
  if(s == null)
  {
    throw "FAILED: can't open db for reading\n";
  }
  stdout << "reading root from storage: \n";
  if( null == s.root )
  {
    throw "FAILED: creating root as an index\n";
  }
  
  var i = 0;
  for(var obj in s.root)
  { 
    if(obj.id != i)
      throw "incorrect data in index\n";
    i++;
  }
  
  s.close();
  
  stdout << "OK creating root as an index\n";
}


function Create2Dbs( dbName1, dbName2 )
{
  stdout << "\nTEST: create 2 DBs at once\n";
  
  var obj = CreateComplexObj();
  
  DumpObj (obj);
  
  var s1 = Storage.open( dbName1 );
  if(s1 == null)
  {
    stdout << "FAILED: can't open db1 for writing\n";
    return;
  }
  s1.root = obj;
  
  var s2 = Storage.open( dbName2 );
  if(s2 == null)
  {
    stdout << "FAILED: can't open db2 for writing\n";
    return;
  }
  s2.root = obj;
  
  s1.close();
  s2.close();
  stdout << "OK writing into DBs\n";
  
  stdout << "Test reading from DBs\n";
  s1 = Storage.open( dbName1 );
  if(s1 == null)
  {
    stdout << "FAILED: can't open db for reading\n";
    return;
  }
  stdout << "reading root from storage: \n";
  if( null == s1.root )
  {
    stdout << "FAILED: creating root as an array\n";
    return;
  }
  DumpObj( s1.root );
  
  s2 = Storage.open( dbName2 );
  if(s2 == null)
  {
    stdout << "FAILED: can't open db for reading\n";
    return;
  }
  stdout << "reading root from storage: \n";
  if( null == s2.root )
  {
    stdout << "FAILED: creating root as an array\n";
    return;
  }
  DumpObj( s2.root );
  
  s2.close();
  s1.close();
  
  stdout << "OK: create 2 DBs at once\n";
}


function HugeTest(dbName, recCount)
{
 stdout << "\nTEST: HugeTest\n";
  var s = Storage.open( dbName );
  if(s == null)
    throw "FAILED: can't open db for writing\n";
    
  var idx = s.createIndex(#integer);
  for(var i = 0; i < recCount; i++)
    idx[i] = CreateSimpleObj(i);
  
  s.root = idx;
  s.close();
  
  
  s = Storage.open( dbName );
  if(s == null)
  {
    throw "FAILED: can't open db for reading\n";
  }
  stdout << "reading root from storage: \n";
  if( null == s.root )
  {
    throw "FAILED: reading root\n";
  }
  
  var i = 0;
  for(var obj in s.root)
  { 
    if(obj.id != i)
      throw "incorrect data in index\n";
    i++;
  }
  
  s.close();
  
  stdout << "OK HugeTest test \n";
}




  CreateRootAsObj( "test.db" );
  stdout << "GC after CreateRootAsObj() \n";
  gc();


/*try
{
  CreateRootAsArray("root_array.db");
}
catch (ex)
{ 
  stdout << "\nTest 'CreateRootAsArray' FAILED\n"
}

try
{
  CreateRootAsIndex("root_index.db");
}
catch (ex)
{ 
  stdout << "\nTest 'CreateRootAsArray' FAILED\n"
}

try
{
  Create2Dbs("test1.db", "test2.db" );
}
catch (ex)
{ 
  stdout << "\nTest 'Create2Dbs' FAILED\n"
}


try
{
  HugeTest("huge.db", 10000 );
}
catch (ex)
{ 
  stdout << "\nTest 'HugeTest' FAILED\n"
}

*/
