/* cs_instanceof.c - 'instanceof' implementation

        Copyright (c) 2001-2004 Terra Informatica Software, Inc.
        and Andrew Fedoniouk andrew@terrainformatica.com
        All rights reserved

*/

#include "cs.h"

namespace tis {

  bool CsInstanceOf(VM *c, value obj, value cls) {
    //dispatch *desiredType = CsGetDispatch(cls);
    //dispatch *type = CsGetDispatch(obj);

    if (CsCObjectP(cls)) {
      dispatch *desiredType = (dispatch *)CsCObjectValue(cls);
      dispatch *type        = CsGetDispatch(obj);
      if (type == desiredType) return true;
      if (type->baseType == desiredType) return true;
      return false;
    }
    else if (CsObjectP(obj) && CsMethodP(cls)) {
      if (!CsObjectOrMethodP(cls)) {
        if (c)
          CsTypeError(c, cls);
        else
          return false;
      }
      obj = CsObjectClass(obj);
      for (;;) {
        if (obj == cls) break;
        if (!obj || obj == UNDEFINED_VALUE) return false;
        if(CsObjectP(obj) && (CsEntityFlags(obj) & IS_PROTOTYPE_OBJECT))
        {
          value ctor = 0;
          if (CsGetProperty(c, obj, CONSTRUCTOR_SYM, &ctor) && ctor == cls)
            return true;
        }
        obj = CsObjectClass(obj);
      }
      return true;
    } else if (CsEntityP(obj)) {
      if (!CsEntityP(cls)) {
        if (c)
          CsTypeError(c, cls);
        else
          return false;
      }
      //obj = CsObjectClass(obj);
      for (;;) {
        if (obj == cls) break;
        if (!obj || obj == UNDEFINED_VALUE) return false;
        obj = CsObjectClass(obj);
      }
      return true;
    } else if (CsVectorP(obj)) {
      if (cls == c->vectorObject) return true;
      obj = CsVectorClass(obj);
      for (;;) {
        if (obj == cls) break;
        if (!obj || obj == UNDEFINED_VALUE) return false;
        obj = CsObjectClass(obj);
      }
      return true;
    }

    // else
    //    CsTypeError(c,cls);
    return false;
  }

  extern int_t CsVectorIndexOf(VM *c, value vector, value val);

  bool CsHasMember(VM *c, value obj, value tag) {
    value t = tag;
    /*if(!CsSymbolP(t))
    {
      t = CsToString(c,t);
      t = CsIntern(c,t);
    }*/
    if (CsVectorP(obj))
      return CsVectorIndexOf(c, obj, tag) >= 0;
    else
      return CsGetProperty(c, obj, t, &tag);
  }

} // namespace tis
