#include "cs.h"

//#include "sdk/include/sciter-x.h"
#include "sdk-headers.h"


#if defined(LINUX) || defined(OSX)
  #include <dlfcn.h>
#endif


namespace tis {
  bool CsLoadExtLibrary(CsScope *scope, tool::ustring fullpath, tool::value& val) {

#ifdef SCITER 

    tool::ustring filename = url::file_url_to_path(fullpath);
  #ifdef WINDOWS
    if (!filename.like(W("*.dll"))) {
      fullpath = tool::ustring::format(W("%s.dll"), filename.c_str());
      filename = fullpath;
    }
    HMODULE hmod = LoadLibraryEx(filename.c_str(), NULL, LOAD_WITH_ALTERED_SEARCH_PATH);
    if (!hmod) return false;
    /*if(TIScriptLibraryInitFunc *pentry = (TIScriptLibraryInitFunc *)GetProcAddress(hmod, "TIScriptLibraryInit"))
    {
      pentry((tiscript_VM *)c, &native_interface);
      // WTF?: FreeLibrary(hmod);
      return true;
    }*/
    if (SciterLibraryInitFunc *pentry = (SciterLibraryInitFunc *)GetProcAddress(hmod, "SciterLibraryInit"))
    {
      pentry(SciterAPI(),(SCITER_VALUE*)&val);
      if (val.is_asset()) {
        som_asset_t* pass = val.get_asset();
        if (pass) {
          som_passport_t* psp = sciter::om::asset_get_passport(pass);
          CsAddConstant(scope->c, scope->globals, psp->name, CsMakeAssetObject(scope->c,pass));
          return true;
        }
      }
      if(val.is_defined())
          return true;
    }
    FreeLibrary(hmod);
  #else
      
    if (!filename.like(W("*.so")) || !filename.like(W("*.dylib"))) {
      #ifdef OSX
        fullpath = tool::ustring::format(W("%s.dylib"), filename.c_str());
      #else
        fullpath = tool::ustring::format(W("%s.so"), filename.c_str());
      #endif
        
      filename = fullpath;
    }
    void *hmod = dlopen(tool::string(filename.c_str()), RTLD_LAZY);
    if (!hmod) return false;
    /*if (TIScriptLibraryInitFunc *pentry =
      (TIScriptLibraryInitFunc *)dlsym(hmod, "TIScriptLibraryInit")) {
      pentry((tiscript_VM *)c, &native_interface);
      return true;
    }*/
    if (SciterLibraryInitFunc *pentry = (SciterLibraryInitFunc *)dlsym(hmod, "SciterLibraryInit"))
    {
      pentry(SciterAPI(), (SCITER_VALUE*)&val);
      if (val.is_asset()) {
        som_asset_t* pass = val.get_asset();
        if (pass) {
          som_passport_t* psp = sciter::om::asset_get_passport(pass);
          CsAddConstant(scope->c, scope->globals, psp->name, CsMakeAssetObject(scope->c, pass));
          return true;
        }
      }
      if(val.is_defined())
        return true;

    }

    dlclose(hmod);
  #endif
#endif
    return false;
  }
} // namespace tis

