#include "d2d/d2d.h"

namespace d2d {

  class d2d_lite_view : public lite::view 
  {
  public:
    DEFINE_TYPE_ID_DERIVED(d2d_lite_view, lite::view)

    com::asset<IDXGISurface> p_surface;
    
    d2d_lite_view(const window_params& params) : super(params) {}

    virtual void on_size(size sz) override {
      p_surface = nullptr;
      _gfx = nullptr;
      super::on_size(sz);
    }

    virtual bool set_target_surface(void* pSurface) { 
      if ((p_surface == pSurface) && _gfx)
        return true;
      p_surface = (IDXGISurface*)pSurface;
      if (!p_surface)
        return false;
      _gfx = dx_surface_graphics::create(p_surface);
      return _gfx.is_defined();
    }

    virtual bool needs_opengl() { return false; }

    virtual void setup_text_flow(html::element *elem, 
        html::tflow::text_flow &tf,
        tool::slice<tool::handle<html::node>> nodes) override 
    {
      d2d::text_analysis::exec(*this, elem, tf, nodes);
    }
    virtual void draw_glyph_run(gool::graphics *gfx,
      const html::tflow::text_flow &tf,
      const html::tflow::glyph_run &gr,
      gool::pointf at, argb color,
      const style *run_style) override 
    {
      app.ptr_of<d2d::application>()->draw_glyph_run(this, gfx, tf, gr, at, color, run_style);
    }

    virtual bool render(void *dc, rect client_rc) 
    {
      size client_dim = this->client_dim();
      if (client_dim.empty()) return false;

      handle<document> pdoc = doc();
      if (!pdoc) return false;

      d2d::graphics *gfx = static_cast<d2d::graphics *>(surface());

      com::asset<ID2D1RenderTarget> rt = gfx->render_target();
      if (!rt) return false;

      rt->BeginDraw();
      rt->Clear(D2D1::ColorF(D2D1::ColorF::Black, 0.0f));

      rt->Clear(D2D1::ColorF(D2D1::ColorF::White, 0.0f));

      auto_state<gool::graphics *> _1(drawing_surface, _gfx.ptr());

      rect paint_rc = client_rc.empty() ? client_dim : client_rc; // invalid; - layered gets redrawn in full.

      gfx->set_clip_rc(paint_rc);

      if (!pdoc->is_layout_valid()) {
        pdoc->commit_measure(*this);
        paint_rc = client_dim;
      }

      D2D1_RECT_F clip = g2f(paint_rc);
      rt->PushAxisAlignedClip(clip, D2D1_ANTIALIAS_MODE_ALIASED);
      paint(nullptr, true);
      rt->PopAxisAlignedClip();

      HRESULT hr = rt->EndDraw();

      if (FAILED(hr))
        pdoc->drop_caches();

      invalid = rect();

      return true;

    }

    virtual bool render_element(element *el, bool front_layer) override {

      size client_dim = this->client_dim();
      if (client_dim.empty()) return false;

      if (el->pview() != this) return false;

      handle<document> pdoc = doc();
      if (!pdoc) return false;

      d2d::graphics *gfx = static_cast<d2d::graphics *>(surface());

      com::asset<ID2D1RenderTarget> rt = gfx->render_target();
      if (!rt) return false;

      rt->BeginDraw();

      //if(!front_layer)
      //  rt->Clear(D2D1::ColorF(D2D1::ColorF::Black, 0.0f));

      auto_state<gool::graphics *> _1(drawing_surface, _gfx.ptr());

      rect paint_rc = client_dim; // invalid; - layered gets redrawn in full.

      gfx->set_clip_rc(paint_rc);

      if (!pdoc->is_layout_valid()) {
        pdoc->commit_measure(*this);
        paint_rc = client_dim;
      }

      D2D1_RECT_F clip = g2f(paint_rc);
      rt->PushAxisAlignedClip(clip, D2D1_ANTIALIAS_MODE_ALIASED);
      paint(el, front_layer);
      rt->PopAxisAlignedClip();

      HRESULT hr = rt->EndDraw();

      if (FAILED(hr))
        pdoc->drop_caches();

      invalid = rect();

      return true;

    }

  };

  lite::view* application::create_window_processor(const window_params& params) {
    return new d2d_lite_view(params);
  }
  
}