#include "xgl/xgl-window-base.h"

#include "xgl/skia/include/gpu/gl/GrGLInterface.h"
#include "xgl/skia/include/gpu/GrContext.h"
#include "xgl/skia/src/gpu/gl/GrGLUtil.h"
#include "xgl/skia/include/gpu/SkGr.h"

#if defined(NATIVE_WINDOWS_BACKEND)
#elif defined(ANDROID)
  #include <EGL/egl.h>
  #include <GLES/gl.h>
#elif defined(LINUX)
   #if DEVICE==IOT
     #include <EGL/egl.h>
     #include <EGL/eglext.h>
     #include <GLES2/gl2.h>
   #else
     #include <GLES2/gl2.h>
     #include <GLES2/gl2ext.h>
   #endif
#endif

namespace xgl {

  //| "primitive" raster device - rasterization by CPU in memory
  float BackendDevice::backing_scale() const { return 1; }

  void BackendDevice::on_dpi_change() {}

  bool DeviceRaster::render_layered(function<bool(xgl::graphics *gfx)> painter,  gool::rect paint_rc, void *hdc) {
#if 1
    return false;
#else
    size dim(this->width(), this->height());

    if (dim.empty()) return false;

    // if (paint_rc.empty())
    //  return false;

    dib32 dib(dim);

    SkImageInfo info = SkImageInfo::MakeN32Premul(dim.x, dim.y);
    fBitmap.setInfo(info);
    fBitmap.setPixels(dib.bits());

    HWND hwnd = this->getHWnd();

    mswin::layered_window_ctx lwctx(dim);
    {
      xgl::ref<SkCanvas> canvas = new SkCanvas(fBitmap);
      canvas->ref();
      handle<xgl::graphics> gfx = new xgl::graphics(canvas);
      gfx->text_paint.setLCDRenderText(false);
      // gfx->offset(-paint_rc.origin);
      gfx->set_clip_rc(dim);
      painter(gfx);
    }

    lwctx.update(hwnd, dib.DC());
    fBitmap.reset();

    return true;
#endif
  }

  bool DeviceRaster::present(rect paint_rc, void *hdc) {
#if 0
    slice<gool::argb> in((const gool::argb*) fBitmap.getPixels(), fBitmap.width() * fBitmap.height());

    array<gool::argb> buf = in;

    gool::argb* p = buf.begin();
    gool::argb* pe = buf.end();

    for (; p < pe; ++p)
      swap(p->red, p->blue);

    ...

#endif
      return true;
  }

  //| OpenGL device:

  void DeviceOpenGL::refresh(iwindow *self, const rect &area) {
    self->iwindow::refresh(area);
    // self->request_render_layered();
  }

  void DeviceOpenGL::enable_vsync(bool enable) {
    // TODO: GLX_EXT_swap_control, glXSwapIntervalEXT(1)
  }

  bool DeviceOpenGL::init() {

#if 0
    const EGLint attribs[] = { EGL_SURFACE_TYPE, EGL_WINDOW_BIT,
      EGL_BLUE_SIZE,    8,
      EGL_GREEN_SIZE,   8,
      EGL_RED_SIZE,     8,
      EGL_DEPTH_SIZE,   0,
      EGL_STENCIL_SIZE, 8,
      EGL_NONE };
    // EGLint       w, h;
    EGLint     format;
    EGLint     numConfigs;
    EGLConfig  config;
    EGLSurface surface;
    EGLContext context;

    EGLDisplay display = eglGetDisplay(EGL_DEFAULT_DISPLAY);

    eglInitialize(display, 0, 0);

    /* Here, the application chooses the configuration it desires. In this
    * sample, we have a very simplified selection process, where we pick
    * the first EGLConfig that matches our criteria */
    eglChooseConfig(display, attribs, &config, 1, &numConfigs);


    /* EGL_NATIVE_VISUAL_ID is an attribute of the EGLConfig that is
    * guaranteed to be accepted by ANativeWindow_setBuffersGeometry().
    * As soon as we picked a EGLConfig, we can safely reconfigure the
    * ANativeWindow buffers to match, using EGL_NATIVE_VISUAL_ID. */
    eglGetConfigAttrib(display, config, EGL_NATIVE_VISUAL_ID, &format);

    ANativeWindow_setBuffersGeometry(getHWnd(), 0, 0, format);

    surface = eglCreateWindowSurface(display, config, getHWnd(), NULL);

    EGLint openGLVersionRequested = 3;
    EGLint contextAttribs[] = {
      EGL_CONTEXT_CLIENT_VERSION,
      openGLVersionRequested, // selects OpenGL ES 3.0, set to 2 to select
                              // OpenGL ES 2.0
                              EGL_NONE };

    context = eglCreateContext(display, config, NULL, contextAttribs);

    if (eglMakeCurrent(display, surface, surface, context) == EGL_FALSE) {
      // LOGW("Unable to eglMakeCurrent");
      return -1;
    }

    // eglQuerySurface(display, surface, EGL_WIDTH, &w);
    // eglQuerySurface(display, surface, EGL_HEIGHT, &h);

    this->display = display;
    this->context = context;
    this->surface = surface;
    // this->width         = w;
    // this->height        = h;
    // engine->state.angle = 0;

    //eglSwapInterval(display, 0); // no effect
#endif

    // Initialize GL state.
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
    glEnable(GL_CULL_FACE);
    glShadeModel(GL_SMOOTH);
    glDisable(GL_DEPTH_TEST);

    glViewport(0, 0, width(), height());
    glClearColor(0, 0, 0, 0);
    glClearStencil(0);
    glClear(GL_STENCIL_BUFFER_BIT | GL_COLOR_BUFFER_BIT);



#if 0
    if (!fGLContext)
    {

      if (fGLContext) {
        //gtk_gl_area_make_current (GTK_GL_AREA(widget));
        glViewport(0, 0, width(), height());
        glClearColor(0, 0, 0, 0);
        glClearStencil(0);
        glClear(GL_STENCIL_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
        return true;
      }
      else {
        //er = gtk_gl_area_get_error(GTK_GL_AREA(widget));
      }
      er = er;
      return false;
    }
#endif
    return true;
  }

  bool DeviceOpenGL::attach() {
    super::resize(this->width(), this->height());
    return true;
  }

  bool DeviceOpenGL::detach() {
#if 0
    if (display != EGL_NO_DISPLAY) {

      eglMakeCurrent(display, EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT);
      if (context != EGL_NO_CONTEXT) eglDestroyContext(display, context);

      if (surface != EGL_NO_SURFACE) eglDestroySurface(display, surface);

      eglTerminate(display);

      display = EGL_NO_DISPLAY;
      context = EGL_NO_CONTEXT;
      surface = EGL_NO_SURFACE;

      SkSafeUnref(fRenderTarget);
      SkSafeUnref(fContext);
      SkSafeUnref(fInterface);
    }
#else
    if (fRenderTarget) {
      SkSafeUnref(fRenderTarget); fRenderTarget = nullptr;
      SkSafeUnref(fContext);
      SkSafeUnref(fInterface);
    }
#endif
    return true;
  }

  bool DeviceOpenGL::present() {
#if 0
    eglSwapBuffers(display, surface);
#endif
    return true;
  }

  void DeviceOpenGL::setUpRenderTarget() {
    SkSafeUnref(fRenderTarget);
    GrBackendRenderTargetDesc desc;
    desc.fWidth = (this->width());
    desc.fHeight = (this->height());
    desc.fConfig = kSkia8888_GrPixelConfig;
    desc.fOrigin = kBottomLeft_GrSurfaceOrigin;
    desc.fSampleCnt = 0;
    desc.fStencilBits = 8; // Skia requirement
    GrGLint buffer;
    GR_GL_GetIntegerv(fInterface, GR_GL_FRAMEBUFFER_BINDING, &buffer);
    desc.fRenderTargetHandle = buffer;
    this->fRenderTarget = fContext->wrapBackendRenderTarget(desc);
  }

  bool DeviceOpenGL::update_request() { return false; }

  void DeviceOpenGL::start_drawing() {}

  bool DeviceOpenGL::render(function<bool(xgl::graphics *gfx)> painter,
    gool::rect paint_rc, void *hdc) {
    if (paint_rc.empty()) {
      //assert(false);
      return false;
    }

    // glClearColor (0, 0, 0, 0);
    // glClearStencil(0);
    // glClear (GL_STENCIL_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
    SkAutoTUnref<SkSurface> surface(createSurface());
    if (!surface) return false;
    SkCanvas *canvas = surface->getCanvas();
    if (!canvas) {
      // glXMakeCurrent(GDK_WINDOW_XDISPLAY(fXWindow), None, nullptr);
      // puts("no canvas!");
      return false;
    }

    SkAutoCanvasRestore acr(canvas, true);

    SkIRect ir;
    ir.set(0, 0, this->width(), this->height());

    // SkRegion dirty(ir);
    // canvas->clipRegion(dirty);

    // canvas->clear(SK_ColorRED);

    {
      handle<xgl::graphics> gfx = new xgl::graphics(canvas, false);
      gfx->set_clip_rc(paint_rc);
      painter(gfx);
    }

    // SkRect rr = SkRect::MakeXYWH(0,0,this->width()/2, this->height()/2);
    // SkPaint paint;
    // paint.setColor(SK_ColorRED);
    // canvas->drawRect(rr,paint);
    // canvas->clear(SK_ColorRED);

    fContext->flush();

    present();

    return true;
  }
}
