#include "lite.h"

namespace lite {

  SBOOL CALLBACK view::proc_x(HWINDOW hwnd, SCITER_X_MSG *pMsg) {
    if (pMsg->msg == SXM_CREATE) {
      SCITER_X_MSG_CREATE *pMsgCreate = (SCITER_X_MSG_CREATE *)pMsg;

      (void)pMsgCreate;

      handle<view> pw = ptr<view>(hwnd);
      if (pw) // the engine has been initialized already on that window.
              // that happens when WM_CREATE and WM_INITDIALOG are *both* sent
              // to the winproc by
              // CreateDialogIndirect/CreateDialogIndirectParam, quote:
              //     The CreateDialogIndirect macro uses the CreateWindowEx
              //     function to create the dialog box. CreateDialogIndirect
              //     then sends a WM_INITDIALOG message to the dialog box
              //     procedure.
        return FALSE;

      bool rtl_env = false;
      window_params params;
      params.window_type = FRAME_WINDOW;
      params.parent = NULL;
      params.rtl = rtl_env;
      params.owns_vm = FALSE;
      
      try {
        pw = lite::app()->create_window_processor(params);
        pw->set_hwnd(hwnd);
        pw->start(window_params());
        pw->reset_resolution();
      }
      catch (std::bad_alloc &) { return FALSE; }
      return TRUE;
    }

    handle<view> pw = ptr<view>(hwnd);
    if (!pw) return FALSE;

    html::current_view_state thread_state(pw);

    switch (pMsg->msg) {
    case SXM_DESTROY: {
      pw->stop();
      pw->set_hwnd(nullptr);
      thread_state.drop_current();
      return TRUE;
    }
    case SXM_SIZE: {
      SCITER_X_MSG_SIZE *pMsgSize = (SCITER_X_MSG_SIZE *)pMsg;
      size sz;
      sz.x = int(pMsgSize->width);
      sz.y = int(pMsgSize->height);
      pw->on_size(sz);
      return TRUE;
    }
    case SXM_RESOLUTION: {
      SCITER_X_MSG_RESOLUTION *pMsgResolution = (SCITER_X_MSG_RESOLUTION *)pMsg;
      size sz;
      sz.x = int(pMsgResolution->pixelsPerInch);
      sz.y = int(pMsgResolution->pixelsPerInch);
      gool::resolution_provider::desktop().pixels_per_inch(sz);
      return TRUE;
    }
    case SXM_PAINT: 
    {
      SCITER_X_MSG_PAINT *pMsPaint = (SCITER_X_MSG_PAINT *)pMsg;

      switch (pMsPaint->targetType) {
        case SPT_SURFACE:
          if (!pw->set_target_surface(pMsPaint->target.pSurface))
            return false;
          // fall through
        case SPT_DEFAULT:
          if(pMsPaint->element)
            return pw->render_element(pMsPaint->element, !!pMsPaint->isFore) ? TRUE : FALSE;
          else 
            return pw->render(nullptr, gool::rect(pw->client_dim()));
        case SPT_RECEIVER: {
          auto cb = [pMsPaint](gool::bitmap *dst, point view_pos) {
            size dim = dst->dim();
            pMsPaint->target.receiver.callback(
              (LPCBYTE)dst->get_bits().start, view_pos.x, view_pos.y,
              uint(dim.x), uint(dim.y), pMsPaint->target.receiver.param);
          };
          pw->paint(cb, pMsPaint->element, !!pMsPaint->isFore);
          return TRUE;
        }
      }
    }

    case SXM_HEARTBIT: {
      SCITER_X_MSG_HEARTBIT *pmsg = (SCITER_X_MSG_HEARTBIT *)pMsg;
      if (pw->has_animations())
        pw->on_animation_tick();
      pw->check_timers_overdue_in_all_views();
      pw->on_idle();
      //pMsg->header.invalid = gool::toRECT(pw->invalid);
      return TRUE;
    }

    case SXM_MOUSE: {
      SCITER_X_MSG_MOUSE *pmsg = (SCITER_X_MSG_MOUSE *)pMsg;
      return pw->on_mouse(pmsg->event, pmsg->button, pmsg->modifiers, gool::point(pmsg->pos.x,pmsg->pos.y));
      //pMsg->header.invalid = gool::toRECT(pw->invalid);
    }

    case SXM_KEY: {
      SCITER_X_MSG_KEY *pmsg = (SCITER_X_MSG_KEY *)pMsg;
      return pw->on_key(pmsg->event, int(pmsg->code), pmsg->modifiers);
      //pMsg->header.invalid = gool::toRECT(pw->invalid);
    }

    case SXM_FOCUS: {
      SCITER_X_MSG_FOCUS *pmsg = (SCITER_X_MSG_FOCUS *)pMsg;
      return pw->on_focus(!!pmsg->got);
      //pMsg->header.invalid = gool::toRECT(pw->invalid);
    }


    }
    return FALSE;
  }

  void view::set_timer(uint_ptr id, uint ms, uint_ptr &sys_id) {}
  bool view::on_timer(uint_ptr uid) { return super::on_timer(uid); }

  iwindow *view::create_window(
    html::element *forel, html::element *anchor, html::WINDOW_TYPE wt,
    function<rect(html::view &, html::element *, html::element *)> setup_and_calc_place, ELEMENT_WINDOW_MODE mode) 
  {
    popup* pup = new lite::popup(this);
    pup->root(forel);
    pup->anchor(anchor);
    windows.push(pup);

    rect wrc = setup_and_calc_place(*this, forel, anchor);
    pup->pos = wrc.start();
    pup->dim = wrc.size();
    //forel->set_border_pos(wrc.origin);
    //forel->set_border_dim(wrc.size());
    
    return pup;
  }
  bool view::close_popup(element *b, bool set_auto_focus) { 
    handle<iwindow> hw = b->window(*this);
    if (!hw) return false;
    super::close_popup(b, set_auto_focus);
    this->forget_window(hw);
    return true;
  }

  void view::paint(element *to_draw, bool front_layer)
  {
    super::paint(to_draw, front_layer);
    if (front_layer) {
      graphics* pg = surface();
      for (auto pw : windows) {
        pw->root()->draw(*this, pg, pw->pos);
      }
    }
  }

  void view::paint(function<void(gool::bitmap *dst, point view_pos)> cb, element *to_draw, bool front_layer) {
    
    handle<document> pd = doc();

    invalid = rect();

    if (!pd) return;

    to_update.update(this);

    measure_document();

    gool::rect  area;
    gool::point offs(0, 0);
    gool::point vpos(0, 0);

    if (!to_draw)
      area = gool::rect(client_dim());
    else {
      point vp = to_draw->view_pos(*this);
      point rp = vp - point(to_draw->ldata->borpad_left(),
        to_draw->ldata->borpad_top());
      rect  rc(vp, to_draw->dim());
      rc >>=
        rect(to_draw->ldata->borpad_left(), to_draw->ldata->borpad_top(),
          to_draw->ldata->borpad_right(), to_draw->ldata->borpad_bottom());
      area = rc;
      offs = rp;
      vpos = rc.start();
    }

    handle<gool::bitmap> bmp = new gool::bitmap(area.size(), true, true);
    {
      handle<graphics> gfx =
        app->create_bitmap_bits_graphics(bmp, gool::argb(0, 0, 0, 0));

      auto_state<gool::graphics *> _1(drawing_surface, gfx);
      auto_state<resolution_provider*> _2(gfx->pview, this);
      gfx->set_drawing_root(pd);

#ifdef _DEBUG
      if (!pd->is_layout_valid())
        dbg_printf("PANIC: view::paint INVALID LAYOUT!\n");
#endif
      gfx->begin_drawing();

      if (to_draw)
        to_draw->draw(*this, gfx, to_draw->view_pos(*this));
      else
        pd->draw(*this, gfx, point(0, 0));

      if (front_layer)
        for (int n = 0; n < moved_elements.size();) {
          helement el = moved_elements[n];
          if (el->pview() != this)
            moved_elements.remove(n);
          else if (el->airborn) {
            if (el->airborn->type == AIRBORN_INPLACE) {
              size prsize = el->airborn->dim;
              if (el->airborn->dim.x.is_defined() && prsize != el->dim()) {
                el->set_width(*this, prsize.x);
                el->set_height(*this, prsize.y);
              }
              el->draw(*this, gfx, moved_element_pos(el, n));
            }
            ++n;
          }
        }

      for (auto pw : windows) {
        pw->root()->draw(*this, gfx, pw->pos);
      }

      gfx->end_drawing();
    }

    cb(bmp, vpos);

  }

  popup *view::create_popup() { return nullptr; }

  bool view::add_animation(element *b, animation *pba, const style *new_style, const style *old_style) {
    return super::add_animation(b, pba, new_style, old_style);
  }

  bool view::request_animation_frame(uint delay) {
    // return super::request_animation_frame(delay);
    return false;
  }
  void view::stop_animation_frames() {
    // return super::stop_animation_frames();
  }

  uint view::get_animation_ticks() { return super::get_animation_ticks(); }

  gool::graphics *view::surface() { return _gfx; }

  bool view::is_active() const { return true; }
  bool view::set_focus(helement b, FOCUS_CAUSE cause, bool postfactum) {  return super::set_focus(b, cause, postfactum); }

  size view::pixels_per_inch() { return resolution_provider::desktop().pixels_per_inch(); }
  void          view::set_cursor(gool::cursor *pcur) { _cursor = pcur; }
  gool::cursor *view::get_cursor() { return _cursor; }

  void view::do_request_idle() {
    // if (!_idle_id) _idle_id = g_timeout_add(20, idle_callback, this);
    //_idle_id = g_idle_add_full(idle_callback,this);
#pragma TODO("do_request_idle")
  }

  void view::stop() {
    // if (_idle_id) {
    //  g_source_remove(_idle_id);
    //  _idle_id = 0;
    //}
    super::stop();
  }

  bool view::ask_close_window(bool by_chrome) {
    if (_is_closing) return true;
    // auto gw = gtkwindow( this );
    // if( gw )
    //   gtk_window_close( gw );

    post(delegate(this, &view::rq_close_window), true);

    return true;
  }

  bool view::rq_close_window() {

    if (inside_animation_frame)
      return false; // cannot do it now, need reposting

    auto_state<bool> _(_is_closing, true);

    _closerq_by_code = true;

    if (ask_unload(doc(), UNLOAD_BY_CODE)) close_window();

    return true;
  }

  bool view::close_window() {
    each([this](html::view *pv) {
      if (pv->parent() == this) pv->close_window();
    });
    // array<tool::handle<gtk::view>> all = g_all.elements()();
    // for( int n = 0; n < all.size(); ++n )
    //{
    //  tool::handle<gtk::view> pv = all[n];
    //  if( pv->parent() == this )
    //    pv->close_window();
    //}
    // auto gw = gtkwindow(this);
    // gtk_widget_destroy(GTK_WIDGET(gw));
    return true;
  }

  rect view::window_decoration() const {

    if (_decorations_origin.x.is_defined())
      return rect(_decorations_origin.x, _decorations_origin.y,
        _decorations_corner.x, _decorations_corner.y);

    // approximate
    /*      screen_info si;
    if(get_screen_info(0, si))
    {
    static rect dmr(0,0,0,0);
    if( dmr == rect(0,0,0,0) )
    dmr = rect(si.workarea.left() - si.monitor.left(),
    si.workarea.top() - si.monitor.top(),
    si.monitor.right() - si.workarea.right(),
    si.monitor.bottom() - si.workarea.bottom());
    return dmr;
    } */

    return rect(0, 0, 0, 0);
  }

  void         view::move_window(const rect &spos, bool client_rc) { super::move_window(spos); }
  WINDOW_STATE view::get_window_state() const { return _window_state; }
  bool         view::set_window_state(WINDOW_STATE ws) {
    _window_state = ws;
    return false;
  }

  bool view::show_modal() { return false; }

  bool view::do_event(DO_EVENT_MANNER m, bool &result) {
    if (dismissing) return false;

    /*    result = true;
    switch (m) {
    case DO_EVENT_WAIT: return !gtk_main_iteration_do(true);
    case DO_EVENT_NOWAIT: return !gtk_main_iteration_do(false);
    case DO_EVENT_ALL: {
    handle<gtk::view> self = this;
    while (self->get_hwnd()) {
    // if(self->_window_state == WINDOW_HIDDEN) break;
    // if(self->_window_state == WINDOW_STATE_NA) break;
    if (gtk_main_iteration_do(true)) return false;
    }
    return true;
    }
    case DO_EVENT_UNTIL_MOUSE_UP: {
    handle<gtk::view> self = this;
    self->_got_mouse_up    = false;

    while (self->get_hwnd() && !self->_got_mouse_up &&
    is_mouse_down(self)) {
    if (self->_window_state == WINDOW_HIDDEN) break;
    if (self->_window_state == WINDOW_STATE_NA) break;
    if (gtk_main_iteration_do(false)) return false;
    yield();
    }
    // printf("DO_EVENT_UNTIL_MOUSE_UP ended\n");
    return true;
    }
    }*/
    return false;
  }

  void view::init_media_vars() {
    super::init_media_vars();
    /*
    GdkScreen *screen = gdk_screen_get_default();
    GdkVisual *visual = gdk_screen_get_rgba_visual(screen);

    gool::size min_w_size(0, 0);
    gool::size max_w_size  = screen_workarea().size();
    gool::size w_size      = max_w_size;
    gool::size device_size = max_w_size;

    uint bits_per_pixel = 0;
    uint num_colors     = 0;

    gool::size dpi = pixels_per_inch();
    gool::size dpcm;

    bool high_contrast   = false;
    bool has_pen         = false;
    bool has_mouse       = false;
    bool has_mouse_wheel = false;
    bool has_horizontal_mouse_wheel =
    false; // GetSystemMetrics(SM_MOUSEHORIZONTALWHEELPRESENT) != 0;
    bool screen_reader = false;
    bool slow_machine  = false;

    #if defined(PLATFORM_DESKTOP)
    // has_pen = GetSystemMetrics(SM_PENWINDOWS) != 0;
    has_mouse       = true;
    has_mouse_wheel = true;
    // slow_machine = GetSystemMetrics(SM_SLOWMACHINE) != 0;
    #endif

    num_colors = gdk_visual_get_best_depth();

    dpcm.x = (dpi.x * 254) / 100;
    dpcm.y = (dpi.y * 254) / 100;

    if (get_hwnd()) { w_size = client_dim(); }

    _media_vars["width"]  = tool::value::make_length(w_size.x, tool::value::px);
    _media_vars["height"] = tool::value::make_length(w_size.y, tool::value::px);
    _media_vars["min-width"] =
    tool::value::make_length(min_w_size.x, tool::value::px);
    _media_vars["min-height"] =
    tool::value::make_length(min_w_size.y, tool::value::px);
    _media_vars["max-width"] =
    tool::value::make_length(max_w_size.x, tool::value::px);
    _media_vars["max-height"] =
    tool::value::make_length(max_w_size.y, tool::value::px);
    _media_vars["aspect-ratio"] =
    tool::value(double(w_size.x) / double(w_size.y));

    _media_vars["monitors"] = tool::value(gdk_screen_get_n_monitors(screen));
    _media_vars["device-width"] =
    tool::value::make_length(device_size.x, tool::value::px);
    _media_vars["device-height"] =
    tool::value::make_length(device_size.y, tool::value::px);
    _media_vars["device-aspect-ratio"] =
    tool::value(double(device_size.x) / double(device_size.y));

    _media_vars["orientation-portrait"]  = device_size.y > device_size.x;
    _media_vars["orientation-landscape"] = device_size.y < device_size.x;
    _media_vars["color"]                 = int(bits_per_pixel);
    _media_vars["color-index"]           = int(num_colors);
    // monochrome ???

    if (dpi.x == dpi.y) // dots per inch
    {
    _media_vars["resolution"]     = dpi.x;
    _media_vars["min-resolution"] = dpi.x;
    _media_vars["max-resolution"] = dpi.x;
    } else {
    // A \91resolution\92 (without a "min-" or "max-" prefix) query never
    // matches a device with non-square pixels.
    _media_vars["min-resolution"] = min(dpi.x, dpi.y);
    _media_vars["max-resolution"] = max(dpi.x, dpi.y);
    }

    if (dpcm.x == dpcm.y) // dots per sentimeter
    {
    _media_vars["resolution-dpcm"]     = dpcm.x;
    _media_vars["min-resolution-dpcm"] = dpcm.x;
    _media_vars["max-resolution-dpcm"] = dpcm.x;
    } else {
    // A \91resolution\92 (without a "min-" or "max-" prefix) query never
    // matches a device with non-square pixels.
    _media_vars["min-resolution-dpcm"] = min(dpcm.x, dpcm.y);
    _media_vars["max-resolution-dpcm"] = max(dpcm.x, dpcm.y);
    }

    _media_vars["high-contrast"]   = high_contrast;
    _media_vars["contrast-screen"] = high_contrast; // Symantec's var.

    _media_vars["has-pen"]                    = has_pen;
    _media_vars["has-mouse"]                  = has_mouse;
    _media_vars["has-mouse-wheel"]            = has_mouse_wheel;
    _media_vars["has-horizontal-mouse-wheel"] = has_horizontal_mouse_wheel;
    _media_vars["screen-reader"]              = screen_reader;
    _media_vars["slow-machine"]               = slow_machine;

    _media_vars["engine"]               = ustring(WTEXT("sciter"));
    _media_vars["engine-version-minor"] = (int)module_version(false);
    _media_vars["engine-version-major"] = (int)module_version(true);

    static uint ver[4] = {SCITER_VERSION};

    _media_vars["sciter"] = value(ver[0]);

    _media_vars["os"]       = ustring(tool::environment::get_os_version_name());
    _media_vars["platform"] = ustring("Linux");

    _media_vars["old-themes"] =
    environment::get_os_version() < environment::WIN_VISTA;
    _media_vars["new-themes"] =
    environment::get_os_version() >= environment::WIN_VISTA;

    bool composited = false;

    if (visual != NULL && gdk_screen_is_composited(screen)) composited = true;

    _media_vars["composition-supported"] = tool::value(composited);
    _media_vars["on-glass"]              = tool::value(get_transparency());

    _media_vars["graphics-layer"] = tool::value(graphics_caps());

    _media_vars["ui-blurbehind"] =
    tool::value(get_transparency()); // tool::value(composited);
    _media_vars["ui-ambience"] = tool::value("light");
    */
  }

  int view::get_window_metrics(tool::value::length_special_values what) {
    switch (what) {
    case tool::value::$scrollbar_height: return 16;
    case tool::value::$scrollbar_width: return 16;
    case tool::value::$small_icon_height: return 24;
    case tool::value::$small_icon_width: return 24;
    case tool::value::$border_width: return 1;
    case tool::value::$border_3d_width: return 2;

    case tool::value::$window_caption_height: return 24;
    case tool::value::$window_button_height: return 24;
    case tool::value::$window_button_width: return 24;
    case tool::value::$window_frame_width: return 0;
    default: assert(false); return 10;
    }
  }

  // void view::render(graphics *gfx, gool::rect dirty_rc) {}

  bool view::ask_folder_name(const ustring &caption, ustring &foldername) {
    return false;
  }

  array<ustring> view::ask_file_name(view::AFN_MODE mode,
    const ustring &caption,
    const ustring &filename,
    const wchar *  def_ext,
    const wchar *  filter) 
  {
    array<ustring> filenames;
    return filenames;
  }

  ustring view::get_window_title() const { return ustring(); }
  bool    view::set_window_title(const wchar *title) { return false; }

  void view::replace_windowed() {}

  /*void view::set_timer(uint_ptr id, uint ms, uint_ptr &sys_id) {}
  bool view::request_animation_frame(uint delay) { return false;  }
  */


}
