//|
//|
//| Copyright (c) 2001-2013
//| Andrew Fedoniouk - andrew@terrainformatica.com
//|
//| UXTHEME support
//|

#include "lite-view.h"

#ifdef THEMES_SUPPORT

#include "gool/gool-theme-parts.h"

#include "lite-theme.h"
//#include "osx-sciter-graphics.h"

#include "gool/gool-part-names-ph.h"

namespace gool
{
  theme* theme::current(CURRENT_OP op)
  {
    static handle<theme_lite> _current = new theme_lite();
    switch(op)
    {
        case PEEK:
        case CURRENT:  break;
        case RESET:    _current = new theme_lite(); break;
        case DESTROY:  _current = 0; break;
    }
    return _current;
  }

  int   theme::scrollbar_width() { return 16; }
  int   theme::scrollbar_height() { return 16; }
  int   theme::small_icon_width() { return 18; }
  int   theme::small_icon_height() { return 18; }
  int   theme::border_width() { return 1; }
  int   theme::border_3d_width() { return 2; }

  theme_lite::theme_lite()
  {
    images.size(TOTAL_KEYWORDS);
  }

  theme_lite::~theme_lite()
  {
  }

  image* theme_lite::get_image_impl(uint id)
  {
    if( !id || id > TOTAL_KEYWORDS)
      return 0;
    --id;
    if(images[id].is_null())
      images[id] = new theme_image_lite(id+1);
    return images[id];
  }

    void   theme_lite::draw_h_scrollbar(gool::graphics* sf, uint pt, uint st, rect rc )
    {
    }

    void   theme_lite::draw_v_scrollbar(gool::graphics* sf, uint pt, uint st, rect rc )
    {
    }


  void  render(theme_image_lite* pimg, graphics* sf, rect dst, rect src)
  {
  }

  bool  is_expandable(const theme_image_lite* pimg, SECTION_DEFS& sd)
  {
      part_def pd = theme_part_defs[pimg->image_id - 1];
      if( pd.margin == 0 || pd.stretch_mode == SHAPE_NOT_EXPANDABLE)
        return false;
      sd.margins.s = sd.margins.e = gool::point(pd.margin,pd.margin);
      sd.center = SRM_STRETCH;
      switch( pd.stretch_mode )
      {
      case SHAPE_HORIZONTAL:   // stretch vertically but tile horizontally
        sd.top    = SRM_TILE;
        sd.bottom = SRM_TILE;
        sd.left   = SRM_STRETCH;
        sd.right  = SRM_STRETCH;
        break;
      case SHAPE_VERTICAL:     // stretch horizontally but tile vertically
        sd.top    = SRM_STRETCH;
        sd.bottom = SRM_STRETCH;
        sd.left   = SRM_TILE;
        sd.right  = SRM_TILE;
        break;
      case SHAPE_EXPAND:       // tile horizontally and vertically
        sd.top    = SRM_TILE;
        sd.bottom = SRM_TILE;
        sd.left   = SRM_TILE;
        sd.right  = SRM_TILE;
        sd.center = SRM_TILE;
        break;
      case SHAPE_STRETCH_BOTH: // stretch horizontally and vertically
        sd.top    = SRM_STRETCH;
        sd.bottom = SRM_STRETCH;
        sd.left   = SRM_STRETCH;
        sd.right  = SRM_STRETCH;
        break;
      }
      return true;
  }

/*
  bitmap* load_res_expandable_bitmap(const wchar *name, const SECTION_DEFS& sd)
  {
    tool::bytes data = get_resource( name, L"png");
    handle<image> aimg = gool::image::create(data,name);
    if( !aimg || !aimg->is_bitmap())
      return 0;
    expandable_bitmap* peb = new expandable_bitmap(aimg->dim(),true,false,sd);
    if(!peb)
      return 0;
    peb->_pixels.transfer_from(aimg.ptr_of<gool::bitmap>()->_pixels);
    return peb;
  }

  bitmap*  make_bitmap(graphics* sf, theme_image_lite* pimg, size dim)
  {
    tool::critical_section _1(gool::theme::lock());
    auto_state<bool> _2(theme::processing,true);

    const part_def& pd = theme_part_defs[pimg->image_id - 1];
    if( pd.nClass == THEME_GROUP_TOOLBAR && pd.nPart == TP_BUTTON ) {
      if(pd.nState == 1)
        return 0; // toolbar button has no bitmap in normal state.
      else if( environment::get_os_version() < environment::WIN_VISTA ) {

        SECTION_DEFS sd;
        //bool is_image_expandable = is_expandable(pimg,sd);

        switch(pd.nState) {
          case 2: return load_res_expandable_bitmap(L"toolbar-button-hover",sd);
          case 3: return load_res_expandable_bitmap(L"toolbar-button-pressed",sd);
          case 4: return load_res_expandable_bitmap(L"toolbar-button-disabled",sd);
          case 5: return load_res_expandable_bitmap(L"toolbar-button-checked",sd);
          case 6: return load_res_expandable_bitmap(L"toolbar-button-checked-hover",sd);
        }
      }
    } else if( pd.nClass == THEME_GROUP_LISTVIEW && pd.nPart == LVP_LISTITEM && environment::get_os_version() < environment::WIN_VISTA) {

        SECTION_DEFS sd;
        //bool is_image_expandable = is_expandable(pimg,sd);

        switch(pd.nState) {
          case 0:
          case 1: return nullptr;
          case 2: return load_res_expandable_bitmap(L"list-view-item-hover",sd);
          case 3: return load_res_expandable_bitmap(L"list-view-item-selected",sd);
          case 4: return nullptr; //return load_res_expandable_bitmap(L"list-view-item-disabled",sd);
          case 5: return load_res_expandable_bitmap(L"list-view-item-selected-not-focus",sd);
          case 6: return load_res_expandable_bitmap(L"list-view-item-selected-hover",sd);
        }
    }

    rect rc = rect(dim);

    RECT r = toRECT(rc);

    HTHEME hTheme = hThemes[pd.nClass];
    HWND ehwnd = engine_controlled_hwnd();

    if(!hTheme && pd.nClass == THEME_GROUP_LISTVIEW && pd.nPart == LVP_LISTITEM)
    {
      SetWindowTheme(ehwnd, L"Explorer", NULL);
      hTheme = OpenThemeData(ehwnd,L"Listview");
      assert(hTheme);
      hThemes[THEME_GROUP_LISTVIEW] = hTheme;
    }


    SECTION_DEFS sd;
    bool is_image_expandable = is_expandable(pimg,sd);
    bool has_alpha = !!IsThemeBackgroundPartiallyTransparent(hThemes[pd.nClass],pd.nPart,pd.nState);

	  if(pd.nClass == THEME_GROUP_PROGRESS && pd.nPart == PP_CHUNK)
	  {
	      // PROGRESS bug workaround
	      is_image_expandable = false;
	  }
	  else if(pd.nClass == THEME_GROUP_PROGRESS && pd.nPart == PP_CHUNKVERT)
	  {
		  is_image_expandable = false;
	  }


       //rc = rc;


    if(_BeginBufferedPaint) // WV,W7,...
    {

    HDC hdcBuffer = 0;

    BP_PAINTPARAMS paintParams = {0};
    paintParams.cbSize = sizeof(paintParams);
    paintParams.dwFlags = BPPF_ERASE | BPPF_NOCLIP; //  | BPPF_NONCLIENT

    HDC hdc = GetDC(0);
      HPAINTBUFFER hpb = _BeginBufferedPaint()(hdc, &r, BPBF_COMPOSITED, &paintParams, &hdcBuffer);
    ReleaseDC(0,hdc);
    if(!hpb)
      return 0;
    //BufferedPaintSetAlpha(hpb,NULL,0);

    HRESULT hr = DrawThemeBackground( hTheme, hdcBuffer, pd.nPart, pd.nState, &r, &r );
    assert(SUCCEEDED(hr));

    if(FAILED(hr))
      return 0;

    RGBQUAD* bits = 0;
    int      width = 0;
      hr = _GetBufferedPaintBits()(hpb, &bits, &width );
    assert(SUCCEEDED(hr));
    if(FAILED(hr))
      return 0;

      bitmap* bmp = is_image_expandable
        ? new expandable_bitmap(dim,has_alpha,true,sd)
        : new bitmap(dim,has_alpha,true);

    argb* src = (argb*)bits;
    for( int r = 0; r < dim.y; ++r )
    {
      argb* pr = (argb*)(*bmp)[r].start;
      xcopy(pr,src,dim.x);
      src += width;
    }
    //????? bmp->premultiply();

      _EndBufferedPaint()(hpb,FALSE);

    return bmp;
    } else { // XP
      dib32 buf( dim );
      RECT r = {0,0,dim.x,dim.y};
      HRESULT hr = DrawThemeBackground( hTheme, buf.DC(), pd.nPart, pd.nState, &r, NULL );
      assert(SUCCEEDED(hr)); hr = hr;
      bitmap* bmp = is_image_expandable
        ? new expandable_bitmap(&buf,has_alpha,sd)
        : new bitmap(&buf,has_alpha);
      return bmp;
    }
  }

  size dimension(part_def& pd)
  {
    tool::critical_section _1(gool::theme::lock());
    auto_state<bool> _2(theme::processing,true);

    if( pd.dim.x && pd.dim.y)
      return pd.dim;

    HTHEME hTheme = hThemes[pd.nClass];
    HWND ehwnd = engine_controlled_hwnd();

    if(!hTheme && pd.nClass == THEME_GROUP_LISTVIEW && pd.nPart == LVP_LISTITEM)
    {
      SetWindowTheme(ehwnd, L"Explorer", NULL);
      hTheme = OpenThemeData(ehwnd,L"Listview");
      assert(hTheme);
      hThemes[THEME_GROUP_LISTVIEW] = hTheme;
    }
    HDC dc = ::GetDC(ehwnd);
    if(pd.nClass == THEME_GROUP_PROGRESS && (pd.nPart == PP_BAR || pd.nPart == PP_BARVERT ))
    {
      // PROGRESS bug workaround
      pd.dim.x = 14;
      pd.dim.y = 14;
    }

    else
      GetThemePartSize(hThemes[pd.nClass], dc, pd.nPart, pd.nState, 0, TS_TRUE, PSIZE(pd.dim));
    ReleaseDC(ehwnd,dc);

    switch(pd.stretch_mode)
    {
      case SHAPE_NOT_EXPANDABLE: break;
      case SHAPE_HORIZONTAL: pd.dim.x = max(pd.dim.x,64); break;
      case SHAPE_VERTICAL: pd.dim.y = max(pd.dim.y,64); break;
      case SHAPE_EXPAND:
            pd.dim.x = max(pd.dim.x,64);
            pd.dim.y = max(pd.dim.y,64);
            break;
      case SHAPE_STRETCH_BOTH:
            pd.dim.x = min(pd.dim.x,64);
            pd.dim.y = min(pd.dim.y,64);
            break;
    }

	if(pd.nClass == THEME_GROUP_PROGRESS && pd.nPart == PP_CHUNK)
	{
	    // PROGRESS bug workaround
	    pd.dim.x = 8;
	    pd.dim.y = 16;
	}
	else if(pd.nClass == THEME_GROUP_PROGRESS && pd.nPart == PP_CHUNKVERT)
	{
	    // PROGRESS bug workaround
	    pd.dim.x = 16;
	    pd.dim.y = 8;
	} else if(pd.stretch_mode != SHAPE_NOT_EXPANDABLE) {
      pd.dim.x = max(pd.dim.x,16);
      pd.dim.y = max(pd.dim.y,16);
  }

    return pd.dim;
  }

  size dimension(const theme_image_lite* pimg)
  {
    part_def& pd = theme_part_defs[pimg->image_id-1];
    return dimension(pd);
  }


  bool is_transparent(const part_def& pd)
  {
    if( pd.nClass == THEME_GROUP_TRACKBAR )
      return true;
    if( pd.nClass == THEME_GROUP_BUTTON )
      return true;
    if( pd.nClass == THEME_GROUP_SPIN )
      return true;
    if( pd.nClass == THEME_GROUP_TOOLBAR )
      return true;
    if( pd.nClass == THEME_GROUP_REBAR )
      return true;
    return 0 != IsThemeBackgroundPartiallyTransparent(hThemes[pd.nClass],pd.nPart, pd.nState);
  }

  bool is_transparent(const theme_image_lite* pimg)
  {
    const part_def& pd = theme_part_defs[pimg->image_id-1];
    return is_transparent(pd);
  }

  void  render(theme_image_lite* pimg, graphics* sf, rect dst, rect src, byte opacity)
  {
    SECTION_DEFS sd;
    bitmap* bmp = pimg->get_bitmap(sf,dst.size());
    if( bmp )
    {
      if(is_expandable(pimg, sd))
        sf->do_expand(bmp,dst,sd, rect());
      else
        sf->do_draw(bmp,dst,src,opacity);
    }
  }

*/

    handle<bitmap> theme_image_lite::get_bitmap(graphics* sf, size sz)
    {
        return handle<bitmap>();
/*
        critical_section _(theme::lock());

        //size native_dim = dim();
        SECTION_DEFS sd;
        if(is_expandable(this,sd))
            sz = dim();

        int nm = cache.size();
        //dbg_printf("get_bitmap %d:\n",image_id);
        for( int n = 0; n < nm; ++n )
        {
            bitmap *pbmp = cache[n];
            if(!pbmp)
            {
                cache.clear();
                return 0;
            }
            if(pbmp->dim() == sz)
                return pbmp;
            //dbg_printf("get_bitmap %d: %d,%d\n", image_id, pbmp->dim().x, pbmp->dim().y);
        }
        bitmap *pbmp = make_bitmap(sf, this, sz);
        //dbg_printf("get_bitmap %d: miss %d,%d\n", image_id, sz.x, sz.y);
        cache.push_front(pbmp);

        return pbmp; */
    }


    void theme_image_lite::draw(graphics* gfx, rect dst, rect src, byte opacity)
    {
        const part_def& pd = theme_part_defs[image_id - 1];
/*        switch( pd.nClass ) {
            case THEME_GROUP_BUTTON:
                render_button( pd, static_cast<osx::graphics*>(gfx), dst ); break;
            case THEME_GROUP_EDIT:
                render_edit( pd, static_cast<osx::graphics*>(gfx), dst ); break;
            case THEME_GROUP_COMBOBOX:
                render_combo( pd, static_cast<osx::graphics*>(gfx), dst ); break;
            case THEME_GROUP_SPIN:
                render_spin( pd, static_cast<osx::graphics*>(gfx), dst ); break;
            default:
                break;
        } */
    }

    size theme_image_lite::dim() const
    {
        const part_def& pd = theme_part_defs[image_id - 1];

        /*gool::geom::size_t<SInt32> sz;

        switch( pd.nClass ) {
            case THEME_GROUP_BUTTON:
                switch(pd.nPart) {
                    case BP_RADIOBUTTON:
                    {
                        GetThemeMetric(kThemeMetricSmallRadioButtonWidth,&sz.x);
                        GetThemeMetric(kThemeMetricSmallRadioButtonHeight,&sz.y);
                        return sz;
                    }
                    case BP_CHECKBOX:
                    {
                        GetThemeMetric(kThemeMetricSmallCheckBoxWidth,&sz.x);
                        GetThemeMetric(kThemeMetricSmallCheckBoxHeight,&sz.y);
                        return sz;
                    }
                }
                break;
            //case THEME_GROUP_SPIN:
            //    return size(13,27);
            default:
                break;
        }*/
        return size();
        //return gool::dimension(this);
    }
    bool theme_image_lite::is_transparent()  const
    {
        return true;
        //return  gool::is_transparent(this);
    }
}
#endif

