#include "lite.h"

#if defined(WINDOWS)
  #include "d2d/d2d.h"
#endif

namespace lite {

  application*  application::instance = nullptr;

  application::application() {
    html::init();
    //window::init(true);
    //popup::init(true);
    behavior::init(true);
  }
  application::~application() {
    behavior::init(false);
    SkGraphics::Term();
    instance = nullptr;
  }

  application *application::factory() { 
    tool::critical_section _(gool::lock);
    if (!instance)
    {
#if defined(WINDOWS)
      switch (requested_gfx_layer)
      {
      default:
        instance = d2d::app_factory();
        break;
      case SKIA_GRAPHICS:
      case SKIA_OPENGL_GRAPHICS:
        instance = xgl::app_factory();
        break;
      }
#else 
      instance = xgl::app_factory();
#endif
    }
    return instance;
  }

  tool::wchars system_fontname()
  {
    static tool::ustring fn;
    if (fn.is_undefined()) {

      xgl::ref<SkTypeface> tf = SkTypeface::RefDefault();
      assert(tf);
      if (!tf)
        return WCHARS("Tahoma");
      SkString tfn;
      tf->getFamilyName(&tfn);
      fn = u8::cvt(chars(tfn.c_str(), tfn.size()));
    }
    return fn();
  }


  void application::get_system_font(/*inout*/ ustring &name, /*out*/ int &size,
    /*out*/ uint &weight,
    /*out*/ bool &italic) {
    //static ustring _name = WCHARS("Roboto");
    //static ustring _name = WCHARS("Tahoma");
    static ustring _name = system_fontname();
    static int     _size = 12; // dips!

    name = _name;
    size = _size;
    weight = 400;
    italic = false;
  }

  // overriden by xgl application
  gool::font *application::create_font(const ustring &name, float size,
    uint weight, bool italic,
    gool::FONT_RENDERING mode) {
    assert(false);
    return nullptr;
  }

  void application::clear_font_cache() { assert(false); }

  tool::ustring application::get_supported_font_family( const tool::ustring &family_name_list) {
    assert(false);
    return tool::ustring();
  }

  view *application::create_window_processor(const window_params &params) {
      lite::view *pv = new lite::view(params);
      return pv;
  }

} // namespace lite


#if defined(SCITERJS)
  #include "master-css-resources-js.cpp"
#else
  #include "master-css-resources.cpp"
#endif

tool::bytes get_resource(const wchar *path) {
  static tool::sar ctx(tool::items_of(master_css_resources));
  return ctx.get(path);
}

std::pair<tool::bytes, tool::ustring> get_stock_style_resource() {
  tool::ustring u = W("ux-master.css");
  tool::bytes   r = get_resource(u);
  return std::pair<tool::bytes, tool::ustring>(r, u);
}

bool load_file_thumbnail(const ustring &path, uint size, load_file_thumbnail_callback *pcb) {
  return false; // will be delivered later
}

namespace virtual_keyboard 
{
  bool show_if_needed() { return false; }
  void dismiss_if_shown() {}
} // namespace virtual_keyboard

