#ifndef __html_h__
#define __html_h__

#include "html-symbols.h"
#include "html-streams.h"
#include "html-dom.h"
#include "html-dom-traversal.h"
#include "html-layout.h"
#include "html-layout-aux.h"
#include "html-layout-text-flow.h"
#include "html-document.h"
#include "html-view.h"
#include "html-style-atts.h"
#include "html-style.h"
#include "html-style-parser.h"
#include "html-pump.h"
#include "html-spring.h"
#include "html-behavior.h"
#include "html-events.h"
#include "html-behaviors.h"
#include "html-clipboard.h"
#include "html-css-script.h"
#include "html-svg.h"

namespace html {

  struct parsed_html_result {
    bool          full_document = false; // true if it was given by full <html>...</html> or <svg>...</svg>  
    array<hnode>  content; // parsed content
  };
    
  parsed_html_result parse_html(view &v, istream &inp, document *doc, bookmark *sel_start = nullptr, bookmark *sel_end = nullptr);

  bool insert_html(view &v, istream &inp, document *doc, /*in-out*/ helement &el, SE_TYPE where, int_v at = int_v());
  // check if istream is SVG document markup
  bool is_svg_markup(istream &inp);

  extern void init_symbols(bool);
  inline void init() {
    static bool initialized = false;
    if (!initialized) {
      initialized = true;
      init_symbols(true);

      behavior::init_buttons();
      behavior::init_frame();
      behavior::init_hyperlink();
      behavior::init_htmlarea();
      behavior::init_edits();
      behavior::init_selects();
      behavior::init_image();
      behavior::init_datetime();
      behavior::init_masked_edit();
      behavior::init_bars();
      behavior::init_menu();
      behavior::init_numeric_edit();
      behavior::init_gestures();
      behavior::init_scrollbar();
      behavior::init_table_ctl();
      behavior::init_lists();
      behavior::init_virtual_list();
      behavior::init_effects();
#ifdef USE_LOTTIE
      behavior::init_lottie();
#endif
      behavior::init_richtext();
      behavior::init_plaintext();
      behavior::init_output();
      behavior::init_media();
      behavior::init_pager();
#if defined(SCITER) || defined(SCITERJS)
      behavior::init_reactor();
#endif
    }
  }

  INLINE void element::do_draw_background(view &v, graphics *pg, point pos,
                                  bool check_animator) {
    if (!behavior || !behavior->_draw_background(v, this, pg, pos)) {
#if defined(SCITER) || defined(SCITERJS)
      if (!flags.script_draws_background ||
          !v.on_element_draw_background(pg, this, pos))
#endif
      {
        draw_background(v, pg, pos);
        if (!c_style->clip_overflow()) draw_border(v, pg, pos);
      }
    }
  }

  INLINE void draw_element_content(view &v, element *_this, graphics *pg,
                                   point pos) {

#ifdef _DEBUG
    if (_this->is_id_test())
      pos = pos;
#endif

#if defined(SCITER) || defined(SCITERJS)
    if (!_this->flags.script_draws_content ||
        !v.on_element_draw_content(pg, _this, pos))
#endif
    {
      if (_this->c_style->clip_overflow() && _this->c_style->has_rounded_corners()) {
        handle<gool::path> path;
        gool::rect         box = _this->ldata->border_box() + pos;
        _this->c_style->background_outline(v, pg, box, box, path,_this);
        if (path) {
          gool::layer _(pg, path);
          _this->draw_content(v, pg, pos);
        } else
          _this->draw_content(v, pg, pos);
      } else {
        _this->draw_content(v, pg, pos);
      }
    }
  }

  INLINE void element::do_draw_content(view &v, graphics *pg, point pos,
                                     bool check_animator) {

    if (check_animator && animator && animator->draw_content(v, pg, this, pos))
      return;
    if (!behavior || !behavior->_draw_content(v, this, pg, pos))
    {
      draw_element_content(v, this, pg, pos);
    }

    if (c_style->clip_overflow()) draw_border(v, pg, pos);
    if (ldata->sb.visible()) ldata->sb.draw(v, pg, this, pos, true, true);
  }

  INLINE void element::do_draw_foreground(view &v, graphics *pg, point pos,
                                  bool check_animator) {
    if (!behavior || !behavior->_draw_foreground(v, this, pg, pos)) {
#if defined(SCITER) || defined(SCITERJS)
      if (!flags.script_draws_foreground ||
          !v.on_element_draw_foreground(pg, this, pos))
#endif
        draw_foreground(v, pg, pos);
    }

    //if (state.selected()) draw_selected_cover(v, pg, pos);

    if (behavior) {
      behavior->_draw_outline(v, this, pg, pos);
    }

#if defined(SCITER) || defined(SCITERJS)
    if (flags.script_draws_outline) {
      if (v.on_element_draw_outline(pg, this, pos)) return;
    }
#endif
  }

  INLINE void element::do_draw(view &v, graphics *pg, point pos, bool check_animator, bool check_layer) {
    // auto_state<argb> _(pg->text_color, argb(c_style->font_color.val(0)));


    if (check_animator && animator && animator->draw(v, pg, this, pos)) return;
    if (check_layer && flags.layered && behavior->draw(v, pg, this, pos)) return;

    IMAGE_RENDERING irm_before = image_rendering_undefined;

    if (c_style->image_rendering.is_defined()) {
      irm_before = pg->image_rendering_mode();
      pg->image_rendering_mode(IMAGE_RENDERING(
          c_style->image_rendering.val(image_rendering_default)));
    }

    do_draw_background(v, pg, pos, check_animator);
    do_draw_content(v, pg, pos, check_animator);
    do_draw_foreground(v, pg, pos, check_animator);

    /*if( v._selection_ctx
      && v._selection_ctx->is_valid()
      && v._selection_ctx->allow_text_selection_on(this) )
    {
      draw_selection(v, pg, pos, v._selection_ctx);
    }*/

    if (irm_before != image_rendering_undefined)
      pg->image_rendering_mode(irm_before);
  }

  void setup_touch_scroll_handler(view &v, element *b);


} // namespace html

#endif
