#include "html.h"

//#include "win/win-application.h"

uint module_version(bool major);

namespace html
{
  bool use_platform_theming =
#if defined(WINDOWS) && !defined(WINDOWLESS)
    true
#else
    false
#endif
    ;

  static tool::thread_context<view*> thread_context_view;
  // thread_var view* thread_current_view = nullptr;

#ifdef ZIP_SUPPORT
  hash_table<string, handle<cabinet>> view::zip_cache; // cache of zip files
#endif

  hash_table<uint_ptr, handle<view>> view::all;
  mutex                              view::all_guard;


  media_variables &media_vars_provider::media_vars()
  {
    critical_section _(lock);
    static media_variables _media_vars;
    if (_media_vars.size() == 0) {

      _media_vars["engine"] = ustring(WCHARS("sciter"));
      _media_vars["engine-version-minor"] = (int)module_version(false);
      _media_vars["engine-version-major"] = (int)module_version(true);

      uint ver[4] = { SCITER_VERSION };

      _media_vars["sciter"] = value(ver[0]);

      _media_vars["os"] = ustring(tool::environment::get_os_version_name());

      _media_vars["old-themes"] =
        environment::get_os_version() < environment::WIN_VISTA;
      _media_vars["new-themes"] =
        environment::get_os_version() >= environment::WIN_VISTA;

      _media_vars["graphics-layer"] = tool::value(app()->graphics_caps());

      _media_vars[W("h-smile")] = value(5);

#if defined(WINDOWS)
      _media_vars[W("os-vendor")] = value(W("Microsoft"));
#elif defined(OSX)
      _media_vars[W("os-vendor")] = value(W("Apple"));
#elif defined(LINUX)
      _media_vars[W("os-vendor")] = value(W("GNU"));
#elif defined(ANDROID)
      _media_vars[W("os-vendor")] = value(W("GOOGLE"));
#endif
      _media_vars["uses-platform-themes"] = html::use_platform_theming;
    }

    return _media_vars;
  }

  media_vars_provider default_media_vars_provider;

  iwindow::iwindow()
    : type(UNDEFINED_WINDOW_TYPE),
    is_painting(false),
    _hwnd(nullptr),
    windowing_mode(),
    used_windowing_mode(),
    animation_count(0),
    _blur_behind(BLUR_BEHIND_NONE)
  {
    app = html_app();
  }
  iwindow::~iwindow() { assert(!is_painting); }

  element *popup::root() const { return _root; } // root element hosted by the window
  element *popup::anchor() const { return _anchor; }
  element *popup::pfocus() const { return _pfocus; }

  void popup::anchor(element *el) {
    _anchor = el; /*if(_root) _root->event_owner = el;*/
  }
  void popup::root(element *r) { _root = r; /*if (_root) _root->event_owner = _anchor;*/ }    // root element hosted by the window


  void popup::pfocus(element *el) { _pfocus = el; }

#if !defined(NATIVE_WINDOWS_BACKEND) && !defined(WINDOWLESS)
  void iwindow::set_layered(bool onoff)
  {
    _is_layered = onoff;
  }

  void iwindow::update_window_frame()
  {
  }

  bool iwindow::show(uint animate_window_flags, uint ms) {
    return false;
  }

  bool iwindow::is_window_visible() {
    return true;
  }
#endif

  window_frame_updater::window_frame_updater(iwindow* pw) : that(pw) {
    ++that->frame_updater_counter;
  }
  window_frame_updater::~window_frame_updater() {
    if (--that->frame_updater_counter > 0)
      return;
    if (!that->is_child()) {
      bool transparent = that->get_frame_type() == LAYERED || that->get_blurbehind() != BLUR_BEHIND_NONE;
      if (!transparent && that->root())
        transparent = !that->root()->get_style()->has_solid_background();
      if (that->get_transparency() != transparent)
        that->set_transparency(transparent);
      that->update_window_frame();
    }
  }

  void view::attached(HWINDOW hw) {
    critical_section _(all_guard);
    bool             created = false;
    handle<view> & ref = all.get_ref(uint_ptr(hw), created);
    ref = this;
    iwindow::attached(hw);
  }

  void view::detached(HWINDOW hw) {
    critical_section _(all_guard);
    all.remove(uint_ptr(hw));
    iwindow::detached(hw);
  }

  current_view_state::current_view_state(view *that) {
    self = that;
    previous_self = thread_context_view.get();
    thread_context_view.set(that);
  }
  current_view_state::~current_view_state() { drop_current(); }
  void current_view_state::drop_current() {
    if (self) {
      if (previous_self && previous_self->get_ref_count() > 1)
        thread_context_view.set(previous_self.ptr());
      else
        thread_context_view.set(nullptr);
      self = nullptr;
      previous_self = nullptr;
    }
  }

  uint view::default_debug_mode = 0 /*FALSE*/;

  view::~view() {
    // while(!z_ctx_list_head.is_empty())
    //  z_ctx_list_head.next()->unlink();
  }

  view * view::get_current() { return thread_context_view.get(); }

  /*
  int view::scrollbar_width() { return gool::theme::current()->scrollbar_width(); }
  int view::scrollbar_height() { return gool::theme::current()->scrollbar_height(); }
  int view::small_icon_width() { return gool::theme::current()->small_icon_width(); }
  int view::small_icon_height() { return gool::theme::current()->small_icon_height(); }
  int view::border_width() { return gool::theme::current()->border_width(); }
  int view::border_3d_width() { return gool::theme::current()->border_3d_width(); }
  */


  // resolution_provider
  size view::pixels_per_inch() {
    if (dpi.x.is_defined()) return dpi;
    return resolution_provider::desktop().pixels_per_inch();
  }
  void view::pixels_per_inch(size sz) {
    dpi = dim_v_t(sz);
    if (doc()) {
      doc()->drop_layout_tree(this, true);
      //add_to_update(doc(),true);
    }
  }
  void view::reset_resolution() {
    dpi.x.clear();
    dpi.y.clear();
    physical_dpi.x.clear();
    physical_dpi.y.clear();
    if (doc())
      add_to_update(doc(), true);
  }

  bool view::px_as_dip() const {
    return treat_px_as_dip;
  }

  ustring view::get_lang() const {
    static ustring ulang;
    if (ulang.is_defined()) return ulang;
    critical_section _(const_cast<view *>(this)->guard);
    tool::ustring    lang;
    tool::ustring    country;
    if (tool::environment::used_lang_country(lang, country, true)) {
      ulang = ustring::format(W("%s-%s"), lang.c_str(), country.c_str());
      ulang.to_lower();
    }
    return ulang;
  }

  ustring view::get_theme() const {
    if (auto p = parent())
      return p->get_theme();
    //TODO("? add SciterSetOption option to set theme")
    return ustring();
  }

  ustring view::get_input_lang() const {
    if (_input_lang.is_defined()) return _input_lang;
    return get_lang();
  }

  void view::on_input_lang_change(const ustring &iso_lang_country) {
    _input_lang = iso_lang_country;
    helement fel = focus_element ? focus_element : doc();
    if (fel) {
      event_behavior evt(fel, fel, INPUT_LANGUAGE_CHANGED, 0);
      evt.data = value(iso_lang_country);
      post_behavior_event(evt, true);
    }
  }

  void view::debug_printf(uint subsystem, uint severity, const char *fmt, ...) {
    struct os : public printf_output_stream {
      tool::array<char> buffer;
      virtual bool      out(int c) {
        buffer.push((char)c);
        return true;
      }
    } os;

    va_list args;
    va_start(args, fmt);
    do_vsprintf_os(&os, fmt, args);
    va_end(args);

    view *pv = view::get_current();
    if (pv) {
      pv->debug_print(subsystem, severity, ustring(os.buffer()));
    }
    else
      ::debug_print(subsystem, severity, ustring(os.buffer()));
  }

  void view::debug_print(uint subsystem, uint severity, wchars msg) {
    if (debug_output) {
      auto_state<handle<view_debug_output>> local(debug_output, handle<view_debug_output>());
      local.value->print(subsystem, severity, msg);
      //if (local.value->is_debug_peer()) return;
      //if( !debug_mode() ) 
      return;
      // otherwise accumulate log messages to present them until connection with
      // the inspector
    }

    if (debug_mode()) {
      do_debug_print(subsystem, severity, msg);
      view::log_item li = { subsystem, severity, msg };
      debug_output_buffer.push(li);
    }
    else {
      do_debug_print(subsystem, severity, msg);
    }
  }

  void view::do_debug_print(uint subsystem, uint severity, wchars msg) {
    if (native_debug_output)
      native_debug_output->print(subsystem, severity, msg);
    else
      ::debug_print(subsystem, severity, msg);
  }


  void view::set_debug_output(view_debug_output *pdo) {
    // assert(debug_output == 0);
    debug_output = pdo;
    while (debug_output_buffer.size() && debug_output) {
      auto it = debug_output_buffer.pop_front();
      debug_output->print(it.subsystem, it.severity, it.msg);
    }
  }

  void view::error_report(const char *cap, element *el) {
    view::debug_printf(OT_DOM, OS_ERROR, "%s\n", cap);
    int d = 0;
    while (el) {
      string tn = tag::symbol_name(el->tag);
      view::debug_printf(OT_DOM, OS_ERROR, "\t%s<%s", d++ != 0 ? "in " : "",
        tn.c_str());
      string id = el->attr_id();
      if (id.length()) view::debug_printf(OT_DOM, OS_ERROR, "#%s", id.c_str());
      string cls = el->attr_class();
      if (cls.length())
        view::debug_printf(OT_DOM, OS_ERROR, ".%s", cls.c_str());
      view::debug_printf(OT_DOM, OS_ERROR, ">");
      if (el->is_document()) break;
      el = el->parent;
    }
  }

  bool view::use_smooth_scroll_default = true;

  view::view(const window_params& params)
    : _is_detached(false),
    _finished(false), _selection_ctx(0), /*last_wheel_ticks(4),*/
    drawing_surface(nullptr), rtl_ctx(false),
    use_smooth_scroll(use_smooth_scroll_default), _paint_ops(0),
    debug_output_buffer(200), // 200 items in debug buffer
    _debug_mode(false),
    animation_frame_no(0),
    message_time(0),
    //idle_history(10),
    treat_px_as_dip(gool::treat_px_as_dip)
  {
    dispatch_queue = async::dispatch::current();
    //init_media_vars();
    _media_vars = default_media_vars_provider.media_vars();
  }

  void view::init_media_vars() {

    //WRONG, can be called on on_media_change: _media_vars = default_media_vars_provider.media_vars();

  //_media_vars.clear();
#if DEVICE == DESKTOP
    if (type == PRINT_VIEW)
      _media_vars[W("print")] = value(true);
    else
      _media_vars[W("screen")] = value(true);
    _media_vars[W("desktop")] = value(true);
    _media_vars[W("device")] = value(CHARS("desktop"));
#elif DEVICE == HANDHELD
    _media_vars[W("handheld")] = value(true);
    _media_vars[W("device")] = value(CHARS("handheld"));
#elif DEVICE == IOT
    _media_vars[W("iot")] = value(true);
    _media_vars[W("device")] = value(CHARS("iot"));
#endif

    if (type != PRINT_VIEW && type != CHILD_WINDOW) {
      switch (get_blurbehind()) {
      case BLUR_BEHIND_NONE:
        _media_vars["blur-behind"] = value(false); break;
      case BLUR_BEHIND_ULTRA_DARK:
        _media_vars["blur-behind"] = value(WCHARS("ultra-dark"));
        break;
      case BLUR_BEHIND_DARK:
        _media_vars["blur-behind"] = value(WCHARS("dark"));
        break;
      case BLUR_BEHIND_LIGHT:
        _media_vars["blur-behind"] = value(WCHARS("light"));
        break;
      case BLUR_BEHIND_ULTRA_LIGHT:
        _media_vars["blur-behind"] = value(WCHARS("ultra-light"));
        break;
      case BLUR_BEHIND_CUSTOM:
        _media_vars["blur-behind"] = value(WCHARS("custom"));
        break;
      }
      _media_vars["on-glass"] = tool::value(get_transparency());
    }
  }

  document *view::doc() const {
    return pdoc;
  }

  style *view::get_default_style() {
    if (!default_style) {
      default_style = new style();
      default_style->font_family = WCHARS("Verdana");
      default_style->font_size.set(10.0, size_v::unit_type::pt);
      default_style->font_color = argb(0, 0, 0);
      value z_scroll_manner;
#if defined(USE_ANIMATED_SCROLL)
      z_scroll_manner.clear();
#else
      tool::function_value *pfunc = new tool::function_value();
      pfunc->name = WCHARS("scroll-manner");
      pfunc->params[value("animation")] = value(false);
      z_scroll_manner = value::make_function(pfunc);
#endif
      default_style->scroll_manner_x = z_scroll_manner;
      default_style->scroll_manner_y = z_scroll_manner;

#pragma TODO("RTL CTX")
      if (rtl_ctx) default_style->direction = direction_rtl;
    }
    return default_style;
  }

  bool view::load_url(const string &url, bool now) {
    // stop_pump(true);
    handle<pump::request> hrq = new pump::request(url, DATA_HTML);

    if (load_data(hrq) && hrq->data.size())
      return load(hrq);

    return false;
  }

  bool view::load(handle<request> hrq) {
    hrq->dst_view = this;
    if (hrq->data.size()) {
      pdocrq = hrq;
      return load_html(hrq->data(), hrq->real_url());
    }
    return true;
  }

  bool view::load_html(bytes html, const string &url, uint encoding) {
    istream m(html, url, debug_mode());
    /*
    handle<html::pump::request> rq = new html::pump::request( url,
    html::DATA_HTML ); rq->dst = self; rq->initiator = self; rq->data.swap(
    html_utf ); self->on_data_request(*pv, rq); self->on_data_arrived(*pv, rq);
    rq->rq_type = html::RQ_PUSH;
    pv->on_data_loaded(rq);
    */
    parse_html(m);
    return true;
  }

  void view::start(const window_params& params) {
    rtl_ctx = params.rtl.val(0) != 0;
    parent(params.parent);
    is_detached(params.is_detached);
    is_main(params.is_main);

    init_type(params.window_type);

    bool is_debug = (params.parent ? params.parent->debug_mode() : false)
      || params.debug_mode.val(html::view::default_debug_mode);

    debug_mode(is_debug);
    if (params.is_transparent) set_layered(true);

    //surface();
    init_media_vars();

    if (params.url.is_defined() || params.data)
    {
      handle<request> hrq = new html::request(params.url, html::DATA_HTML);

      if (params.data) {
        hrq->rq_type = RQ_PUSH;
        hrq->data = params.data;
      }
      else if (!load_data(hrq, true))
        return;

      load(hrq);
      on_data_loaded(hrq);
      commit_update();
    }
  }

  void view::stop() {

    if (is_main())
      view::each([this](view* pvother) {
      if (pvother == this) return;
      if (pvother->parent() == this)
        pvother->close_window();
    });
    else
      view::each([this](view* pvother) {
      if (pvother == this) return;
      if (pvother->parent() == this && !pvother->is_detached())
        pvother->close_window();
    });

    pump::stop();

    dismissing = true;
    detach_all_behaviors();
    auto_state<tristate_v> _(is_measuring, true);
    // auto_state<tristate_v> _(is_detaching, true);

    remove_tooltips();

    handle<view> holder = this; // to prevent its deletion in load time events.
    handle<document> tpdoc = pdoc;
    unload_doc(true);
    to_update.clear();
    current_rq = nullptr;

    posted_events.clear();
    //_posted_events.clear();
    posted_functors.clear();
    //_posted_functors.clear();
    element_timers.clear();
    windows.clear(); // popup, tool and child windows
    default_style = nullptr;
    ground_behavior = nullptr;
    animating.clear();
    callback.clear();
    mouse_over_element.clear();
    mouse_down_element.clear();
    mouse_capture_element.clear();
    focus_element.clear();
    old_focus_element.clear();
    event_capture_element.clear();
    sticky_scrollable.clear();        // see sticky_scroll_ctl
    sticky_scrollable_anchor.clear(); // see sticky_scroll_ctl
    highlighted_ctl.clear();
    gesture_element.clear();
    _media_vars.clear();
    _box_shadow_cache.clear();
    _icon.clear();
    bfc.clear();
    moved_elements.clear();
    to_update.clear();
  }

  bool view::ask_unload(document *d, UNLOAD_REASON reason) {
    html::event_behavior evt(d, d, DOCUMENT_CLOSE_REQUEST, reason);
    evt.data = get_retval();
    this->send_behavior_event(evt);
    return !evt.is_canceled();
  }

  bool view::on_unload(document *d) {
    if (helement hp = d->parent) {
      {
        html::event_behavior evt(d, d, DOCUMENT_CLOSE, 0);
        evt.is_bubbling = false;
        this->send_behavior_event(evt);
      }
      {
        html::event_behavior evt(d, hp, DOCUMENT_CLOSE, 0);
        evt.is_bubbling = false;
        this->send_behavior_event(evt);
      }
    }
    else {
      html::event_behavior evt(d, d, DOCUMENT_CLOSE, 0);
      evt.data = get_retval();
      this->send_behavior_event(evt);
    }
    return true;
  }

  bool view::on_before_unload(document *d) {
    if (helement hp = d->parent) {
      {
        html::event_behavior evt(d, d, DOCUMENT_CLOSING, 0);
        evt.is_bubbling = false;
        this->send_behavior_event(evt);
      }
      {
        html::event_behavior evt(d, hp, DOCUMENT_CLOSING, 0);
        evt.is_bubbling = false;
        this->send_behavior_event(evt);
      }
    }
    else {
      html::event_behavior evt(d, d, DOCUMENT_CLOSING, 0);
      evt.data = get_retval();
      this->send_behavior_event(evt);
    }
    return true;
  }


  bool view::unload_doc(bool uconditionally) {

    // auto_state<tristate_v> _(is_measuring, true);
    // handle<view> holder = this; // to prevent its deletion in load time
    // events.

    if (!pdoc) return true;

    process_posted_things(false);

    if (!pdoc) return true;

    if (!uconditionally && !ask_unload(pdoc, UNLOAD_BY_LOAD)) { return false; }

    on_before_unload(pdoc);

    if (uconditionally)
      pump::stop();
    else
      pump::restart();

    remove_all_animations();
    stop_all_timers();
    process_posted_things(false);

    // stop_pump(true); - should be already restarted at the moment

    {
      critical_section _pg(posted_guard);
      posted_events.clear();
      posted_functors.clear();
    }

    focus_element = 0;
    mouse_over_element = 0;
    mouse_down_element = 0;
    mouse_capture_element = 0;
    event_capture_element = 0;
    old_focus_element = 0;
    gesture_element = 0;

    if (pdoc) {
      mutator_ctx _mut(pdoc, this);
      pdoc->state.ready(false);
      on_unload(pdoc);
      pdoc->stray(*this);
      pdoc->pview(0);
      pdoc = 0;
    }

    return true;
  }

  void view::parse_html(istream &inp) {
    auto_state<tristate_v> _1(is_measuring, true);
    current_view_state     _2(this);

    handle<view> holder = this; // to prevent its deletion in load time events.

    handle<document> tpdoc = pdoc;

    if (!view::unload_doc(false)) return;

    if (dismissing) return; // exisiting document closed the view

    has_view_relative_units = false;

    pdoc =
#if defined(SVG_SUPPORT)
      is_svg_markup(inp) ? new svg_document(inp.url) :
#endif
      new document(inp.url);

    pdoc->debug_mode(debug_mode());
    swap(pdoc->pdocrq, pdocrq);
    pdoc->pview(this);
    // if(rtl_ctx)
    pdoc->state.rtl(rtl_ctx);
    pdoc->flags.state_initialized = 1;

    // pdoc->num_resources_requested = 0;
    // pdoc->num_styles_requested = 0;
    // pdoc->state.rtl(rtl_ctx);

    on_load_start(pdoc);

    mutator_ctx _mut(pdoc, this);

    html::parse_html(*this, inp, pdoc);

    pdoc->measure(*this, dimension());

    on_load_end(pdoc, !!tpdoc);

    on_root_doc_parsed(pdoc);

    uint content_flags = CONTENT_ADDED;
    if (tpdoc) content_flags |= CONTENT_REMOVED;

    event_behavior evt(0, 0, CONTENT_CHANGED, content_flags);
    post_behavior_event(evt); // notify the view that its content has been changed.

    if (pdoc->num_resources_requested == 0) on_document_complete(pdoc);

    pdoc->operational = true;
    
    refresh();

#ifdef _DEBUG

    // get_styles(*this, doc());
    doc()->resolve_styles(*this);
    doc()->styles().usage_stats();
    //doc()->styles()._resolved_pool.report();
#endif
    on_root_doc_loaded(pdoc);
  }

  // void view::setup_custom_frame()
  //{
  //    this->set_frameless_ctl(wctls);
  //}

  void view::on_size(size sz) {
    auto_state<tristate_v> _(is_measuring, true);
    dim = sz;
    on_size_changed();

    for (handle<ctl> hct = this->ground_behavior; hct; hct = hct->next)
      hct->on_size_changed(*this, nullptr);

    if (doc() && !dim.empty()) {
      if (has_view_relative_units)
        doc()->drop_layout_tree(this);
      doc()->measure(*this, sz);
      replace_windowed();
      refresh();
      // replace_windowed();
    }
  }

  bool view::on_size_request(int side_id, rect &rc) {
    VIEW_TYPE vt = view_type();
    if (vt != VIEW_WINDOW && vt != VIEW_DIALOG) return false;
    if (!doc()) return false;

    auto dim_ratio = this->aspect_ratio();
    if (dim_ratio.is_defined() && dim_ratio > 0.1f) {
      rect wdc = window_decoration();
      rect crc = rc << wdc;
      int  w, h;
      switch (side_id) {
      case 8:
      case 2:
        w = int(crc.height() * dim_ratio.val(0.0f) + 0.5f);
        crc >>= size((w - crc.width()) / 2, 0);
        break;
      case 4:
      case 6:
        h = int(crc.width() / dim_ratio.val(0.0f) + 0.5f);
        crc >>= size(0, (h - crc.height()) / 2);
        break;
      case 3:
        if (float(crc.width()) / float(crc.height()) > dim_ratio)
          crc.e.y = crc.s.y + int(crc.width() / dim_ratio);
        else
          crc.e.x = crc.s.x + int(crc.height() * dim_ratio);
        break;
      case 7:
        if (float(crc.width()) / float(crc.height()) > dim_ratio)
          crc.s.y = crc.e.y - int(crc.width() / dim_ratio);
        else
          crc.s.x = crc.e.x - int(crc.height() * dim_ratio);
        break;
      case 9:
        if (float(crc.width()) / float(crc.height()) > dim_ratio)
          crc.s.y = crc.e.y - int(crc.width() / dim_ratio);
        else
          crc.e.x = crc.s.x + int(crc.height() * dim_ratio);
        break;
      case 1:
        if (float(crc.width()) / float(crc.height()) > dim_ratio)
          crc.e.y = crc.s.y + int(crc.width() / dim_ratio);
        else
          crc.s.x = crc.e.x - int(crc.height() * dim_ratio);
        break;
      default: break;
      }
      rc = crc >> wdc;
      // rc = crc;
      return true;
    }

    // static name_or_symbol a_resizeable("resizable");
    // if(!doc()->atts.exist( a_resizeable ))
    //  return false;
    if (!this->get_resizeable()) return false;

    hstyle cs = doc()->get_style(*this);
    if (cs->min_width.is_undefined()
      //|| cs->max_width.undefined()
      || cs->width.is_undefined())
      return false;

    rect screen_rc = this->screen_workarea();
    rect pure_screen_rc = screen_rc;
    rect client_rc(this->client_dim());
    rect window_rc = client_rc;
    this->adjust_window_rect(window_rc);

    // reduce size of screen_rc by window frame decoration widths:
    rect decorations;
    decorations.s = client_rc.s - window_rc.s;
    decorations.e = window_rc.e - client_rc.e;

    screen_rc <<= decorations;

    rect distances = doc()->outer_distance(*this);

    int minw = limit(doc()->declared_min_width(*this, screen_rc.width()), 0,
      pure_screen_rc.width()) +
      distances.left() + distances.right() + decorations.left() +
      decorations.right();
    int maxw = limit(doc()->declared_max_width(*this, screen_rc.width()), 0,
      pure_screen_rc.width()) +
      distances.left() + distances.right() + decorations.left() +
      decorations.right();
    // int w = doc()->declared_min_width(*this,screen_rc.width());
    int rcw = rc.width();

    if (rcw < minw) switch (side_id) {
    case 7:
    case 4:
    case 1: rc.s.x = rc.e.x - minw; break;
    case 9:
    case 6:
    case 3: rc.e.x = rc.s.x + minw; break;
    }
    if (rcw > maxw) switch (side_id) {
    case 7:
    case 4:
    case 1: rc.s.x = rc.e.x - maxw; break;
    case 9:
    case 6:
    case 3: rc.e.x = rc.s.x + maxw; break;
    }

    int w = doc()->dim().x;

    doc()->set_width(*this, rc.width() - distances.left() - distances.right() -
      decorations.left() - decorations.right());

    int minh = limit(doc()->declared_min_height(*this, screen_rc.height()), 0,
      pure_screen_rc.height()) +
      distances.top() + distances.bottom() + decorations.top() +
      decorations.bottom();
    int maxh = limit(doc()->declared_max_height(*this, screen_rc.height()), 0,
      pure_screen_rc.height()) +
      distances.top() + distances.bottom() + decorations.top() +
      decorations.bottom();

    doc()->set_width(*this, w);

    if (rc.height() < minh) switch (side_id) {
    case 7:
    case 8:
    case 9: rc.s.y = rc.e.y - minh + 1; break;
    case 1:
    case 2:
    case 3: rc.e.y = rc.s.y + minh - 1; break;
    }
    if (rc.height() > maxh) switch (side_id) {
    case 7:
    case 8:
    case 9: rc.s.y = rc.e.y - maxh + 1; break;
    case 1:
    case 2:
    case 3: rc.e.y = rc.s.y + maxh - 1; break;
    }
    return true;
  }

  void view::paint(element *to_draw, bool front_layer) {
    check_visibility(true);

    invalid = rect();
    request_render_requested = false;

    handle<document> pd = doc();

    handle<graphics> gfx = surface();

    //if (has_animations())
    //  on_animation_tick();

    if (pd && gfx) {
      gfx->set_drawing_root(pd);

      auto_state<resolution_provider*> _1(gfx->pview, this);

      to_update.update(this);

      // doc()->resolve_styles(*this);
      //pd->measure(*this,dimension());
      measure_document();


#ifdef _DEBUG
      if (!pd->is_layout_valid())
        dbg_printf("PANIC: view::paint INVALID LAYOUT!\n");
#endif

      if (to_draw)
        to_draw->draw(*this, gfx, to_draw->view_pos(*this));
      else
        pd->draw(*this, gfx, pd->view_pos(*this));

      if (front_layer)
        for (int n = 0; n < moved_elements.size();) {
          helement el = moved_elements[n];
          if (el->pview() != this)
            moved_elements.remove(n);
          else if (el->airborn) {
            if (el->airborn->type == AIRBORN_INPLACE) {
              size prsize = el->airborn->dim;
              if (el->airborn->dim.x.is_defined() && prsize != el->dim()) {
                el->set_width(*this, prsize.x);
                el->set_height(*this, prsize.y);
              }
              el->draw(*this, gfx, moved_element_pos(el, n));
            }
            ++n;
          }
        }
    }
  }

#if 0
  void view::paint(function<void(gool::bitmap *dst, point view_pos)> cb,
    element *to_draw, bool front_layer) {
    handle<document> pd = doc();

    invalid = rect();

    if (!pd) return;

    to_update.update(this);

    measure_document();

    gool::rect  area;
    gool::point offs(0, 0);
    gool::point vpos(0, 0);

    if (!to_draw)
      area = gool::rect(client_dim());
    else {
      point vp = to_draw->view_pos(*this);
      point rp = vp - point(to_draw->ldata->borpad_left(),
        to_draw->ldata->borpad_top());
      rect  rc(vp, to_draw->dim());
      rc >>=
        rect(to_draw->ldata->borpad_left(), to_draw->ldata->borpad_top(),
          to_draw->ldata->borpad_right(), to_draw->ldata->borpad_bottom());
      area = rc;
      offs = rp;
      vpos = rc.s;
    }

    handle<gool::bitmap> bmp = new gool::bitmap(area.size(), true, true);
    {
      handle<graphics> gfx =
        app->create_bitmap_bits_graphics(bmp, gool::argb(0, 0, 0, 0));

      auto_state<gool::graphics *> _1(drawing_surface, gfx);
      auto_state<resolution_provider*> _2(gfx->pview, this);
      gfx->set_drawing_root(pd);

#ifdef _DEBUG
      if (!pd->is_layout_valid())
        dbg_printf("PANIC: view::paint INVALID LAYOUT!\n");
#endif
      gfx->begin_drawing();

      if (to_draw)
        to_draw->draw(*this, gfx, to_draw->view_pos(*this));
      else
        pd->draw(*this, gfx, point(0, 0));

      if (front_layer)
        for (int n = 0; n < moved_elements.size();) {
          helement el = moved_elements[n];
          if (el->pview() != this)
            moved_elements.remove(n);
          else if (el->airborn) {
            if (el->airborn->type == AIRBORN_INPLACE) {
              size prsize = el->airborn->dim;
              if (el->airborn->dim.x.is_defined() && prsize != el->dim()) {
                el->set_width(*this, prsize.x);
                el->set_height(*this, prsize.y);
              }
              el->draw(*this, gfx, moved_element_pos(el, n));
            }
            ++n;
          }
        }
      gfx->end_drawing();
    }
    cb(bmp, vpos);
  }
#endif

  ctl *view::create_behavior(element *b, const string &name) {
    if (callback) return callback->create_behavior(this, b, name);
    return 0;
  }

  bool view::on_data_loaded(pump::request *rq) {

    rq->end();

    rq->ready_flag = true;

    this->notify_data_arrived(nullptr, rq);

    if (callback && callback->data_loaded(this, rq)) {
      rq->consumed = true;
      return true; // it was "consumed" marked for not storing.
    }

    return rq->process_callbacks();
  }

  void view::on_content_change(element *el, uint content_change_bits) {
    {
      critical_section cs(posted_guard);
      for (int n = 0; n < posted_events.size(); ++n) {
        handle<posted_event> pe = posted_events[n];
        if (pe->cmd == CONTENT_CHANGED && pe->target == el && pe->source == el) {
          pe->reason |= content_change_bits;
          return; // we've found similar event on the same element.
        }
      }
    }
    // el->drop_style(this);

    event_behavior evt(el, el, CONTENT_CHANGED, content_change_bits);
    post_behavior_event(evt, false);
  }

  bool view::post(functor *pf, bool only_once) {
    critical_section cs(posted_guard);
    handle<functor>  hf = pf;
    if (only_once && (posted_functors.get_index(hf) >= 0)) {
      request_idle();
      return false;
    }
    posted_functors.push(hf);
    request_idle();
    return true;
  }

  element *view::popup_anchor(element *popup) {
    FOREACH(n, windows) {
      handle<iwindow> pw = windows[n];
      if ((pw->is_popup() || pw->is_tooltip()) && pw->root() == popup)
        return pw->anchor();
    }
    return nullptr;
  }
  element *view::popup_of_anchor(element *anchor) {
    FOREACH(n, windows) {
      handle<iwindow> pw = windows[n];
      if ((pw->is_popup() || pw->is_tooltip()) && pw->root()->event_owner == anchor)
        return pw->root();
    }
    return 0;
  }

  element *view::popup_saved_focus(element *popup) {
    FOREACH(n, windows) {
      handle<iwindow> pw = windows[n];
      if (pw->root() == popup) return pw->pfocus();
    }
    return 0;
  }

  void view::kill_sibling_popups(element *anchor) {
    helement         pup = anchor;
    critical_section _(guard);
    if (anchor)
      for (int n = windows.last_index(); n >= 0; --n) {
        if (n > windows.last_index()) continue;
        iwindow *iw = windows[n];
        if (!iw->is_popup() && !iw->is_tooltip()) continue;
        helement b = iw->root();
        if (b->state.moving() || b->state.copying()) continue;
        if (!anchor->belongs_to(*this, b, true)) {
          // anchor->dbg_report("ANCHOR"); anchor->parent->dbg_report("ANCHOR
          // PARENT");  b->dbg_report("BASE");  bool r =
          // anchor->belongs_to(*this,b,true);
          close_popup(b, false);
        }
      }
  }

  iwindow *view::get_iwindow_of(element *el) {
    critical_section _(guard);
    for (int n = windows.last_index(); n >= 0; --n) {
      iwindow *iw = windows[n];
      if (iw->root() == el) return iw;
    }
    return 0;
  }

  bool view::is_anchored_popup(element *b) {
    if (!b->state.popup()) return false;
    iwindow *pw = view::get_iwindow_of(b);
    if (!pw) return false;
    return pw->is_popup() || pw->is_tooltip();
  }

  /*bool view::is_tool(element* b)
  {
    if(!b->state.popup()) return false;
    iwindow* pw = get_iwindow_of(b);
    return pw && pw->is_tool();
  }*/

  bool view::close_popup(element *p, bool set_auto_focus) {
    close_owned_popups(p);
    iwindow *pw = p->window(*this);

    if (pw) {
      if (!set_auto_focus) {
        //WRONG: helement anchor = this->popup_anchor(pw->root());
        //WRONG: if (anchor) post_set_focus(anchor, BY_CODE); note: https://sciter.com/forums/topic/there-are-multiple-elements-on-the-page/
        pw->pfocus(nullptr);
      }
      else {
        if(pw->pfocus() && pw->pfocus()->is_connected())
          post_set_focus(pw->pfocus(), BY_CODE);
      }
      if (mouse_over_element &&
        mouse_over_element->belongs_to(*this, p, true)) {

        helement anchor = this->popup_anchor(pw->root());
        helement over_element = mouse_over_element;

        event_mouse evt(mouse_over_element, 0, point(0, 0), 0, 0);

        mouse_over_element = anchor;

        evt.cmd = MOUSE_LEAVE | EVENT_SINKING;
        traverse_mouse_parent_child(over_element, p, evt);
        evt.cmd = MOUSE_LEAVE;
        traverse_mouse_child_parent(over_element, p, evt);
      }
    }

    event_behavior evt(p, p, POPUP_DISMISSING, 0);
    send_behavior_event(evt);

    p->p_drawn_style = element::null_style;

    // if(b)
    //  WRONG: b->state.popup(false); // to indicate forced close
    return true;
  }

  /*bool view::close_tool( element* p )
  {
     event_behavior evt( p, p, POPUP_DISMISSING, 0 );
     send_behavior_event( evt );
     return true;
  }
  */
  bool view::close_popup_tree(element *b) {
    helement pup = b;
    close_owned_popups(b);
    if (pup->state.popup()) {
      iwindow *pw = pup->window(*this);
      if (pw && (pw->is_popup() || pw->is_tooltip())) {
        close_popup(pup, false);
      }
    }

    // if(b)
    //  WRONG: b->state.popup(false); // to indicate forced close
    return true;
  }

  void view::close_owned_popups(element *b) {
    helement         pup = b;
    critical_section _(guard);

    if (b)
      for (int n = windows.last_index(); n >= 0; --n) {
        if (n > windows.last_index()) continue;
        handle<iwindow> pw = windows[n];
        if (!pw->is_popup() && !pw->is_tooltip()) continue;
        if (pup->belongs_to(*this, pw->root(), true)) continue;
        if (pw->anchor() && pw->anchor()->belongs_to(*this, pup, true)) {
          close_owned_popups(pw->root());
          close_popup(pw->root(), false);
        }
      }
  }

  void view::attach_behavior(ctl *pc) {
    behavior_h t = ground_behavior;
    behavior_h last = 0;
    while (t)
      if (t->next == 0) {
        last = t;
        break;
      }
      else
        t = t->next;

    pc->attach(*this, doc());

    if (last)
      last->next = pc;
    else
      ground_behavior = pc;

    pc->next = 0;
  }

  void view::detach_behavior(ctl *pc) {
    behavior_h cp = ground_behavior;
    behavior_h prevcp;
    behavior_h nextcp;
    while (cp) {
      if (cp == pc) {
        nextcp = cp->next;
        cp->detach(*this, doc());
        break;
      }
      prevcp = cp;
      cp = cp->next;
    }
    if (prevcp)
      prevcp->next = nextcp;
    else
      ground_behavior = nextcp;
  }

  void view::detach_behavior(chars name) {
    behavior_h cp = ground_behavior;
    behavior_h prevcp;
    behavior_h nextcp;
    while (cp) {
      if (cp->behavior_name() == name) {
        nextcp = cp->next;
        cp->detach(*this, doc());
        break;
      }
      prevcp = cp;
      cp = cp->next;
    }
    if (prevcp)
      prevcp->next = nextcp;
    else
      ground_behavior = nextcp;
  }

  void view::detach_all_behaviors() {
    behavior_h cp = ground_behavior;
    while (cp) {
      cp->detach(*this, doc());
      cp = cp->next;
    }
    ground_behavior = 0;
  }

  ctl *view::create_behavior_for(element *b, const string &name) {
#if 0
    static string hyperlink = "hyperlink";
    bool          is_hyperlink = false;
    ctl *         c = 0;
    if (name != hyperlink) {
      c = ctl_factory::produce(b, name);
      if (c) return c;
    }
    else
      is_hyperlink = true;

    c = create_behavior(b, name);

    if (!c && is_hyperlink) {
      c = ctl_factory::produce(b, name);
      if (c) return c;
    }

    if (!c && this->parent())
      return this->parent()->create_behavior_for(b, name);
#else
    ctl * c = nullptr;
    c = ctl_factory::produce(b, name);
    if (c) return c;

    c = create_behavior(b, name);

    if (!c && this->parent())
      return this->parent()->create_behavior_for(b, name);
#endif
    return c;
  }

  bool view::call_behavior_method(method_params *p) {
    behavior_h pc = ground_behavior;
    while (pc) {
      if (pc->will_handle(HANDLE_METHOD_CALL) &&
        pc->handle_method_call(*this, 0, p))
        return true;
      behavior_h next = pc->next;
      pc = next;
    }
    return false;
  }

  bool view::call_behavior_method(element *b, method_params *p) {
    return b->call_behavior_method(*this, p);
  }

  struct media_eval_env : object // evaluation environment, responsible for
                                 // handling "global" functions and constants
  {
    view *    pv;
    document *pd;
    media_eval_env(view *v /*can be null*/, document *doc) : pv(v), pd(doc) {}

    virtual bool get_const(wchars name, value &v) {
      if (name == WCHARS("all")) {
        v = value(true);
        return true;
      }
      v.clear();
      return pd->find_media_var(name, v);
    }
    virtual bool call(wchars name, uint argn, const value *argv,
      value &retval) {
      if (pv) {
        uint n;
        char x_name[64];
        for (n = 0; n < min(63u, name.length); ++n)
          x_name[n] = (char)name[n];
        x_name[n] = 0;

        scripting_params sp;
        sp.csss_call = true;
        sp.method_name = x_name;
        sp.argc = argn;
        sp.argv = argv;
        if (pv->call_behavior_method(&sp)) {
          retval = sp.retval;
          return true;
        }
      }
      return false;
    }
  };

  bool eval_media_query(view *pv, document *doc, eval::conduit *code,
    bool &res) {
    if (!doc) return false;

    handle<eval::conduit> prg = code;

    handle<media_eval_env> env = new media_eval_env(pv, doc);
    eval::vm               vm(prg, env, 0);

    try {
      // Evaluate expr.
      vm.eval();
      res = vm.val.to_bool();
      if (res && code->prev) {
        bool pres = false;
        if (!eval_media_query(pv, doc, code->prev, pres))
          return false;
        if (!pres)
          res = false;
      }
      return true;
    }
    catch (eval::eval_runtime_error &er) {
      debug_printf(OT_CSS, OS_ERROR,
        "%s while media expression evaluation at (%s(%d))\n",
        er.msg.c_str(), er.url.c_str(), er.line_no);
    }
    return false;
  }

  bool view::send_behavior_event(event_behavior &evt) {
    traverser<event_behavior> trv(*this);
    if (evt.target) {
      if (!evt.event_bubbling()) {
        if (evt.target->on(*this, evt))
          evt.is_handled(true);
        return evt.is_handled();
      }
      if (trv.traverse(evt.target, evt, false)) {
        point pos = cursor_pos();
        if (pos != mouse_pos) { on_mouse(MOUSE_CHECK, 0, 0, pos); }
        return true;
      }
    }
    else {
      return trv.traverse(0, evt, false);
    }
    return false;
  }

  void view::on_element_visibility_changed(element *b, bool on_off) {
    //b->flags.visibility_status = on_off;
    event_behavior evt(b, b, VISUAL_STATUS_CHANGED, on_off);
    post_behavior_event(evt, true);
  }

  void view::post_behavior_event(event_behavior &evt, bool only_if_not_exist) {

    event_behavior to_send(evt);
    switch (evt.cmd) {
      case EDIT_VALUE_CHANGED:
        if (evt.target && evt.target->flags.suppress_change_event)
          return;
        to_send.cmd = CHANGE;
        break;
      case BUTTON_STATE_CHANGED:
        to_send.cmd = CHANGE;
        break;
      case SELECT_VALUE_CHANGED:
      //case SELECT_SELECTION_CHANGED:
        to_send.cmd = CHANGE;
        break;
      case FORM_VALUE_CHANGED:
        to_send.cmd = CHANGE;
        break;
      default:
        goto DO_POST;
    }
    send_behavior_event(to_send);
    if (to_send.is_canceled())
      return;
DO_POST:
    critical_section cs(posted_guard);
    posted_event     pe(evt);
    if (only_if_not_exist) {
      for (int n = 0; n < posted_events.size(); ++n) {
        if (posted_events[n]->can_collapse(evt)) {
          posted_events.remove(n);
          break;
        }
      }
    }
    int n = posted_events.size();
    posted_events.push(new posted_event(evt));
    if (n == 0)
      request_idle();
  }

  void view::set_capture(element *b) {
    mouse_capture_element = b;
    mouse_capture_strict = false;
    if (!b) check_mouse();
  }

  element *view::get_capture() { return mouse_capture_element; }

  void view::set_event_capture(element *b) {
    set_capture(0);
    if (b == doc()) b = 0;
    update_element(b);
    event_capture_element = b;
    if (focus_element && b && !focus_element->belongs_to(b))
      set_focus_on(FOCUS_FIRST);
  }
  element *view::get_event_capture() { return event_capture_element; }

  element *view::find_element(gool::point viewp) {
    if (!doc()) return 0;

    point bodyp = viewp;
    int   n;

    for (n = windows.last_index(); n >= 0; --n) {
      if (n > windows.last_index()) continue;
      element *b = windows[n]->root();
      if (!b) {
        windows.remove(n);
        continue;
      }
      if (b->state.is_dragging()) continue;
      if (!b->is_visible(*this)) continue;

      point vp = b->view_pos(*this);
      rect  r = b->hit_box(*this) + vp;
      if (r.contains(viewp)) {
        if (element* found = b->find_element(*this, viewp - vp))
          return found;
      }
    }

    for (n = moved_elements.last_index(); n >= 0; --n) {
      handle<element> el = moved_elements[n];
      if (el->is_disabled()) continue;
      rect            r = el->hit_box(*this) + moved_element_pos(el, n);
      if (r.contains(viewp))
        return el->find_element(*this, viewp - moved_element_pos(el, n));
    }

    if (this->mouse_capture_element) {
      point    cpos = this->mouse_capture_element->view_pos(*this);
      element *r =
        this->mouse_capture_element->find_element(*this, viewp - cpos, true);
      // if(!r)
      //  this->mouse_capture_element->find_element(*this,viewp-cpos);
      return r ? r : this->mouse_capture_element.ptr();
    }

    return doc()->find_element(*this, viewp - doc()->pos());
  }

  bool view::request_data(pump::request *rq) // delayed
  {
    if (load_data(rq)) return dispatch_request(rq);
    return false;
  }

  bool view::dispatch_request(handle<pump::request> hrq) {

    ON_SCOPE_EXIT(notify_data_arrived(nullptr, hrq));

    hrq->end();

    if (hrq->consumed) return true;

    if (hrq->dst_view && hrq->dst_view != this)
      return hrq->dst_view->dispatch_request(hrq);

    if (hrq->dst && (hrq->data_type == DATA_HTML || hrq->data_type == DATA_RAW_DATA)) {
      hrq->dst->state_off(*this, hrq->data.size() == 0 ? S_BUSY : (S_BUSY | S_INCOMPLETE));
    }

    this->postprocess_loaded_data(hrq);

    if (hrq->process_callbacks()) return false;

    if (on_data_loaded(hrq))
      return false; // no changes - on_data_loaded should take care

    if (hrq->is_sync) return false; // no changes - caller will consume the data

    if (hrq->dst) {
      if (hrq->dst->pview()) {
        return hrq->dst->on_data_arrived(*this, hrq); // pass it to the element and its behavior.
      }
      // otherwise if dst was removed from the DOM simply return (discard the
      // data).
      return false;
    }

    if (hrq->data_type == DATA_HTML) {
      // array<byte> data; data.swap(hrq->data);
      // string url = hrq->real_url();
      // load_html(data(),url);
      return load(hrq); // the matrix reloaded
    }

    handle<document> hd = doc();
    if (!hd) return false;

    assert(hrq->dst);

    hd->on_data_arrived(*this, hrq);

    return false;
  }

  extern element *get_enabled_mouse_target(view &v, element *b);

  bool view::will_handle_gesture_at(point pt, uint &flags) {
    helement b = find_element(pt);
    if (!b) return false;
    b = get_enabled_mouse_target(*this, b);
    if (!b) return false;
    gesture_element = b;
    event_gesture evt(gesture_element, GESTURE_REQUEST, pt);
    if (traverse_mouse(b, evt)) {
      flags = evt.flags;
      return true;
    }
    return false;
  }

  bool view::handle_gesture(gesture_cmd cmd, uint st, point pt, double val) {
    // hblock b = find_block(pt);
    // if(!b) return false;
    // b = get_enabled_mouse_target(*this,b);
    // if(!b) return false;
    if (!gesture_element) return false;

    event_gesture evt(gesture_element, cmd, pt);
    evt.flags = st;
    size delta_xy;

    if (st & GESTURE_STATE_BEGIN) {
      gesture_pos = pt;
      gesture_val = val;
      gesture_time = get_ticks();
      delta_xy = evt.delta_xy = size();
      evt.delta_v = 0;
      // event_gesture evt(gesture_element, cmd, pt);
    }
    else if (cmd == GESTURE_ZOOM) {
      uint ct = get_ticks();
      delta_xy = evt.delta_xy = gesture_pos - pt;
      evt.delta_v = val / gesture_val;
      evt.delta_time = ct - gesture_time;
      gesture_pos = pt;
      gesture_val = val;
      gesture_time = ct;

    }
    else {
      uint ct = get_ticks();
      delta_xy = evt.delta_xy = gesture_pos - pt;
      evt.delta_v = val - gesture_val;
      evt.delta_time = ct - gesture_time;
      gesture_pos = pt;
      gesture_val = val;
      gesture_time = ct;
    }
    return traverse_mouse(gesture_element, evt) ||
      delta_xy != evt.delta_xy; // pan can be partially handled
  }

  bool view::ensure_visible(element *b, bool toTop, ENSURE_VISIBLE_MANNER how) {
    //if (to_update.is_empty()) return _ensure_visible(b, toTop, how); // this does not work always reliably - seems like should always be delayed
    to_update.request_ensure_visible(b, toTop, how >= SCROLL_SMOOTH);
    request_idle();
    return true;
  }

  void view::request_render() {
    if (request_render_requested) return;
    request_render_requested = true;
    this->async([&]() -> bool {
      if(get_hwnd())
        render(nullptr, rect(dimension()));
      request_render_requested = false;
      return true;
    });
  }
  
  bool view::_ensure_visible(element *b, bool toTop, ENSURE_VISIBLE_MANNER how) {
    if (!b /*|| ??? b->abs_positioned(*this)*/ || b->airborn || b->state.popup())
      return true; // it is already here

    element *scrollable = b->get_scrollable_container(*this);
    if (scrollable && scrollable->is_visible(*this)) {
      return scrollable->scroll_to_view(*this, b, toTop, how);
    }
    return false;
  }

  bool view::scroll_to_view(element *scrollable_parent, const rect &view_rc,
    bool toTop, ENSURE_VISIBLE_MANNER manner) {

    rect src = scrollable_parent->client_rect(*this) +  scrollable_parent->view_pos(*this);
    rect brc = view_rc;

    //WRONG, scrollable_parent can itself be partially visible: if (!toTop && (brc & src) == brc) return false; // fully visible

    gool::point oldoffset = scrollable_parent->scroll_pos();
    gool::point newoffset = oldoffset;

    scroll_data sd;

    hstyle scs = scrollable_parent->get_style(*this);

    if ((scs->overflow_y > overflow_hidden ||
      scs->overflow_x > overflow_hidden) &&
      scrollable_parent->get_scroll_data(*this, sd)) {
      if (scs->overflow_y >
        overflow_hidden) // scrolling only auto or scroll, sic!
        do {
          if (brc.height() > src.height()) {
            if (brc.y().overlaps_with(src.y())) break; // it is visible
            toTop = true;
          }

          if (!toTop) {
            if (brc.top() < src.top())
              newoffset.y -= (src.top() - brc.top());
            else if (brc.bottom() > src.bottom())
              newoffset.y += (brc.bottom() - src.bottom());
            else
              break;
          }
          else {
            if (brc.top() < src.top())
              newoffset.y -= (src.top() - brc.top());
            else if (brc.top() > src.top())
              newoffset.y += (brc.top() - src.top());
            else
              break;
          }
        } while (0);

        if (newoffset.y > sd.content_outline.bottom() - sd.dim_view.y)
          newoffset.y = sd.content_outline.bottom() - sd.dim_view.y + 1;
        if (newoffset.y < sd.content_outline.top())
          newoffset.y = sd.content_outline.top();

        if (scs->overflow_x >
          overflow_hidden) // scrolling only auto or scroll, sic!
          do {
            if (brc.width() > src.width()) {
              if (brc.x().overlaps_with(src.x())) break; // it is visible
            }
            if (scs->direction == direction_rtl) {
              if (brc.right() > src.right())
                newoffset.x += (brc.right() - src.right());
              else if (brc.left() < src.left())
                newoffset.x -= (src.left() - brc.left());
              else
                break;
            }
            else {
              if (brc.left() < src.left())
                newoffset.x -= (src.left() - brc.left());
              else if (brc.right() > src.right())
                newoffset.x += (brc.right() - src.right());
              else
                break;
            }
          } while (0);

          if (newoffset.x > sd.content_outline.right() - sd.dim_view.x)
            newoffset.x = sd.content_outline.right() - sd.dim_view.x + 1;
          if (newoffset.x < sd.content_outline.left())
            newoffset.x = sd.content_outline.left();
    }

    if (oldoffset != newoffset) {
      scroll_window(newoffset, scrollable_parent, manner, false);
    }

    if (scrollable_parent->abs_positioned(*this) ||
      scrollable_parent->popup_positioned(*this)) {
      //???update_element(scrollable_parent);
      return true; // nothing to do
    }

    element *pscroll = scrollable_parent->get_scrollable_container(*this);
    if (!pscroll) return false;
    if (pscroll == scrollable_parent) {
      //???update_element(pscroll);
      return true;
    }

    brc += oldoffset;
    brc -= newoffset;

    brc &= src;

    return scroll_to_view(pscroll, brc, false /* false intentionally! */,
      manner);
  }

  bool view::scroll_window(point pos, element *b, ENSURE_VISIBLE_MANNER manner,
    bool should_close_popups, bool allow_out_of_bounds) {

    if (b->scroll_pos() == pos) return true;

    if (manner == AS_PER_CSS)
      manner = b->get_style(*this)->smooth_scroll(true) ? SCROLL_SMOOTH : SCROLL;

    scroll_animator *psa = 0;

    if (should_close_popups) {
      // remove_tooltips();
      for (int n = windows.size() - 1; n >= 0; --n) {
        handle<iwindow> iw = windows[n];
        if (iw->is_popup() || iw->is_tooltip()) {
          if (iw->root()->belongs_to(*this, b, false) ||
            (iw->anchor() && iw->anchor()->belongs_to(*this, b, false))) {
            //iw->dismiss();
            close_popup(iw->root(), false);
          }
        }
      }
    }
#if defined(USE_ANIMATED_SCROLL)
    if (manner == SCROLL_SMOOTH && use_smooth_scroll /*&& b->can_scroll_fast()*/) {
      point scroll_pos = b->scroll_pos();
      point scroll_pos_prev = scroll_pos;
      size  dim = b->ldata->dim;

      psa = b->get_animation_of_type<scroll_animator>();

      if (psa)
        psa->set_final_pos(*this, pos);
      else
        add_animation(b, new scroll_animator(*this, pos));
      return true;
    }
    else if (manner == SCROLL_PAN &&
      use_smooth_scroll /*&& b->can_scroll_fast()*/) {
      // point scroll_pos = b->scroll_pos();
      // point scroll_pos_prev = scroll_pos;

      // if( pos.y > scroll_pos.y ) { if((pos.y - scroll_pos.y) > b->dim.y)
      // scroll_pos.y = pos.y - b->dim.y + 1; }  else if( pos.y < scroll_pos.y ) {
      // if((scroll_pos.y - pos.y) > b->dim.y) scroll_pos.y = pos.y + b->dim.y -
      // 1;  }

      // if( pos.x > scroll_pos.x ) { if((pos.x - scroll_pos.x) > b->dim.x)
      // scroll_pos.x = pos.x - b->dim.x + 1; }  else if( pos.x < scroll_pos.x ) {
      // if((scroll_pos.x - pos.x) > b->dim.x) scroll_pos.x = pos.x + b->dim.x -
      // 1; }

      // if(scroll_pos_prev != scroll_pos) b->scroll_pos(scroll_pos);

      psa = b->get_animation_of_type<scroll_animator>();

      if (psa)
        psa->set_final_pos(*this, pos);
      else
        add_animation(b, new scroll_animator(*this, pos));
      return true;
    }

    if (b->animator) {
      auto filter = [](handle<animation> pa) {
        return pa->is_of_type<scroll_animator>();
      };
      remove_animations(b, filter);
    }
    // psa = b->get_animation_of_type<scroll_animator>();
    // if(psa)
    //{
    //  remove_animation(b,psa);
    //}
#endif
    if (!b->is_layout_valid())
      b->measure_inplace(*this);
    b->scroll_pos(*this, pos, allow_out_of_bounds);
    refresh(b);
    // replace_windowed();
    check_mouse();
    update_element(b);
    return true;
  }

  static bool is_current_element(view &v, element *pe) {
    //return pe->is_visible(v) && pe->state.current();
    return pe->state.current();
  }
  static bool is_focusable_element(view &v, element *pe) {
    return pe->is_focusable(v);
  }

  static bool is_not_focusable_element(view &v, element *pe) {
    return !pe->is_focusable(v);
  }


  element *view::get_current(element *b) {
    if (!b) b = focus_element;

    while (b && !b->is_focusable(*this))
      b = b->get_owner();

    if (!b) return 0;

    for (int n = 0; n < 32; ++n) {
      element_iterator it(*this, b, is_current_element, is_not_focusable_element);
      element *        current;
      if (it(current)) {
        b = current;
        continue;
      }
      else
        return b;
    }

    return 0;
  }

  bool
    view::reset_current_in(element *container) // reset :current on siblings of element b
  {
    if (!container) return false;

    container->check_layout(*this);

    auto current_off = [&](element *c) -> bool {
      if ((c != container) && c->state.current())
        c->state_off(*this, S_CURRENT);
      return false;
    };
    container->each_ui_child(current_off);
    return true;
  }

  /*void view::refresh(element *b, rect rc_to_refresh)
  {
    if( !b ) return;
    if( rc_to_refresh.empty() )
      rc_to_refresh = b->rendering_box(*this);

    rc_to_refresh += b->view_pos(*this);

    for( ;b; b = b->owner)
    {
      iwindow* pw = b->window();
      if(pw || b->parent == 0)
      {
        rc_to_refresh -= b->view_pos(*this);
        if( b->abs_positioned(*this))
          rc_to_refresh += point( b->ldata->borpad_left(),
  b->ldata->borpad_top() ); pw->refresh(rc_to_refresh); return;
      }
    }
    refresh(rc_to_refresh);
  }*/

  rect area_to_refresh(view &v, element *pe) {
    return pe->rendering_box(v) | pe->hit_box(v);
  }

  void view::refresh(element *b, rect rc_to_refresh) {
    // if( this->iss_painting ) return;
    if (dismissing) return;
    if (!b) return;
    if (!b->is_visible(*this)) return;

    if (rc_to_refresh.empty()) {
      element *bb = b->nearest_known_box();
      if (bb) b = bb;
      rc_to_refresh = area_to_refresh(*this, b);
    }

    if (rc_to_refresh.empty()) return;

#if 0 && defined(_DEBUG)
    b->dbg_report("view::refresh\n");
#endif

    // iwindow* wnd_to_refresh = this;

    rc_to_refresh += b->view_pos(*this);

    bool full_window_refresh = needs_full_window_refresh();

    element *sb = b;
    while (sb) {
      if (sb->window(*this)) break;
      if (!sb->is_it_visible(*this)) return;
      if ((sb != b) && (sb->get_style(*this)->overflow() > overflow_visible)) {
        rect rc = sb->content_box(*this, element::TO_VIEW);
        rc_to_refresh &= rc;
      }
      if (sb->flags.force_refresh) {
        rect rc = sb->rendering_box(*this, element::TO_VIEW);
        rc_to_refresh |= rc;
      }
      if (sb->c_style->transforms) full_window_refresh = true;

      sb->needs_draw(*this, rc_to_refresh);

      sb = sb->layout_parent(*this);
    }

    if (rc_to_refresh.empty() && !full_window_refresh)
      return;

    for (; b; b = b->get_owner()) {
      handle<iwindow> pw = b->window(*this);
      if (pw) {
        if (pw != this) {
          rc_to_refresh -= b->view_pos(*this);
          if (b->popup_positioned(*this))
            rc_to_refresh += b->outline_distance(*this).s;
          //rc_to_refresh += point(b->ldata->borpad_left(), b->ldata->borpad_top());
        }
        if ((pw != this) || check_visibility()) {
          //#ifdef _DEBUG
          //            dbg_printf("refresh:%d,%d,%d,%d\n",
          //            rc_to_refresh.left(), rc_to_refresh.top(),
          //            rc_to_refresh.width(), rc_to_refresh.height());
          //#endif
          if (full_window_refresh)
            pw->refresh();
          else {
            pw->refresh(rc_to_refresh);
          }
          return;
        }
        else
          break;
      }
      if (!b->is_it_visible(*this)) return;
    }
    if (check_visibility()) refresh(rc_to_refresh);
  }

  void view::update_element(element *b) {
    to_update.update(this);
    for (; b; b = b->get_owner()) {
      iwindow *pw = b->window(*this);
      if (pw) {
        pw->update();
        return;
      }
    }
    update();
  }

  void view::post_close_all_popups() {
    post(delegate(this, &view::close_all_popups), true);
  }
  bool view::close_all_popups() {
    if (doc()) close_popup_tree(doc());
    return true;
  }

  void view::on_move() { replace_windowed(); }

  void view::on_element_behavior_changed(element *b, const string &old_names,
    const string &new_names) {
    behavior_h pc = b->behavior;
    while (pc) {
      pc->on_behaviors_changed(*this, b);
      behavior_h next = pc->next;
      pc = next;
    }
  }

  bool view::on_element_data_arrived(element *b, pump::request *prq) {
    //!!!! wrong! handle<pump::request> hrq = prq;
    behavior_h pc = b->behavior;
    while (pc) {
      if (pc->will_handle(HANDLE_DATA_ARRIVED) &&
        pc->on_data_arrived(*this, b, prq))
        return true;
      behavior_h next = pc->next;
      pc = next;
    }
    return false;
  }

  bool view::on_element_data_request(element *b, pump::request *prq) {
    behavior_h pc = b->behavior;
    while (pc) {
      if (pc->will_handle(HANDLE_DATA_ARRIVED) &&
        pc->on_data_request(*this, b, prq))
        return true;
      behavior_h next = pc->next;
      pc = next;
    }
    return false;
  }

  void view::commit_update(bool force_render) {
    to_update.update(this);
    if (doc()) doc()->commit_measure(*this);
    if (force_render) iwindow::update();
  }

  void view::set_media_vars(
    wchars mvt, bool reset,
    bool reapply_styles) // accepts comma separated list of vars
  {
    if (reset)
      _media_vars.clear();
    wtokens tz(mvt, WCHARS(","));
    wchars  t;
    while (tz.next(t)) {
      ustring n = trim(t);
      _media_vars[n] = value(true);
    }
    update_media_vars(reapply_styles);
  }

  bool view::match_media_type(wchars media_var_list) const {
    wtokens tz(media_var_list, WCHARS(","));
    wchars  t;
    while (tz.next(t)) {
      ustring n = trim(t);
      value vt = _media_vars(n);
      if (vt.get<bool>()) return true;
    }
    return false;
  }

  bool is_document_filter(view &v, element *el) { return el->is_document(); }

  void view::update_media_vars(bool reset_styles)
  {
    if (frame_updater_counter)
      return; // frame_updater is active, it will do that at the end
    // loop for all <html> nodes (e.g. in frames) including master doc itself.
    element *b = doc();
    if (!b) return;
    element_iterator bi(*this, b, is_document_filter);
    bool             changes = false;
    do {
      document *pd = static_cast<document *>(b);
      for (int n = 0; n < pd->media_expressions.size(); ++n) {
        handle<eval::conduit> code = pd->media_expressions.elements()[n];
        bool                  was_true = code->is_true;
        eval_media_query(this, pd, code, code->is_true);
        if (code->is_true != was_true) changes = true;
      }
    } while (bi(b));

    if (changes || reset_styles) {
      doc()->drop_layout_tree(this, true);

      // drop_layout_tree does all this:
      //doc()->reset_styles(*this);
      // b->commit_measure(*this);
      //add_to_update(b,true);
      //commit_update();

    }
  }

  void view::set_media_vars(
    value map, bool reset,
    bool reapply_styles) // accepts comma separated list of vars
  {
    if (reset)
      _media_vars.clear();

    assert(map.is_map() || map.is_proxy_of_object());

    auto each_name_value = [&](const value &k, const value &v) -> bool {
      ustring us = k.to_string();
      _media_vars[us] = v;
      return true;
    };

    map.visit(each_name_value);
    update_media_vars(reapply_styles);
  }

  void view::set_default_media_vars(value map, bool reset) // accepts comma separated list of vars
  {
    if (reset) default_media_vars_provider.media_vars().clear();

    assert(map.is_map() || map.is_proxy_of_object());

    ustring lang, country;

    auto each_name_value = [&](const value &k, const value &v) -> bool {
      ustring us = k.to_string();
      if (us == WCHARS("lang")) lang = v.to_string();
      else if (us == WCHARS("country")) country = v.to_string();
      default_media_vars_provider.media_vars()[us] = v;
      return true;
    };
    map.visit(each_name_value);

    if (lang.is_defined() && country.is_defined())
      tool::environment::set_used_lang_country(lang, country);

  }




  /*bool view::on(view& v, element* self, event_behavior& evt)
  {
    switch (evt.cmd) {
      case MEDIA_CHANGED | EVENT_SINKING:
        if(doc())
          doc()->drop_styles(*this, true);
        refresh();
        break;
    }
    return false;
  }*/

  bool view::on_media_changed() {
    current_view_state _(this);

#ifdef _DEBUG
    auto mv = _media_vars["os-vendor"];
    assert(mv.is_defined());
#endif

    init_media_vars();
    update_media_vars(true);

    event_behavior evt(doc(), doc(), MEDIA_CHANGED, 0);
    post_behavior_event(evt, true);
    return true;
  }

  bool view::set_element_html(helement &el, bytes html, SE_TYPE where, const string &url) {
    document *doc = el->doc();
    if (!doc) doc = this->doc();
    istream m(html, url.length() ? url : doc->uri().src, false);
    if (html.length) {
      if ((html[0] == 0) && (html[1] != 0))
        m.set_utf16_encoding();
      else
        m.set_utf8_encoding();
    }
    return insert_html(*this, m, doc, el, where);
  }

  bool view::set_element_html(helement &el, wchars whtml, SE_TYPE where, const string &url) {
    document *doc = el->doc();
    if (!doc) doc = this->doc();
    //bytes html((const byte*)whtml.start, whtml.byte_size());
    //istream m(html, url.length() ? url : doc->uri().src, false);
    //m.set_utf16_encoding(); WRONG - MAY CONTAIN <include> with different encoding
    //return insert_html(*this, m, doc, el, where);
    array<byte> html;
    u8::from_utf16(whtml, html);
    istream m(html(), url.length() ? url : doc->uri().src, false);
    m.set_utf8_encoding();
    return insert_html(*this, m, doc, el, where);


  }

  bool view::construct_element_from_html(bytes html, helement &el) {
    document *doc = el ? el->doc() : this->doc();
    if (!doc) return false;
    istream m(html, doc->uri().src, false);
    m.set_utf8_encoding();
    helement container = new element(tag::T_DIV);
    helement he = container;

    if (insert_html(*this, m, doc, he, SE_APPEND)) {
      helement first = container->first_element();
      helement last = container->last_element();
      // dbg_printf("%s
      // %s\n",tag::symbol_name(first->tag).c_str(),tag::symbol_name(last->tag).c_str());
      if (first == last) {
        el = container->first_element();
        el->remove(false);
      }
      else
        el = container;
      return true;
    }
    return false;
  }

  bool view::forget_window(iwindow *iw) {
    critical_section _(guard);

    int idx = windows.get_index(iw);

    assert(idx >= 0);
    if (idx < 0) return false;

    helement anchor = iw->anchor();
    helement pfocus = iw->pfocus();

#ifdef _DEBUG
    anchor->dbg_report("forget_window anchor");
#endif

    helement popup = iw->root();

    if (mouse_over_element && mouse_over_element->belongs_to(*this, popup, true))
      mouse_over_element = anchor;

    // bool was_popup = popup->state.popup();
    popup->state.popup(false);
    popup->drop_layout(this);
    popup->drop_style(this);

    // popup->notify_visual_status_change(*this,false);

    if (anchor && (anchor->pview() != this)) anchor = 0;
    if (pfocus && (pfocus->pview() != this)) pfocus = 0;

    windows.remove(idx);

    document *pd = popup->doc();
    if (!pd) pd = this->doc();
    if (pd) {
      int pidx = pd->_synthetic_elements.get_index(popup);
      if (pidx >= 0) {
        popup->parent = nullptr;
        popup->owner = nullptr;
        pd->_synthetic_elements.remove(pidx);
        popup->stray(*this);
      }
    }

    event_behavior evt_dismissed(popup, anchor ? anchor : popup, POPUP_DISMISSED, 0);
    //post_behavior_event(evt_dismissed);
    this->send_behavior_event(evt_dismissed);

    // mouse_under may change as a result of popup disappearance.
    if (anchor && anchor->state.hover()) {
      element *hover = find_element(mouse_pos);
      element *p = element::find_common_parent(hover, anchor);
      if (hover && !hover->belongs_to(anchor, true)) {
        event_mouse evt(hover, 0, mouse_pos, 0, 0);
        evt.cursor = 0;
        evt.cmd = MOUSE_LEAVE | EVENT_SINKING;
        traverse_mouse_parent_child(anchor, p, evt);
        evt.cmd = MOUSE_LEAVE;
        traverse_mouse_child_parent(anchor, p, evt);
      }
    }

    // if( anchor ) - that is moved to block::on(event_behavior)
    //   anchor->state_off(*this, S_OWNS_POPUP);
    // ATTN! pattern changed:
    //   notify_popup_show does post of POPUP_DISMISSED
    //   thus S_OWNS_POPUP is still 'on' in message that cause this call.

    /*block_visitor bv(popup);
    for( block* b = bv.first(); b; b = bv.next())
    {
      if( b->animator )  remove_animation( b );
      b->state -= S_HOVER | S_ACTIVE;
    }*/

    if (focus_element && focus_element->belongs_to(*this, popup, true)) {
      if (pfocus && pfocus->is_focusable(*this))
        post_set_focus(pfocus, BY_CODE);
    }
    else {
      // if(focus_element)
      //  focus_element->dbg_report("popup close, old focus ");
      // else
      //  dbg_printf("popup close, no focus ");
    }

    /*if (anchor) {
      this->async([anchor, this]() -> bool { //
        anchor->state_off(*this, S_OWNS_POPUP);
        return true;
      });
    }*/
    return true;
  }

  element *view::get_anonymous_para(tag::symbol_t sym) {
    /* el->get_ref_count() == 1 criteria seems like not quite reliable for
       caching purposes. And causing problems:
       http://www.terrainformatica.com/forum/read.php?4,944,944#msg-944 Anyway
       standard malloc in C++ is fast enough these days so caching is disabled
       for a while. */

       /*if(anonymous_elements.size())
         FOREACH(n,anonymous_elements)
         {
           element* el = anonymous_elements[n];
           if( el->get_ref_count() == 1 )
           {
             //FOREACH(i,el->nodes)
             //  el->nodes[i]->detach(el); //- WRONG!, children already attached to
         other element. el->flags = element_flags(); el->flags.is_synthetic = 1;
             el->flags.index = -1;
             el->parent = 0;
             el->owner = 0;
             el->drop_layout();
             el->nodes.clear();
             el->clear_style(); el->p_style = element::null_style;
             el->tag = sym;
             el->state.data = 0;
             el->drop_caches();
             //::new(el) element(NO_INIT());
             return el;
           }
         }*/
    element *el = new element(sym);
    el->flags.is_synthetic = 1;
    el->flags.index = SYNTHETIC_NODE_INDEX;
    // anonymous_elements.push(el);
    return el;
  }

  bool view::on_context_menu(point pt) {
    if (!doc()) return false;

    element *b = 0;

    remove_tooltips();

    value data = value::make_map();

    bool by_key_code = pt.x < 0 && pt.y < 0;

    if (by_key_code) {
      b = focus_element;
      if (b) {
        b = get_current(b);
        if (!b) {
          b = focus_element;
          pt = b->padding_box(*this, element::TO_VIEW).s;
        }
        else
          pt = b->padding_box(*this, element::TO_VIEW).pointOf(1);
      }
    }
    else {
      //---
      b = mouse_over_element;
      data.set_prop("x", value(pt.x));
      data.set_prop("y", value(pt.y));
    }

    if (!b) b = doc();

    if (b->state.owns_popup()) return false;

    traverser<event_behavior> trv(*this);
    event_behavior            evt(0, b, CONTEXT_MENU_REQUEST, by_key_code ? BY_CODE : BY_MOUSE);
    evt.data = data;

    helement menu_owner;

    if (trv.traverse(b, evt)) {
      if (evt.cmd != (EVENT_HANDLED | CONTEXT_MENU_REQUEST)) // redundant?
        return false;

      if (evt.source == 0) return false;

      menu_owner = trv.handled_by;

      evt.cmd = CONTEXT_MENU_SETUP;
      if (!trv.traverse(b, evt)) {

        auto check = [&](element *cmdel) -> bool {
          traverser<event_command> trv(*this);
          event_command            cevt(b, cmdel);
          cevt.cmd = event_command::CHECK;
          cevt.command = cmdel->atts.get_ustring(attr::a_command);
          //#ifdef _DEBUG
          //          if (cevt.command == WCHARS("edit:undo")) cevt.cmd = cevt.cmd;
          //#endif // _DEBUG
          bool on = trv.traverse(b, cevt);
          if (on && cevt.result.is_defined()) {
            bool disabled = (cevt.result.to_int() & behavior::CMD_DISABLED) == behavior::CMD_DISABLED;
            bool selected = (cevt.result.to_int() & behavior::CMD_SELECTED) == behavior::CMD_SELECTED;
            cmdel->state.disabled(disabled);
            cmdel->state.checked(selected);
            cmdel->flags.state_initialized = 1;
            cmdel->drop_styles(*this);
          }
          return false;
        };
        find_all(*this, evt.source, WCHARS("[command]"), check);
      }

      if (!menu_owner)
        return false;
      if (!evt.target->belongs_to(menu_owner, true))
        return false; // is not a natural DOM parent, context menu on context menu or what?

      // evt.source->drop_layout(true);
      value x = evt.data.get_prop("x");
      value y = evt.data.get_prop("y");

      if(!evt.source->is_connected() || evt.source->parent->is_document_fragment())
        evt.source->parent = menu_owner;

      if (x.is_number() && y.is_number()) {
        point pos(x.get_int(), y.get_int());
        show_popup(evt.source /* menu element */,
          evt.target /* deepest element */, POPUP_WINDOW, 0x20, pos);
      }
      else
        show_popup(evt.source /* menu element */,
          evt.target /* deepest element */, POPUP_WINDOW, 2);

      // set_current(evt.source);
      // evt.source->state_on(*this,S_CURRENT);
      set_focus(evt.source, by_key_code ? BY_CODE : BY_MOUSE);
      return true;
    }

    return false;
  }

  bool view::on_ime_chars(bool final, tool::wchars ime_string, range ime_target,
    int_v ime_caret_pos) {
    if (doc() == 0) return false;

    element *pfocus = focus_element ? focus_element : doc();

    if (pfocus) {
      event_key evt(pfocus, final ? KEY_RESULT_STRING : KEY_COMP_STRING, 0, 0);
      evt.ime.composition = ime_string;
      evt.ime.target = ime_target;
      evt.ime.caret_pos = ime_caret_pos;
      traverser<event_key> trv(*this);
      if (trv.traverse(pfocus, evt)) return true;
    }
    return false;
  }

  // float zoomify(element* b, float val);

  font *view::get_font(style *cs) {
    if (cs->font != 0) return cs->font;

    ustring fname;
    int     fsize;
    bool    fitalic = false;
    uint    fweight = 400;
    // font f;
    if (cs->font_family.is_defined())
      fname = app->get_supported_font_family(cs->font_family);
    else
      fname = get_default_style()->font_family;

    if (cs->font_size.is_defined())
      fsize = cs->font_size.kpoints();
    else
      fsize = get_default_style()->font_size.kpoints();

    if (cs->zoom.is_defined()) fsize = int(fsize * cs->zoom.val(1.0f) + 0.5f);

    // float fsize_dips = (fsize / 1000.0f) * 96.0f / 72.0f; // points to
    // logical pixels

    // fsize_dips = int( fsize_dips + 0.99f ); // round up to nearest integer.

    if (cs->font_style.is_defined()) fitalic = cs->font_style.val() != font_style_normal;

    if (cs->font_weight.is_defined()) fweight = cs->font_weight;

    font_rendering_mode_e frm = cs->font_rendering_mode.val(font_rendering_mode_sub_pixel);
    FONT_RENDERING fmode = frm == font_rendering_mode_snap_pixel ? FR_UI : FR_VECTOR;

#if 0 && defined(OSX)
    fsize *= frm == font_rendering_mode_sub_pixel_scaled ? 96.0f : pixels_per_inch().y;
    fsize /= 72.0f;
    // fsize *= 1.2;
    cs->font =
      app->create_font(fname, fsize / 1000.0f, fweight, fitalic, fmode);
#else
    float pixels = (fsize * (frm == font_rendering_mode_sub_pixel_scaled ? 96.0f : pixels_per_inch().y)) / 72000.0f;
    cs->font = app->create_font(fname, pixels, fweight, fitalic, fmode);
#endif
    if (!cs->font) cs->font = app->get_system_font();
    return cs->font;
  }

  element *view::get_bfc(element *for_el) {
    if (!bfc) bfc = for_el->floats_parent(*this);
    assert(bfc);
    return bfc;
  }

  range view::get_x_space_at(int at_y, element *of) {
    if (!bfc) bfc = of->floats_parent(*this);
    assert(bfc);
    if (!bfc) return range(of->ldata->inner_borpad_left(),
      of->ldata->inner_dim.x - of->ldata->inner_borpad_right());

    floats_ctx *fc = bfc->fctx(*this);
    if (fc) {
      point off = of->rel_pos(*this, bfc);
      return fc->get_space_at(*this, range(at_y + off.y, at_y + off.y), of) - off.x;
    }
    else
      return range(of->ldata->inner_borpad_left(),
        of->ldata->inner_dim.x - of->ldata->inner_borpad_right());
  }

  int view::find_free_space(
    element *for_el, int at_y,
    int width) // returns first y where we can place rect.size().x == width
  {
    if (!bfc) bfc = for_el->floats_parent(*this);
    assert(bfc);
    floats_ctx *fc = bfc->fctx(*this);
    if (fc) {
      point off = for_el->rel_pos(*this, bfc);
      return fc->find_free_space(*this, range(at_y + off.y, at_y + off.y),
        width, for_el) -
        off.y;
    }
    else {
      // assert(false); // this branch shall execute only if there are active
      // floats in BFC
      return at_y;
    }
  }

  range view::push_left(element *elem, int at_y, element *of) {
    if (!bfc) bfc = elem->floats_parent(*this);
    assert(bfc);
    floats_ctx *fc = bfc->fctx(*this, true);
    point       off = of->rel_pos(*this, bfc);
    fc->push_left(*this, at_y + off.y, elem);
    return fc->get_space_at(*this, range(at_y + off.y, at_y + off.y), of) -
      off.x;
  }

  range view::push_right(element *elem, int at_y, element *of) {
    if (!bfc) bfc = elem->floats_parent(*this);
    assert(bfc);
    floats_ctx *fc = bfc->fctx(*this, true);
    point       off = of->rel_pos(*this, bfc);
    fc->push_right(*this, at_y + off.y, elem);
    return fc->get_space_at(*this, range(at_y + off.y, at_y + off.y), of) -
      off.x;
  }

  bool need_window_for(view &v, element *b) {
    rect     screen_rc = b->border_box(v) + b->screen_pos(v);
    element *windowed = b->get_windowed_container(v, false);
    if (!windowed) windowed = v.doc();
    rect view_screen_rc = windowed->border_box(v) + windowed->screen_pos(v);
    bool inside_in_full = (screen_rc & view_screen_rc) == screen_rc;
    if (!inside_in_full) return true;

    // array< handle<iwindow> > v.windows;
    FOREACH(i, v.windows) {
      handle<iwindow> piw = v.windows[i];
      if (piw->root() == windowed) continue;
      if (piw->root() == b) continue;
      rect wb_screen_rc =
        piw->root()->border_box(v) + piw->root()->screen_pos(v);
      if (!(screen_rc & wb_screen_rc).empty()) return true;
    }
    return false;
  }

  void view::stop_move_element(element *b) {
    refresh(b);
    rect rc = b->rendering_box(*this, element::TO_VIEW);
    refresh(rc);

    if (b->state.popup()) { close_popup(b, false); }
    int idx = moved_elements.get_index(b);
    // assert(idx >= 0);
    if (idx >= 0) moved_elements.remove(idx);
    b->airborn = nullptr;

    b->reset_styles(*this);
    b->check_layout(*this);

    add_to_update(b, CHANGES_MODEL);

    // refresh(b);
  }

  void view::move_element(element *el, point view_pos, size *pdim,
    ELEMENT_WINDOW_MODE mode, int ref_point) {
    helement b = el;
    // auto r = moved_elements().find_if([b](const moved_element& mel){ return
    // mel.el == b; } );
    b->check_layout(*this);

    rect rc = b->rendering_box(*this, element::TO_VIEW);
    refresh(rc);

    if (ref_point) {
      el->measure_inplace(*this);
      rect place(view_pos, el->dim());
      place >>= el->border_distance(*this);
      place.pointOf(ref_point, view_pos);
      place <<= el->border_distance(*this);
      view_pos = place.s;
    }
    bool needs_parent_update = false;
    if (!b->airborn) {
      needs_parent_update = true;
      b->airborn = new airborn_ctx();
    }

    if (pdim) {
      size nsz;
      nsz = *pdim;
      if (nsz.x < 0) {
        nsz.x = -nsz.x;
        view_pos.x -= (nsz.x - 1);
      }
      if (nsz.y < 0) {
        nsz.y = -nsz.y;
        view_pos.y -= (nsz.y - 1);
      }

      if (nsz.x <= 0) nsz.x = 300;
      if (nsz.y <= 0) nsz.y = 150;

      b->airborn->dim = nsz;
      //assert(nsz.x && nsz.y);
    }

    switch (mode) {
    case ELEMENT_WINDOW_AUTO:
      b->airborn->type = AIRBORN_INPLACE;
      b->airborn->pos = view_pos;
      break;
    case ELEMENT_WINDOW_ATTACHED:
      b->airborn->type = AIRBORN_WINDOW_VIEW;
      b->airborn->pos = view_pos;
      break;
    case ELEMENT_WINDOW_DETACHED:
    case ELEMENT_WINDOW_DETACHED_TOPMOST:
      b->airborn->type = AIRBORN_WINDOW_SCREEN;
      b->airborn->pos = view_pos + client_screen_pos();
      break;
    }

    int idx = moved_elements.get_index(b);
    if (idx >= 0) moved_elements.remove(idx);
    moved_elements.push(b);

    measure_out_of_flow(*this, b);

    {
      rect rc = b->rendering_box(*this, element::TO_VIEW);
      refresh(rc);
    }

    bool need_window =
      (mode > ELEMENT_WINDOW_AUTO) || need_window_for(*this, b);

    if (!need_window && b->state.popup()) {
      close_popup(b, false);
      b->reset_styles(*this);
      b->check_layout(*this);
      if (b->airborn) // may have stop_move_element() called from style assignment code (e.g. Element.attached/detached)
        b->airborn->type = AIRBORN_INPLACE;
      // dbg_printf("GROUNDED!\n");
    }
    else if (need_window && !b->state.popup()) {
      show_popup(b, b->parent, TOOL_WINDOW, 0xF0007, view_pos, mode);
      // dbg_printf("AIRBORN!\n");
    }
    else if (b->state.popup()) {
      this->refresh(b->rendering_box(*this) + view_pos);
      handle<iwindow> wnd = b->window(*this);
      assert(wnd);
      if (wnd) wnd->windowing_mode = mode;
      replace_windowed();
      // dbg_printf("MOVED!\n");
    }

    if (needs_parent_update && b->parent)
      this->add_to_update(b->parent, CHANGES_MODEL);

    refresh(b);
  }

  bool view::show_popup(element *pel, element *panchor, WINDOW_TYPE wt,
    uint placement, point at, ELEMENT_WINDOW_MODE mode) {
    helement el = pel;
    helement anchor = panchor;

#ifdef DEBUG
    if (panchor)
      panchor->dbg_report("show_popup anchor");
#endif // DEBUG

    if (panchor) {
      if (panchor->belongs_to(*this, pel, true))
        return false;
    }


    //el->set_event_owner(panchor); - wrong, event owners are handled specially

    //if (el->state.popup())
    //  placement = placement;

    to_update.update(this); // anchor position has to be known at this point

    critical_section _(guard);

    handle<iwindow> parent_window =
      panchor ? panchor->get_window(*this) : pel->get_window(*this);
    if (!parent_window) return false;

    // bool need_set_focus = false;

    bool initial_state_popup = el->state.popup();

    // if( wt == TOOLTIP_WINDOW )
    //  need_set_focus = false;
    // else
    if (wt != TOOLTIP_WINDOW && panchor && mode <= ELEMENT_WINDOW_AUTO && !el->state.popup())
      kill_sibling_popups(panchor);

    auto calc_place = [&](view &v, element *el, element *anchor) -> rect {
      point wcs_pos = client_screen_pos();

      gool::rect anchor_place = anchor->border_box(v, element::TO_VIEW) + wcs_pos;

      ustring role = el->atts.get_ustring("role");

      if (role() == WCHARS("overflow-tooltip") || role() == WCHARS("overflow-multiline-tooltip")) {
        anchor_place = anchor->content_box(v, element::TO_SCREEN);
        el->measure_borders_x(v, anchor_place.size());
        el->measure_borders_y(v, anchor_place.size());
        anchor_place >>= el->ldata->border_width;
        anchor_place >>= el->ldata->padding_width;
      }

      helement solid_a = block_parent(*this, anchor);
      size     parent_dim = solid_a ? solid_a->border_box(*this).size()
        : anchor->border_box(*this).size();

      /*      el->drop_layout(this);

            // popup state indicators
            el->state.popup(true);
            el->drop_styles(v);



            //el->flags.out_of_flow = 1;
            cs->fetch_images(*this,el->doc());*/

      hstyle cs = el->get_style(*this);

      if (!initial_state_popup)
        notify_popup_show(anchor, el, html::POPUP_REQUEST);

      v.refresh(anchor);

      rect target_box;
      rect margins(0, 0, 0, 0);
      uint popup_attachment = 0; // essentialy that is the "arrow" position:

      auto target_margins = [&]() -> rect {
        rect m = el->ldata->margin_width;
        rect r;
        switch (popup_attachment) {

          case 0: return m; // no reasonable attachement 

          case 1:
          case 2:
          case 3: r.e.y = m.bottom(); break;

          case 4: 
          case 5: 
          case 6: r.s.x = m.left(); break;

          case 7: 
          case 8: 
          case 9: r.s.y = m.top(); break;

          case 10: 
          case 11: 
          case 12: r.e.x = m.right(); break;
        }
        return r;
      };
            
      rect workspace_area = parent_window->screen_workarea(anchor_place);
      assert(!workspace_area.empty());

      if (mode != ELEMENT_WINDOW_DETACHED) {

        // size max_size = workspace_area.size() - parent_dim;
        //     max_size /= 2;
        size max_size = workspace_area.size();

        if (placement == 2 || placement == 8) {
          int ht = anchor_place.top() - workspace_area.top();
          int hb = workspace_area.bottom() - anchor_place.bottom();
          max_size.y = max(ht, hb);
        }
        else if (placement == 0x17 || placement == 0x19 ||
          placement == 0x14 || placement == 0x16 ||
          placement == 0x11 || placement == 0x13) {
          int wl = anchor_place.left() - workspace_area.left();
          int wr = workspace_area.right() - anchor_place.right();
          max_size.x = max(wl, wr);
        }
        el->measure_oof(*this, parent_dim, max_size);

        size sz = el->border_box(*this).size();
        target_box = rect(sz);
        margins = el->ldata->margin_width;
      }
      else {
        target_box = rect(el->border_box(*this).size());
      }

      //target_place >>= margins;
      rect target_place;

      // dbg_printf("screen height %d start_pos %d vpads %d anchor_sz.y %d\n",
      // screen_height(), start_pos, vpads, anchor_sz.y);

      auto set_popup_attachment = [&](uint pa) {
        popup_attachment = pa;
        margins = target_margins();
        target_place = target_box >> margins;
      };

      range t;


      uint popup_placement = (placement >> 16) & 0xF;
      
/*     1     2     3 
      +-------------+
  12  |             | 4
      |             |
  11  |             | 5 
      |             |
  10  |             | 6
      +-------------+
       9     8    7
*/

      if (cs->popup_attachment.is_defined() && popup_placement >= 0 && popup_placement <= 9) {

        auto replace_h = [&](uint popup, uint anchor) {
          target_place.pointOf(popup, anchor_place.pointOf(anchor));
          range t = target_place.x();
          replace_on_screen(workspace_area, target_place, anchor_place, wt);
          bool r = t == target_place.x();
          return r;
        };

        auto replace_v = [&](uint popup, uint anchor) {
          target_place.pointOf(popup, anchor_place.pointOf(anchor));
          range t = target_place.y();
          replace_on_screen(workspace_area, target_place, anchor_place, wt);
          bool r = t == target_place.y();
          return r;
        };

        set_popup_attachment(cs->popup_attachment);

        for (int n = 0; n < 2; ++n) {
          switch (popup_attachment) {
            case 1: if (!replace_v(1, 7)) { set_popup_attachment(9); continue; } break;
            case 2: if (!replace_v(2, 8)) { set_popup_attachment(8); continue; } break;
            case 3: if (!replace_v(3, 9)) { set_popup_attachment(7); continue; } break;

            case 4: if (!replace_h(7, 9)) { set_popup_attachment(12); continue; } break;
            case 5: if (!replace_h(4, 6)) { set_popup_attachment(11); continue; } break;
            case 6: if (!replace_h(1, 3)) { set_popup_attachment(10); continue; } break;

            case 7: if (!replace_v(9, 3)) { set_popup_attachment(3); continue; } break;
            case 8: if (!replace_v(8, 2)) { set_popup_attachment(2); continue; } break;
            case 9: if (!replace_v(7, 1)) { set_popup_attachment(1); continue; } break;

            case 10: if (!replace_h(3, 1)) { set_popup_attachment(6); continue; } break;
            case 11: if (!replace_h(6, 4)) { set_popup_attachment(5); continue; } break;
            case 12: if (!replace_h(9, 7)) { set_popup_attachment(4); continue; } break;
          }
          break;
        }
        target_place <<= margins;
        goto REPLACED;
      }
      else if (cs->popup_aref_point.is_defined() && cs->popup_aref_point != 0) {
        popup_placement = cs->popup_pref_point;
        placement = cs->popup_aref_point;
      }

      if (popup_placement == 0) {
        wchars halign;
        wchars valign;

        for (int n = 0; n < 2; ++n) {
          switch (placement) {
          case 4: // left

            valign = WCHARS("at-center");
            if (anchor->get_style(*this)->direction == direction_rtl) {
              set_popup_attachment(11);
              target_place.pointOf(4, anchor_place.pointOf(6));
              halign = WCHARS("at-right");
            }
            else {
              set_popup_attachment(5);
              target_place.pointOf(6, anchor_place.pointOf(4));
              halign = WCHARS("at-left");
            }

            t = target_place.x();
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            if (t != target_place.x()) {
              placement = 6; // right
              continue;
            }
            target_place <<= margins;

            break;
          case 0x17: // menu on the left
            valign = WCHARS("at-top");
            if (anchor->get_style(*this)->direction == direction_rtl) {
              set_popup_attachment(12);
              target_place.pointOf(7, anchor_place.pointOf(9));
              halign = WCHARS("at-right");
            }
            else {
              set_popup_attachment(4);
              target_place.pointOf(9, anchor_place.pointOf(7));
              halign = WCHARS("at-left");
            }
            t = target_place.x();
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            if (t != target_place.x()) {
              placement = 0x19; // right
              continue;
            }
            target_place <<= margins;
            break;

          case 0x14: // menu on the left / middle
            valign = WCHARS("at-middle");
            if (anchor->get_style(*this)->direction == direction_rtl) {
              set_popup_attachment(11);
              target_place.pointOf(4, anchor_place.pointOf(6));
              halign = WCHARS("at-right");
            }
            else {
              set_popup_attachment(5);
              target_place.pointOf(6, anchor_place.pointOf(4));
              halign = WCHARS("at-left");
            }
            t = target_place.x();
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            if (t != target_place.x()) {
              placement = 0x16; // right middle
              continue;
            }
            target_place <<= margins;
            break;

          case 0x18: // top
            valign = WCHARS("at-top");
            if (anchor->get_style(*this)->direction == direction_rtl) {
              set_popup_attachment(7);
              target_place.pointOf(3, anchor_place.pointOf(9));
              halign = WCHARS("at-right");
            }
            else {
              set_popup_attachment(9);
              target_place.pointOf(1, anchor_place.pointOf(7));
              halign = WCHARS("at-left");
            }
            t = target_place.y();
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            if (t != target_place.y()) {
              placement = 2; // bottom
              continue;
            }
            target_place <<= margins;
            break;

          case 8: // top
            valign = WCHARS("at-top");
            if (anchor->get_style(*this)->direction == direction_rtl) {
              set_popup_attachment(7);
              target_place.pointOf(3, anchor_place.pointOf(9));
              halign = WCHARS("at-right");
            }
            else {
              set_popup_attachment(9);
              target_place.pointOf(1, anchor_place.pointOf(7));
              halign = WCHARS("at-left");
            }
            // target_place -= point(0, popup->margin_width.bottom());
            t = target_place.y();
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            target_place <<= margins;
            break;

          case 6: // right
            valign = WCHARS("at-center");
            if (anchor->get_style(*this)->direction == direction_rtl) {
              set_popup_attachment(5);
              target_place.pointOf(6, anchor_place.pointOf(4));
              halign = WCHARS("at-right");
            }
            else {
              set_popup_attachment(11);
              target_place.pointOf(4, anchor_place.pointOf(6));
              halign = WCHARS("at-left");
            }
            t = target_place.x();
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            if (t != target_place.x()) {
              placement = 4; // left
              continue;
            }
            target_place <<= margins;
            break;
          case 0x19: // menu on the right
            valign = WCHARS("at-top");
            if (anchor->get_style(*this)->direction == direction_rtl) {
              set_popup_attachment(4);
              target_place.pointOf(9, anchor_place.pointOf(7));
              halign = WCHARS("at-left");
            }
            else {
              set_popup_attachment(12);
              target_place.pointOf(7, anchor_place.pointOf(9));
              halign = WCHARS("at-right");
            }
            t = target_place.x();
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            if (t != target_place.x()) {
              placement = 0x17; // left
              continue;
            }
            target_place <<= margins;
            break;

          case 0x16: // menu on the right centered vertically
            valign = WCHARS("at-middle");
            if (anchor->get_style(*this)->direction == direction_rtl) {
              set_popup_attachment(5);
              target_place.pointOf(6, anchor_place.pointOf(4));
              halign = WCHARS("at-left");
            }
            else {
              set_popup_attachment(11);
              target_place.pointOf(4, anchor_place.pointOf(6));
              halign = WCHARS("at-right");
            }
            t = target_place.x();
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            if (t != target_place.x()) {
              placement = 0x14; // left - middle
              continue;
            }
            target_place <<= margins;
            break;

          case 0x12: // bottom
            valign = WCHARS("at-bottom");
            if (anchor->get_style(*this)->direction == direction_rtl) {
              set_popup_attachment(7);
              target_place.pointOf(9, anchor_place.pointOf(3));
              halign = WCHARS("at-right");
            }
            else {
              set_popup_attachment(9);
              target_place.pointOf(7, anchor_place.pointOf(1));
              halign = WCHARS("at-left");
            }
            t = target_place.y();
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            if (t != target_place.y()) {
              placement = 8; // top
              continue;
            }
            target_place <<= margins;
            break;

          case 2: // bottom
            valign = WCHARS("at-bottom");
            if (anchor->get_style(*this)->direction == direction_rtl) {
              set_popup_attachment(7);
              target_place.pointOf(9, anchor_place.pointOf(3));
              halign = WCHARS("at-right");
            }
            else {
              set_popup_attachment(9);
              target_place.pointOf(7, anchor_place.pointOf(1));
              halign = WCHARS("at-left");
            }
            t = target_place.y();
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            target_place <<= margins;
            break;

          case 7: // left-top
            set_popup_attachment(0);
            target_place.pointOf(7, anchor_place.pointOf(7));
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            target_place <<= margins;
            break;
          case 1: // left-bottom
            set_popup_attachment(0);
            target_place.pointOf(1, anchor_place.pointOf(1));
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            target_place <<= margins;
            break;
          case 9: // right - top
            set_popup_attachment(0);
            target_place.pointOf(9, anchor_place.pointOf(9));
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            target_place <<= margins;
            break;
          case 3: // right - bottom
            set_popup_attachment(0);
            target_place.pointOf(3, anchor_place.pointOf(3));
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            target_place <<= margins;
            break;
          case 5: // center
            set_popup_attachment(0);
            target_place.pointOf(5, anchor_place.pointOf(5));
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            target_place <<= margins;
            break;
          case 0x20: // tooltip at the 'at'
            set_popup_attachment(0);
            if (anchor->get_style(*this)->direction == direction_rtl)
              target_place.pointOf(9, at + wcs_pos);
            else
              target_place.pointOf(7, at + wcs_pos);
            replace_on_screen(workspace_area, target_place, anchor_place, wt);
            target_place <<= margins;
            break;
          default: assert(false); return target_place;
          }
          break;
        }
        if (halign.length) {
          el->atts.set("hpos", halign);
          el->atts.set("vpos", valign);
          el->drop_styles(*this);
        }
      }
      else if (popup_placement >= 1 && popup_placement <= 9) {
        set_popup_attachment(0);
        target_place.pointOf(popup_placement, anchor_place.pointOf(placement & 0xF));
        replace_on_screen(workspace_area, target_place, anchor_place, wt);
        target_place <<= margins;
      }
      else // show popup 'at'
      {
        //rect borpad = el->border_distance(*this);
        set_popup_attachment(0);
        target_place.pointOf(placement & 0xF, at + client_screen_pos());
        replace_on_screen(workspace_area, target_place, anchor_place, wt);
        target_place <<= margins;
      }
    REPLACED:
      if (popup_attachment) {
        el->atts.set("popup-attachment",popup_attachment_ev(popup_attachment).to_string());
        el->drop_styles(*this);
      }

      point tpos = target_place.s;

      el->set_pos(tpos + point(el->ldata->borpad_left(), el->ldata->borpad_top()) - wcs_pos);

      if (!initial_state_popup)
        notify_popup_show(anchor, el, html::POPUP_READY);

      target_place >>= el->outline_border_distance(*this);

      return target_place;

    }; // calc_place

    // popup->notify_visual_status_change(*this,true);

    // if( anchor == popup->parent )

    if (!el->state.popup()) {
      el->drop_layout(this);
      // popup state indicators
      el->state.popup(true);
      el->state.content_non_editable(true);
      el->drop_styles(*this);

      hstyle cs = el->get_style(*this);
      cs->fetch_images(*this, el->doc());

      handle<iwindow> pup = create_window(el, anchor, wt, calc_place, mode);
      if (!pup) return false;
      pup->windowing_mode = mode;
      // el->drop_layout(this);

      if (!pup->is_tooltip())
        anchor->state_on(*this, S_OWNS_POPUP);
      // check_mouse();
      update_element(panchor);
    }
    else {
      el->drop_layout(this);
      rect rc = calc_place(*this, el, anchor);
      replace_windowed();
    }

    return true;
  }

  void view::notify_popup_show(element *anchor, element *popup, int code,
    int reason) {
    event_behavior evt(anchor ? anchor : popup, popup, code, reason);
    if (code == html::POPUP_READY || code == html::POPUP_DISMISSED)
      post_behavior_event(evt);
    else
      send_behavior_event(evt);
    // if(anchor)
    //  evt.target = popup;
    // ???? popup->on(*this,evt);
  }


  enum_item_def blur_edef[BLUR_BEHIND_SIZE] = {
      {BLUR_BEHIND_NONE, W("none")},
      {BLUR_BEHIND_ULTRA_DARK, W("ultra-dark")},
      {BLUR_BEHIND_DARK, W("dark")},
      {BLUR_BEHIND_LIGHT, W("light")},
      {BLUR_BEHIND_ULTRA_LIGHT, W("ultra-light")},
      {BLUR_BEHIND_CUSTOM, W("custom")},
  };

  void view::required_frame_attributes(frame_attributes& fatts) {
    //rsz.clear();
    //ft.clear();
    if (!doc()) return;
    // FRAME_TYPE

    OBSOLETE static name_or_symbol custom_frame = name_or_symbol("custom-frame"); // since 3.3.2.13
    OBSOLETE static name_or_symbol resizeable = name_or_symbol("resizeable");

    static name_or_symbol window_resizeable = name_or_symbol("window-resizable");
    static name_or_symbol window_minimizable = name_or_symbol("window-minimizable");
    static name_or_symbol window_maximizable = name_or_symbol("window-maximizable");
    static name_or_symbol window_frame = name_or_symbol("window-frame");
    static name_or_symbol window_blurbehind = name_or_symbol("window-blurbehind");

    static name_or_symbol window_width = name_or_symbol("window-width");
    static name_or_symbol window_height = name_or_symbol("window-height");

    static name_or_symbol window_min_width = name_or_symbol("window-min-width");
    static name_or_symbol window_min_height = name_or_symbol("window-min-height");

    static name_or_symbol window_max_width = name_or_symbol("window-max-width");
    static name_or_symbol window_max_height = name_or_symbol("window-max-height");

    if (doc()->atts.exist(window_frame)) {
      string val = doc()->atts.get_string(window_frame);

      if (val == CHARS("default"))
        fatts.frame_type = STANDARD;
      else if (val == CHARS("solid"))
        fatts.frame_type = SOLID;
      else if (val == CHARS("solid-with-shadow"))
        fatts.frame_type = SOLID_WITH_SHADOW;
      else if (val == CHARS("transparent"))
        fatts.frame_type = LAYERED;
      else if (val == CHARS("extended"))
        fatts.frame_type = STANDARD_EXTENDED;
      else
        fatts.frame_type = STANDARD;
    }
    else if (doc()->atts.exist(custom_frame)) {
      string val = doc()->atts.get_string(custom_frame);
      if (val == CHARS("false") || val == CHARS("none"))
        fatts.frame_type = STANDARD;
      else if (val == CHARS("solid"))
        fatts.frame_type = SOLID;
      else if (val == CHARS("solid-with-shadow"))
        fatts.frame_type = SOLID_WITH_SHADOW;
      else if (val == CHARS("glassy"))
        // ft = GLASSY;
        fatts.frame_type = SOLID;
      else
        fatts.frame_type = LAYERED;
    }
    else
      fatts.frame_type.clear();

    if (doc()->atts.exist(window_resizeable))
      fatts.resizeable = doc()->atts.get_bool(window_resizeable, false);
    else if (doc()->atts.exist(resizeable))
      fatts.resizeable = doc()->atts.get_bool(resizeable, false);

    if (doc()->atts.exist(window_minimizable))
      fatts.minimizable = doc()->atts.get_bool(window_minimizable, false);
    if (doc()->atts.exist(window_maximizable))
      fatts.maximizable = doc()->atts.get_bool(window_maximizable, false);

    if (doc()->atts.exist(window_blurbehind)) {
      fatts.glassy = doc()->atts.get_enum(window_blurbehind, items_of(blur_edef)).val(BLUR_BEHIND_CUSTOM);
    }

    fatts.width = doc()->atts.get_size(window_width, size_v(), NUMBER_DIP);
    fatts.height = doc()->atts.get_size(window_height, size_v(), NUMBER_DIP);

    fatts.min_width = doc()->atts.get_size(window_min_width, size_v(), NUMBER_DIP);
    fatts.min_height = doc()->atts.get_size(window_min_height, size_v(), NUMBER_DIP);

    fatts.max_width = doc()->atts.get_size(window_max_width, size_v(), NUMBER_DIP);
    fatts.max_height = doc()->atts.get_size(window_max_height, size_v(), NUMBER_DIP);

  }

  bool view::on(view &v, element *self, html::event_behavior &evt) {
    /*if ((evt.cmd == DOCUMENT_RELOAD) && doc()) {
      string url = doc()->doc_url();
      //doc()->is_reloading = true;
      if (unload_doc(false))
        this->load_url(url);
      return true;
    }*/
    return false;
  }

  bool inscribe_to_screen(iwindow *pw, rect &target_place,
    const rect &anchor_place) {
    gool::rect mr = pw->screen_workarea(target_place);
    gool::rect rc = target_place;
    rc.inscribe(mr);
    bool r = rc == target_place;
    target_place = rc;
    return r;
  }

  // bool replace_on_screen( iwindow* pw, rect& target_place /* screen relative
  // */, const rect& initiator_place/* screen relative */, WINDOW_TYPE for_type )
  //{
  //  if(for_type == TOOLTIP_WINDOW || for_type == POPUP_WINDOW ) // we inscribe
  //  only popups and tooltips
  //  {
  //    rect anchor_place = initiator_place;

  //   //dbg_printf("target place before inscribing left %d top %d w %d h %d\n",
  //   target_place.left(), target_place.top(), target_place.width(),
  //   target_place.height());
  //    bool r = inscribe_to_screen(pw,target_place, anchor_place);
  //    return r;
  //  }
  //  else
  //    return false;
  //}

  bool replace_on_screen(rect screen_place,
    rect& target_place /* screen relative */,
    const rect& initiator_place /* screen relative */,
    WINDOW_TYPE for_type) {
    if (for_type == TOOLTIP_WINDOW ||  for_type == POPUP_WINDOW) // we inscribe only popups and tooltips
    {
      rect anchor_place = initiator_place;
      gool::rect rc = target_place;
      rc.inscribe(screen_place);
      bool r = rc == target_place;
      target_place = rc;
      return r;
    }
    else
      return false;
  }

  url_data *url_data::from(pump::request *rq) {
    url_data *pdata = new url_data();
    pdata->url = rq->url;
    pdata->content_url = rq->real_url();
    pdata->data_type = rq->data_type;
    // pdata->headers = rq->headers;
    pdata->data = rq->data; // NOPE: pdata->data.transfer_from(rq->data);
    pdata->data_content_type = rq->data_content_type;
    pdata->data_content_encoding = rq->data_content_encoding;
    return pdata;
  }

  /*  array<ustring> file_filter_to_ext_list(const wchar* filter) {

      array<ustring> out;

      auto add_filter = [&out](tool::ustring title, tool::ustring pattern)
      {
        wchars pat = pattern();
        while (!!pat) {
          tool::wchars glob = pat.chop(';');
          if (!glob)
            break;
          out.push(glob.r_tail('.', true));
        }
      };

      auto add_filters = [&add_filter](tool::wchars filters)
      {
        while (!!filters) {
          tool::wchars name = filters.chop('|');
          tool::wchars filt = filters.chop('|');
          if (!!name && !!filt)
            add_filter(name, filt);
        }
      };
      return out;
    }*/

} // namespace html

namespace tool {
  namespace async {

    void dispatch::start_timer() {
      html::view* pv = html::view::last<html::view>();
      assert(pv);
      while (pv) {
        if (!pv->parent()) {
          pv->request_idle();
          break;
        }
        else
          pv = pv->parent();
      }
    }
    void dispatch::stop_timer() {
    }
  }
}
