#include "html.h"

namespace html {

  bool stops_layout_propagation(view &v, element *el) {
    if (el->state.popup() || el->airborn) return true;
    if (el->c_style == element::null_style) return false;
    return el->c_style->stops_layout_propagation();
  }

  /*void view::update(element *b)
  {
    //on_idle(); -- wrong!
    to_update.update(this);

  }*/
  bool view::drop_styles(helement el) 
  {
    if (!invalid_style_root) {
      invalid_style_root = el;
      request_idle();
      //refresh(el);
    }
    else if (invalid_style_root->belongs_to(el)) {
      invalid_style_root = el;
      //refresh(el);
    }
    return _drop_styles(el);
  }

  bool view::_drop_styles(helement el)
  {
    if (el->c_style == element::null_style || el->d_style == element::null_style)
      return false;

    //if (el->c_style->is_display_none() && !force_all)
    //  return false;

    el->each_any_child([this](element *el) -> bool {
      this->_drop_styles(el);
      return false;
    });
    el->flags.has_transformed = 0;
    el->clear_style();
    return true;
}


  void measure_out_of_flow(view &v, element *b) {

#ifdef _DEBUG
    if (b->is_id_test())
      b = b;
#endif

    point pos = b->pos();
    b->drop_layout(&v);

    element *anchor = v.popup_anchor(b);
    if (!anchor) anchor = v.doc();

    // point start_pos = anchor->view_pos(v);
    element *solid_a = block_parent(v, anchor);
    size     parent_dim =
        solid_a ? solid_a->border_box(v).size() : anchor->border_box(v).size();

    rect workspace_area = v.screen_workarea();
    size max_sz;
    max_sz.x = workspace_area.width();
    max_sz.y = workspace_area.height();
    b->measure_oof(v, parent_dim, max_sz);

    b->set_pos(pos);
  }

  void view::add_to_update(element *el, STYLE_CHANGE_TYPE ut) {
    if (!el) return;

    if (!el->is_connected()) {
      el->drop_layout();
      el->drop_style();
      return;
    }
    to_update.add(this, el, ut);
  }

  bool update_queue::is_covered_by(element *b, helement &by) {
    for (int n = 0; n < _set.size(); ++n) {
      element *t = _set[n];
      if (b->belongs_to(t)) {
        by = t;
        return true;
      }
    }
    return false;
  }

  void update_queue::request_scroll_pos(helement el, point pos, bool smooth,
                                        bool allow_out_of_bounds) {
    for (auto &spr : _spqueue) {
      if (spr.el == el) {
        spr.to_top.clear();
        spr.pos                 = pos;
        spr.smooth              = smooth;
        spr.allow_out_of_bounds = allow_out_of_bounds;
        return;
      }
    }
    spitem spr;
    spr.el = el;
    spr.to_top.clear();
    spr.pos                 = pos;
    spr.smooth              = smooth;
    spr.allow_out_of_bounds = allow_out_of_bounds;
    _spqueue.push(spr);
  }

  void update_queue::request_ensure_visible(helement el, bool to_top,
                                            bool smooth) {
    for (auto &spr : _spqueue) {
      if (spr.el == el) {
        spr.to_top = uint(to_top);
        spr.smooth = smooth;
        return;
      }
    }
    spitem spr;
    spr.el     = el;
    spr.to_top = uint(to_top);
    spr.smooth = smooth;
    _spqueue.push(spr);
  }

  void update_queue::mark_changing_dimension(view *v, element *b) {

    //b->drop_content_layout(v);

    if (auto peid = b->pseudo_element_id())
    {
      if (peid == PSEUDO_MARKER) {
        b->flags.marker_layout_valid = 0;
        b->drop_content_layout(v);
        return;
      }
      if (peid == PSEUDO_SHADE) {
        b->flags.shadow_layout_valid = 0;
        b->drop_content_layout(v);
        return;
      }
    }
    
    helement cap;
    if (is_covered_by(b, cap)) {
      for (helement bp = b; bp; bp = bp->layout_parent(*v)) {
        if (bp->state.popup()) {
          bp->drop_content_layout(v);
          if (_set.get_index(bp) < 0) _set.push(bp);
          return;
        }
        // if(!bp->is_layout_valid())
        //  break;
        if (bp == cap) break;
        bp->drop_content_layout(v);
      }
      return;
    }
    // find parent with known layout:
    for (helement bp = b; bp; bp = bp->layout_parent(*v)) {
      if (bp->state.popup()) {
        bp->drop_content_layout(v);
        if (_set.get_index(bp) < 0) _set.push(bp);
        return;
      }

      // if(!bp->is_layout_valid()) - wrong, too optimistic in some cases.
      //  break;

      if (bp != b && bp->is_layout_valid() && stops_layout_propagation(*v, bp)) {
        v->refresh(bp);
        bp->drop_content_layout(v);
        _set.push(bp);
        return;
      }
      bp->drop_content_layout(v);
    }
    // need to rebuild whole document
    if (v->doc()) {
      v->refresh();
      v->doc()->drop_content_layout(v);
      _set.push(v->doc());
    }
  }

  void update_queue::mark_invalid_model(view *v, element *b) {

    if (auto peid = b->pseudo_element_id())
    {
      if (peid == PSEUDO_MARKER) {
        b->drop_content_layout(v);
        b->flags.marker_layout_valid = 0;
        return;
      }
      if (peid == PSEUDO_SHADE) {
        b->drop_content_layout(v);
        b->flags.shadow_layout_valid = 0;
        return;
      }
    }

    v->_drop_styles(b);
    b->flags.model_valid = 0;
    if (!stops_layout_propagation(*v, b)) {
      element *owner = b->get_owner();
      if (owner) {
        owner->drop_content_layout(v);
        owner->flags.model_valid = 0;
      }
      if (b->parent && (owner != b->parent)) {
        b->parent->drop_content_layout(v);
        b->parent->flags.model_valid = 0;
      }
    }

    if (b->is_inline_element(*v)) {
      b = b->nearest_known_box();
      if (b) {
        b->drop_content_layout(v);
        b->flags.model_valid = 0;
      }
    }
    mark_changing_dimension(v, b);
  }

  void update_queue::queue(view *v, element *b, STYLE_CHANGE_TYPE ut) {

    if (is_empty()) v->request_idle();

    for (auto& qi : _queue) {
      if (qi.el == b) {
        if (ut > qi.sct) qi.sct = ut;
        return;
      }
      //if (b->belongs_to(qi.el) && ut <= qi.sct) { - reactor::vtape
      //  return; // coverd by queued element 
      //}
    }
    qitem qi = {b, ut};
    _queue.push(qi);

  }

  void update_queue::add(view *v, element *b, STYLE_CHANGE_TYPE ut) {
    if (!b || ut == NO_CHANGES) return;
    view* pv = b->pview();
    if (v != pv) return;
    queue(v, b, ut);
  }

  void update_queue::do_add(view *v, helement b, STYLE_CHANGE_TYPE ut) {

    if (!b->is_connected()) 
      return;

    ++update_rq;

    switch (ut) {
    case CHANGES_DIMENSION:
      if (!b->is_inside_text_flow(*v)) {
        mark_changing_dimension(v, b);
        break;
      } // else we need to change model so fall through
    case CHANGES_MODEL: mark_invalid_model(v, b); return;
    case CHANGES_POSITION: {
      element *pel = b->abs_pos_parent(*v);
      // b->drop_style(v);
      if (pel) {
        pel->drop_positioned(v);
        mark_changing_dimension(v, pel);
      } else 
        mark_changing_dimension(v, b);
      return;
    }

    case RESOLVE_STYLE: {
      b->get_style(*v);
      return;
    }
                        
    default: { // do not need remeasure
      element *pb = b->nearest_box();
      if (!pb) return;
      v->refresh(pb);
      b->drop_styles(*v);
      return;
    }
    }
  }

  void update_queue::update(view *v) {
    if (inside_update)
      return; // to prevent stack overflow in some degenerative cases

    auto_state<bool> _(inside_update, true);

    uint queue_size = (uint)_queue.length();

    for (uint n = 0; n < queue_size; ++n) {
      qitem &qi = _queue[n];
      do_add(v, qi.el, qi.sct);
    }
    _queue.remove(0, queue_size);

    for (int attempt = 1; attempt <= 10; ++attempt) {

      if (_set.size() == 0) break;

      _working_set.clear();
      _working_set.swap(_set);

      for (int n = 0; n < _working_set.size(); ++n) {
        helement b = _working_set[n];
        if (!b) continue;
        if (!b->pview()) continue;

        b->resolve_styles(*v);
        hstyle cs = b->get_style(*v);
        b->check_layout(*v);
        handle<element> owner = b->get_owner();
        if (b->state.popup() && owner && b->doc()) {
          v->refresh(b);
          // assert(NOT_YET);
          measure_out_of_flow(*v, b);
          v->refresh(b);
          continue;
        } else if (cs->is_position_detached()) {
          if (cs->visible()) b->commit_measure(*v);
          v->refresh(b);
          continue;
        } else if (b->positioned(*v) && !b->rel_positioned(*v)) {
          // if( require_rem )
          b = b->layout_parent(*v);
          if (b) b->commit_measure(*v);
        } else if (!cs->is_display_none()) {
          if (owner && owner->is_table_row()) b = owner;
          b->commit_measure(*v);
          v->refresh(b);
        }
      } // for( int n = 0; n < working_set.size(); ++n )

    } // for(int attempt = 1; attempt <= 2; ++attempt )

    assert(_set.size() == 0);

    for (auto &spr : _spqueue) {
      if (!spr.el || (spr.el->pview() != v)) continue; // it was removed on the way
      if (spr.to_top.is_defined())
        v->_ensure_visible(spr.el, !!spr.to_top,
                           spr.smooth ? SCROLL_SMOOTH : SCROLL);
      else
        spr.el->do_set_scroll_pos(*v, spr.pos, spr.smooth,
                                  spr.allow_out_of_bounds);
    }
    _spqueue.clear();
    if (update_rq) {
      // v->replace_windowed();
      v->check_mouse(true);
      update_rq = 0;
    }
    v->replace_windowed();
    if (!is_empty()) v->request_idle();
  }


  void update_queue::clear(element *b) {
    for (int n = 0; n < _set.size();) {
      element *t = _set[n];
      if (b->belongs_to(t, true)) {
        _set.remove(n);
        continue;
      }
      ++n;
    }
  }

  void update_queue::reduce_set(view *v) {
    element *cp = _set[0];
    for (int n = 1; n < _set.size(); ++n) {
      element *t = _set[n];
      if (t->belongs_to(cp, true)) continue;
      cp = element::find_common_parent(cp, t);
    }
    _set.clear();
    _set.push(cp);
    cp->drop_content_layout();
  }

  bool view::mutator_push(element* p) {
    if (mutator_stack.size() == 0)
    {
      mutator_rec mr;
      mr.el = p;
      mr.flags = 0;
      mutator_stack.push(mr);
      return true;
    }
    const mutator_rec &mr = mutator_stack.last();
    if (mr.el == p)
      return false;
    else
    {
      mutator_rec mr;
      mr.el = p;
      mr.flags = 0;
      mutator_stack.push(mr);
      return true;
    }
  }
  void view::mutator_pop() 
  {
    auto has_changes_above = [](slice<mutator_rec> stack) -> bool {
      for (int i = stack.size() - 1; i >= 0; --i)
        if (stack[i].flags)
          return true;
      return false;
    };
    auto mr = mutator_stack.pop();
    if (mr.flags)
      mr.el->commit_mutation(*this, mr.flags, !has_changes_above(mutator_stack()));
  }

  bool view::mutator_rq(element* p, uint flags) {
    if (mutator_stack.size() == 0) return true; // proceed with normal update
    auto& mr = mutator_stack.last();
    if (mr.el != p) return true; // proceed with normal update
    mr.flags |= flags;
    return false; // will update
  }


} // namespace html