#include "html.h"

namespace html {

#ifdef _DEBUG
  int style::_total = 0;

  int _total_new = 0;
  int _total_reused = 0;

#endif

  tool::lookup_tbl<string> span_class_vocabulary;

  char_mark_t span_class_bit(const string &cls) {
    uint r = span_class_vocabulary.insert(cls) - 1;
    if (r >= sizeof(char_mark_t) * 8) {
      assert(false);
      return 0;
    }
    return (char_mark_t)(1u << r); // bit flag
  }

  array<string> span_class_names(char_mark_t b) {
    array<string> names;
    for (uint r = 0; r < sizeof(char_mark_t) * 8 && r <= span_class_vocabulary.size(); ++r)
      if (char_mark_t(1u << r) & b)
        names.push(span_class_vocabulary(r + 1));
    return names;
  }

  char_mark_t apply_span_class(char_mark_t id, slice<string> additions) {
    for (auto name : additions)
      id |= span_class_bit(name);
    return id;
  }

  char_mark_t remove_span_class(char_mark_t id, slice<string> removals) {
    for (auto name : removals)
      id &= ~span_class_bit(name);
    return id;
  }

  bool mark_id_contains_class(char_mark_t id, chars cls) {
    if (id) {
      uint mask = span_class_bit(cls);
      return (id & mask) != 0;
    }
    return false;
  }


  inline void resolve_value(size_v &v, const style &on_that, const size_v &parent_val) {
    //v = unname(v, on_that);
    if (v.is_inherit())
      v = parent_val;
     
  }

  inline void resolve_inheritable_value(size_v & v, const style & on_that, const size_v & parent_val) {
    //v = unname(v, on_that);
    if (v.is_inherit() || v.is_undefined())
      v = parent_val;
  }


  inline void resolve_value(color_v &v, const style & on_that, const color_v &parent_val) {
    //v = unname(v, on_that);
    if (v.is_inherit())
      v = parent_val;
    /*else if (v.is_current()) {
      v = on_that.font_color;
      if(!v.is_current())
        resolve_value(v, on_that, parent_val);
    }*/
  }

  inline void resolve_inheritable_value(color_v &       v,
                                        const style &   on_that,
                                        const color_v & parent_val) {
    //v = unname(v, on_that);
    if (v.is_inherit() || v.is_undefined())
      v = parent_val;
    /*else if (v.is_current()) {
      v = on_that.font_color;
      resolve_value(v, on_that, parent_val);
    }*/
  }

  template <typename T>
  inline void resolve_value(T &v, const style &on_that,
                            const T &parent_val) {
    if (v.is_inherit()) v = parent_val;
  }

  template <typename T>
  inline void resolve_inheritable_value(T &v, const style &on_that, const T &parent_val) {
    if (v.is_inherit() || v.is_undefined()) v = parent_val;
  }

  /*gool::argb style::resolve_color(color_v v) const {
    return unname(v,*this).to_argb(nullptr);
  }

  bool  style::resolve_color(uint attr_sym, color_v& val) const
  {
    return variables.get_color(attr_sym, val);
  }

  size_v style::resolve_length(size_v v) const 
  {
    return unname(v, *this);
  }*/

  bool style::apply_to(const element_context& ctx, style &s, uint inherit_mode, bool apply_important)
  {
    style *importants = get_importants(false);
    if (apply_important)
      s.inherit(importants, inherit_mode);
    else
      s.inherit(this, inherit_mode);
    return importants != nullptr;
  }

  void style::apply_variables(const element_context& ctx, style &s) {
    s.vars.inherit(vars);
  }


#define RESOLVE(n) resolve_value(n, that, parent.n)
#define RESOLVE_INHERITABLE(n) resolve_inheritable_value(n, that, parent.n)

  char_style char_style::null_val;
  para_style para_style::null_val;
  rect_style rect_style::null_val;

  inline bool hpcf_fast_check(const style_def *psd, ui_state st) {
    if (psd->pseudos.is_defined() && ui_state::intersect(psd->pseudos, st))
      return true;
    if (psd->negation)
      return psd->negation->pseudos.is_defined() &&
             ui_state::intersect(psd->negation->pseudos, st);
    return false;
  }

  // pool<image_color_transformation>
  // rect_style::image_def::color_transformations;

  void rect_style::resolve(resolution_provider &v, const style &that, const style &parent) {

    RESOLVE(back_color);
    RESOLVE(fore_color);
    // RESOLVE(back_color[1]);
    // RESOLVE(back_color[2]);
    // RESOLVE(back_color[3]);

    // RESOLVE(back_image);
    // moved to char_rect RESOLVE(text_decoration);
    RESOLVE(opacity);

    // RESOLVE(fore_image);

    // if(src->border_radius.defined())    border_radius = src->border_radius;

    RESOLVE(border_width[0]);
    RESOLVE(border_width[1]);
    RESOLVE(border_width[2]);
    RESOLVE(border_width[3]);

    RESOLVE(border_color[0]);
    RESOLVE(border_color[1]);
    RESOLVE(border_color[2]);
    RESOLVE(border_color[3]);

    RESOLVE(border_style[0]);
    RESOLVE(border_style[1]);
    RESOLVE(border_style[2]);
    RESOLVE(border_style[3]);

    RESOLVE(border_radius[0]);
    RESOLVE(border_radius[1]);
    RESOLVE(border_radius[2]);
    RESOLVE(border_radius[3]);
    RESOLVE(border_radius[4]);
    RESOLVE(border_radius[5]);
    RESOLVE(border_radius[6]);
    RESOLVE(border_radius[7]);

    RESOLVE(padding_width[0]);
    RESOLVE(padding_width[1]);
    RESOLVE(padding_width[2]);
    RESOLVE(padding_width[3]);

    RESOLVE(margin[0]);
    RESOLVE(margin[1]);
    RESOLVE(margin[2]);
    RESOLVE(margin[3]);

    RESOLVE(outline_color);
    RESOLVE(outline_width);
    RESOLVE(outline_style);
    RESOLVE(outline_offset);
    RESOLVE(outline_shift_x);
    RESOLVE(outline_shift_y);

    RESOLVE(width);
    RESOLVE(height);

    RESOLVE(min_width);
    RESOLVE(min_height);

    RESOLVE(max_width);
    RESOLVE(max_height);

    RESOLVE(display);
    //RESOLVE(display_model);
    RESOLVE(visibility);
    RESOLVE(floats);

    RESOLVE(vertical_align);
    RESOLVE(content_vertical_align);
    RESOLVE(horizontal_align);
    RESOLVE(flow);
    RESOLVE(overflow_x);
    RESOLVE(overflow_y);

    // behavior = combine_behavior(behavior,src->behavior);

    RESOLVE(clears);
    RESOLVE(box_sizing);
    RESOLVE(clip_box);

    RESOLVE(position);
    RESOLVE(z_index);
    RESOLVE(left);
    RESOLVE(right);
    RESOLVE(top);
    RESOLVE(bottom);

    RESOLVE(text_overflow);

    // WHY?????
    //if (foreground_image_cursor.is_undefined() || foreground_image_cursor == cursor::inherit)
    //  foreground_image_cursor = parent.foreground_image_cursor;

    // RESOLVE(vscrollbar);
    // RESOLVE(hscrollbar);

    RESOLVE(border_spacing_x);
    RESOLVE(border_spacing_y);
    RESOLVE(border_collapse);

    RESOLVE(transform_origin_x);
    RESOLVE(transform_origin_y);

    RESOLVE(popup_aref_point);
    RESOLVE(popup_pref_point);
    RESOLVE(popup_attachment);

    if (box_shadow == shadow_def::inherit_val()) box_shadow = parent.box_shadow;
  }

  /*OBSOLETE: string combine_behavior(document* pd, const string& ov, const
  string& nv)
  {

    if(nv.length())
    {
      string v;
      if( nv.starts_with("~ "))
      {
        chars st = nv();
        assert(st[1] == ' ');
        ++st.start;
        --st.length;
        if( ov.ends_with(" ~") ) // "something1 ~" + "~ something2" =
  "something1 something2 ~" v = pd->string_pool.intern( ov.substr(0, nv.size() -
  2) + st + " ~" ); else if(ov.length()) v = pd->string_pool.intern( ov + st);
        else // ov.length() == 0
        {
          while(st.length && st[0] == ' ')
            st.prune(1);
          v = pd->string_pool.intern(st);
        }
      }
      else if( nv.ends_with(" ~") )
      {
        chars st = nv();
        assert(st[st.length-2] == ' ');
        --st.length;
        if( ov.starts_with("~ ") ) // "~ something1" + "something2 ~" = "~
  something2 something1" v = pd->string_pool.intern( string("~ ") + st +
  ov.substr(2)); else if(ov.length()) v = pd->string_pool.intern( st + ov); else
  // ov.length() == 0
        {
          while(st.length && st.last() == ' ')
            st.prune(0,1);
          v = pd->string_pool.intern(st);
        }
      }
      else
        v = pd->string_pool.intern(nv);
      return v;
    }
    return ov;
  }*/

  void rect_style::inherit(const rect_style *src, bool background) {
    if (!src) return;

    if (background) {
      back_color.inherit(src->back_color);
      // back_color[0].inherit(src->back_color[0]);
      // back_color[1].inherit(src->back_color[1]);
      // back_color[2].inherit(src->back_color[2]);
      // back_color[3].inherit(src->back_color[3]);
      back_image.inherit(src->back_image);
      // text_decoration.inherit(src->text_decoration);
      opacity.inherit(src->opacity);
      back_gradient.inherit(src->back_gradient);
    }

    fore_image.inherit(src->fore_image);
    fore_color.inherit(src->fore_color);
    fore_gradient.inherit(src->fore_gradient);

    border_width[0].inherit(src->border_width[0]);
    border_width[1].inherit(src->border_width[1]);
    border_width[2].inherit(src->border_width[2]);
    border_width[3].inherit(src->border_width[3]);

    border_color[0].inherit(src->border_color[0]);
    border_color[1].inherit(src->border_color[1]);
    border_color[2].inherit(src->border_color[2]);
    border_color[3].inherit(src->border_color[3]);

    border_style[0].inherit(src->border_style[0]);
    border_style[1].inherit(src->border_style[1]);
    border_style[2].inherit(src->border_style[2]);
    border_style[3].inherit(src->border_style[3]);

    border_radius[0].inherit(src->border_radius[0]);
    border_radius[1].inherit(src->border_radius[1]);
    border_radius[2].inherit(src->border_radius[2]);
    border_radius[3].inherit(src->border_radius[3]);
    border_radius[4].inherit(src->border_radius[4]);
    border_radius[5].inherit(src->border_radius[5]);
    border_radius[6].inherit(src->border_radius[6]);
    border_radius[7].inherit(src->border_radius[7]);

    padding_width[0].inherit(src->padding_width[0]);
    padding_width[1].inherit(src->padding_width[1]);
    padding_width[2].inherit(src->padding_width[2]);
    padding_width[3].inherit(src->padding_width[3]);

    margin[0].inherit(src->margin[0]);
    margin[1].inherit(src->margin[1]);
    margin[2].inherit(src->margin[2]);
    margin[3].inherit(src->margin[3]);

    outline_color.inherit(src->outline_color);
    outline_width.inherit(src->outline_width);
    outline_style.inherit(src->outline_style);
    outline_offset.inherit(src->outline_offset);
    outline_shift_x.inherit(src->outline_shift_x);
    outline_shift_y.inherit(src->outline_shift_y);

    width.inherit(src->width);
    height.inherit(src->height);

    min_width.inherit(src->min_width);
    min_height.inherit(src->min_height);

    max_width.inherit(src->max_width);
    max_height.inherit(src->max_height);

    display.inherit(src->display);
    //display_model.inherit(src->display_model);
    visibility.inherit(src->visibility);
    floats.inherit(src->floats);

    vertical_align.inherit(src->vertical_align);
    content_vertical_align.inherit(src->content_vertical_align);
    horizontal_align.inherit(src->horizontal_align);
    flow.inherit(src->flow);
    overflow_x.inherit(src->overflow_x);
    overflow_y.inherit(src->overflow_y);

    behavior.inherit(src->behavior);
    // behavior = combine_behavior(behavior,src->behavior);

    clears.inherit(src->clears);
    box_sizing.inherit(src->box_sizing);
    clip_box.inherit(src->clip_box);
    
    position.inherit(src->position);

    text_overflow.inherit(src->text_overflow);
    foreground_image_cursor.inherit(src->foreground_image_cursor);

    border_spacing_x.inherit(src->border_spacing_x);
    border_spacing_y.inherit(src->border_spacing_y);
    border_collapse.inherit(src->border_collapse);

    context_menu_url.inherit(src->context_menu_url);
    context_menu_sel.inherit(src->context_menu_sel);

#if defined(SCITER) || defined(SCITERJS)
    prototype.inherit(src->prototype); // prototype object
    prototype_url.inherit(src->prototype_url);
#endif

    page_break_after.inherit(src->page_break_after);
    page_break_before.inherit(src->page_break_before);
    page_break_inside.inherit(src->page_break_inside);

    role.inherit(src->role);

    z_index.inherit(src->z_index);
    left.inherit(src->left);
    right.inherit(src->right);
    top.inherit(src->top);
    bottom.inherit(src->bottom);

    hit_margin[0].inherit(src->hit_margin[0]);
    hit_margin[1].inherit(src->hit_margin[1]);
    hit_margin[2].inherit(src->hit_margin[2]);
    hit_margin[3].inherit(src->hit_margin[3]);

    content.inherit(src->content);

    draggable.inherit(src->draggable);
    accept_drop.inherit(src->accept_drop);
    drop.inherit(src->drop);

    transform_origin_x.inherit(src->transform_origin_x);
    transform_origin_y.inherit(src->transform_origin_y);

    popup_aref_point.inherit(src->popup_aref_point);
    popup_pref_point.inherit(src->popup_pref_point);

    popup_attachment.inherit(src->popup_attachment);

    box_shadow.inherit(src->box_shadow);

    filter.inherit(src->filter);
    backdrop_filter.inherit(src->backdrop_filter);

    animation_style_bag.inherit(src->animation_style_bag);
    animation_name.inherit(src->animation_name);
    animation_delay.inherit(src->animation_delay);
    animation_duration.inherit(src->animation_duration);
    animation_iteration_count.inherit(src->animation_iteration_count);
    animation_timing_function.inherit(src->animation_timing_function);
    animation_fill_mode.inherit(src->animation_fill_mode);
    animation_direction.inherit(src->animation_direction);
    animation_play_state.inherit(src->animation_play_state);

  }

  void rect_style::inherit_background(const rect_style *src) {
    if (!src) return;

    back_color.inherit(src->back_color);
    back_gradient.inherit(src->back_gradient);
    // back_color[0].inherit(src->back_color[0]);
    // back_color[1].inherit(src->back_color[1]);
    // back_color[2].inherit(src->back_color[2]);
    // back_color[3].inherit(src->back_color[3]);
    back_image.inherit(src->back_image);
  }

  void char_style::inherit(const char_style *src) {
    if (!src) return;
    font_color.inherit(src->font_color);
    font_family.inherit(src->font_family);
    font_style.inherit(src->font_style);
    font_rendering_mode.inherit(src->font_rendering_mode);
    font_variant_ligatures.inherit(src->font_variant_ligatures);
    font_variant_caps.inherit(src->font_variant_caps);
    font_size.inherit(src->font_size);
    font_weight.inherit(src->font_weight);
    line_height.inherit(src->line_height);
    letter_spacing.inherit(src->letter_spacing);
    white_space.inherit(src->white_space);
    word_wrap.inherit(src->word_wrap);
    word_break.inherit(src->word_break);
    cursor.inherit(src->cursor);
    direction.inherit(src->direction);
    text_selection_color.inherit(src->text_selection_color);
    text_selection_background_color.inherit(src->text_selection_background_color);
    text_selection_caret_color.inherit(src->text_selection_caret_color);
    text_transform.inherit(src->text_transform);
    text_shadow.inherit(src->text_shadow);
    mapping.inherit(src->mapping);
    text_decoration_style.inherit(src->text_decoration_style);
    text_decoration_color.inherit(src->text_decoration_color);
    text_decoration_line.inherit(src->text_decoration_line);
    text_decoration_thickness.inherit(src->text_decoration_thickness);

    fill_color.inherit(src->fill_color);
    fill_id.inherit(src->fill_id);
    fill_opacity.inherit(src->fill_opacity);
    fill_rule.inherit(src->fill_rule);
    stroke_color.inherit(src->stroke_color);
    stroke_id.inherit(src->stroke_id);
    stroke_width.inherit(src->stroke_width);
    stroke_linecap.inherit(src->stroke_linecap);
    stroke_linejoin.inherit(src->stroke_linejoin);
    stroke_miterlimit.inherit(src->stroke_miterlimit);
    stroke_dasharray.inherit(src->stroke_dasharray);
    stroke_dashoffset.inherit(src->stroke_dashoffset);
    stroke_opacity.inherit(src->stroke_opacity);

    image_rendering.inherit(src->image_rendering);

    tab_size.inherit(src->tab_size);

    zoom.inherit(src->zoom);

    scroll_manner_x.inherit(src->scroll_manner_x);
    scroll_manner_y.inherit(src->scroll_manner_y);
  }

  void char_style::resolve(view &v, const element* pel, const style &that, const char_style &parent) {
    //static string s_inherit = "inherit";

    RESOLVE_INHERITABLE(direction);

    //font_size = unname(font_size,pel,&that);

    if (font_size.unit == size_v::unit_type::ch)
      font_size = size_v(0.5, size_v::unit_type::ch);

    if (font_size.is_undefined())
      font_size = parent.font_size;
    if(parent.font_size.is_defined())
      font_size.resolve(v, parent.font_size);

    if(line_height.is_undefined())
      line_height = parent.line_height;
    if (line_height.is_inherit()) 
      line_height = parent.line_height;
    // else if(line_height.unit != size_v::pr)
    else if (line_height.unit == size_v::unit_type::nm) {
      double m       = line_height.number(0.0);
      line_height = font_size;
      line_height.d.value = int(line_height.d.value * m);
    } 
    //else if (line_height.is_named())
    //  line_height = unname(line_height, that);

    if (letter_spacing.is_inherit() || letter_spacing.is_undefined())
      letter_spacing = parent.letter_spacing;
    else if (letter_spacing.is_defined())
      letter_spacing.resolve(v, font_size);

    // if(font_color.is_undefined()  || font_color.is_inherit())      font_color
    // = parent.font_color;
    RESOLVE_INHERITABLE(font_color);
    
    if (font_family.is_undefined() || font_family() == WCHARS("inherit"))
      font_family = parent.font_family;
    RESOLVE_INHERITABLE(font_style);
    RESOLVE_INHERITABLE(font_rendering_mode);
    RESOLVE_INHERITABLE(font_variant_ligatures);
    RESOLVE_INHERITABLE(font_variant_caps);
    RESOLVE_INHERITABLE(font_weight);
    RESOLVE_INHERITABLE(white_space);
    RESOLVE_INHERITABLE(word_wrap);
    RESOLVE_INHERITABLE(word_break);
    if (cursor.is_undefined() || cursor == cursor::inherit)
      cursor = parent.cursor;
    RESOLVE_INHERITABLE(text_selection_color);
    RESOLVE_INHERITABLE(text_selection_background_color);
    RESOLVE_INHERITABLE(text_selection_caret_color);
    RESOLVE_INHERITABLE(text_transform);
    if (text_shadow.is_undefined() || text_shadow == shadow_def::inherit_val())
      text_shadow = parent.text_shadow;
    RESOLVE_INHERITABLE(text_decoration_style);
    RESOLVE_INHERITABLE(text_decoration_color);
    RESOLVE_INHERITABLE(text_decoration_line);
    RESOLVE_INHERITABLE(text_decoration_thickness);

    RESOLVE_INHERITABLE(fill_color);
    RESOLVE_INHERITABLE(fill_id);
    RESOLVE_INHERITABLE(fill_opacity);
    RESOLVE_INHERITABLE(fill_rule);
    RESOLVE_INHERITABLE(stroke_color);
    RESOLVE_INHERITABLE(stroke_id);
    RESOLVE_INHERITABLE(stroke_width);
    RESOLVE_INHERITABLE(stroke_linecap);
    RESOLVE_INHERITABLE(stroke_linejoin);
    RESOLVE_INHERITABLE(stroke_miterlimit);
    RESOLVE_INHERITABLE(stroke_dasharray);
    RESOLVE_INHERITABLE(stroke_dashoffset);
    RESOLVE_INHERITABLE(stroke_opacity);

    RESOLVE_INHERITABLE(image_rendering);
    RESOLVE_INHERITABLE(tab_size);
    RESOLVE_INHERITABLE(zoom);

    mapping.resolve(parent.mapping);

    RESOLVE_INHERITABLE(scroll_manner_x);
    RESOLVE_INHERITABLE(scroll_manner_y);
  }

  void style::resolve(view &v, const element* pel, const style &parent_resolved_style) {
    char_style::resolve(v, pel, *this, parent_resolved_style);
    para_style::resolve(v, *this, parent_resolved_style);
    rect_style::resolve(v, *this, parent_resolved_style);

    if (text_decoration_line.is_undefined() && parent_resolved_style.text_decoration_line.is_defined())
      text_decoration_line = text_decoration_line | parent_resolved_style.text_decoration_line;

    if (display == display_inline && parent_resolved_style.display == display_inline && vertical_align.is_undefined())
      vertical_align = parent_resolved_style.get_text_vertical_align();
  }

  void style::fetch_images(view &v, document *d) {
    if (list_style_image.is_defined()) list_style_image.fetch(v, d);
    if (back_image.id.is_defined()) back_image.id.fetch(v, d);
    if (fore_image.id.is_defined()) fore_image.id.fetch(v, d);
  }

  void para_style::inherit(const para_style *src) {
    if (!src) return;
    text_align.inherit(src->text_align);
    text_indent.inherit(src->text_indent);
    list_style_image.inherit(src->list_style_image);
    list_style_position.inherit(src->list_style_position);
    list_style_type.inherit(src->list_style_type);
    list_marker_color.inherit(src->list_marker_color);
    list_marker_size.inherit(src->list_marker_size);
    list_marker_style.inherit(src->list_marker_style);
    style_set.inherit(src->style_set);
    style_set_base.inherit(src->style_set_base);
    appearance.inherit(src->appearance);
    vscrollbar.inherit(src->vscrollbar);
    hscrollbar.inherit(src->hscrollbar);
  }

  void para_style::resolve(resolution_provider &v, const style &that, const style &parent) {
    RESOLVE_INHERITABLE(text_align);
    RESOLVE(text_indent);
    // if(list_style_image.inherit()) list_style_image =
    // parent.list_style_image;
    RESOLVE_INHERITABLE(list_style_position);
    RESOLVE_INHERITABLE(list_style_type);
    RESOLVE_INHERITABLE(list_marker_color);
    RESOLVE_INHERITABLE(list_marker_size);
    RESOLVE_INHERITABLE(list_marker_style);
    RESOLVE_INHERITABLE(style_set);
    RESOLVE_INHERITABLE(style_set_base);
    RESOLVE_INHERITABLE(appearance);
    RESOLVE_INHERITABLE(vscrollbar);
    RESOLVE_INHERITABLE(hscrollbar);
  }

  bool match_first_token(const ustring &val, const ustring &str, wchar delimeter) {
    tokens<wchar> z(str(), wchars(delimeter));
    wchars        t;
    if (z.next(t)) {
      if (t == val) return true;
    }
    return false;
  }

  void disable_fast_css_match(element *b, bool v) {
    b->flags.disable_fast_css_match = uint(v);
    /*foreach(i, b->subs)
    {
      element *t = b->subs[i];
      if(t) t->state.disable_fast_css_match(v);
    }*/
  }

  bool style_def::apply_to(const element_context& ctx, style &s, uint inherit_mode, bool apply_important) {
    /*if (pseudo_element.val(0) != el->pseudo_element_id()) {
      s.pseudo_elements |= pseudo_element.val(0);
      return false;
    }*/
    return plist->apply_to(ctx, s, inherit_mode, apply_important);
  }

  void style_def::apply_variables(const element_context& ctx, style &s) {
    return plist->apply_variables(ctx, s);
  }

  bool style_def::apply_char_mark_styles_to(const element_context& ctx, style &s, uint inherit_mode, char_mark_t pseudo_id) {
    if ((pseudo_element.val(0) & pseudo_id) != 0)
      plist->apply_to(ctx, s, inherit_mode, false);
    return false;
  }
  
  bool style_def::match_single(const ustring &class_name, ui_state st) const {
    if (pseudos.is_defined()) {
      if (!st.match(pseudos)) return false;
    }

    attr_def *p = atts.head();
    if (!p || p->attr_eq_op != '~' || p->attr_value != class_name) return false;

    return true;
  }

  bool style_def::match_single(const element *el,
                               const element *root_element) const {
    const element* principal = el;
    if (pseudo_element.is_defined() && (el->pseudo_element_id() == pseudo_element))
      principal = el->owner;
    ui_state bst = principal->state;
    if (pseudos.is_defined() || (negation && negation->pseudos.is_defined())) {
      bst = principal->get_state(pseudos.disabled());
      if (root_element && (principal == root_element))
        bst.root(true);
    }
    return match_single(el, bst, root_element);
  }

  bool style_def::match_single(const element *el, ui_state st,
                               const element *root_element) const {
    return _match_single(el, st, root_element, false) &&
           !_match_single_negation(el, st, root_element, false);
  }

  bool style_def::depends_single(const element *el, ui_state st,
                                 const element *root_element) const {
    if (hpcf_fast_check(this, st))
      return _match_single(el, st, root_element, true) ||
             _match_single_negation(el, st, root_element, true);
    return false;
  }

  // NEXT LINE (#pragma optimize) is actually the must here, without it I have
  // some problems in VC++ 6 when "favor small code" optimization is used.
  // Probably some bug in code generator of VC++ 6.  Anyway these functions has
  // to be as fast as possible. style_def::_match_single is the function that
  // causes problem "in the galaxy far far away".
  //#pragma optimize( "t", on )

  inline int minus1(int v) {
    if (v > 0) return v - 1;
    if (v < 0) return v;
    return 0;
  }

  bool style_def::_match_single(const element *el, ui_state st,
                                const element *root_element,
                                bool           depends_on) const {
    
    if (this->pseudo_element.is_defined()) {
      if (el->pseudo_element_id() == this->pseudo_element.val(0))
        el = el->owner; // matching div::after pseudo as not-so-pseudo element div > _after
      else if (el->pseudo_element_id())
        return false;   //  div::after (div>_after) does not match div>_before rule
    }
    
    if (tag) {
      if (tag == TAG_ANY)
      {
        if (el->is_pseudo_element())
          return false; // '*' does not match ::after,::before
        //if (el->is_anonymous_text_block()) WRONG: is used
        //  return false; // '*' does not match syntetic <text>
      }
      else if(tag != el->tag)
        return false;
    }

    if (has_bound_attributes) {
      if (!el->atts.has_bound) return false;
    }

    if (id.length()) {
      ustring el_id = el->atts(attr::a_id);
      if (id != el_id) return false;
    }

    attr_def *p   = atts.head();
    attr_def *end = atts.tail();
    ustring   v;

    for (; p < end; ++p) {
      switch (p->attr_eq_op) {
      case 0:
        if (!el->atts.exist(p->attr_name)) return false;
        break;
      case '=':
        if (!el->atts.exist(p->attr_name, v) || v != p->attr_value)
          return false;
        break;
      case '#':
        if (!el->atts.exist(p->attr_name, v) || !lexical::ci::eq(v(),p->attr_value()))
          return false;
        break;
      case '~':
        if (p->attr_name == attr::a_class) {
          if (!el->atts.has_class(p->attr_value)) return false;
        } else if (!match_list(p->attr_value(), el->atts(p->attr_name)(),WCHARS(" ")))
          return false;
        break;
      case '%':
        if (!match_list_ci(p->attr_value(), el->atts(p->attr_name)(), WCHARS(" ")))
          return false;
        break;
      case '|':
        if (!match_first_token(p->attr_value, el->atts(p->attr_name), '-'))
          return false;
        break;

        //  [att^=val]
        //  Represents the att attribute whose value begins with the prefix
        //  "val"

      case '^':
        if (!el->atts(p->attr_name)().starts_with(p->attr_value())) return false;
        break;
      //  [att$=val]
      //  Represents the att attribute whose value ends with the suffix "val"
      case '$':
        if (!el->atts(p->attr_name)().ends_with(p->attr_value)) return false;
        //{
        // ustring t = el->atts(p->attr_name);
        // if(t.last_index_of(p->attr_value) != (t.length() -
        // p->attr_value.length()))
        //  return false;
        //}
        break;
      //  [att*=val]
      //  Represents the att attribute whose value contains at least one
      //  instance of the substring "val"
      case '*':
        if (el->atts(p->attr_name)().index_of(p->attr_value()) < 0) return false;
        break;
      }
    }

    // bool index_rel = false;
    // bool

    if (index || step) {
      disable_fast_css_match(const_cast<element *>(el), true);
      // F*** specification that has no specification of this behavior, only
      // guess
#if 0
      if (el->parent && el->parent->is_id_test() && el->index() == 0)
        el = el;

      if(step < 0)
      {
        if(el->index() >= index)
          return false;
      }
      else
      {
        int tindex = index;
        int idx = el->index();

        if( idx < 0 ) // synthetic elements.
          return false;
        int s = step;
        if( s != 0 )
        {
          idx %= s;
          if(tindex < 0) 
            tindex = s + tindex + 1;
        }
        else
          if(tindex < 0) 
            tindex = el->n_children() + tindex + 1;

        ++idx;
        if( s != 1)
        {
          if(idx != tindex) 
            return false;
        }
      }
#else
      if (el->parent) {
        int elindex = max(0, el->index()); // max(0, is needed here as synthetic
                                           // elements have index = -1
        if (step == 0) {
          if (elindex != minus1(index)) return false;
        } else if (step > 0) {
          elindex -= minus1(index);
          if ((elindex % step) != 0 || elindex < 0) return false;
        } else { // < 0
          elindex -= minus1(index);
          if ((elindex % -step) != 0 || elindex > 0) return false;
        }
      }
#endif
    }

    if (last_index || last_step) {
      disable_fast_css_match(const_cast<element *>(el), true);
#if 0 
      element* pel = el->parent;
      int idx = el->index();
      if( idx < 0 ) // synthetic element
        return false;
      if(pel)
      {
        if(last_step < 0)
        {
          idx = pel->n_children() - 1 - idx;
          if(idx >= last_index)
            return false;
        }
        else
        {
          idx = pel->n_children() - 1 - idx;
          int s = last_step;
          if( s != 0 )
            idx %= s;
          ++idx;
          if( s != 1)
          {
            if(idx != last_index) 
              return false;
          }
        }
      }
#else
      if (el->parent) {
        int n       = el->parent->n_children();
        int elindex = n - el->index() - 1;
        if (last_step == 0) {
          if (elindex != minus1(last_index)) return false;
        } else if (last_step > 0) {
          elindex -= minus1(last_index);
          if ((elindex % last_step) != 0 || elindex < 0) return false;
        } else { // < 0
          elindex -= minus1(last_index);
          if ((elindex % -last_step) != 0 || elindex > 0) return false;
        }
      }
#endif
    }

    // if(index_rel)
    //  disable_fast_css_match(const_cast<element*>(el),true);

    if (child_of_type) {
      disable_fast_css_match(const_cast<element *>(el), true);
      if (!el->has_child_of_type(child_of_type)) return false;
    }
    if (children_of_type) {
      disable_fast_css_match(const_cast<element *>(el), true);
      if (!el->has_children_of_type(children_of_type)) return false;
    }
    if (only_child) {
      disable_fast_css_match(const_cast<element *>(el), true);
      if (!el->parent) return false;
      if (el->index() != 0) return false;
      if (el->parent->n_children() != 1) return false;
    }
    if (only_child_of_type) {
      disable_fast_css_match(const_cast<element *>(el), true);
      if (!el->is_only_child_of_type()) return false;
    }
    if (lang.length()) {
      wchars sel_lang;
      wchars sel_country;
      if (!wchars(lang).split('-', sel_lang, sel_country)) sel_lang = lang;
      ustring el_lang_country = el->get_lang();
      wchars  el_lang;
      wchars  el_country;
      if (!wchars(el_lang_country).split('-', el_lang, el_country))
        el_lang = el_lang_country;

      if (sel_country.length) {
        if (sel_lang != el_lang || sel_country != el_country) return false;
      } else if (lang != el_lang)
        return false;
    }
    if (theme.length()) {
      ustring el_theme_ab = el->get_theme();
      wchars  el_theme_a;
      wchars  el_theme_b;
      if (!wchars(el_theme_ab).split('-', el_theme_a, el_theme_b))
        el_theme_a = el_theme_ab;

      if (el_theme_b.length) {
        if (el_theme_b != theme() && el_theme_a != theme())
          return false;
      }
      else if (el_theme_a != theme())
        return false;
    }

    if (pseudos.is_defined()) {
      el->style_state.data |= pseudos.data;
      if (pseudos.root()) {
        if (root_element) {
          if (el != root_element) return false;
        }
        else if (!el->is_document())
          return false;
      }
      if (depends_on) {
        if (!ui_state::intersect(st, pseudos)) return false;
      }
      else {
        if (!st.match(pseudos)) return false;
      }
    }

    /*if(pseudos.defined())
    {
      if(pseudos.has_child() || pseudos.has_children())
        disable_fast_css_match(const_cast<element*>(el),true);
    }*/

    return true;
  }

  bool style_def::_match_single_negation(const element *el, ui_state st,
                                         const element *root_element,
                                         bool           depends_on) const {
    style_def *t = negation;
    while (t) {
      if (t->_match_single(el, st, root_element, false) &&
          !t->_match_single_negation(el, st, root_element, false)) return true;
      t = t->next;
    }
    return false;
  }

  bool style_def::match(const element *el, const element *root_element, bool match_pseudos) const {
    if (media_expr && !media_expr->is_true) return false;

    if (!match_single(el, root_element)) return false;

    if (!match_pseudos && el->pseudo_element_id())
      el = el->parent;

    if (next == 0) return true;

    const style_def *psd = next;
    const element *  pel = el->parent;

    const element *top = root_element->parent;

    while (psd) {
      if (!pel || (pel == top)) return false;

      if (psd->depth) {
        for (uint d = 1; d < psd->depth; ++d) {
          pel = pel->parent;
          if (pel == top) return false;
          if (pel == 0) return false;
        }
        if (!psd->match_single(pel, root_element)) return false;
        psd = psd->next;
        el  = pel;
        pel = pel->parent;
        continue;
      } else if (psd->sibling) {
        disable_fast_css_match(const_cast<element *>(el), true);
        if (pel == top) return false;
        const element *tel;
        if (psd->sibling == ST_ADJACENT) {
          tel = el->prev_element();
          if (!tel) return false;
          const_cast<element*>(tel)->flags.has_sibling_selector = 1;
          if (!psd->match_single(tel, root_element)) return false;
        } else /*if (psd->sibling == ST_NEXT)*/ {
          for (tel = el->prev_element(); tel; tel = tel->prev_element())
            if (psd->match_single(tel, root_element)) goto FOUND;
          return false;
        }
FOUND:
        psd = psd->next;
        el  = tel;
        disable_fast_css_match(const_cast<element *>(tel), true);
        continue;
      }
      for (; pel != top;) {
        if (psd->match_single(pel, root_element)) { break; }
        el  = pel;
        pel = pel->parent;
        if (!pel) return false;
      }
      if (pel == top) return false;
      el  = pel;
      pel = pel->parent;
      psd = psd->next;
    }
    return true;
  }

  bool style_def::match(const element *el, ui_state st,
                        const element *root_element) const {
    if (media_expr && !media_expr->is_true) return false;

    if (!match_single(el, st, root_element)) return false;

    if (next == 0) return true;

    const style_def *psd = next;
    const element *  pel = el->parent;

    while (psd) {
      if (!pel) return false;
      // if(root_element && pel == root_element)
      //  return false;

      if (psd->depth) {
        for (uint d = 1; d < psd->depth; ++d) {
          //
          pel = pel->parent;
          if (pel == 0) return false;

          // if( pel->type == T_TEXT )
          //  continue; // skip anonymous paragraph
        }
        if (!psd->match_single(pel, root_element)) return false;
        psd = psd->next;
        el  = pel;
        pel = pel->parent;
        continue;
      } else if (psd->sibling == ST_ADJACENT) {
        const element *tel = el->prev_element();
        if (!tel) return false;
        const_cast<element*>(tel)->flags.has_sibling_selector = 1;
        // FOUND_PREV:
        if (!psd->match_single(tel, root_element)) return false;
        psd = psd->next;
        continue;
      } else if (psd->sibling == ST_NEXT) {
        for (const element *tel = el->prev_element(); tel; tel = tel->prev_element()) {
          if (psd->match_single(tel, root_element)) {
            const_cast<element*>(tel)->flags.has_sibling_selector = 1;
            goto FOUND;
          }
        }
        return false;
      FOUND:
        psd = psd->next;
        continue;
      }

      for (; pel;) {
        if (psd->match_single(pel, root_element)) { break; }
        el  = pel;
        pel = pel->parent;
      }
      if (pel == 0) return false;
      el  = pel;
      pel = pel->parent;
      psd = psd->next;
    }
    return true;
  }

  bool style_def::depends_on(const element *el, ui_state st,
                             const element *root_element) const {
    if (!depends_single(el, st, root_element)) return false;

    if (next == 0) return true;

    const style_def *psd = next;
    const element *  pel = el->parent;

    while (psd) {
      if (!pel) return false;
      // if(root_element && pel == root_element)
      //  return false;

      if (psd->depth) {
        for (uint d = 1; d < psd->depth; ++d) {
          //
          pel = pel->parent;
          if (pel == 0) return false;

          // if( pel->type == T_TEXT )
          //  continue; // skip anonymous paragraph
        }
        if (!psd->match_single(pel, root_element)) return false;
        psd = psd->next;
        el  = pel;
        pel = pel->parent;
        continue;
      }
      else if (psd->sibling == ST_ADJACENT) {
        const element *tel = el->prev_element();
        if (!tel) return false;
        const_cast<element*>(tel)->flags.has_sibling_selector = 1;
        // FOUND_PREV:
        if (!psd->match_single(tel, root_element)) return false;
        psd = psd->next;
        continue;
      }
      else if (psd->sibling == ST_NEXT) {
        for (const element *tel = el->prev_element(); tel; tel = tel->prev_element()) {
          if (psd->match_single(tel, root_element)) {
            const_cast<element*>(tel)->flags.has_sibling_selector = 1;
            goto FOUND;
          }
        }
        return false;
      FOUND:
        psd = psd->next;
        continue;
      }
      for (; pel;) {
        if (psd->match_single(pel, root_element)) { break; }
        el  = pel;
        pel = pel->parent;
      }
      if (pel == 0) return false;
      el  = pel;
      pel = pel->parent;
      psd = psd->next;
    }
    return true;
  }

  bool style_def::parse_list(style_bag *pb, css_istream &s,
                             array<handle<style_def>> &list) {
    assert(list.size() == 0);
    list.clear();
    while (true) {
      style_def *sd = parse(pb, s);
      if (!sd) break; // error
      list.push(sd);
      int t = s.s_token(true);
      if (t == 0) 
        return false;
      if (t == '{') {
        s.push_back();
        return true;
      }
    }

    // int t, braces = 0;
    // while(t = s.b_token())
    //{
    //  if( t == '{' ) ++braces;
    //  else if( t == '}' ) { if(--braces <= 0) break; }
    //}
    list.clear();
    return false;
  }

  style_def *style_def::parse(style_bag *sb, css_istream &s) {
    style_def *p = 0;

    const wchar *start   = s.pos;
    int          line_no = s.line_no;
    string       url     = s.url;

    int t = s.s_token();

    if (t == '>') // '>' at start means :root >
    {
      p = new style_def();
      if (!p) goto ABEND;
      p->pseudos.root(true);
      // and keep the token unprocessed
    }

    for (; t; t = s.s_token()) {
      switch (t) {
      case ' ': continue;
      case '+':
        if (!p) return nullptr;
        p->sibling = ST_ADJACENT;
        continue;
      case '~':
        if (!p) return nullptr;
        p->sibling = ST_NEXT;
        continue;
      case '>':
        if (!p) return nullptr;
        ++p->depth;
        continue;

      case '{': s.push_back(); goto READY;
      case ',': s.push_back(); goto READY;

      case '*':
      case '[':
      case '(':
      case css_istream::T_NMTOKEN:
      case css_istream::T_ID:
      case css_istream::T_PSEUDO:
      case css_istream::T_CLASS:
      case css_istream::T_PSEUDO_EL: {
        s.push_back();
        style_def *t = new style_def();
        if (!t) goto ABEND;
        t->next = p;
        p       = t;
        // ln = s.line_no;
        if (!p->parse_single(sb, s, true)) goto ABEND;
        continue;
      }
      default: 
        s.push_back(); goto ABEND;
      }
    }
  READY:
    if (p) {
      p->src_line_no   = line_no;
      p->src_url       = url;
      p->selector_text = ustring(start, s.pos - start);
    }
    return p;
  ABEND:
    // assert(false);
    delete p;
    return 0;
  }

  //#pragma optimize( "t", off )

  static string sv_link                 = "link";
  static string sv_hover                = "hover";
  static string sv_active               = "active";
  static string sv_visited              = "visited";
  static string sv_focus                = "focus";
  static string sv_ownsfocus            = "owns-focus";
  static string sv_tabfocus             = "tab-focus";
  static string sv_popup                = "popup";
  static string sv_current              = "current";
  static string sv_checked              = "checked";
  static string sv_selected             = "selected";
  static string sv_unchecked            = "unchecked";
  static string sv_disabled             = "disabled";
  static string sv_expanded             = "expanded";
  static string sv_collapsed            = "collapsed";
  static string sv_incomplete           = "incomplete";
  static string sv_invalid              = "invalid";
  static string sv_animating            = "animating";
  static string sv_focusable            = "focusable";
  static string sv_read_only            = "read-only";
  static string sv_empty                = "empty";
  static string sv_anchor               = "anchor";
  static string sv_synthetic            = "synthetic";
  static string sv_owns_popup           = "owns-popup";
  static string sv_leaf                 = "leaf";
  static string sv_node                 = "node";
  static string sv_busy                 = "busy";
  static string sv_not                  = "not";
  static string sv_root                 = "root";
  static string sv_has_child            = "has-child";
  static string sv_has_children         = "has-children";
  static string sv_has_child_of_type    = "has-child-of-type";
  static string sv_has_children_of_type = "has-children-of-type";
  static string sv_has                  = "has";
  static string sv_only_of_type         = "only-of-type";
  static string sv_only_child           = "only-child";
  static string sv_drag_over            = "drag-over";
  static string sv_drop_target          = "drop-target";
  static string sv_moving               = "moving";
  static string sv_copying              = "copying";
  static string sv_drag_source          = "drag-source";
  static string sv_drop_marker          = "drop-marker";
  static string sv_content_editable     = "content-editable";
  static string sv_content_non_editable = "content-non-editable";
  static string sv_has_bound_attributes = "has-bound-attributes";

  // static string sv_popup_owner = "popup-parent";
  static string sv_first_child    = "first-child";
  static string sv_last_child     = "last-child";
  static string sv_nth_child      = "nth-child";
  static string sv_last_nth_child = "nth-last-child";
  static string sv_odd("odd");
  static string sv_even("even");

  static string sv_rtl  = "rtl";
  static string sv_ltr  = "ltr";
  static string sv_lang = "lang"; // lang(ru)

  static string sv_theme = "theme"; // theme(dark)

  static string sv_before("before");
  static string sv_after("after");
  static string sv_shade("shade");
  static string sv_marker("marker");

  static string sv_ready("ready");

  bool style_def::parse_attr(css_istream &s) {
    // int t = s.s_token(true);
    // if( t != css_istream::T_NMTOKEN)
    //  return false;
    if (!s.scan_nmtoken(css_istream::NMTOKEN_PLUS_AT)) return false;

    attr_def ad;
    ad.attr_name = attr::symbol(string(s.token_value()));

    int t = s.s_token(true);
    if (t == ']') {
      atts.push(ad);
      return true;
    }

    switch (t) {
    case css_istream::T_MATCH_LIST:
      ad.attr_eq_op = '~';
      break; // ~=
    case css_istream::T_MATCH_FIRST:
      ad.attr_eq_op = '|';
      break; // |=
    case css_istream::T_MATCH_PREFIX:
      ad.attr_eq_op = '^';
      break; // ^=
    case css_istream::T_MATCH_SUFFIX:
      ad.attr_eq_op = '$';
      break; // $=
    case css_istream::T_MATCH_SUBSTR:
      ad.attr_eq_op = '*';
      break; // *=
    case css_istream::T_MATCH_ICASE:
      ad.attr_eq_op = '#';
      break; // ==
    case css_istream::T_MATCH_LIST_ICASE:
      ad.attr_eq_op = '%';
      break; // %=
    case '=':
      ad.attr_eq_op = '=';
      break; // =
    default: return false;
    }

    t = s.s_token(true);
    if (t != css_istream::T_STRING && t != css_istream::T_NMTOKEN &&
        t != css_istream::T_INTEGER) // T_NMTOKEN, T_INTEGER here is not
                                     // standard!
      return false;

    ad.attr_value = s.token_value();
    atts.push(ad);

    t = s.s_token(true);
    if (t != ']') return false;

    return true;
  }

  bool parse_state_flag(const string &val, uint64 &s) {
    static hash_table<string, uint64> s2s;
    if (s2s.size() == 0) {
      s2s[sv_link]                 = S_LINK;
      s2s[sv_hover]                = S_HOVER;
      s2s[sv_active]               = S_ACTIVE;
      s2s[sv_visited]              = S_VISITED;
      s2s[sv_focus]                = S_FOCUS;
      s2s[sv_ownsfocus]            = S_OWNS_FOCUS;
      s2s[sv_popup]                = S_POPUP;
      s2s[sv_current]              = S_CURRENT;
      s2s[sv_checked]              = S_CHECKED;
      s2s[sv_unchecked]            = S_UNCHECKED;
      s2s[sv_selected]             = S_SELECTED;
      s2s[sv_expanded]             = S_EXPANDED;
      s2s[sv_collapsed]            = S_COLLAPSED;
      s2s[sv_disabled]             = S_DISABLED;
      s2s[sv_incomplete]           = S_INCOMPLETE;
      s2s[sv_invalid]              = S_INVALID;
      s2s[sv_busy]                 = S_BUSY;
      s2s[sv_animating]            = S_ANIMATING;
      s2s[sv_focusable]            = S_FOCUSABLE;
      s2s[sv_read_only]            = S_READONLY;
      s2s[sv_empty]                = S_EMPTY;
      s2s[sv_anchor]               = S_ANCHOR;
      s2s[sv_synthetic]            = S_SYNTHETIC;
      s2s[sv_owns_popup]           = S_OWNS_POPUP;
      s2s[sv_node]                 = S_NODE;
      s2s[sv_tabfocus]             = S_TABFOCUS;
      s2s[sv_has_child]            = S_HAS_CHILD;
      s2s[sv_has_children]         = S_HAS_CHILDREN;
      s2s[sv_rtl]                  = S_IS_RTL;
      s2s[sv_ltr]                  = S_IS_LTR;
      s2s[sv_drag_over]            = S_DRAG_OVER;
      s2s[sv_drop_target]          = S_DROP_TARGET;
      s2s[sv_moving]               = S_MOVING;
      s2s[sv_copying]              = S_COPYING;
      s2s[sv_drag_source]          = S_DRAG_SOURCE;
      s2s[sv_drop_marker]          = S_DROP_MARKER;
      s2s[sv_content_editable]     = S_CONTENT_EDITABLE;
      s2s[sv_content_non_editable] = S_CONTENT_NON_EDITABLE;
      s2s[sv_ready]                = S_READY;
    }
    return s2s.find(val, s);
  }

  bool parse_state_flag(const string &val, ui_state &s) {
    return parse_state_flag(val, s.data);
  }

  bool style_def::parse_pseudo_class(style_bag *psb, css_istream &s) {
    string val = string(s.token_value());
    if (val == sv_link) {
      attr_def ad;
      ad.attr_name = attr::a_href;
      atts.push(ad);
      return true;
    }
    /*
    else if(parse_state_flag(val, pseudos))
    {
      return true;
    }
    */
    else if (val == sv_hover) {
      //pseudos.hover(true);
      if(!parse_hover(s))
        return false;
    }
    else if (val == sv_active)
      pseudos.active(true);
    else if (val == sv_visited)
      pseudos.visited(true);
    else if (val == sv_focus)
      pseudos.focus(true);
    else if (val == sv_ownsfocus)
      pseudos.owns_focus(true);
    else if (val == sv_popup)
      pseudos.popup(true);
    else if (val == sv_current)
      pseudos.current(true);
    else if (val == sv_checked)
      pseudos.checked(true);
    else if (val == sv_selected)
      pseudos.selected(true);
    else if (val == sv_unchecked)
      pseudos.unchecked(true);
    else if (val == sv_expanded)
      pseudos.expanded(true);
    else if (val == sv_collapsed)
      pseudos.collapsed(true);
    else if (val == sv_disabled)
      pseudos.disabled(true);
    else if (val == sv_incomplete)
      pseudos.incomplete(true);
    else if (val == sv_invalid)
      pseudos.invalid(true);
    else if (val == sv_busy)
      pseudos.busy(true);
    else if (val == sv_animating)
      pseudos.animating(true);
    else if (val == sv_focusable)
      pseudos.focusable(true);
    else if (val == sv_read_only)
      pseudos.readonly(true);
    else if (val == sv_empty)
      pseudos.empty(true);
    else if (val == sv_anchor)
      pseudos.anchor(true);
    else if (val == sv_synthetic)
      pseudos.synthetic(true);
    else if (val == sv_owns_popup)
      pseudos.owns_popup(true);
    // else if(val == sv_leaf)
    //  pseudos.leaf(true);
    else if (val == sv_node)
      pseudos.node(true);
    else if (val == sv_tabfocus)
      pseudos.tabfocus(true);
    else if (val == sv_ready)
      pseudos.ready(true);
    else if (val == sv_has_child) {
      pseudos.has_child(true);
    } else if (val == sv_has_children) {
      pseudos.has_children(true);
    } else if (val == sv_has_child_of_type) {
      if (!parse_child_type(s, child_of_type)) return false;
    } else if (val == sv_has_children_of_type || val == sv_has) {
      if (!parse_child_type(s, children_of_type)) return false;
    } else if (val == sv_only_of_type) {
      only_child_of_type = true;
    } else if (val == sv_only_child) {
      only_child = true;
    } else if (val == sv_rtl)
      pseudos.rtl(true);
    else if (val == sv_ltr)
      pseudos.ltr(true);
    else if (val == sv_lang) {
      if (!parse_named(s, lang)) return false;
    }
    else if (val == sv_theme) {
      if (!parse_named(s, theme)) return false;
    }
    else if (val == sv_drag_over)
      pseudos.drag_over(true);
    else if (val == sv_drop_target)
      pseudos.drop_target(true);
    else if (val == sv_moving)
      pseudos.moving(true);
    else if (val == sv_copying)
      pseudos.copying(true);
    else if (val == sv_drag_source)
      pseudos.drag_source(true);
    else if (val == sv_drop_marker)
      pseudos.drop_marker(true);
    else if (val == sv_content_editable)
      pseudos.content_editable(true);
    else if (val == sv_content_non_editable)
      pseudos.content_non_editable(true);

    else if (val == sv_not) {
      if (!parse_not(psb, s)) return false;
    } else if (val == sv_first_child) {
      step  = 0;
      index = 1;
    } else if (val == sv_last_child) {
      last_step  = 0;
      last_index = 1;
    } else if (val == sv_nth_child) {
      if (!parse_nth(s, step, index)) return false;
    } else if (val == sv_last_nth_child) {
      if (!parse_nth(s, last_step, last_index)) return false;
    } else if (val == sv_root) {
      pseudos.root(true);
    } else if (val == sv_has_bound_attributes)
      this->has_bound_attributes = 1;
    else
      return false;

    return true;
  }

  bool style_def::parse_span_pseudo_element(style_bag *psb, css_istream &s,
                                            enum_v &selector) {
    if (s.s_token() != '(') return false;

    array<char> buffer;

    for (;;)
      switch (s.s_token()) {
      // case css_istream::T_EOF: return false;
      // case '{': return false;
      default: return false;
      case ' ': continue;
      case ',': continue;
      case ')': goto DONE;
      case css_istream::T_NMTOKEN: {
        string nm = string(s.token_value());
        if (buffer.length()) buffer.push(CHARS(" "));
        buffer.push(nm());
      }
        continue;
      }
  DONE:
    if (buffer.length() == 0) return false;
    selector = span_class_bit(string(buffer()));
    return true;
  }

  bool style_def::parse_pseudo_element(style_bag *psb, css_istream &s) {
    if (pseudo_element.is_defined() || !psb) return false;
    string val = string(s.token_value());
    if (val == sv_before)
      pseudo_element = PSEUDO_BEFORE;
    else if (val == sv_after)
      pseudo_element = PSEUDO_AFTER;
    else if (val == sv_shade)
      pseudo_element = PSEUDO_SHADE;
    else if (val == sv_marker)
      pseudo_element = PSEUDO_MARKER;
    // else if(val.like("char-mark?"))
    //  pseudo_element = PSEUDO_ELEMENT_MARK0 + limit<int>(val[9] - '0',0,7);
    //  //PSEUDO_ELEMENT_BIT0..7
    else if (val == CHARS("mark") || val == CHARS("highlight")) {
      return parse_span_pseudo_element(psb, s, pseudo_element);
    } else
      return false;
    return true;
  }

  bool style_def::parse_not(style_bag *psb, css_istream &s) {
    int t = s.s_token();
    if (t != '(') return false;

    style_def *ns = new style_def();
    ns->next      = negation;
    negation      = ns;
    if (!negation->parse_single(psb, s, false)) return false;

    t = s.s_token(true);
    if (t != ')') return false;

    return true;
  }

  bool style_def::parse_hover(css_istream &s) {
    int t = s.s_token();
    if (t != '(') {
      s.push_back();
      pseudos.hover(true);
      return true;
    }
    t = s.s_token(true, false);
    if (t != css_istream::T_NMTOKEN) return false;
    auto nm = s.token_value();
    if(nm == WCHARS("left")) pseudos.hover(LEFT,true);
    else if (nm == WCHARS("right")) pseudos.hover(RIGHT, true);
    else if (nm == WCHARS("top")) pseudos.hover(TOP, true);
    else if (nm == WCHARS("bottom")) pseudos.hover(BOTTOM, true);
    t = s.s_token(true, false);
    if (t != ')') return false;
    assert(side_to_state(RIGHT) == S_HOVER_RIGHT);
    return true;
  }

  bool style_def::parse_child_type(css_istream &s, tag::symbol_t &type) {
    int t = s.s_token();
    type  = 0;
    if (t != '(') {
      s.push_back();
      return true;
    }
    t = s.s_token(true, false);
    if (t != css_istream::T_NMTOKEN) return false;
    ustring nm = s.token_value();
    t          = s.s_token(true, false);
    if (t != ')') return false;
    type = tag::symbol(string(nm));
    return type != 0;
  }

  bool style_def::parse_named(css_istream &s, ustring &lang) {
    int t = s.s_token();
    lang.clear();
    if (t != '(') {
      s.push_back();
      return false;
    }
    t = s.s_token(true, false);
    if (t != css_istream::T_NMTOKEN) return false;
    lang = s.token_value();
    t    = s.s_token(true, false);
    if (t != ')') return false;
    return lang.length() != 0;
  }

  bool style_def::parse_nth(css_istream &s, int &step, int &index) {
    step  = 0;
    index = 0;

    int t = s.s_token();
    if (t != '(') return false;

    t = s.s_token(true, true);

    bool got_minus = false;
    int  i         = 0;
    if (t == '-') {
      got_minus = true;
      i         = -1;
      t         = s.s_token(true, true);
    }

    if (t == css_istream::T_INTEGER) {
      wchars tv = s.token_value();
      i         = to_int(tv);
      if (got_minus) i = -i;
      t = s.s_token(true, true);
    }

    if (t == ')') {
      index = i;
      return true;
    } else if (t == css_istream::T_NMTOKEN && s.token_value() == WCHARS("n"))
      t = s.s_token(true, true);
    else if (t == css_istream::T_NMTOKEN && s.token_value() == WCHARS("odd")) {
      step  = 2;
      index = 1;
      t     = s.s_token(true, true);
      return t == ')';
    } else if (t == css_istream::T_NMTOKEN &&
               s.token_value() == WCHARS("even")) {
      step  = 2;
      index = 2;
      t     = s.s_token(true, true);
      return t == ')';
    } else
      return false;

    if (t == ')') {
      index = step = i;
      return true;
    }

    got_minus = false;
    if (t != '+' && t != '-') return false;

    got_minus = t == '-';

    t = s.s_token(true, true);
    if (t != css_istream::T_INTEGER) return false;

    step      = i;
    wchars tv = s.token_value();
    index     = to_int(tv);
    if (got_minus) index = -index - 1;

    t = s.s_token(true, true);

    if (t != ')') return false;

    return true;
  }

  bool style_def::parse_single(style_bag *psb, css_istream &s, bool allow_pseudo_element) {
    tag = 0;

    int t = s.s_token(true);

    int processed = 0;

    if (t == '*') {
      tag = TAG_ANY;
      t = s.s_token();
      ++processed;
    } else if (t == css_istream::T_NMTOKEN) {
      tag_name = string(s.token_value());
      tag      = tag::symbol(tag_name);
      if (!tag) {
        assert(false);
        tag = tag::T__UNKNOWN;
      }
      t = s.s_token();
      ++processed;
    }

    depth = 0;

    for (; t; t = s.s_token()) {
      switch (t) {
      case ' ': return processed != 0;

      case '{': s.push_back(); return processed != 0;

      case ')':
      case ',': s.push_back(); return processed != 0;

      case css_istream::T_PSEUDO:
        if (!parse_pseudo_class(psb, s)) goto ERROR_SKIP;
        break;
      case css_istream::T_PSEUDO_EL:
        if (!allow_pseudo_element || !parse_pseudo_element(psb, s))
          goto ERROR_SKIP;
        break;

      case css_istream::T_CLASS: {
        attr_def ad;
        ad.attr_name  = attr::a_class;
        ad.attr_value = s.token_value();
        ad.attr_eq_op = '~';
        atts.push(ad);
      } break;

      case css_istream::T_ID: id = s.token_value(); break;

      case '>':
      case '+': s.push_back(); return processed != 0;

      case '[':
        if (!parse_attr(s)) goto ERROR_SKIP;
        break;

      case '(': // input(nm) as input[name="nm"]
      {
        attr_def ad;
        t = s.s_token();
        if (t != css_istream::T_NMTOKEN) goto ERROR_SKIP;
        ad.attr_name  = attr::a_name;
        ad.attr_value = s.token_value();
        ad.attr_eq_op = '=';
        t             = s.s_token();
        if (t != ')') goto ERROR_SKIP;
        atts.push(ad);
      } break;
      case '|':
      {
        attr_def ad;
        t = s.s_token();
        if (t != css_istream::T_NMTOKEN) goto ERROR_SKIP;
        ad.attr_name = attr::a_type;
        ad.attr_value = s.token_value();
        ad.attr_eq_op = '=';
        //t = s.s_token();
        //if (t != ')') goto ERROR_SKIP;
        atts.push(ad);
      } break;
      
      default: return false;
      }
      ++processed;
    }
    return processed != 0;
  ERROR_SKIP:
    // assert(false);
    for (; t; t = s.s_token())
      if (t == '{' || t == ',') {
        s.push_back();
        break;
      }
    return false;
  }

#if 0
  bool style_bag::has_pseudo_classes_for(const element *el, ui_state st,
                                         bool           deep,
                                         const element *root_element) const {
    if (!deep && !st.is_defined()) return false;

    tag::symbol_t tag        = el->tag;
    int           i          = 0;
    int           _defs_size = _defs.size();
    for (i = 0; i < _defs_size; ++i) {
      style_def *psd = _defs[i];
      if (psd->has_pseudo_classes_for(el, st, deep, root_element)) return true;
    }

    /*if( _sets.size() )
    {
      hstyle cs = el->current_style();
      if(cs->style_set.length())
      {
        style_bag *psb = get_named_set(cs->style_set);
        if( !psb || psb == this )
          return false;
        return psb->has_pseudo_classes_for(el, st, deep, root_element);
      }
    }*/

    string ssn = el->get_style()->style_set;
    if (ssn.length() == 0) return false;
    const element *r = el;
    const element *t = el->parent;
    while (t && ssn.length()) {
      while (t && t->c_style->style_set == ssn) {
        r = t;
        t = t->parent;
      }
      style_bag *named_set = get_named_set(ssn);
      if (named_set) {
        // counter += named_set->apply(s,el,r, pcb);
        if (named_set->has_pseudo_classes_for(el, st, deep, r)) return true;
      }
      if (t)
        ssn = t->c_style->style_set;
      else
        break;
    }
    return false;
  }

  /* not used in 3.1.*.* */
  bool style_bag::has_dependent_pseudo_classes_for(
      const element *el, ui_state st, const element *child_el,
      const element *root_element) const {
    if (el->state.is_defined()) {
      // symbol_t tag = el->type;
      int i          = 0;
      int _defs_size = _defs.size();
      for (i = 0; i < _defs_size; ++i) {
        style_def *psd = _defs[i];
        if (psd->has_dependent_pseudo_classes_for(el, st, child_el,
                                                  root_element))
          return true;
      }
    }
    return false;
  }
#endif

  hstyle style_bag::style_for(const ustring &class_name, ui_state st, const element *root_element) {
    
    style_list slist;

    int _defs_size = _defs.size();

    for (int i = 0; i < _defs_size; ++i) {
      style_def *psd = _defs[i];
      if (psd->match_single(class_name, st)) {
        //s.inherit(psd->pstyle);
        slist.add(psd->plist, style::INHERIT_ALL);
      }
    }
    if (slist.list.size() == 0)
      return nullptr;
    //style::key k = slist.compute_key();

    //hstyle hs = this->get_cached(k);
    //if (hs) return hs;
      
    style ps;
    //hs->set_key(k);
    //if(root_element)
    //  hs->variables.inherit(root_element->get_style()->variables); // ???
    assert(root_element);
    slist.apply_to(element_context(root_element), ps, false);
    return intern_resolved(ps);
    //this->set_cached(k, hs);
    //return hs;
  }
#if 0
  // old way: style sets on top of other styles
  bool style_bag::apply(style &s, const element *el,
                        const element *root_element, style_def::callback *pcb,
                        bool apply_important) {
    tag::symbol_t tag = el->tag;
    int           i;
    bool          has_importants = false;

    if (!root_element) root_element = el->doc();

    int _defs_size = _defs.size();

    for (i = 0; i < _defs_size; ++i) {
      style_def *psd = _defs[i];
      if (psd->match(el, root_element)) {
        if (psd->pseudo_element.val(0) != el->pseudo_element_id()) {
          s.inherited_pseudo_element_ids |= psd->pseudo_element.val(0);
          continue;
        }
        ++psd->usage_counter;
        style *importants = psd->pstyle->get_importants(false);
        if (apply_important)
          s.inherit(importants);
        else {
          if (!has_importants) has_importants = importants != 0;
          s.inherit(psd->pstyle);
        }
        if (pcb) pcb->has_rule(psd);
      }
    }

    // named set support:

    if (!apply_important && s.style_set.length()) {
      string ssn = s.style_set;

      const element *r = el;
      const element *t = el->parent;
      while (t && ssn.length()) {
        while (t && t->c_style->style_set == ssn) {
          r = t;
          t = t->parent;
        }
        style_bag *named_set = get_named_set(ssn);
        if (named_set) 
          named_set->apply(s, el, r, pcb);
        if (t)
          ssn = t->c_style->style_set;
        else
          break;
      }
    }
    return has_importants;
  }
#endif
#if 1
  int style_bag::rules_for(const element *el, const element *root_element, style_list &list) {
        
    int _defs_size = _defs.size();
    int n = 0;
    for (int i = 0; i < _defs_size; ++i) {
      style_def *psd = _defs[i];

#ifdef DEBUG
      if (el->tag == tag::T__SHADE && psd->pseudo_element.val() == PSEUDO_SHADE)
        el = el;
      if (el->is_id_test() && psd->pseudo_element.val() == PSEUDO_SHADE)
        el = el;
#endif

      if (psd->match(el, root_element)) {
        ++psd->usage_counter;
        uint pse = psd->pseudo_element.val();
        if (pse && !el->pseudo_element_id()) {
          list.pseudo_element_ids |= pse;
          if(pse & char_mark_mask)
            list.marks_add(psd, style::INHERIT_ALL);
        }
        else
          list.add(psd,style::INHERIT_ALL);
        ++n;
      }
    }
    return n;
  }

#if 0
  bool style_bag::apply_list(style &s, const element *el, const element *root_element, slice<hstyle> list, bool apply_important) 
  {
    bool          has_importants = false;

//#ifdef DEBUG
//    if (el->is_id_test())
//      el = el;
//#endif

    for (auto ps : list) {
      if (ps->pseudo_element_id != el->pseudo_element_id()) {
        s.inherited_pseudo_element_ids |= ps->pseudo_element_id;
        continue;
      }
      style *importants = ps->get_importants(false);
      if (apply_important) 
        s.inherit(importants);
      else {
        if (!has_importants) has_importants = importants != 0;
        s.inherit(ps);
      }
    }
    return has_importants;
  }
#endif

  int style_bag::style_set_rules_for(const element *el, const element *root_element, style_list &list, const string &set_name) {
    int n = 0;

    string ssn = set_name;

    const element *r = el;
    const element *t = el->parent;
    while (t && ssn.length()) {
      while (t && t->c_style->used_style_set_name() == ssn) {
        r = t;
        t = t->parent;
      }
      style_bag *named_set = get_named_set(ssn);
      if (named_set) {
        named_set->rules_for(el, r, list);
        ++n;
      }
      if (t)
        ssn = t->c_style->used_style_set_name();
      else
        break;
    }

    return n > 0;
  }

#if 0
  bool style_bag::apply_style_set(style &s, const element *el, const element *root_element, const string& set_name)
  {
    int n = 0;

    string ssn = set_name;

    const element *r = el;
    const element *t = el->parent;
    while (t && ssn.length()) {
      while (t && t->c_style->style_set == ssn) {
        r = t;
        t = t->parent;
      }
      style_bag *named_set = get_named_set(ssn);
      if (named_set) {
        named_set->apply(s, el, r, nullptr);
        ++n;
      }
      if (t)
        ssn = t->c_style->style_set;
      else
        break;
    }

    return n > 0;
  }
#endif

  //bool style_bag::apply_forced_style_set(style &s, const element *el, document *d, const style_set_holder* pssh, style_def::callback *pcb)

  int style_bag::forced_style_set_rules_for(const element *el, document *d, const style_set_holder *pssh, style_list &list)
  {
    auto fetch_named_set = [&](const style_set_holder* pssh) -> style_bag* 
    {
      if (pssh->style_set)
        return pssh->style_set;
      style_bag * sb = d->get_named_style_set(pssh->name);
      if (!sb)
      {
        if (view* pv = d->pview())
          if (!d->load_style(pssh->url))
            pv->debug_printf(OT_CSS, OS_ERROR, "SSX: failed to load %s\n", pssh->url.c_str());
          else {
            sb = d->get_named_style_set(pssh->name);
            if (!sb) {
              pv->debug_printf(OT_CSS, OS_ERROR, "SSX: @set %s not found in %s\n", pssh->name.c_str(), pssh->url.c_str());
              // to prevent further warnings
              d->styles().add_named_set(pssh->name, new style_bag());
            }
          }
      }
      pssh->style_set = sb;
      return sb;
    };

    int n = 0;

    const style_set_holder* ssn = pssh;

    auto eq = [](const style_set_holder* a, const style_set_holder* b) {
      if (a == b) return true;
      if (a && b) return a->style_set == b->style_set;
      return false;
    };

    const element *r = el;
    const element *t = el->parent;
    while (t && ssn) {
      while (t && eq(t->forced_style_set(),ssn)) {
        r = t;
        t = t->parent;
      }
      style_bag *named_set = fetch_named_set(ssn);
      if (named_set) {
        named_set->rules_for(el, r, list); //named_set->apply(s, el, r, pcb);
        ++n;
      }
      if (t)
        ssn = t->forced_style_set();
      else
        break;
    }
    return n;
  }


#else
  // new wave: other styles on top of style sets
  bool style_bag::apply(style &s, const element *el,
                        const element *root_element, style_def::callback *pcb,
                        bool apply_important) {
    tag::symbol_t tag = el->tag;
    int i, counter = 0;
    bool has_importants = false;

    if (!root_element) root_element = el->doc();

    int _defs_size = _defs.size();

    style ts;

    for (i = 0; i < _defs_size; ++i) {
      style_def *psd = _defs[i];
      if (psd->match(el, root_element)) {
        ++psd->usage_counter;
        style *importants = psd->pstyle->get_importants(false);
        if (apply_important)
          ts.inherit(importants);
        else {
          if (!has_importants) has_importants = importants != 0;
          ts.inherit(psd->pstyle);
        }
        if (pcb) pcb->has_rule(psd);
        ++counter;
      }
    }

    tool::string style_set = ts.style_set;
    if (style_set.is_undefined()) style_set = s.style_set;

    // named set support:

    if (!apply_important && style_set.length()) {
      string ssn = style_set;

      const element *r = el;
      const element *t = el->parent;
      while (t && ssn.length()) {
        while (t && t->c_style->style_set == ssn) {
          r = t;
          t = t->parent;
        }
        style_bag *named_set = get_named_set(ssn);
        if (named_set) counter += named_set->apply(s, el, r, pcb);

        if (t)
          ssn = t->c_style->style_set;
        else
          break;
      }
    }
    if (counter) s.inherit(&ts);
    return has_importants;
  }
#endif

  bool cmp_style_defs(const handle<style_def> &a, const handle<style_def> &b) {
    return *a.ptr() < *b.ptr();
  }

  void style_bag::reorder() {
#if 0
    // WRONG, in this case: :root in derived set will override :root:hover of parent
    tool::sort(_defs.begin() + _defs_start_idx,
               _defs.length() - _defs_start_idx, cmp_style_defs);
#else
    tool::sort(_defs.begin(),
               _defs.length(), cmp_style_defs);
#endif
  }

  /*
  static int compare_style_defs(const void *elem1, const void *elem2)
  {
   if(**(style_def**)(elem1) < **(style_def**)(elem2))
    return -1;
   if(**(style_def**)(elem2) < **(style_def**)(elem1))
    return +1;
   return 0;
  }

  void style_bag::reorder()
  {
    if (_defs.size())
      ::qsort((_defs.elements(), _defs.size(), sizeof(style_def*),
  compare_style_defs);
    //_resolved_pool.clear();
  }*/

  style_bag *doc_style_bag::get_named_set(const string &name_of_set) const {
    style_bag *sb = super::get_named_set(name_of_set);
    // if(!sb && !is_master)
    //  sb = document::stock_styles().get_named_set(name_of_set);
    return sb;
  }

  void style_bag::remove_styles(element *link_or_style) {
    string seq_id = link_or_style->sequential_id();
    for (int n = _defs.last_index(); n >= 0; --n) {
      style_def *sd = _defs[n];
      if (sd->seqid().starts_with(seq_id())) _defs.remove(n);
    }
    for (int cn = _constants.size() - 1; cn >= 0; --cn) {
      handle<const_def> cd = _constants.elements()[cn];
      if (cd->seqid().starts_with(seq_id())) _constants.remove(cd->name);
    }
    // reorder();
  }

  void x_translation::apply(view &v, element *el, affine_mtx_f &to_mtx) {
    auto dim = el->border_box(v).size();
    float vx = pixels(v, el, x, dim).width_f();
    float vy = pixels(v, el, y, dim).height_f();
    to_mtx *= affine_translation_f(vx, vy);
  }

  void x_rotation::apply(view &v, element *el, affine_mtx_f &to_mtx) {
    if (x.is_defined() && y.is_defined()) {
      auto dim = el->border_box(v).size();
      float vx = pixels(v, el, x, dim).width_f();
      float vy = pixels(v, el, y, dim).height_f();
      to_mtx *= affine_translation_f(-vx, -vy);
      to_mtx *= affine_rotation_f(radians);
      to_mtx *= affine_translation_f(vx, vy);
    } else
      to_mtx *= affine_rotation_f(radians);
  }

  transforms *transforms::make_initial() const {
    transforms *pn = new transforms();
    int         nm = items.size();
    for (int n = 0; n < nm; ++n)
      pn->items.push(items[n]->make_initial());
    return pn;
  }

  transforms *transforms::clone() const {
    transforms *pn = new transforms();
    // pn->origin_x = origin_x;
    // pn->origin_y = origin_y;
    int nm = items.size();
    for (int n = 0; n < nm; ++n)
      pn->items.push(items[n]->clone());
    return pn;
  }

  bool transforms::is_compatible(const transforms *rs) const {
    int nm = items.size();
    if (nm != rs->items.size()) return false;
    for (int n = 0; n < nm; ++n)
      if (rs->items[n]->type() != items[n]->type()) return false;
    return true;
  }
  bool transforms::is_identical(const transforms *rsi) const {
    handle<transforms> rs = rsi ? rsi : make_initial();
    int nm = items.size();
    if (nm != rs->items.size()) return false;
    // if(origin_x != rs->origin_x ) return false;
    // if(origin_y != rs->origin_y ) return false;
    for (int n = 0; n < nm; ++n)
      if (!rs->items[n]->is_identical(items[n])) return false;
    return true;
  }

  bool transforms::is_identical(const transforms *ls, const transforms *rs) {
    if (ls == rs) return true;
    if (!ls || !rs) return false;
    return ls->is_identical(rs);
  }

  void transforms::morph(view &v, element *b, const transforms *start, const transforms *end,
                         float r) {
    int nm = items.size();
    for (int n = 0; n < nm; ++n)
      items[n]->morph(v,b,start->items[n], end->items[n], r);
    // origin_x.morph(start->origin_x,end->origin_x,r);
    // origin_y.morph(start->origin_y,end->origin_y,r);
  }

#ifdef _DEBUG
  void style_bag::usage_stats() {
    dbg_printf("styles cached:%d allocated:%d "
               "\n----------------------------------------------\n", this->_resolved_pool.size(), style::_total);
    _resolved_pool.report();
    dbg_printf("\n");
    /*
    dbg_printf("used styles:%d new:%d similar:%d "
      "\n----------------------------------------------\n",
      this->_resolved_pool.size(), _total_new, _total_reused);
    for (int n = 0; n < this->_resolved_pool.size(); ++n) {
      long cnt = this->_resolved_pool.elements()[n]->get_ref_count();
      dbg_printf("%d\t", int(cnt));
      if ((n + 1) % 10 == 0) dbg_printf("\n");
    }
    dbg_printf("\n");*/

  }
#endif

  bool need_animation(const style *from, const style *to) {
    if (from == to) return false;
    if (!from->transitions && !to->transitions) return false;

    if (to->transitions == transition_def::null()) return false;
    if (from->transitions == transition_def::null()) return false;

    if (from->transitions && !to->transitions) return true;
    else if (!from->transitions && to->transitions) return true;
    else if (from->transitions && to->transitions) {
      //if (from->transitions != to->transitions) 
      //  return true;
      return need_animation(from->transitions, from, to);
    }
    return false;
  }

  value style::definition() const {
    struct propdefs : public html::style::property_callback {
      bool important = false;
      value rd;
      propdefs() {}
      virtual void on_prop(const tool::string &name, const tool::value &val) {
        if (important) {
          function_value* pf = new function_value();
          pf->name = WCHARS("!important");
          pf->params.push(val);
          rd.push(value(ustring(name)), value::make_function(pf));
        }
        else
          rd.push(value(ustring(name)), val);
      }
    };
    propdefs ad;
    enum_properties(ad);
    if (importants) {
      ad.important = true;
      importants->enum_properties(ad);
    }
    return ad.rd;
  }

#pragma warning(push)
#pragma warning(disable : 4706) // warning C4706: assignment within conditional expression

  bool style::get_rounded_corners(view &v, element* b, size &rtl, size &rtr, size &rbr, size &rbl, size borderboxsz) const {
    int cnt = 0;
    if (border_radius[0].is_defined() && (rtl.x = pixels(v,b, border_radius[0],borderboxsz).width()) &&
        border_radius[1].is_defined() && (rtl.y = pixels(v, b, border_radius[1], borderboxsz).height()))
      ++cnt;
    if (border_radius[2].is_defined() &&
        (rtr.x = pixels(v, b, border_radius[2],borderboxsz).width()) &&
        border_radius[3].is_defined() &&
        (rtr.y = pixels(v, b, border_radius[3],borderboxsz).height()))
      ++cnt;
    if (border_radius[4].is_defined() &&
        (rbr.x = pixels(v, b, border_radius[4],borderboxsz).width()) &&
        border_radius[5].is_defined() &&
        (rbr.y = pixels(v, b, border_radius[5],borderboxsz).height()))
      ++cnt;
    if (border_radius[6].is_defined() &&
        (rbl.x = pixels(v, b, border_radius[6],borderboxsz).width()) &&
        border_radius[7].is_defined() &&
        (rbl.y = pixels(v, b, border_radius[7],borderboxsz).height()))
      ++cnt;

    if (cnt) gool::normailize_round_rect(borderboxsz, rtl, rtr, rbr, rbl);

    return cnt > 0;
  }
#pragma warning(pop)
}
