#include "html.h"

#if defined(PLATFORM_WINCE) || defined(EMULATE_WINCE)
#define PLATFORM_MEDIA_TYPE "handheld"
#else
#define PLATFORM_MEDIA_TYPE "all"
#endif

extern std::pair<tool::bytes, tool::ustring> get_stock_style_resource();
extern uint                                  module_version(bool major);

namespace html {
  string quote_chars = "\"\'";

#if 0
  bool add_custom_element(const string &name, style *ps) {
    tag::TAG_TYPE    t_type  = tag::UNKNOWN_TAG;
    tag::CMODEL_TYPE cm_type = tag::CMODEL_BLOCKS;
    if (ps->display_model == display_model_inline_inside) {
      // tag::CMODEL_TYPE cm_type = tag::CMODEL_INLINES;
      if (ps->display == display_block || ps->display == display_list_item) {
        t_type = tag::BLOCK_TAG;
      } else if (ps->display == display_inline_block) {
        t_type = tag::INLINE_BLOCK_TAG;
      } else if (ps->display == display_inline) {
        t_type = tag::INLINE_TAG;
      } else
        goto ERROR_COMBINATION;
    } else if (ps->display_model == display_model_block_inside) {
      // tag::CMODEL_TYPE cm_type = tag::CMODEL_BLOCKS;
      if (ps->display == display_block || ps->display == display_list_item) {
        t_type = tag::BLOCK_TAG;
      } else if (ps->display == display_inline_block) {
        t_type = tag::INLINE_BLOCK_TAG;
      }
      /*else if( ps->display == display_inline)
      {
        t_type = html::INLINE_TAG; block_type = html::BLOCK_PARA;
      }
      */
      else
        goto ERROR_COMBINATION;
    } else if (ps->display_model == display_model_table) {
      // tag::CMODEL_TYPE cm_type = tag::CMODEL_BLOCKS;
      if (ps->display == display_block) {
        t_type = tag::BLOCK_TAG;
      } else if (ps->display == display_inline_block) {
        t_type = tag::INLINE_BLOCK_TAG;
      } else
        goto ERROR_COMBINATION;
    }
    tag::add_definition(name, t_type, tag::PMODEL_NORMAL, cm_type, ps);
    return true;
  ERROR_COMBINATION:
    return false;
  }
#endif

  // this will be full media query parser one day:
  // see: http://www.w3.org/TR/css3-mediaqueries/
  /*bool is_conforming_media(const string& view_media_types, const string&
  media_query)
  {
    if(media_query.length() == 0)
      return true;


    atokens zv(view_media_types," ,");
    chars tv;

    while(zv.next(tv))
    {
      //if(tv == CHARS("all"))
      //  return true;


      atokens z(media_query," ,");
      chars t;
      while(z.next(t))
      {
        if(t == CHARS("all"))
          return true;
        if(t == tv)
          return true;
      }
    }
    return false;
  }*/

  style_parser::style_parser(const string &seq_id, wchars text, document *pd)
      : s(text, pd->uri().src), doc(pd), pcs(0), seqid(seq_id) {
    url    = pd->uri().src;
    top_sb = &pd->styles();
  }

  style_parser::style_parser(const string &seq_id, wchars text, document *pd,
                             const string &src_url, int line_no)
      : s(text, src_url, line_no), doc(pd), url(src_url), pcs(0),
        seqid(seq_id) {
    top_sb = &pd->styles();
  }

  array<value> substitute_params(slice<value> values, const hash_table<ustring, value>& params)
  {
    array<value> out(values.length);
    for (uint n = 0; n < values.length; ++n)
      out[n] = values[n].clone(params);
    return out;
  }

#if 0
  bool style_parser::parse_body(style*st, slice<handle<style_def>> outer_defs) {
    int t;

    const wchar *start   = s.prev_pos;
    int          line_no = s.line_no;
    string       attr_name;
    array<value> a_values;
    PAV_RESULT   pr = PAV_BAD_VALUE;

    for (t = s.b_token(); t; t = s.b_token())
      switch (t) {
      case '}': return true;

      case ';': continue;
#if defined(SCSS)
      case '^': parse_nested_declaration(this->top_sb, outer_defs); continue;
#endif
      case css_istream::T_ATRULE: {
        ustring        mixin_name = ustring(s.token_value());
        handle<mixin> pmixin      = this->top_sb->get_mixin(mixin_name);
        hash_table<ustring, value> params;
        if (pmixin)
        {
          t = s.b_token();
          if (t == '(')
          {
            int pn = 0;
            while (true) {
              t = s.a_token();
              if (t == ')' || t == css_istream::T_EOF) { break; }
              if (t == ',') continue;
              s.push_back();
              if (pn >= pmixin->params.size()) {
                view::debug_printf(OT_CSS, OS_WARNING,"too many mixin parameters at (%s(%d))\n", url.c_str(), line_no);
                break;
              }
              ustring param_name = pmixin->params[pn++];
              value  param_value;
              if(!parse_variable_value(doc, url, s, param_value, top_sb))
              {
                view::debug_printf(OT_CSS, OS_WARNING, "unrecognized mixin parameter syntax at (%s(%d))\n", url.c_str(), line_no);
                break;
              }
              params[param_name] = param_value;
            }
            // parameters
          }
          //else
          //  s.push_back();

          if(params.size())
            for (int n = 0; n < pmixin->items.size(); ++n)
            {
              auto vals = substitute_params(pmixin->items[n].attr_value(), params);
              set_attribute_value(doc, *st, pmixin->items[n].attr_name, vals());
            }
          else
            for (int n = 0; n < pmixin->items.size(); ++n)
              set_attribute_value(doc, *st, pmixin->items[n].attr_name, pmixin->items[n].attr_value());
        } else
          view::debug_printf(OT_CSS, OS_WARNING,
                             "unknown mixin '%S' at (%s(%d))\n",
                             mixin_name.c_str(), url.c_str(), line_no);
        continue;
      }

      case css_istream::T_VARIABLE_NAME: {
        start     = s.prev_pos;
        line_no   = s.line_no;
        attr_name = string(s.token_value());

        t = s.b_token();
        if (t != ':') {
          skip_block(true);
          view::debug_printf(
              OT_CSS, OS_ERROR,
              "bad variable declaration syntax of '%s' at (%s(%d))\n",
              attr_name.c_str(), url.c_str(), line_no);
          return false;
        }

        value val;
        if (parse_variable_value(doc, url, s, val, top_sb))
          st->variables.set(attr_name, val);
        else
          goto BAD_VALUE;
      }
        continue;

      case css_istream::T_NMTOKEN: {
        start     = s.prev_pos;
        line_no   = s.line_no;
        attr_name = string(s.token_value());

        // PARSE_ATTR_VALUE:

        t = s.b_token();
        // if(t == '!')
        // wchar tc = t;

        if (t != ':') {
          skip_block(true);

          view::debug_printf(
              OT_CSS, OS_ERROR,
              "bad property declaration syntax of '%s' at (%s(%d))\n",
              attr_name.c_str(), url.c_str(), line_no);
          // view::debug_print( start, s.pos );

          return false;
        }

        // bool is_important = false;

        if (attr_name().ends_with(CHARS("!"))) {
          if (parse_action_attribute_value(doc, url, s, a_values,
                                           &doc->styles())) {
            if (!set_attribute_value(doc, *st, attr_name, a_values()))
              // view::debug_printf(OT_CSS, OS_WARNING,"unrecognized property
              // '%s' at (%s(%d))\n", attr_name.c_str(), url.c_str(), line_no);
              goto BAD_NAME;
          } else
            goto BAD_VALUE;
          continue;
        } else if (attr_name[0] == '-') {
          value customv;
          if (parse_custom_attribute_value(doc, url, s, customv, top_sb)) {
            st->custom.set(attr_name, customv);
          } else
            goto BAD_VALUE;
          continue;
        } else {
#ifdef _DEBUG
          if (attr_name == CHARS("flow"))
            url = url;
#endif
          pr = parse_attribute_value(doc, url, st, s, attr_name, top_sb);
          switch (pr) {
          case /*PAV_RESULT::*/ PAV_BAD_VALUE:
          BAD_VALUE:
            view::debug_printf(
                OT_CSS, OS_WARNING,
                "unrecognized property syntax of '%s' at (%s(%d))\n",
                attr_name.c_str(), url.c_str(), line_no);
            break;
          case /*PAV_RESULT::*/ PAV_UNKNOWN_PROPERTY:
          BAD_NAME:
            view::debug_printf(OT_CSS, OS_WARNING,
                               "unknown property '%s' at (%s(%d))\n",
                               attr_name.c_str(), url.c_str(), line_no);
            break;
          }

          continue;
        }

        // view::debug_printf(OT_CSS, OS_WARNING,"unrecognized property syntax
        // of '%s' at (%s(%d))\n", attr_name.c_str(), url.c_str(), line_no);
        // view::debug_println( start, s.pos );
      }
        continue;

        /*          case css_istream::T_ATRULE :
                  {
                    start = s.prev_pos;
                    line_no = s.line_no;
                    string name = string(s.token_value());

                    value cv = top_sb->get_const(name);
                    if( cv.is_undefined() )
                       goto BAD_NAME;
                    attr_name = cv.to_string();
                    goto PARSE_ATTR_VALUE;
                  } */

      default:
        view::debug_printf(OT_CSS, OS_WARNING,
                           "unrecognized property name syntax at (%s(%d))\n",
                           url.c_str(), s.line_no);
        skip_statement();
        continue;
      }
    return false;
  }
#endif

  //PAV_RESULT parse_attribute_value_to(css_istream &s, document *pd, const string &url, const string &a_name, style_bag *sb, style_prop_list& tolist);

  PAV_RESULT parse_attribute_value_to(css_istream &s, document *pd, const string &url, const string &a_name, style_bag *sb, style_prop_list& tolist)
  {
    array<value> a_values;
    bool         is_important = false;

    if (crack_attribute_value(pd, url, s, a_values, is_important, sb, CAV_DEFAULT)) {
      //if (is_important) pcs = pcs->get_importants(true);
      //if (set_attribute_value(pd, *pcs, a_name, a_values())) return PAV_OK;
      //return PAV_UNKNOWN_PROPERTY;
      tolist.set(a_name, a_values(), is_important);
      return PAV_OK;
    }
    else
      return PAV_BAD_VALUE;
  }


  bool style_parser::parse_body(style_prop_list& spl) {

    int t;

    const wchar *start = s.prev_pos;
    int          line_no = s.line_no;
    string       attr_name;
    array<value> a_values;
    PAV_RESULT   pr = PAV_BAD_VALUE;
    bool is_important = false;

    for (t = s.b_token(); t; t = s.b_token())
      switch (t) {
      case '}': return true;

      case ';': continue;
#if defined(SCSS)
      case '^': parse_nested_declaration(this->top_sb, outer_defs); continue;
#endif
      case css_istream::T_ATRULE: 
      {
        ustring        mixin_name = ustring(s.token_value());
        handle<mixin> pmixin = this->top_sb->get_mixin(mixin_name);
        hash_table<ustring, value> params;
        if (pmixin)
        {
          t = s.b_token();
          if (t == '(')
          {
            int pn = 0;
            while (true) {
              t = s.a_token();
              if (t == ')' || t == css_istream::T_EOF) { break; }
              if (t == ',') continue;
              s.push_back();
              if (pn >= pmixin->params.size()) {
                view::debug_printf(OT_CSS, OS_WARNING, "too many mixin parameters at (%s(%d))\n", url.c_str(), line_no);
                break;
              }
              ustring param_name = pmixin->params[pn++];
              value  param_value;
              if (!parse_variable_value(doc, url, s, param_value, top_sb))
              {
                view::debug_printf(OT_CSS, OS_WARNING, "unrecognized mixin parameter syntax at (%s(%d))\n", url.c_str(), line_no);
                break;
              }
              params[param_name] = param_value;
            }
            // parameters
          }
          //else
          //  s.push_back();

          if (params.size())
            for (int n = 0; n < pmixin->items.size(); ++n)
            {
              auto vals = substitute_params(pmixin->items[n].attr_value(), params);
              //set_attribute_value(doc, *st, pmixin->items[n].attr_name, vals());
              spl.set(pmixin->items[n].attr_name, vals());
            }
          else
            for (int n = 0; n < pmixin->items.size(); ++n)
            {
              //set_attribute_value(doc, *st, pmixin->items[n].attr_name, pmixin->items[n].attr_value());
              spl.set(pmixin->items[n].attr_name, pmixin->items[n].attr_value());
            }
        }
        else
          view::debug_printf(OT_CSS, OS_WARNING, "unknown mixin '%S' at (%s(%d))\n",mixin_name.c_str(), url.c_str(), line_no);
        continue;
      }

      case css_istream::T_VARIABLE_NAME: 
      {
        start = s.prev_pos;
        line_no = s.line_no;
        attr_name = string(s.token_value());

        t = s.b_token();
        if (t != ':') {
          skip_block(true);
          view::debug_printf(OT_CSS, OS_ERROR,"bad variable declaration syntax of '%s' at (%s(%d))\n",attr_name.c_str(), url.c_str(), line_no);
          return false;
        }

        value val;
        if (parse_variable_value(doc, url, s, val, top_sb)) {
          spl.set_var(attr_name, val);
          //st->variables.set(attr_name, val);
        }
        else
          goto BAD_VALUE;

        continue;
      }
      
      case css_istream::T_NMTOKEN: 
      {
        start = s.prev_pos;
        line_no = s.line_no;
        attr_name = string(s.token_value());

        // PARSE_ATTR_VALUE:

        t = s.b_token();
        // if(t == '!')
        // wchar tc = t;

        if (t != ':') {
          skip_block(true);

          view::debug_printf(
            OT_CSS, OS_ERROR,
            "bad property declaration syntax of '%s' at (%s(%d))\n",
            attr_name.c_str(), url.c_str(), line_no);
          // view::debug_print( start, s.pos );

          return false;
        }

        /*if (attr_name().ends_with(CHARS("!"))) 
        {
          if (parse_action_attribute_value(doc, url, s, a_values,&doc->styles())) {
            //if (!set_attribute_value(doc, *st, attr_name, a_values()))
            //  goto BAD_NAME;
            spl.set_action(attr_name, a_values[0]);
          }
          else
            goto BAD_VALUE;
        }
        else */
        if (attr_name[0] == '-') 
        {
          value customv;
          if (parse_custom_attribute_value(doc, url, s, customv, top_sb)) {
            //st->custom.set(attr_name, customv);
            spl.set_custom(attr_name, customv);
          }
          else
            goto BAD_VALUE;
        }
        else 
        {
          is_important = false;
          if (crack_attribute_value(doc, url, s, a_values, is_important, top_sb, CAV_DEFAULT)) 
          {
            spl.set(attr_name, a_values(), is_important);
            pr = PAV_OK;
          }
          else
            pr = PAV_BAD_VALUE;

          switch (pr) {
            case PAV_BAD_VALUE:
BAD_VALUE:
            view::debug_printf(OT_CSS, OS_WARNING,"unrecognized property syntax of '%s' at (%s(%d))\n",attr_name.c_str(), url.c_str(), line_no);
            break;
          case PAV_UNKNOWN_PROPERTY:
//BAD_NAME:
            view::debug_printf(OT_CSS, OS_WARNING, "unknown property '%s' at (%s(%d))\n", attr_name.c_str(), url.c_str(), line_no);
            break;
          }
        }
        continue; 
      }
      
      default:
        view::debug_printf(OT_CSS, OS_WARNING, "unrecognized property name syntax at (%s(%d))\n", url.c_str(), s.line_no); 
        skip_statement();
        continue;
      }
    return false;

  }

  bool style_parser::parse(wchars mquery, bool section, style_bag *sb) {

    tool::hash_table<ustring, handle<style_bag::const_def>> saved_const;

    if (!sb)
      sb = &doc->styles();

    handle<eval::conduit> parsed_media_expr;

    if (mquery.length) {
      parsed_media_expr = new eval::conduit(media_expr);
      eval::parser p(*parsed_media_expr.ptr(), url, s.line_no, sb);
      try {
        wchars rest = p.parse_mediaq(mquery);
        if (rest.length != 0) return false;
      } catch (const tool::eval::parse_error &er) {
        view::debug_printf(OT_CSS, OS_WARNING,
                           "error parsing media section at (%s(%d))\n",
                           url.c_str(), er.line_no);
        return false;
      }

      view *pv = doc->pview();
      eval_media_query(pv, doc, parsed_media_expr, parsed_media_expr->is_true);

      if (!parsed_media_expr->is_true) {
        if (!section)
          return false;
        saved_const = sb->get_constants();
      }
    }

    ON_SCOPE_EXIT(
      if (parsed_media_expr && !parsed_media_expr->prev)
        doc->media_expressions.intern(parsed_media_expr) // that is root media expression, need to intern - register in doc 
    );

    auto_state<handle<eval::conduit>> _(media_expr, parsed_media_expr);

    array<handle<style_def>> defs;
    const wchar *            start    = s.start;
    int                      start_ln = s.line_no;

    string initial_seqid = seqid;

    uint import_cnt = 'A'; // this is a sequent counter of import sections
                           // inside parsing CSS 'A' is because it is getting
                           // appended to unique style sheet sequentional id.
    if(!section)
      seqid = string::format("%s%c", initial_seqid.c_str(), import_cnt++);

    if (parse_rules(initial_seqid,seqid,import_cnt, sb)) {
      if (section) {
        if (saved_const.size())
          sb->set_constants(saved_const);
      }
    }
    doc->styles().reorder();
    return true;
  }

  bool style_parser::parse_rules(string initial_seqid, string seqid, uint& import_cnt, style_bag *sb)
  {
    array<handle<style_def>> defs;
    const wchar *            start = s.start;
    int                      start_ln = s.line_no;

    int t;

    for (t = s.s_token(true); t; t = s.s_token(true))
      switch (t) {
      case css_istream::T_ATRULE: {
        wchars tok = s.token_value();
        defs.clear();
        if (tok == WCHARS("media"))
          parse_media_section(sb);
        else if (tok == WCHARS("import")) {
          parse_import_statement(seqid);
          seqid = string::format("%s%c", initial_seqid.c_str(), import_cnt++);
        }
        else if (tok == WCHARS("set"))
          parse_set_block(sb);
        else if (tok == WCHARS("const"))
          parse_const_declaration(sb);
        else if (tok == WCHARS("mixin"))
          parse_mixin_declaration(sb);
        else if (tok == WCHARS("keyframes"))
          parse_keyframes_declaration(sb);
        else if (tok == WCHARS("include"))
          parse_include_statement();
        else if (tok == WCHARS("font-face"))
          parse_font_face_statement();
        else if (tok == WCHARS("image-map"))
          parse_image_map_statement();
        else if (tok == WCHARS("supports"))
          parse_supports_section(initial_seqid,seqid,import_cnt,sb);
        continue;
      }

                                  // case ',': - moved int parse_list
                                  //  assert(defs.size() != 0);
                                  //  continue;

      case '}':
        return true;
      case '{':
        if (defs.size() == 0) {
          start = s.prev_pos;
          // skip_block(true);
          s.push_back();
          goto SELECTOR_ERROR;
        }
        else {
          hstyle_prop_list spl = new style_prop_list();
          spl->pbag = sb;
          parse_body(*spl);
          for (int i = 0; i < defs.size(); ++i) {
            style_def *def = defs[i];
            def->media_expr = media_expr;

            //if (def->pseudo_element.is_defined())
            //  st->pseudo_element_id = (PSEUDO_ELEMENT_ID)def->pseudo_element.val(0);

            sb->add_style(seqid, defs[i], spl);
          }
          defs.clear();
          continue;
        }

      case '*':
      case '[':
      case '(':
      case css_istream::T_NMTOKEN:
      case css_istream::T_ID:
      case css_istream::T_PSEUDO:
      case css_istream::T_PSEUDO_EL:
      case css_istream::T_CLASS:
      {
        s.push_back();
        start = s.pos;
        // const wchar* sss = s.pos;
        start_ln = s.line_no;
        if (!style_def::parse_list(sb, s, defs)) { // ERROR in SELECTOR
        SELECTOR_ERROR:
          defs.clear();
          view::debug_printf(OT_CSS, OS_WARNING,
            "unrecognized css selector at (%s(%d))\n",
            url.c_str(), start_ln);
          skip_block();
        }
        continue;
      }

      default:
        // assert(false);
        // continue;
        start = s.prev_pos;
        goto SELECTOR_ERROR;
      }
    return true;
  }

  void style_parser::skip_statement() {
    int t = 0;
    for (t = s.a_token(); t; t = s.a_token())
      if (t == ';')
        break;
      else if (t == '}')
        break;
  }
  void style_parser::skip_block(bool open) {
    int t, braces = open ? 1 : 0;
    for (t = s.b_token(); t; t = s.b_token()) {
      if (t == '{')
        ++braces;
      else if (t == '}') {
        if (--braces <= 0) break;
      }
    }
  }
  void style_parser::parse_import_statement(const string &is_seqid) {
    // caller consumed @import

    // const wchar* start = s.pos;
    wchars mquery;

    int t = s.a_token();

    string        url;
    array<string> mtypes;

    if (t == css_istream::T_STRING || t == css_istream::T_URL) {
      url = string(s.token_value());
    } else
      goto IMPORT_ERROR;

    mquery = s.scan_until(W(";"));
    if (mquery.end() == s.end) { goto IMPORT_ERROR; }
    /*
    while(t = s.a_token())
    {
      if( t == ';')
        break;
      else if( t == css_istream::T_NMTOKEN )
        mtypes.push( string( s.token_value ) );
      else
        goto IMPORT_ERROR;
    }*/

    assert(url.length());

    // if(!is_conforming_media(mtypes))
    //  return;

    load_style_sheet(is_seqid, url, mquery);
    return;

  IMPORT_ERROR:
    view::debug_printf(OT_CSS, OS_ERROR, "in @import statement at (%s(%d))\n",
                       url.c_str(), s.line_no);
    skip_statement();
    // view::debug_println(start, s.pos);
  }

  void style_parser::parse_include_statement() {
    // caller consumed @include

    // const wchar* start = s.pos;

    int t = s.a_token();

    string        url;
    string        type;
    array<string> mtypes;

    if (t == css_istream::T_STRING) {
      type = string(s.token_value());
    } else
      goto INCLUDE_ERROR;

    t = s.a_token();

    if (t == css_istream::T_STRING || t == css_istream::T_URL) {
      url = string(s.token_value());
    } else
      goto INCLUDE_ERROR;

    for (t = s.a_token(); t; t = s.a_token()) {
      if (t == ';')
        break;
      else if (t == css_istream::T_NMTOKEN)
        mtypes.push(string(s.token_value()));
      else
        goto INCLUDE_ERROR;
    }

    assert(url.length());

    // if(!is_conforming_media(mtypes))
    //  return;

    load_resource(url, type);
    return;

  INCLUDE_ERROR:
    view::debug_printf(OT_CSS, OS_ERROR, "in @include statement at (%s(%d)):\n",
                       url.c_str(), s.line_no);
    skip_statement();
    // view::debug_println(start, s.pos);
  }

  /*
  @font-face
  {
    font-family: Gentium;
    src: url(http://site/fonts/Gentium.ttf);
  }*/

  void style_parser::parse_font_face_statement() {
    // caller consumed @font-face

    // const wchar* start = s.pos;

    ustring    name;
    string     src;
    ustring    field_name;
    int_v      weight;
    font_style_ev italic;

    int t = s.b_token();

    if (t != '{') goto FONT_FACE_ERROR;

    for (t = s.b_token(); t; t = s.b_token()) {
      if (t == ';') continue;

      if (t == '}') break;

      if (t != css_istream::T_NMTOKEN) goto FONT_FACE_ERROR;

      field_name = s.token_value();

      t = s.b_token();
      if (t != ':') goto FONT_FACE_ERROR;

      value val;

      if (!parse_value(doc, url, s, val)) goto FONT_FACE_ERROR;

      if (field_name == WCHARS("font-family")) {
        if (val.is_string())
          name = val.get(W(""));
        else
          goto FONT_FACE_ERROR;
      } else if (field_name == WCHARS("src")) {
        if(val.is_url())
          src = val.get_url();
        else if (val.is_string())
          src = combine_url(url, val.get(W("")));
        else
          goto FONT_FACE_ERROR;
      } else if (field_name == WCHARS("font-weight")) {
        if (!font_weight(weight, val)) goto FONT_FACE_ERROR;
      } else if (field_name == WCHARS("font-style")) {
        if (!italic.set(val)) goto FONT_FACE_ERROR;
      }
    }

    if (name.length() && src.length()) {
      // handle<pump::request> rq = new pump::request(src,DATA_RAW_DATA);
      handle<pump::request> rq = new pump::request(src, DATA_FONT);
      rq->dst                  = doc;
      view * pv                = doc->pview();
      int    line_no           = s.line_no;
      string url               = this->url;

      rq->add([pv, src, url, line_no, name, weight,
               italic](request *rq) -> bool {

        if (!rq->data.size()) {
          view::debug_printf(OT_CSS, OS_WARNING,
                             "in @font-face statement font resource, %s is not "
                             "available at (%s(%d))\n",
                             src.c_str(), url.c_str(), line_no);
          return true;
        }
        if (!pv->app->install_font(name, weight.val(400), italic.val() != font_style_normal, rq->data())) {
          view::debug_printf(
              OT_CSS, OS_WARNING,
              "in @font-face statement, failed to install font at (%s(%d))\n",
              url.c_str(), line_no);
          return true;
        }
        return true;
      });

      load_data(rq, pv, true);
      return;
    } else {
      view::debug_printf(
          OT_CSS, OS_ERROR,
          "in @font-face statement, declaration is not complete at (%s(%d))\n",
          url.c_str(), s.line_no);
    }

    return;

  FONT_FACE_ERROR:
    view::debug_printf(OT_CSS, OS_ERROR,
                       "in @font-face statement at (%s(%d))\n", url.c_str(),
                       s.line_no);
    skip_statement();
    // view::debug_println(start, s.pos);
  }

  /*
  @image-map
  {
    name: icons;
    src: url(images.png);
    cell: X Y; // optional, in image pixels
    items: name1(1) name2(0,0,16,16);
  }*/

  void style_parser::parse_image_map_statement() {
    // caller consumed @image-map

    // const wchar* start = s.pos;

    ustring                  name;
    array<pair<string, int>> url_and_dpi;
    size                     cells; // number of columns and rows
    array<value>             items;

    ustring field_name;

    int t = s.b_token();
    if (t != css_istream::T_NMTOKEN) goto IMAGE_MAP_ERROR;

    name = s.token_value();

    t = s.b_token();

    if (t != '{') goto IMAGE_MAP_ERROR;

    for (t = s.b_token(); t; t = s.b_token()) {
      if (t == ';') continue;

      if (t == '}') break;

      if (t != css_istream::T_NMTOKEN) goto IMAGE_MAP_ERROR;

      field_name = s.token_value();

      t = s.b_token();
      if (t != ':') goto IMAGE_MAP_ERROR;

      array<value> values;
      bool         dummy;

      CAV_MODE parsing_mode =
          field_name == WCHARS("items") || field_name == WCHARS("src") ? CAV_FORCE_COMMA_LIST : CAV_DEFAULT;

      if (crack_attribute_value(doc, url, s, values, dummy, 0, parsing_mode)) {
        if (field_name == WCHARS("cells")) {
          if (values.size() != 2 || !values[0].is_int() || !values[1].is_int())
            goto IMAGE_MAP_ERROR;
          cells.x = values[0].to_int();
          cells.y = values[1].to_int();
        } else if (field_name == WCHARS("src")) {
          // if(values.size() == 1 && values[0].is_url() )
          //{
          //   string src = combine_url(url,values[0].to_string());
          //   url_and_dpi.push( pair<string,int>(src,0) );
          //}
          // else
          {
            for (int n = 0; n < values.size(); ++n) {
              value p2 = values[n];
            JUST_URL:
              if (p2.is_url()) {
                string src = combine_url(url, p2.get_url());
                url_and_dpi.push(pair<string, int>(src, 0));
              } else if (p2.is_array() && p2.size() == 1) {
                p2 = p2.values()[0];
                goto JUST_URL;
              } else if (p2.is_array() && p2.size() == 2) {
                slice<value> url_dpi = p2.values();
                value        d1      = url_dpi[1];
                string       src;
                int_v        dpi;
                if (url_dpi[0].is_url())
                  src = combine_url(url, url_dpi[0].get_url());
                else if (url_dpi[0].is_int())
                  dpi = url_dpi[0].get(0);
                else
                  goto IMAGE_MAP_ERROR;

                if (url_dpi[1].is_url())
                  src = combine_url(url, url_dpi[1].get_url());
                else if (url_dpi[1].is_int())
                  dpi = url_dpi[1].get(0);
                else
                  goto IMAGE_MAP_ERROR;

                if (src.is_empty() || dpi.is_undefined()) goto IMAGE_MAP_ERROR;

                url_and_dpi.push(pair<string, int>(src, dpi.val(0)));
              } else
                goto IMAGE_MAP_ERROR;
            }
          }
        } else if (field_name == WCHARS("items")) {
          // if( values.size() && values[0].is_array() ) {
          //  value a1 = value::make_array(values());
          //  items.size(1);
          //  items[0] = a1;
          //}
          // else
          items = values;
        }
      }
    }

    if (name.length() && url_and_dpi.length()) {
      if (!doc->register_image_map(name, url_and_dpi(), cells, items())) {
        view::debug_printf(
            OT_CSS, OS_WARNING,
            "in @image-map statement, failed to parse items at (%s(%d))\n",
            url.c_str(), s.line_no);
        return;
      }
      return;
    } else {
      view::debug_printf(
          OT_CSS, OS_ERROR,
          "in @image-map statement, declaration is not complete at (%s(%d))\n",
          url.c_str(), s.line_no);
    }
    return;

  IMAGE_MAP_ERROR:
    view::debug_printf(OT_CSS, OS_ERROR,
                       "in @image-map statement at (%s(%d))\n", url.c_str(),
                       s.line_no);
    skip_statement();
    // view::debug_println(start, s.pos);
  }

  // parse named set of style definitions

  // format named set of style definitions is:
  // @set nmtoken {
  //    selector1 { ... }
  //    selector2 { ... }
  //    ...
  // }

  void style_parser::parse_set_block(style_bag *parent_sb) {
    // caller consumed @set

    const wchar *start = s.pos;

    string name;
    string super_name;

    int t = s.s_token(true);

    if (t == css_istream::T_NMTOKEN) {
      name = string(s.token_value());
      t    = s.s_token(true);
      if (t == '<') {
        t = s.s_token(true);
        if (t != css_istream::T_NMTOKEN) goto HEADER_ERROR;
        super_name = string(s.token_value());
        t          = s.s_token(true);
      }

      if (t != '{') goto HEADER_ERROR;
    }

    if (name.length() == 0) {
    HEADER_ERROR:
      view::debug_printf(OT_CSS, OS_ERROR, "in @set statement at (%s(%d))\n",
                         url.c_str(), s.line_no);
      skip_block();
      // view::debug_println(start, s.pos);
      return;
    }

    handle<style_bag> sb = new style_bag(parent_sb);

    auto_state<style_bag *> _(top_sb, sb.ptr());

    if (super_name.length()) {
      style_bag *super_sb = parent_sb->get_named_set(super_name);
      if (!super_sb && parent_sb != &application::stock_styles())
        super_sb = application::stock_styles().get_named_set(super_name);

      if (super_sb)
        sb->derive_from(super_sb);
      else {
        view::debug_printf(
            OT_CSS, OS_ERROR,
            "in @set statement, parent set %s not found at (%s(%d)) \n",
            super_name.c_str(), url.c_str(), s.line_no);
        // view::debug_println(start, s.pos);
      }
    }

    start        = s.start;
    int start_ln = s.line_no;
    // style_def* sd = 0;
    array<handle<style_def>> defs;

    for (t = s.s_token(true); t; t = s.s_token(true))
      switch (t) {
      case '}': {
        sb->reorder();
        // doc->styles().add_named_set(name, sb);
        parent_sb->add_named_set(name, sb);
      }
        return;
      case '{':
        if (defs.size() == 0) {
          start = s.prev_pos;
          s.push_back();
          goto SELECTOR_ERROR;
        } else {
          hstyle_prop_list spl = new style_prop_list();
          spl->pbag = sb;
          parse_body(*spl);
          for (int i = 0; i < defs.size(); ++i) {
            defs[i]->media_expr = media_expr;
            //if (defs[i]->pseudo_element.is_defined())
            //  st->pseudo_element_id = (PSEUDO_ELEMENT_ID) defs[i]->pseudo_element.val(0);
            sb->add_style(seqid, defs[i], spl);

            /*if (defs[i]->pseudo_element.is_defined()) {
              hstyle empty_st = new style();
              switch (defs[i]->pseudo_element.val(0)) {
              case PSEUDO_ELEMENT_AFTER: empty_st->after = st; break;
              case PSEUDO_ELEMENT_BEFORE: empty_st->before = st; break;
              case PSEUDO_ELEMENT_SHADE: empty_st->shade = st; break;
              case PSEUDO_ELEMENT_MARKER: empty_st->marker = st; break;
              case 0: assert(false); break;
              default: {
                style::span_mark sm;
                sm.id    = defs[i]->pseudo_element.val(0);
                sm.style = st;
                empty_st->span_marks.push(sm);
              }
              }
              sb->add_style(seqid, defs[i], empty_st);
            } else 
              sb->add_style(seqid, defs[i], st);*/
          }
          defs.clear();
        }
        continue;

      case css_istream::T_ATRULE: {
        wchars tok = s.token_value();
        defs.clear();
        if (tok == WCHARS("set"))
          parse_set_block(sb);
        else if (tok == WCHARS("media"))
          parse_media_section(sb);
        else if (tok == WCHARS("const"))
          parse_const_declaration(sb);
        else if (tok == WCHARS("mixin"))
          parse_mixin_declaration(sb);
        else if (tok == WCHARS("keyframes"))
          parse_keyframes_declaration(sb);
        else {
          FOREACH(k, defs) delete defs[k];
          defs.clear();
          view::debug_printf(
              OT_CSS, OS_ERROR,
              "AT-rule is not acceptable in this context, at (%s(%d))\n",
              url.c_str(), s.line_no);
          skip_block();
          // view::debug_println(start, s.pos);
        }
        continue;
      }

      case '*':
      case '[':
      case '(':
      case css_istream::T_NMTOKEN:
      case css_istream::T_ID:
      case css_istream::T_PSEUDO:
      case css_istream::T_PSEUDO_EL:
      case css_istream::T_CLASS: {
        s.push_back();
        start    = s.pos;
        start_ln = s.line_no;
        if (!style_def::parse_list(sb, s, defs)) { // ERROR in SELECTOR
        SELECTOR_ERROR:
          FOREACH(k, defs) delete defs[k];
          defs.clear();
          view::debug_printf(OT_CSS, OS_WARNING,
                             "unrecognized css selector at (%s(%d))\n",
                             url.c_str(), start_ln);
          skip_block();
          // view::debug_println(start, s.pos);
        }
      }
        continue;

      default: start = s.prev_pos; goto SELECTOR_ERROR;
      }
    assert(false);
    return;
  }

#if defined(SCSS)
  void
  style_parser::parse_nested_declaration(style_bag *              sb,
                                         slice<handle<style_def>> outer_defs) {
    // caller has consumed ?
    const wchar *start = s.pos;

    auto_state<style_bag *> _(top_sb, sb);

    start        = s.start;
    int start_ln = s.line_no;
    // style_def* sd = 0;
    array<handle<style_def>> defs;

    for (int t = s.s_token(true); t; t = s.s_token(true))
      switch (t) {
      case '{':
        if (defs.size() == 0) {
          start = s.prev_pos;
          s.push_back();
          goto SELECTOR_ERROR;
        } else {
          hstyle st = new style();
          parse_body(st);
          for (int oi = 0; oi < outer_defs.size(); ++oi)
            for (int i = defs.last_index(); i >= 0; --i) {
              handle<style_def> def = defs[i]->copy();
              def->last()->next     = outer_defs[oi];
              def->media_expr       = media_expr;
              // sb->add_style(seqid,defs[i],st);
              if (def->pseudo_element.is_defined()) {
                hstyle empty_st = new style();
                if (def->pseudo_element == PSEUDO_ELEMENT_AFTER)
                  empty_st->after = st;
                else if (def->pseudo_element == PSEUDO_ELEMENT_BEFORE)
                  empty_st->before = st;
                else if (def->pseudo_element == PSEUDO_ELEMENT_SELECTION)
                  empty_st->selection = st;
                sb->add_style(seqid, def, empty_st);
              } else
                sb->add_style(seqid, def, st);
            }
          defs.clear();
        }
        return;

      case '*':
      case '[':
      case '>':
      case '+':
      case css_istream::T_NMTOKEN:
      case css_istream::T_ID:
      case css_istream::T_PSEUDO:
      case css_istream::T_PSEUDO_EL:
      case css_istream::T_CLASS: {
        s.push_back();
        start    = s.pos;
        start_ln = s.line_no;

        if (!style_def::parse_list(s, defs)) { // ERROR in SELECTOR
        SELECTOR_ERROR:
          FOREACH(k, defs) delete defs[k];
          defs.clear();
          view::debug_printf(OT_CSS, OS_WARNING,
                             "unrecognized css selector at (%s(%d))\n",
                             url.c_str(), start_ln);
          skip_block();
          // view::debug_println(start, s.pos);
        }
      }
        continue;

      case css_istream::T_ATRULE:
      default: start = s.prev_pos; goto SELECTOR_ERROR;
      }
    assert(false);
    return;
  }
#endif

  void style_parser::parse_const_declaration(style_bag *sb) {
    // caller has consumed @const
    int line_no = s.line_no;
    // const wchar* start = s.pos;
    string name;
    int    t;
    while (true) {
      t = s.b_token();
      if (t == ',')
        continue;
      else if (t == ';')
        break;
      if (t == css_istream::T_NMTOKEN) name = string(s.token_value());

      t = s.b_token();
      if (t == ':') {
        array<value> values;
        bool         dummy;
        if (crack_attribute_value(doc, url, s, values, dummy)) {
          //if (!media_expr || media_expr->is_true) {
            if (values.size() == 1)
              sb->add_const(name, values[0], seqid);
            else
              sb->add_const(name, values, seqid);
          //}
        } else
          goto GOT_ERROR;
      }
      /*else if( t == '{' )
      {
        //array<value> values; bool dummy;
        handle<function_value> pmap = new function_value;
        while((t = s.b_token()) != css_istream::T_EOF )
        {
          if( t == '}')
            break;

         value::make_function(function_value* f = 0);

        }


        //sb->add_const( names, values, seqid );
      } */
      else {
      GOT_ERROR:
        view::debug_printf(OT_CSS, OS_WARNING,
                           "wrong @const declaration at (%s(%d))\n",
                           url.c_str(), line_no);
        skip_statement();
        // view::debug_println(start, s.pos);
        return;
      }
    }
  }

  void style_parser::parse_mixin_declaration(style_bag *sb) {
    // caller has consumed @mixin
    int line_no = s.line_no;
    // const wchar* start = s.pos;
    string name;
    string errm;
    int    t = s.b_token();

    handle<mixin> pmixin = new mixin;

    if (t != css_istream::T_NMTOKEN) {
      errm = "name expected";
      goto GOT_ERROR;
    }
    pmixin->name = ustring(s.token_value());

    t = s.b_token();
    if (t == '(') { // mixin with parameters
      while (true) {
        t = s.b_token();
        if (t == ')' || t == css_istream::T_EOF) { t = s.b_token(); break; }
        if (t == ',') break;
        if (t != css_istream::T_NMTOKEN) {
          errm = "name expected";
          goto GOT_ERROR;
        }
        pmixin->params.push(ustring(s.token_value()));
      }
    }
    //else
    //  s.push_back();

    if (t != '{') {
      errm = "'{' expected";
      goto GOT_ERROR;
    }

    while (true) {
      t = s.b_token();
      if (t == '}') break;
      if (t == ';') continue;

      line_no = s.line_no;

      if (t == css_istream::T_ATRULE) // nested mixin support
      {
        string        mixin_name = ustring(s.token_value());
        handle<mixin> omixin     = this->top_sb->get_mixin(mixin_name);
        if (omixin) {
          hash_table<ustring, value> params;
          t = s.b_token();
          if (t == '(')
          {
            int pn = 0;
            while (true) {
              t = s.a_token();
              if (t == ')' || t == css_istream::T_EOF) { break; }
              if (t == ',') continue;
              s.push_back();
              if (pn >= omixin->params.size()) {
                view::debug_printf(OT_CSS, OS_WARNING, "too many mixin parameters at (%s(%d))\n", url.c_str(), line_no);
                break;
              }
              ustring param_name = omixin->params[pn++];
              value  param_value;
              if (!parse_variable_value(doc, url, s, param_value, top_sb))
              {
                view::debug_printf(OT_CSS, OS_WARNING, "unrecognized mixin parameter syntax at (%s(%d))\n", url.c_str(), line_no);
                break;
              }
              params[param_name] = param_value;
            }
            // parameters
          }
          else
            s.push_back();

          int size_before = pmixin->items.size();
          pmixin->items.push(omixin->items());
          if (params.size())
            for(auto& prm: pmixin->items.target()(size_before))
              prm.attr_value = substitute_params(prm.attr_value(),params);

        }
        else
          view::debug_printf(OT_CSS, OS_WARNING,
                             "unknown mixin '%S' at (%s(%d))\n",
                             mixin_name.c_str(), url.c_str(), line_no);
        continue;
      }

      if (t != css_istream::T_NMTOKEN) {
        errm = "name expected";
        goto GOT_ERROR;
      }

      name = string(s.token_value());

      t = s.b_token();
      if (t != ':') {
        errm = "':' expected";
        goto GOT_ERROR;
      }

      {
        mixin::item mi;
        mi.attr_name = name;
        bool dummy;
        if (crack_attribute_value(doc, url, s, mi.attr_value, dummy))
          pmixin->items.push(mi);
        else {
          {
            errm = "mixin property value";
            goto GOT_ERROR;
          }
          goto GOT_ERROR;
        }
      }
    }
    if (!media_expr || media_expr->is_true) { sb->add_mixin(pmixin); }
    return;
  GOT_ERROR:
    view::debug_printf(OT_CSS, OS_WARNING,
                       "wrong @mixin declaration: %s at (%s(%d))\n",
                       errm.c_str(), url.c_str(), line_no);
    skip_statement();
  }

  void style_parser::parse_keyframes_declaration(style_bag *sb) {
    // caller consumed @media
    int line_no = s.line_no;
    int errors = 0;
    // const wchar* start = s.pos;
    string name;
    string errm;
    int    t = s.b_token();

    handle<keyframes> pkeyframes = new keyframes();

    if (t != css_istream::T_NMTOKEN) {
      errm = "name expected";
      goto GOT_ERROR;
    }
    pkeyframes->name = ustring(s.token_value());

    t = s.b_token();

    if (t != '{') {
      errm = "'{' expected";
      goto GOT_ERROR;
    }

    while (true) {
      t = s.a_token();
      if (t == '}') break;
      if (t == ';') continue;

      line_no = s.line_no;

      keyframes::edge_def edge_def;

      if (t == css_istream::T_NUMBER_UNIT && s.token_value().like(W("*%"))) {
        wchars nc = s.token_value();
        edge_def.key_position = str_to_f(nc, 0.0f);
        edge_def.key_position /= 100.0f;
        edge_def.key_position = limit(edge_def.key_position, 0.0f, 1.0f);
      }
      else if (t == css_istream::T_NMTOKEN && s.token_value() == WCHARS("from"))
      {
        edge_def.key_position = 0.0f;
      }
      else if (t == css_istream::T_NMTOKEN && s.token_value() == WCHARS("to"))
      {
        edge_def.key_position = 1.0f;
      }
      else {
        view::debug_printf(OT_CSS, OS_WARNING, "keyframes: unrecognized position value at (%s(%d))\n", url.c_str(), line_no);
        edge_def.key_position = 1.0f;
        ++errors;
      }

      t = s.b_token();
      if (t != '{') {
        line_no = s.line_no;
        view::debug_printf(OT_CSS, OS_WARNING, "keyframes: expecting '{' at (%s(%d))\n", url.c_str(), line_no);
        ++errors;
        while (true) {
          t = s.b_token();
          if (t == css_istream::T_EOF || t == '}')
            break;
        }
        return;
      }

      while (true)
      {
        keyframes::prop_def prop_def;

        t = s.b_token();

        if (t == ';')
          continue;
        else if (t == '}')
          break;
        else if (t != css_istream::T_NMTOKEN) {
          errm = "name expected";
          goto GOT_ERROR;
        }

        prop_def.prop_symbol = cssa::symbol(string(s.token_value()));

        if (!prop_def.prop_symbol) {
          errm = "unknown property";
          goto GOT_ERROR;
        }

        t = s.b_token();
        if (t != ':') {
          errm = "':' expected";
          goto GOT_ERROR;
        }

        {
          bool dummy;
          if (crack_attribute_value(doc, url, s, prop_def.prop_value, dummy))
            edge_def.key_props.push(prop_def);
          else
          {
            errm = "property value";
            goto GOT_ERROR;
          }
        }
      }

      pkeyframes->edges.push(edge_def);
    }

    if(!errors)
      sb->add_keyframes(pkeyframes);

    return;
  GOT_ERROR:
    view::debug_printf(OT_CSS, OS_WARNING, "keyframes: %s at (%s(%d))\n", errm.c_str(), url.c_str(), line_no); skip_statement();

  }

  void style_parser::parse_media_section(style_bag *sb) {
    // caller consumed @media
    int line_no = s.line_no;
    // const wchar* start = s.pos;

    wchars mquery = s.scan_until(W("{"));
    if (mquery.end() == s.end) {
      view::debug_printf(OT_CSS, OS_WARNING,
                         "invalid @media declaration at (%s(%d))\n",
                         url.c_str(), line_no);
      return;
    }

    if (trim(mquery).length == 0)
      mquery = WCHARS("false"); // ATTN! this is not standard behavior!
                                // it is introduced in h-smile to support
                                // detection of h-smile and non-hsmile in CSS.
                                // @media { ... only conventional browsers rules
                                // ... }
                                // @media h-smile { ... h-smile only rules ... }

    parse(mquery, true, sb);
  }

  /* @supports (display: grid) {
    div{
      display: grid;
    }
  }*/


  bool style_parser::parse_supports_expr(bool &block_open) 
  {
    enum TOK {
      TOK_EOF = 0,
      TOK_NAME = 1,
      TOK_AND = 2,
      TOK_OR = 3,
      TOK_NOT = 4,
      TOK_COLON = 5,
      TOK_ERROR = 6,
      TOK_BOF = 7,
    };

    TOK current_token = TOK_EOF;
    auto next_token = [&]() -> TOK {
      int t = s.b_token();
      if (t == css_istream::T_NMTOKEN) {
        if (s.token_value() == WCHARS("or")) return current_token = TOK_OR;
        else if (s.token_value() == WCHARS("and")) return current_token = TOK_AND;
        else if (s.token_value() == WCHARS("not")) return current_token = TOK_NOT;
        else return current_token = TOK_NAME;
      }
      else if (t == '{')
        return current_token = TOK(t);
      else if (t == '(' || t == ')' || t == '{' || t == ':')
        return current_token = TOK(t);
      else if( t == css_istream::T_EOF)
        return current_token = TOK_EOF;
      else {
        //return current_token = TOK_ERROR;
        throw tool::error("unrecognized token");
      }
    };

    std::function<bool()> eval_primary;

    auto eval_prop = [&]() -> bool {
      string prop_name = s.token_value();
      if (next_token() != ':')
        throw tool::error("expecting ':'");
      bool r = false;
      value customv;
      if (parse_custom_attribute_value(doc, url, s, customv, top_sb)) {
        style s; r = set_attribute_value(element_context(doc), s, prop_name, customv);
      }
      next_token();
      return r;
    };

    auto eval_paren = [&]() -> bool {
      switch (current_token) {
      case TOK_NAME: {
        bool r = eval_prop();
        if (current_token != ')')
          throw tool::error("expecting ')'");
        return r;
      }
      case '(': {
        bool r = eval_primary();
        if (current_token != ')')
          throw tool::error("expecting ')'");
        return r;
      }
      default:
        throw tool::error("bad paren expression");
      }
    };

    eval_primary = [&]() -> bool {
      switch (current_token) {
      case '(': {
        next_token();
        bool r = eval_paren();
        if (current_token != ')')
          throw tool::error("missing ')'");
        next_token();
        return r;
      }
                //case TOK_SELECTOR:
      default:
        throw tool::error("expecting (");
      }
    };

    auto eval_unary = [&]() -> bool {
      switch (current_token) {
      case TOK_NOT: next_token(); return !eval_primary();
      default: return eval_primary();
      }
    };

    auto eval_and = [&]() -> bool {
      bool r = eval_unary();
      for (;;) switch (current_token)
      {
      case TOK_AND:
        next_token();
        r = eval_unary() && r;
        break;
      default:
        return r;
      }
    };

    auto eval_or = [&]() -> bool {
      bool r = eval_and();
      for (;;) switch (current_token)
      {
      case TOK_OR:
        next_token();
        r = eval_and() || r;
        break;
      default:
        return r;
      }
    };

    bool result = false;
    next_token();
    result = eval_or();
    block_open = current_token == '{';
      
    return result;
  }

  void style_parser::parse_supports_section(string initial_seqid, string seqid, uint& import_cnt, style_bag *sb) {
    // caller consumed @supports
    int line_no = s.line_no;

    bool block_open = false;
    bool result = false;

    try 
    {
      result = parse_supports_expr(block_open);

      if (!block_open)
        throw tool::error("expecting '{'");

    } catch(std::exception& e) {
      view::debug_printf(OT_CSS, OS_WARNING, "@supports: %s at (%s(%d))\n", e.what(), url.c_str(), line_no);
    }

    if (result)
      parse_rules(initial_seqid, seqid, import_cnt, sb);
    else
      skip_block(block_open);
  }

  bool style_parser::load_style_sheet(const string &ss_seqid, string href,
                                      wchars mquery) {
    // string href_fact;
    href = combine_url(url, href);

    view *pv = doc->pview();

    handle<pump::request> hrq = new pump::request(href, DATA_STYLE);
    hrq->rq_id                = ss_seqid;
    hrq->dst                  = doc;
    hrq->mediaq               = mquery;

    if (!load_data(hrq, pv)) return false;

    if (!hrq->data.size()) return false;

    hrq->data.push(0);

    ustring wdata = u8::cvt(hrq->data());

    style_parser stp(ss_seqid, wdata, doc, href);
    stp.parse(mquery);
    return true;
  }

  bool style_parser::load_resource(string href, string mime_type) {
    // string href_fact;
    href = combine_url(url, href);

    view *pv = doc->pview();
    if (!pv) return false;

    RESOURCE_DATA_TYPE rt = DATA_ALL;

    if (mime_type.like("*/*script"))
      rt = DATA_SCRIPT;
    else
      return false;

    /*
    pump::request rq(href,rt);
    rq.dst = doc;

    if(!pv->load_data(rq))
      return false;

    if(!rq.data.size())
      return false;

    rq.data.push(0);
    rq.data.pop();

    array<wchar> wdata;
    from_utf8(rq.data(),wdata);

    return pv->load_script(doc,href,mime_type,wdata());
    */
    return pv->include_script(doc, href, mime_type);
  }

  /*void parse_inline_style(style &st, wchars text, document *pd) {
    style_parser stp("", text, pd, pd->uri().src);
    stp.parse_body(&st);
  }*/

  handle<style_prop_list> parse_style_prop_list(document *pd, const ustring& text)
  {
    handle<style_prop_list> spl = new inline_style_prop_list();
    style_parser stp("", text, pd, pd->uri().src);
    stp.parse_body(*spl);
    return spl;
  }

  void parse_style_sheet(const string &seqid, wchars text, document *pd,
                         const string &url, wchars mediaq) {
    style_parser stp(seqid, text, pd, url);
    stp.parse(mediaq);
    // stt.reorder();
  }

  bool document::reset_styles(wchars text, const string &base_url) {
    style_bag &stt = styles();
    stt.clear();

    // string mtype = media_type && media_type[0]? media_type:"display";
    string burl = base_url.length() ? base_url : url().src;

    style_parser stp(" ", text, this, burl);
    stp.parse(wchars());
    // stt.reorder();
    return true;
  }

  bool style::add_transition(const transition_item &p) {
    if (!p.valid()) return false;
    if (!transitions)
      transitions = new transition_def();

    cssa::each_terminal_prop_of(p.prop_sym, [&](cssa::symbol_t ts) {
      transition_item ti = p;
      ti.prop_sym = ts;
      transitions->props[ts] = ti;
    });

#if 0
    auto seti = [this](uint sym, transition_item ti)
    {
      ti.prop_sym = sym;
      transitions->props[sym] = ti;
    };

    switch (p.prop_sym) 
    {
    case cssa_font:
      seti(cssa_font_size,p);
      seti(cssa_line_height,p);
      seti(cssa_color,p);
      break;
    case cssa_font_size: seti(cssa_font_size, p ); break;
    case cssa_letter_spacing: seti(cssa_letter_spacing, p ); break;
    case cssa_line_height: seti(cssa_line_height, p ); break;
    case cssa_color: seti(cssa_color, p ); break;
    case cssa_zoom: seti(cssa_zoom, p ); break;
    case cssa_text_selection_color:
      seti(cssa_text_selection_color, p );
      break;
    case cssa_text_selection_background_color:
      seti(cssa_text_selection_background_color, p );
      break;
    case cssa_text_selection_caret_color:
      seti(cssa_text_selection_caret_color, p );
      break;
    case cssa_text_selection:
      seti(cssa_text_selection_color, p);
      seti(cssa_text_selection_background_color, p );
      break;
    case cssa_height: seti(cssa_height, p ); break;
    case cssa_width: seti(cssa_width, p ); break;
    case cssa_max_width: seti(cssa_max_width, p ); break;
    case cssa_min_width: seti(cssa_min_width, p ); break;
    case cssa_max_height: seti(cssa_max_height, p ); break;
    case cssa_min_height: seti(cssa_min_height, p ); break;
    case cssa_size:
      seti(cssa_width, p );
      seti(cssa_height, p );
      break;
    case cssa_background_size:
      seti(cssa_background_width, p );
      seti(cssa_background_height, p );
      break;
    case cssa_text_indent: seti(cssa_text_indent, p ); break;
    case cssa_background_color:
      seti(cssa_background_color, p );
      break;
    case cssa_background:
      seti(cssa_background_position_top, p);
      seti(cssa_background_position_left, p);
      seti(cssa_background_position_right, p);
      seti(cssa_background_position_bottom, p);
      seti(cssa_background_gradient, p);
      seti(cssa_background_image, p);
      seti(cssa_background_color, p);
      break;
    case cssa_background_image:
      seti(cssa_background_image, p );
      break;
    case cssa_background_gradient:
      seti(cssa_background_gradient, p );
      break;
    case cssa_background_position:
      seti(cssa_background_position_top, p );
      seti(cssa_background_position_left, p );
      seti(cssa_background_position_right, p );
      seti(cssa_background_position_bottom, p );
      break;
    case cssa_background_position_top:
      seti(cssa_background_position_top, p );
      break;
    case cssa_background_position_left:
      seti(cssa_background_position_left, p );
      break;
    case cssa_background_position_right:
      seti(cssa_background_position_right, p );
      break;
    case cssa_background_position_bottom:
      seti(cssa_background_position_bottom, p );
      break;
    case cssa_background_offset:
      seti(cssa_background_offset_top, p);
      seti(cssa_background_offset_left, p);
      seti(cssa_background_offset_right, p);
      seti(cssa_background_offset_bottom, p);
      break;
    case cssa_background_offset_top:
      seti(cssa_background_offset_top, p );
      break;
    case cssa_background_offset_left:
      seti(cssa_background_offset_left, p );
      break;
    case cssa_background_offset_right:
      seti(cssa_background_offset_right, p );
      break;
    case cssa_background_offset_bottom:
      seti(cssa_background_offset_bottom, p );
      break;
    case cssa_background_frame_no:
      seti(cssa_background_frame_no, p );
      break;

      // foreground
    case cssa_foreground_image:
      seti(cssa_foreground_image, p );
      break;
    case cssa_foreground_color:
      seti(cssa_foreground_color, p );
      break;
    case cssa_foreground:
      seti(cssa_foreground_position_top, p);
      seti(cssa_foreground_position_left, p);
      seti(cssa_foreground_position_right, p);
      seti(cssa_foreground_position_bottom, p);
      seti(cssa_foreground_gradient, p);
      seti(cssa_foreground_image, p);
      seti(cssa_foreground_color, p);
      break;
    case cssa_foreground_gradient:
      seti(cssa_foreground_gradient, p );
      break;
    case cssa_foreground_position:
      seti(cssa_foreground_position_top, p);
      seti(cssa_foreground_position_left, p);
      seti(cssa_foreground_position_right, p);
      seti(cssa_foreground_position_bottom, p);
      break;
    case cssa_foreground_position_top:
      seti(cssa_foreground_position_top, p );
      break;
    case cssa_foreground_position_left:
      seti(cssa_foreground_position_left, p );
      break;
    case cssa_foreground_position_right:
      seti(cssa_foreground_position_right, p );
      break;
    case cssa_foreground_position_bottom:
      seti(cssa_foreground_position_bottom, p );
      break;
    case cssa_foreground_frame_no:
      seti(cssa_foreground_frame_no, p );
      break;
    case cssa_foreground_size:
      seti(cssa_foreground_width, p);
      seti(cssa_foreground_height, p);
      break;

      // foreground

      // case cssa_foreground_image_transformation:
      //      image_transformation(pcs->fore_image, a_values[0]);
      //  break;

    case cssa_border:
      seti(cssa_border_bottom_color, p );
      seti(cssa_border_bottom_width, p );
      seti(cssa_border_left_color, p );
      seti(cssa_border_left_width, p );
      seti(cssa_border_right_color, p );
      seti(cssa_border_right_width, p );
      seti(cssa_border_top_color, p );
      seti(cssa_border_top_width, p );
      break;

    case cssa_border_bottom:
      seti(cssa_border_bottom_color, p );
      seti(cssa_border_bottom_width, p );
      break;
    case cssa_border_bottom_color:
      seti(cssa_border_bottom_color, p );
      break;
    case cssa_border_bottom_width:
      seti(cssa_border_bottom_width, p );
      break;
    case cssa_border_color:
      seti(cssa_border_bottom_color, p );
      seti(cssa_border_left_color, p );
      seti(cssa_border_right_color, p );
      seti(cssa_border_top_color, p );
      break;

    case cssa_border_left:
      seti(cssa_border_left_color, p );
      seti(cssa_border_left_width, p );
      break;
    case cssa_border_left_color:
      seti(cssa_border_left_color, p );
      break;
    case cssa_border_left_width:
      seti(cssa_border_left_width, p );
      break;

    case cssa_border_right:
      seti(cssa_border_right_color, p );
      seti(cssa_border_right_width, p );
      break;
    case cssa_border_right_color:
      seti(cssa_border_right_color, p );
      break;
    case cssa_border_right_width:
      seti(cssa_border_right_width, p );
      break;

    case cssa_border_top:
      seti(cssa_border_top_color, p );
      seti(cssa_border_top_width, p );
      break;
    case cssa_border_top_color:
      seti(cssa_border_top_color, p );
      break;
    case cssa_border_top_width:
      seti(cssa_border_top_width, p );
      break;

    case cssa_border_width:
      seti(cssa_border_bottom_width, p );
      seti(cssa_border_left_width, p );
      seti(cssa_border_right_width, p );
      seti(cssa_border_top_width, p );
      break;

    case cssa_border_radius:
      seti(cssa_border_top_left_radius_x, p);
      seti(cssa_border_top_left_radius_y, p);
      seti(cssa_border_top_right_radius_x, p );
      seti(cssa_border_top_right_radius_y, p );
      seti(cssa_border_bottom_right_radius_x, p );
      seti(cssa_border_bottom_right_radius_y, p );
      seti(cssa_border_bottom_left_radius_x, p );
      seti(cssa_border_bottom_left_radius_y, p );
      break;

    case cssa_border_top_left_radius:
      seti(cssa_border_top_left_radius_x, p );
      seti(cssa_border_top_left_radius_y, p );
      break;
    case cssa_border_top_right_radius:
      seti(cssa_border_top_right_radius_x, p );
      seti(cssa_border_top_right_radius_y, p );
      break;
    case cssa_border_bottom_right_radius:
      seti(cssa_border_bottom_right_radius_x, p );
      seti(cssa_border_bottom_right_radius_y, p );
      break;
    case cssa_border_bottom_left_radius:
      seti(cssa_border_bottom_left_radius_x, p );
      seti(cssa_border_bottom_left_radius_y, p );
      break;

    case cssa_margin:
      seti(cssa_margin_bottom, p );
      seti(cssa_margin_left, p );
      seti(cssa_margin_right, p );
      seti(cssa_margin_top, p );
      break;
    case cssa_margin_bottom: seti(cssa_margin_bottom, p ); break;
    case cssa_margin_left: seti(cssa_margin_left, p ); break;
    case cssa_margin_right: seti(cssa_margin_right, p ); break;
    case cssa_margin_top: seti(cssa_margin_top, p ); break;
    case cssa_padding:
      seti(cssa_padding_bottom, p );
      seti(cssa_padding_left, p );
      seti(cssa_padding_right, p );
      seti(cssa_padding_top, p );
      break;

    case cssa_padding_bottom:
      seti(cssa_padding_bottom, p );
      break;
    case cssa_padding_left: seti(cssa_padding_left, p ); break;
    case cssa_padding_right: seti(cssa_padding_right, p ); break;
    case cssa_padding_top:
      seti(cssa_padding_top, p );
      break;
      // case cssa_list_style_image:
      break;
    case cssa_list_marker_color:
      seti(cssa_list_marker_color, p );
      break;
    case cssa_list_marker_size:
      seti(cssa_list_marker_size, p );
      break;

    case cssa_display:
      seti(cssa_display, p );
      break;

    case cssa_position:
      seti(cssa_position, p );
      break;

    // case cssa_flow:
    //   flow_value(pcs->flow, a_values);
    //   break;
    case cssa_visibility: seti(cssa_visibility, p ); break;
    case cssa_content:
      //??? seti(cssa_content, p );
      break;
    case cssa_outline_width: seti(cssa_outline_width, p ); break;
    case cssa_outline_offset:
      seti(cssa_outline_offset, p );
      break;
    case cssa_outline_color: seti(cssa_outline_color, p ); break;
    case cssa_outline:
      seti(cssa_outline_width, p );
      seti(cssa_outline_offset, p );
      seti(cssa_outline_color, p );
      seti(cssa_outline_style, p );
      break;
    case cssa_outline_shift:
      seti(cssa_outline_shift_x, p );
      seti(cssa_outline_shift_y, p );
      break;
    case cssa_outline_shift_x:
      seti(cssa_outline_shift_x, p );
      break;
    case cssa_outline_shift_y:
      seti(cssa_outline_shift_y, p );
      break;
    case cssa_outline_style: seti(cssa_outline_style, p ); break;

    case cssa_left: seti(cssa_left, p ); break;
    case cssa_right: seti(cssa_right, p ); break;
    case cssa_top: seti(cssa_top, p ); break;
    case cssa_bottom: seti(cssa_bottom, p ); break;
    case cssa_border_spacing:
      seti(cssa_border_spacing, p );
      break;
    case cssa_opacity: seti(cssa_opacity, p ); break;
    case cssa_transform: seti(cssa_transform, p ); break;
    case cssa_transform_origin:
      seti(cssa_transform_origin_x, p );
      seti(cssa_transform_origin_y, p );
      break;
    case cssa_box_shadow: seti(cssa_box_shadow, p ); break;
    case cssa_text_shadow: seti(cssa_text_shadow, p ); break;

    case cssa_fill:
    case cssa_fill_opacity:
    case cssa_stroke:
    case cssa_stroke_width:
    case cssa_stroke_dashoffset:
    case cssa_stroke_opacity: seti(p.prop_sym, p ); break;

    default: return false;
    }
#endif
    return true;
  }

  PAV_RESULT parse_attribute_value(document *pd, style_prop_map& sm, css_istream &s, cssa::name_or_symbol a_name, style_bag *sb);

  PAV_RESULT parse_attribute_value(document *pd, style_prop_map &sm, cssa::name_or_symbol a_name, const ustring &v) {
    string      url = pd->uri().src;
    css_istream in(v, url);
    return parse_attribute_value(pd, sm, in, a_name,nullptr);
  }

  // parse val text as is it is defined in CSS, used by SVG parser
  void parse_css_property_as(document *pd, cssa::name_or_symbol attr_sym, wchars val, style_prop_list *s) {
#ifdef DEBUG
    //if (val == WCHARS("none"))
    //  val = val;
#endif
    //if (val.length == 0) return;
    string       url = pd->uri().src;
    css_istream  in(val, url);
    array<value> a_values;
    bool         is_important = false;
    if(val.length == 0)
      s->set(attr_sym, value()); 
    else if (crack_attribute_value(pd, url, in, a_values, is_important))
      s->set(attr_sym, a_values()); //set_attribute_value(pd, s, attr_sym, a_values());
  }

  /*
  void element::parse_attribute_as(view &v, document *pd,
    cssa::symbol_t attr_sym, wchars val,
    style &s) {
    if (val.length == 0) return;
    string       url = pd->uri().src;
    css_istream  in(val, url);
    array<value> a_values;
    bool         is_important = false;
    if (crack_attribute_value(pd, url, in, a_values, is_important))
      set_attribute_value(pd, s, attr_sym, a_values());
  }*/


  handle<document> application::stock_styles_doc;

  style_bag &application::stock_styles() {
    critical_section _(html::lock);
    if (!stock_styles_doc) {
      app(); // app should exist at the moment
      std::pair<tool::bytes, tool::ustring> text_url =
          get_stock_style_resource();
      if (text_url.first.length) {
        ustring master_url = WCHARS("sciter:") + text_url.second;
        stock_styles_doc   = new document(master_url);
        stock_styles_doc->app =
            0; // ATTN: stock style doc does not hold the app

        stock_styles_doc->_media_vars_provider = &default_media_vars_provider;

        stock_styles_doc->_styles.is_master = true;

        ustring wdata = u8::cvt(text_url.first);

        style_parser stp(" ", wdata, stock_styles_doc, master_url /*, PLATFORM_MEDIA_TYPE*/);
        stp.parse(wchars());
      }
    }
    return stock_styles_doc->styles();
  }

  void application::final_release() {
    destroy_stock_styles();
    init_symbols(false);
    super::final_release();
  }

  void application::destroy_stock_styles() { stock_styles_doc = 0; }

  void application::set_stock_styles(chars text, bool append) {
    //const char *start = text.start;
    //const char *end   = text.end();
    if (append) {
      (void)stock_styles();
      assert(stock_styles_doc);
      ustring      wdata = u8::cvt(text);
      style_parser stp(" ", wdata, stock_styles_doc, "sciter:master.css");
      stp.parse(wchars());
    } else {
      document *pd          = new document("sciter:master.css");
      pd->_styles.is_master = true;

      ustring wdata = u8::cvt(text);

      style_parser stp(" ", wdata, pd, "sciter:master.css");
      stp.parse(wchars());
      // stt.reorder();

      stock_styles_doc = pd;
    }
  }

} // namespace html
