#include "html.h"

namespace html {

  uint get_char_multibyte(uint encoding, bytes &buf) {
#ifdef WINDOWS
    wchar uc[6];
    // if(_code_page)
    int sz  = min(buf.size(), 6);
    int len = MultiByteToWideChar(encoding, // code page
                                  0,        // character-type options
                                  (const char *)buf.start, // string to map
                                  sz, // number of bytes in string
                                  uc, // wide-character buffer
                                  6   // size of buffer
    );

    if (len == 0) { return buf++; }

    // wierd but should work
    int bytes_consumed = WideCharToMultiByte(encoding, // code page
                                             0, // performance and mapping flags
                                             uc, // wide-character string
                                             1,  // number of chars in string
                                             0,  // buffer for new string
                                             0,  // size of buffer
                                             0,  // default for unmappable chars
                                             0   // set when default char used
    );

    buf.prune(bytes_consumed);

    return uc[0];
#else
    // assert(false);
    return get_char_utf8(encoding, buf);
#endif
  }

  uint get_char_singlebyte(uint encoding, bytes &buf) {
#ifdef WINDOWS
    wchar uc = buf[0];
    MultiByteToWideChar(encoding, 0, (const char *)buf.start, 1, &uc, 1);
    buf.prune(1);
    return uc;
#else
    return buf++;
#endif
  }

  uint get_char_utf8(uint encoding, bytes &buf) { return u8::getc(buf); }

  uint get_char_utf16(uint encoding, bytes &buf) {
    wchars t;
    t.start    = (const wchar *)buf.start;
    t.length   = buf.length / sizeof(wchar);
    uint c     = u16::getc(t);
    buf.start  = (const byte *)t.start;
    buf.length = t.length * sizeof(wchar);
    return c;
  }

} // namespace html