#include "html.h"
#include "html-scrollbar.h"

namespace html {
  using namespace tool;
  using namespace gool;

  uint scrollbar::hit_test(point pos) const {
    rect rc = _place;
    int  c, t;
    if (_vertical) {
      c = pos.y - rc.top();
      t = rc.height();
    } else {
      c = pos.x - rc.left();
      t = rc.width();
    }
    if (c < _min_size) return MINUS;
    if (c < _slider_pos) return PAGE_MINUS;
    if (c < _slider_pos + _slider_size) return SLIDER;
    if (c < t - _max_size) return PAGE_PLUS;
    //if (_vertical && (c > rc.bottom())) return CORNER;
    return PLUS;
  }

  int scrollbar::minus_size(view &v, element *b,int dv) {
    if (!_style_minus) return dv;
    if (_style_minus->display.is_defined() && _style_minus->is_display_none())
      return 0;
    int val = _vertical ? pixels(v, b->doc(), _style_minus->height, -1).height()
                        : pixels(v, b->doc(), _style_minus->width, -1).width();
    if (val < 0) return dv;
    return val;
  }

  int scrollbar::plus_size(view &v, element *b, int dv) {
    if (!_style_plus) return dv;
    if (_style_plus->display.is_defined() && _style_plus->is_display_none())
      return 0;
    int val = _vertical ? pixels(v, b->doc(), _style_plus->height, -1).height()
                      : pixels(v, b->doc(), _style_plus->width, -1).width();
    if (val < 0) return dv;
    return val;
  }

  int scrollbar::slider_min_size(view &v, element *b, int dv) {
    if (!_style_slider) return dv;
    int val = _vertical ? pixels(v, b->doc(), _style_slider->min_height, -1).height()
                      : pixels(v, b->doc(), _style_slider->min_width, -1).width();
    if (val < 0) return dv;
    return val;
  }

  void scrollbar::do_layout(view &v, element *b) {
    // if(_layout_valid)
    //  return;
    //_layout_valid = true;

    update_styles(v, b);

    rect cr = client_place(); // cl(place().size());

    int tsize = _vertical ? cr.width() : cr.height();

    int csize = _vertical ? cr.height() : cr.width();

    _min_pos     = 0;
    _min_size    = minus_size(v,b,tsize);
    _slider_size = 0;
    _max_pos     = 0;
    _max_size    = plus_size(v, b, tsize);
    _slider_pos  = 0;

    int tsize2 = _min_size + _max_size;

    if (_max <= _min) return;

    if (csize < tsize2) {
      _slider_size = 0;
      _min_size    = csize / 2;
      _max_size    = csize - _min_size;
      return;
    }

    _max_pos = csize - tsize;

    // first scale slider
    _slider_size = (_page * (csize - tsize2)) / (_max - _min);
    _slider_size = max(_slider_size, slider_min_size(v, b, 4));

    if (_slider_size < tsize / 2) _slider_size = tsize / 2;

    if (_slider_size >= (csize - tsize2)) {
      _slider_pos  = tsize;
      _slider_size = 0;
      //_value = _min;
    } else
      _slider_pos = pos_by_val(v,b, position(), tsize, csize);

    // dbg_printf("do SB layout, %d\n", _slider_pos);
  }

  inline int rdiv(int64 a, int64 b) {
    if (!b) return 0;
    int64 r = a / b;
    if ((a % b) >= (b / 2)) return int(r) + 1;
    return int(
        limit<int64>(r, limits<int>::min_value(), limits<int>::max_value()));
  }

  int scrollbar::pos_by_val(view &v, element *b, int val, int button_size, int csize) {
    int minussz = minus_size(v, b, button_size);
    int plussz = plus_size(v, b, button_size);
    int rmax =
        csize - minussz - plussz - _slider_size;
    int r = rdiv(int64(rmax) * (int64(val) - int64(_min)),
                 int64(_max) - int64(_min) - int64(_page));
    // return min(r,rmax) + minus_size(button_size); - it can overflow (kinetic
    // scrolling)
    return r + minussz;
    // assert(r >= button_size);
  }

  int scrollbar::val_by_pos(view &v, element *b, int p, int button_size, int csize) {
    int minussz = minus_size(v, b, button_size);
    int plussz = plus_size(v, b, button_size);

    return limit(rdiv(int64(_max - _min + 1 - _page) * int64(p - minussz),
                      int64(csize) - minussz - plussz - _slider_size) + _min,
                 _min, _max);
  }

  int scrollbar::get_value() { return position(); }

  void scrollbar::set_value(view &v, element *el, int val,
                            bool allow_out_of_bounds) {

    if (!allow_out_of_bounds) 
      val = limit(val, _min, _max - _page);

    if (_inverse)
      val = _max - _page - val;

    if (val != _val.val(_min))
      _val = val;
  }

  void scrollbar::set_ranges(view &v, element *el, int min, int max, int page,
                             int step) {
    _min  = min;
    _max  = max;
    _page = page;
    _step = step;

    if (position() > _max + 1 - _page)
      set_value(v, el, _max + 1 - _page);
    if (position() < _min)
      set_value(v, el, _min);
    //_layout_valid = false;
  }

  int scrollbar::position() const {
    if (_inverse)
      return _max + 1 - _page -_val.val(0);
    else
      return _val.val(_min);
  }

  bool scrollbar::on(view &v, element *b, event_mouse &evt) {
    int  p;
    int  sz;
    rect cr = _place;

    handle<scrollbar> protect = this;

    rect hit_rc = cr;
    //if (_vertical)
    //  hit_rc.e.y = b->padding_box(v).e.y;

    if (!_tracking && !hit_rc.contains(evt.pos) /*&& !evt.is_dragging()*/) {
      if (_active_element) {
        _active_element = 0;
        refresh(v, b);
      }
      // if(!evt.is_dragging())
      return false;
    }

    if (!evt.target->belongs_to(b, true))
      return false;

    if (_vertical) {
      p  = evt.pos.y - cr.top();
      sz = cr.height();
    } else {
      p  = evt.pos.x - cr.left();
      sz = cr.width();
    }

    evt.cursor = cursor::system(cursor_default);

    switch (evt.cmd) {
#if 0
    case (EVENT_SINKING | MOUSE_WHEEL): {
      notify(v, b, SCROLL_POS, value() - int(evt.wheel_delta() * _page / 5));
      uint te = hit_test(evt.pos);
      if (_active_element != te) _active_element = te;
      refresh(v, b);
      // evt.cursor = 0;
    }
    return true;
#endif

      /*case DRAGGING | MOUSE_TICK: // while dragging this allows to scroll
        elements we are dragging over if( evt.is_point_button() && (_place &&
        evt.pos))
        {
           _active_element = hit_test(evt);
           if( _active_element == SLIDER )
             return false;
           goto DO_CLICK;
        }
        return false;*/


    case (EVENT_SINKING | MOUSE_TICK):
      if (!evt.is_point_button() || (hit_test(evt.pos) != _active_element) ||
          (_active_element == SLIDER))
        return true;
      // otherwise fall down
    case (EVENT_SINKING | MOUSE_DOWN) :
    case (EVENT_SINKING | MOUSE_DCLICK):
    case (EVENT_SINKING | MOUSE_TCLICK):
    {
      // DO_CLICK:
      if (!evt.is_point_button()) return false;
      if (evt.target != b) return false;

      if (evt.cmd == (EVENT_SINKING | MOUSE_DOWN)) v.set_capture_strict(b);

      if (evt.is_shift()) {
        p -= _slider_size / 2;
        goto SET_POS;
      }

      uint item = hit_test(evt.pos);
      if (!_tracking) {
        _active_element = item;
        _tracking = true;
      }
      refresh(v, b);
      if (item == SLIDER) {
        _tracking_offset = p - _slider_pos;
        notify(v, b, SCROLL_SLIDER_PRESSED, position(), _active_element);
        //_style_slider = 0;
      } else if (item == MINUS) {
        //_style_minus = 0;
        notify(v, b, SCROLL_STEP_MINUS, position() - _step, _active_element);
      } else if (item == PAGE_MINUS) {
        //_style_page_minus = 0;
        notify(v, b, SCROLL_PAGE_MINUS, position() - _page, _active_element);
      } else if (item == PLUS) {
        //_style_plus = 0;
        notify(v, b, SCROLL_STEP_PLUS, position() + _step, _active_element);
      } else if (item == PAGE_PLUS) {
        //_style_page_plus = 0;
        notify(v, b, SCROLL_PAGE_PLUS, position() + _page, _active_element);
      } else if (item == CORNER) {
        notify(v, b, SCROLL_CORNER_PRESSED, 0, _active_element);
      }

      //_state.active = 1;
      //_layout_valid = false;

      // evt.cursor = 0;
    }
      return true;

    case (EVENT_SINKING | MOUSE_UP): {
      v.set_capture(0);
      if (!_tracking)
         _active_element = hit_test(evt.pos);
      if (_active_element == SLIDER && _tracking && evt.is_point_button())
        notify(v, b, SCROLL_SLIDER_RELEASED, position(), _active_element);
      else if (_active_element == CORNER && _tracking && evt.is_point_button())
        notify(v, b, SCROLL_CORNER_RELEASED, 0, _active_element);
      _tracking = false;
      refresh(v, b);
      // evt.cursor = 0;
    }
      return true;
    case (EVENT_SINKING | MOUSE_MOVE ):

      if (evt.target != b)
        return false;

      if (_active_element == SLIDER && _tracking && evt.is_point_button()) {
      SET_POS:
        _slider_pos = p - _tracking_offset;

        int tsize = _vertical ? cr.width() : cr.height();
        int csize = _vertical ? cr.height() : cr.width();

        int msize = minus_size(v,b,tsize);
        int psize = plus_size(v, b,tsize);

        if (_slider_pos < msize) _slider_pos = msize;
        if (_slider_pos > sz - psize - _slider_size)
          _slider_pos = sz - psize - _slider_size;

        int val = val_by_pos(v, b, _slider_pos, tsize, csize);

        refresh(v, b);
        notify(v, b, SCROLL_POS, val, _active_element);

        // evt.cursor = cursor::system(cursor_default);
        return true;
      } else if (!evt.is_point_button()) {
        uint te = hit_test(evt.pos);
        if (_active_element != te) {
          _active_element = te;
          refresh(v, b);
        }
      }
      // evt.cursor_type = 0;
      return true;
    case MOUSE_LEAVE:
      if (!evt.is_point_button()) {
        _active_element = 0;
        refresh(v, b);
      }
      break;
    case MOUSE_CHECK:
      // evt.cursor = 0;
      return true;
    case MOUSE_IDLE:
      // evt.cursor = 0;
      break;
    }
    return false;
  }

  void scrollbar::notify(view &v, element *b, int cmd, int val, uint part) {
    val = limit(val, _min, _max - _page);
    event_scroll evt(b, cmd, _vertical, val, SCROLL_SOURCE_SCROLLBAR, part);
    if (b->on(v, evt)) {
      return;
    }
    /*else if(b->owner)
    {
      view::traverser<event_scroll> trv(v);
      if(!trv.traverse(b->owner, evt))
        set_value(val);
      refresh(v, b);
    }*/
  }

  scrollbar::state scrollbar::element_state(uint element) {
    if (!enabled() && element != CORNER) return DISABLED;
    if (_active_element == element) return _tracking ? PRESSED : HOVER;
    return NORMAL;
  }

  ui_state scrollbar::part_state(uint element) {
    ui_state st;
    if (!enabled() && element != CORNER)
      st.disabled(true);
    else {
      if (_active_element == element) {
        st.hover(true);
        if (_tracking) st.active(true);
      }
    }
    return st;
  }

  void scrollbar::clear_styling() {
    _style_base =
    _style_plus =
    _style_minus =
    _style_page_plus =
    _style_page_minus =
    _style_slider =
    _style_corner = nullptr;
    _style_set_name.clear();
  }

  void scrollbar::update_styles(view &v, element *b) {
    static ustring cn_base      = WCHARS("base");
    static ustring cn_prev      = WCHARS("prev");
    static ustring cn_next      = WCHARS("next");
    static ustring cn_prev_page = WCHARS("prev-page");
    static ustring cn_next_page = WCHARS("next-page");
    static ustring cn_slider    = WCHARS("slider");
    static ustring cn_corner    = WCHARS("corner");

    string set_name;

    hstyle bs = b->get_style(v);
    if (is_vertical()) {
      set_name = bs->vscrollbar;
#ifndef THEMES_SUPPORT
      static string sn = "std-v-scrollbar";
      if (set_name.is_undefined())
        set_name = sn;
#endif
    } else {
      set_name = bs->hscrollbar;
#ifndef THEMES_SUPPORT
      static string sn = "std-h-scrollbar";
      if (set_name.is_undefined())
        set_name = sn;
#endif
    }

    if (set_name.length() != 0) {
      document *doc = b->doc();
      if (doc) {
        style_bag *sbag = doc->get_named_style_set(set_name);
        if (sbag) {
          if (set_name != _style_set_name || enabled() != _style_enabled ||
              _style_tracking != _tracking ||
              _style_active_element != _active_element) {
            _style_tracking       = _tracking;
            _style_active_element = _active_element;
            _style_enabled        = enabled();
            _style_set_name       = set_name;

            //style s0, s1, s2, s3, s4, s5, s6;
            if (hstyle hs = sbag->style_for(cn_base, part_state(BASE), b)) {
              _style_base = hs;
              _style_base->fetch_images(v, doc);
            }
            if (hstyle hs = sbag->style_for(cn_prev, part_state(MINUS), b)) {
              _style_minus = hs;
              _style_minus->fetch_images(v, doc);
            }
            if (hstyle hs = sbag->style_for(cn_prev_page, part_state(PAGE_MINUS), b)) {
              _style_page_minus = hs;
              _style_page_minus->fetch_images(v, doc);
            }
            if (hstyle hs = sbag->style_for(cn_slider, part_state(SLIDER), b)) {
              _style_slider = hs;
              _style_slider->fetch_images(v, doc);
            }
            if (hstyle hs = sbag->style_for(cn_next_page, part_state(PAGE_PLUS), b)) {
              _style_page_plus = hs;
              _style_page_plus->fetch_images(v, doc);
            }
            if (hstyle hs = sbag->style_for(cn_next, part_state(PLUS), b)) {
              _style_plus = hs;
              _style_plus->fetch_images(v, doc);
            }
            if (hstyle hs = sbag->style_for(cn_corner, part_state(CORNER), b)) {
              _style_corner = hs;
              _style_corner->fetch_images(v, doc);
            }
          }
        }
      }
    } else // no custom styles were defined
    {
    }
  }

  void scrollbar::refresh(view &v, element *b) {
    update_styles(v, b);
    rect hit_rc = _place;
    if (_vertical) hit_rc.e.y = b->dim().y;
    v.refresh(b, hit_rc);
  }

  void scrollbar::draw(view &v, graphics *sf, element *b, const rect &crc,
                       const rect &corner_rc) {
    // do_layout(v, b);

    // handle<dib32> pdib;
    graphics *psf = sf;

    if (_vertical) {
      int tsize = crc.width();
      // int tsize1 = crc.width();
      rect minrc(point(crc.left(), crc.top() + _min_pos),
                 size(tsize, _min_size));
      if (_style_minus)
        _style_minus->draw_shape(v, psf, minrc, b);
#ifdef THEMES_SUPPORT
      else if(theme::current())
        theme::current()->draw_v_scrollbar(psf, MINUS, element_state(MINUS), minrc);
#endif

      if (_slider_size > 0 && enabled()) {
        rect slider_area = crc;
        slider_area.s.y += _min_size;
        slider_area.e.y -= _max_size;

        // minus base =========================================
        rect minbase(point(crc.left(), crc.top() + _min_size),
                     size(tsize, _slider_pos - _min_size));

        minbase &= slider_area;

        if (!minbase.empty()) {
          if (_style_page_minus)
            _style_page_minus->draw_shape(v, psf, minbase, b);
#ifdef THEMES_SUPPORT
          else if(theme::current())
            theme::current()->draw_v_scrollbar(
                psf, PAGE_MINUS, element_state(PAGE_MINUS), minbase);
#endif

        }

        // slider =============================================
        rect sliderrc(point(crc.left(), crc.top() + _slider_pos),
                      size(tsize, _slider_size));

        sliderrc &= slider_area;

        if (!sliderrc.empty()) {
          if (_style_slider)
            _style_slider->draw_shape(v, psf, sliderrc, b);
#ifdef THEMES_SUPPORT
          else if(theme::current())
            theme::current()->draw_v_scrollbar(psf, SLIDER, element_state(SLIDER), sliderrc);
#endif
        }

        // plus base ==========================================
        rect plusbase(point(crc.left(), crc.top() + _slider_pos + _slider_size),
                      size(tsize, crc.height() - (_slider_pos + _slider_size) -
                                      _max_size));

        plusbase &= slider_area;

        if (!plusbase.empty()) {
          if (_style_page_plus)
            _style_page_plus->draw_shape(v, psf, plusbase, b);
#ifdef THEMES_SUPPORT
          else if (theme::current())
            theme::current()->draw_v_scrollbar(
                psf, PAGE_PLUS, element_state(PAGE_PLUS), plusbase);
#endif
        }
      } else {
        rect base(point(crc.left(), crc.top() + _min_size),
                  size(tsize, crc.height() - _max_size - _min_size));
        if (_style_base)
          _style_base->draw_shape(v, psf, base, b);
#ifdef THEMES_SUPPORT
        else if (theme::current())
          theme::current()->draw_v_scrollbar(psf, BASE, DISABLED, base);
#endif
      }

      // plus button ========================================
      rect plusrc(point(crc.left(), crc.bottom() - _max_size), size(tsize, _max_size));

      if (_style_plus)
        _style_plus->draw_shape(v, psf, plusrc, b);
#ifdef THEMES_SUPPORT
      else if (theme::current())
        theme::current()->draw_v_scrollbar(psf, PLUS, element_state(PLUS),
                                           plusrc);
#endif

      if (!corner_rc.empty()) {
        if (_style_corner)
          _style_corner->draw_shape(v, psf, corner_rc, b);
#ifdef THEMES_SUPPORT
        else if (theme::current())
          theme::current()->draw_v_scrollbar(psf, CORNER, element_state(CORNER),
                                             corner_rc);
#endif
      }
    } else // horizontal
    {
      int tsize = crc.height();
      // int tsize1 = crc.height();

      // draw minus button ==================================
      rect minrc(point(crc.left() + _min_pos, crc.top()),
                 size(_min_size, tsize));
      if (_style_minus)
        _style_minus->draw_shape(v, psf, minrc, b);
#ifdef THEMES_SUPPORT
      else if (theme::current())
        theme::current()->draw_h_scrollbar(psf, MINUS, element_state(MINUS),
                                           minrc);
#endif

      if (_slider_size > 0 && enabled()) {
        rect slider_area = crc;
        slider_area.s.x += _min_size;
        slider_area.e.x -= _max_size;

        // minus base =========================================
        rect minbase(point(crc.left() + _min_size, crc.top()),
                     size(_slider_pos - _min_size, tsize));

        minbase &= slider_area;

        if (!minbase.empty()) {
          if (_style_page_minus)
            _style_page_minus->draw_shape(v, psf, minbase, b);
#ifdef THEMES_SUPPORT
          else if (theme::current())
            theme::current()->draw_h_scrollbar(
                psf, PAGE_MINUS, element_state(PAGE_MINUS), minbase);
#endif
        }

        // slider =============================================
        rect sliderrc(point(crc.left() + _slider_pos, crc.top()),
                      size(_slider_size, tsize));

        sliderrc &= slider_area;

        if (!sliderrc.empty()) {
          if (_style_slider)
            _style_slider->draw_shape(v, psf, sliderrc, b);
#ifdef THEMES_SUPPORT
          else if (theme::current())
            theme::current()->draw_h_scrollbar(psf, SLIDER,
                                               element_state(SLIDER), sliderrc);
#endif
        }

        // plus base ==========================================
        rect plusbase(
            point(crc.left() + _slider_pos + _slider_size, crc.top()),
            size(crc.width() - (_slider_pos + _slider_size) - _max_size,
                 tsize));

        plusbase &= slider_area;

        if (!plusbase.empty()) {
          if (_style_page_plus)
            _style_page_plus->draw_shape(v, psf, plusbase, b);
#ifdef THEMES_SUPPORT
          else if (theme::current())
            theme::current()->draw_h_scrollbar(
                psf, PAGE_PLUS, element_state(PAGE_PLUS), plusbase);
#endif
        }
      } else {
        rect base(point(crc.left() + _min_size, crc.top()),
                  size(crc.width() - _max_size - _min_size, tsize));
        if (_style_base)
          _style_base->draw_shape(v, psf, base, b);
#ifdef THEMES_SUPPORT
        else if (theme::current())
          theme::current()->draw_h_scrollbar(psf, BASE, DISABLED, base);
#endif
      }

      // plus button ========================================
      rect plusrc(point(crc.right() - _max_size, crc.top()),size(_max_size, tsize));
      if (_style_plus)
        _style_plus->draw_shape(v, psf, plusrc, b);
#ifdef THEMES_SUPPORT
      else if (theme::current())
        theme::current()->draw_h_scrollbar(psf, PLUS, element_state(PLUS),
                                           plusrc);
#endif
    }

    /*if( pdib )
    {
      delete psf;
      pdib->render(sf,crc.s);
    }*/
  }

  int scrollbar::defined_width(view &v, element *b) {
    // if(!_layout_valid)
    update_styles(v, b);

    int dv = v.get_window_metrics(value::$scrollbar_width);

    if (_style_base) //dv = _style_base->width.pixels(dv);
                     dv = pixels(v, b->doc(), _style_base->width, dv).width();

    return dv;
  }

  int scrollbar::defined_height(view &v, element *b) {
    // if(!_layout_valid)
    update_styles(v, b);

    int dv = v.get_window_metrics(value::$scrollbar_height);

    if (_style_base) //dv = _style_base->height.pixels(dv);
                     dv = pixels(v, b->doc(), _style_base->height, dv).height();

    return dv;
  }

  void scrollbars::refresh(view &v, element *b) {
    if (vsb()) _vsb->refresh(v, const_cast<element *>(b));
    if (hsb()) _hsb->refresh(v, const_cast<element *>(b));
  }

  int scrollbars::v_width(view &v, element *b) {
    return vsb() ? _vsb->defined_width(v, b) : 0;
  }
  int scrollbars::h_height(view &v, element *b) {
    return hsb() ? _hsb->defined_height(v, b) : 0;
  }

  inline bool is_scrollable_y_tbody(const element *b) {
    return b->is_of_type<block_table_body>() &&
           b->c_style->overflow_y >= overflow_scroll && b->parent &&
           b->parent->c_style->overflow_x >= overflow_scroll;
  }

  bool scrollbars::set_v(view &v, element *b, range rval, int page, SB_MODE mode) {
    bool r = false;
    //rval.e += 1;

    if (mode == SBM_PER_CSS)
      switch (b->get_style(v)->overflow_y.val()) {
        case overflow_auto: mode = SBM_OPTIONAL; break;
        case overflow_scroll: mode = SBM_ALWAYS; break;
        case overflow_scroll_indicator: mode = SBM_INDICATOR; break;
      }

    if (mode == SBM_ALWAYS || need_to_show(rval.s, rval.e, page)) {
      if (!_vsb) {
#ifdef SCROLL_INDICATOR_ONLY
        _vsb = new scrollbar_indicator(true, b->c_style->get_block_vertical_align() == valign_bottom);
        r = false;
#else
        if (mode == SBM_INDICATOR) {
          _vsb = new scrollbar_indicator(true, b->c_style->get_block_vertical_align() == valign_bottom);
          r = false;
        }
        else {
          _vsb = new scrollbar(true, b->c_style->get_block_vertical_align() == valign_bottom);
          r = true;
        }
#endif
      }
      page = min(rval.e, page);
      int step = max(10, page / 12);
      if (step > page) step = page;
      _vsb->set_ranges(v, b, rval.s, rval.e, page, step);
      layout_valid = false;
    }
    else {
      if (vsb()) {
        _vsb = nullptr;
        r = true;
        layout_valid = false;
      }
      pos.y = rval.s;
    }
#ifdef SCROLL_INDICATOR_ONLY
    r = r;
    return false;
#else
    return r;
#endif
  }

  bool scrollbars::set_v(view &v, element *b, range rval, int page, int pos, SB_MODE mode) {
    set_v(v, b, rval, page, mode);
    if (_vsb) {
      _vsb->set_value(v, b, pos, true);
      return true;
    }
    return false;
  }

  bool scrollbars::set_h(view &v, element *b, range rval, int page, SB_MODE mode) {
    bool r = false;
    //rval.h += 1;

    if (mode == SBM_PER_CSS)
      switch (b->get_style(v)->overflow_x.val()) {
        case overflow_auto: mode = SBM_OPTIONAL; break;
        case overflow_scroll: mode = SBM_ALWAYS; break;
        case overflow_scroll_indicator: mode = SBM_INDICATOR; break;
      }


    if (mode == SBM_ALWAYS || need_to_show(rval.s, rval.e, page)) {
      if (!_hsb) {
#ifdef SCROLL_INDICATOR_ONLY
        _hsb = new scrollbar_indicator(false, b->c_style->get_horizontal_align() == align_right);
        r = false;
#else
        if (mode == SBM_INDICATOR) {
          _hsb = new scrollbar_indicator(false, b->c_style->get_horizontal_align() == align_right);
          r = false;
        }
        else {
          _hsb = new scrollbar(false, b->c_style->get_horizontal_align() == align_right);
          r = true;
        }
#endif
      }
      int step = max(10, page / 12);
      if (step > page) step = page;
      _hsb->set_ranges(v, b, rval.s, rval.e, page, step);
      layout_valid = false;
    }
    else {
      if (hsb()) {
        _hsb = nullptr;
        layout_valid = false;
        r = true;
      }
      pos.x = rval.s;
    }
#ifdef SCROLL_INDICATOR_ONLY
    r = r;
    return false;
#else
    return r;
#endif
  }

  bool scrollbars::set_h(view &v, element *b, range rval, int page, int pos, SB_MODE mode) {
    set_h(v, b, rval, page, mode);
    if (_hsb) {
      _hsb->set_value(v, b, pos, true);
      return true;
    }
    return false;
  }


  void scrollbars::replace(view &v, element *b) {
    // if(layout_valid) !!! commented, otherwise client_rect returns wrong value
    //  return;

    layout_valid = true;

    rect ca(b->dim());
    //ca >>= b->padding_distance(v);
    ca >>= b->ldata->padding_width;
    ca <<= b->ldata->inner_border_width;
    rect oca = ca;

    if (b->get_style(v)->direction != direction_rtl) {
      if (vsb()) ca.e.x -= _vsb->defined_width(v, b);
      if (hsb()) ca.e.y -= _hsb->defined_height(v, b);
      rect r;
      if (vsb()) {
        if (is_scrollable_y_tbody(b)) {
          point psp = b->parent->scroll_pos();
          rect  pca(b->parent->dim());
          r.s.x = pca.e.x + psp.x - _vsb->defined_width(v, b);
          r.e.x = pca.width() + psp.x;
        } else {
          r.s.x = ca.e.x;
          r.e.x = oca.e.x;
        }

        r.s.y = oca.s.y;
        r.e.y = ca.e.y;

        _vsb->place(r);
        _vsb->do_layout(v, b);
      }
      else if (evsb()) {
        _vsb->do_layout(v, b);
      }

      if (hsb()) {
        r.s.x = oca.s.x;
        r.e.x = ca.e.x;
        r.s.y = ca.e.y;
        r.e.y = oca.e.y;
        _hsb->place(r);
        _hsb->do_layout(v, b);
      } else if(ehsb())
        _hsb->do_layout(v, b);

    } else // rtl
    {
      if (vsb()) ca.s.x += _vsb->defined_width(v, b);
      if (hsb()) ca.e.y -= _hsb->defined_height(v, b);
      rect r;
      if (vsb()) {
        if (is_scrollable_y_tbody(b)) {
          point psp = b->parent->scroll_pos();
          rect  pca(b->parent->dim());
          r.s.x = psp.x;
          r.e.x = r.s.x + _vsb->defined_width(v, b);
        } else {
          r.s.x = oca.s.x;
          r.e.x = ca.s.x;
        }
        r.s.y = oca.s.y;
        r.e.y = ca.e.y;
        _vsb->place(r);
        _vsb->do_layout(v, b);
      }
      else if (evsb()) {
        _vsb->do_layout(v, b);
      }

      if (hsb()) {
        r.s.x = ca.s.x;
        r.e.x = oca.e.x;
        r.s.y = ca.e.y;
        r.e.y = oca.e.y;
        _hsb->place(r);
        _hsb->do_layout(v, b);
      }
      else if (ehsb()) {
        _hsb->do_layout(v, b);
      }

    }
  }

  rect scrollbars::client_rect(view &v, element *b) const {
    rect r(b->dim());

    auto cs = b->get_style(v);

    if (!vsb() && !hsb()) return r;

    const_cast<scrollbars *>(this)->replace(v, b);

    if (cs->direction != direction_rtl) {
      if (_vsb && _vsb->takes_space()) r.e.x = _vsb->place().s.x;
    } else // rtl
    {
      if (_vsb && _vsb->takes_space()) r.s.x = _vsb->place().e.x;
    }

    if (_hsb && _hsb->takes_space()) r.e.y = _hsb->place().s.y;

    return r;
  }

  void scrollbars::draw(view &v, graphics *sf, element *b, gool::point p,
                        bool horz, bool vert) {
    if (!layout_valid) replace(v, b);

    if (vert && vsb()) {

      rect r = _vsb->place();
      rect corner_r;
      if (hsb()) {
        corner_r = rect(r.x(), _hsb->place().y());
        corner_r += p;
      }

      r += p;

      if (r.width() > b->dim().x) {
        if (_vsb->_inverse)
          r.e.x = r.s.x + b->dim().x;
        else
          r.s.x = r.e.x - b->dim().x;
      }
      if (!r.empty()) _vsb->draw(v, sf, b, r, corner_r);
    }
    if (horz && hsb()) {
      rect r = _hsb->place() + p;
      if (r.height() > b->dim().y) {
        if (_hsb->_inverse)
          r.e.y = r.s.y + b->dim().y;
        else
          r.s.y = r.e.y - b->dim().y;
      }
      if (!r.empty()) _hsb->draw(v, sf, b, r);
    }
  }

  bool scrollbars::on(view &v, element *b, event_mouse &evt) {
    if (evt.cmd == (EVENT_SINKING | MOUSE_ENTER)) {
      if (vsb()) _vsb->on_mouse_enters_element(v, b);
      if (hsb()) _hsb->on_mouse_enters_element(v, b);
    } else if (evt.cmd == (MOUSE_LEAVE | EVENT_SINKING)) {
      if (vsb()) _vsb->on_mouse_leaves_element(v, b);
      if (hsb()) _hsb->on_mouse_leaves_element(v, b);
    }
    return (vsb() && _vsb->on(v, b, evt)) || (hsb() && _hsb->on(v, b, evt));
  }

  point scrollbars::scroll_pos(const element *b) const {
    return point(_hsb && !b->flags.virtual_h_scrollbar ? _hsb->position() : pos.x,
      _vsb && !b->flags.virtual_v_scrollbar ? _vsb->position() : pos.y);
  }

  void scrollbars::scroll_pos(view &v, element *b, point pt,
                              bool allow_out_of_bounds) {
    scroll_data sd;
    if (b->get_scroll_data(v, sd)) {
      if (_hsb && !b->flags.virtual_h_scrollbar) {
        _hsb->set_value(v, b, pt.x, allow_out_of_bounds);
        pos.x = sd.content_outline.left();
      } else
        pos.x = allow_out_of_bounds
                    ? pt.x
                    : limit(pt.x, sd.content_outline.left(),
                            sd.content_outline.right() - sd.dim_view.x + 1);
      if (_vsb && !b->flags.virtual_v_scrollbar) {
        _vsb->set_value(v, b, pt.y, allow_out_of_bounds);
        pos.y = sd.content_outline.top();
      } else
        pos.y = allow_out_of_bounds
                    ? pt.y
                    : limit(pt.y, sd.content_outline.top(),
                            sd.content_outline.bottom() - sd.dim_view.y + 1);
      layout_valid = false;
    }
  }

  const int PROGRESS_STEPS = 10;
  //const size isb_dim(16);
  const size isb_compact_dim(7);
  const uint isb_light_opacity = 64;
  const uint isb_dark_opacity = 128;

  int scrollbar_indicator::progress(int min, int max) {
    int total = max - min + 1;
    return (mode_progress * total) / PROGRESS_STEPS + min;
  }

  void scrollbar_indicator::refresh(view &v, element *b) {
    // scrollbar::refresh(v, b)
    // update_styles(v,b);
    v.refresh(b);
  }

  void scrollbar_indicator::do_layout(view &v, element *b) {
    update_styles(v, b);
    rect cr = client_place(); // cl(place().size());

    int tsize = _vertical ? cr.width() : cr.height();
    int csize = _vertical ? cr.height() : cr.width();

    _min_pos     = 0;
    _min_size    = 0;
    _slider_size = 0;
    _max_pos     = 0;
    _max_size    = 0;
    _slider_pos  = 0;

    int tsize2 = _min_size + _max_size;

    if (_max <= _min) return;

    if (csize < tsize2) {
      _slider_size = 0;
      _min_size    = csize / 2;
      _max_size    = csize - _min_size;
      return;
    }

    _max_pos = csize - tsize;

    // first scale slider
    _slider_size = (_page * (csize - tsize2)) / (_max - _min);
    _slider_size = max(_slider_size, tsize);

    if (_slider_size < tsize / 2) _slider_size = tsize / 2;

    if (_slider_size > (csize - tsize2)) {
      _slider_pos  = tsize;
      _slider_size = 0;
      //_value = _min;
    } else
      _slider_pos = pos_by_val(v, b, position(), 0, csize);

  }

  static argb get_background_color(view &v, element *el) {
    if (!el) return argb(255, 255, 255);
    style *cs = el->get_style(v);
    if (cs->back_color.is_defined()) return cs->back_color.to_argb();
    return get_background_color(v, el->parent);
  }

  static argb get_indicator_color(view &v, element *el) {
    argb c = get_background_color(v, el);
    if (c.luminance() < 128)
      return argb(255, 255, 255);
    else
      return argb(0, 0, 0);
  }



  void scrollbar_indicator::draw(view &v, graphics *psf, element *b,
                                 const rect &crc, const rect &corner_rc) {
    //uint opacity = calc_opacity(v, b);
    if (_slider_size <= 0) return;

    if (mode_progress == 0 && !b->state.hover())
      return;

    rect sliderrc;
    int  tsize;
    int  radius = 0;

    rect slider_area = crc;

    size compact_size = v.pixels_per_dip(isb_compact_dim);

    if (_vertical) {
      tsize    = crc.width();
      sliderrc = rect(point(crc.left(), crc.top() + _slider_pos), size(tsize, _slider_size));
      if (!_style_slider)
      {
        if (b->get_style(v)->direction == direction_rtl)
          sliderrc.e.x = sliderrc.s.x + progress(compact_size.x, sliderrc.width());
        else
          sliderrc.s.x = sliderrc.e.x - progress(compact_size.x, sliderrc.width());
        radius = compact_size.x / 2;
      }
    }
    else // horizontal
    {
      tsize    = crc.height();
      sliderrc = rect(point(crc.left() + _slider_pos, crc.top()),
                      size(_slider_size, tsize));
      if (!_style_slider)
      {
        sliderrc.s.y = sliderrc.e.y - progress(compact_size.y, sliderrc.height());
        radius = compact_size.y / 2;
      }
    }

    sliderrc &= slider_area;

    if (_style_slider) {
      rect margins;
      margins.s.x = pixels(v, b, _style_slider->margin[0],crc.size()).width();
      margins.e.x = pixels(v, b, _style_slider->margin[2], crc.size()).width();
      margins.s.y = pixels(v, b, _style_slider->margin[1], crc.size()).height();
      margins.e.y = pixels(v, b, _style_slider->margin[3], crc.size()).height();

      sliderrc <<= margins;

      //if (opacity == 255)
      _style_slider->draw_shape(v, psf, sliderrc, b);
      //else {
      //  gool::layer _(psf, sliderrc, byte(opacity));
      //  _style_slider->draw_shape(v, psf, sliderrc, b);
      //}
    } else {
      sliderrc <<= 1;//v.pixels_per_dip(1);
      argb c = get_indicator_color(v, b);

      uint isb_opacity;
      uint isb_hover_opacity;

      if (c.luminance() > 128) {
        isb_opacity = isb_dark_opacity;
        isb_hover_opacity = 248;
      }
      else {
        isb_opacity = isb_light_opacity;
        isb_hover_opacity = 128;
      }

      c.alfa = (argb::channel_t)progress(0, isb_opacity / 3);
      psf->fill(c, crc);
      if (_active_element == SLIDER)
        //c = get_current_system_color(SC_ACCENT);
        c.alfa = byte(isb_hover_opacity);
      else
        c.alfa = byte(isb_opacity);
      //c.morph(c,v.)
#if defined(OSX)
      psf->fill(c, sliderrc, radius ? size(radius - 1) : size(tsize / 2 - 1));
#else
      psf->fill(c, sliderrc);
#endif
    }
  }

  bool scrollbar_indicator::on(view &v, element *b, event_mouse &evt)
  {
    bool r = super::on(v, b, evt);
    if (_active_element && (evt.cmd == (MOUSE_MOVE | EVENT_SINKING))) {
      request_expansion(v, b);
    }
    if (!_active_element && (evt.cmd == (MOUSE_IDLE | EVENT_SINKING))) {
      if (mode_progress != 0)
        start_collapse(v, b);
    }
    return r;
  }

  int scrollbar_indicator::defined_width(view &v, element *b) {
    update_styles(v, b);
    //int dv = v.pixels_per_dip(isb_dim).x;
    int dv = v.get_window_metrics(value::$scrollbar_width);
    if (_style_base)
      dv = _style_base->width.pixels(dv);
    return dv;
  }

  int scrollbar_indicator::defined_height(view &v, element *b) {
    update_styles(v, b);
    //int dv = v.pixels_per_dip(isb_dim).y;
    int dv = v.get_window_metrics(value::$scrollbar_height);
    if (_style_base)
      dv = _style_base->height.pixels(dv);
    return dv;
    //return v.pixels_per_dip(isb_dim).y;
  }

  void scrollbar_indicator::set_value(view &v, element *el, int val, bool allow_out_of_bounds) {
    scrollbar::set_value(v, el, val, allow_out_of_bounds);
    //start_dissolve(v, el);
  }

  bool scrollbar_indicator::on_timer_tick(view &v, element *el, timer_id id) {
    if (id == SCROLLBAR_TIMER_ID)
    {
      if (mode_progress <= 0 || mode_progress >= PROGRESS_STEPS) {
        mode_progressing = 0;
        refresh(v, el);
        return false;
      }
      mode_progress += mode_progressing;
      refresh(v, el);
      return true;
    }
    else if (id == SCROLLBAR_EXPANSION_TIMER_ID) {
      if (mode_progress == 0 && _active_element)
        start_expansion(v, el);
      return false;
    }
    else if (id == SCROLLBAR_INACTIVE_TIMER_ID && mode_progress > 0)
    {
      mode_progress = PROGRESS_STEPS - 1;
      mode_progressing = -1;
      v.start_timer(el, SCROLLBAR_TIMER_MS, SCROLLBAR_TIMER_ID, INTERNAL_TIMER);
      refresh(v, el);
    }
    //opacity -= 8;
    return false;
  }

  void scrollbar_indicator::on_mouse_enters_element(view &v, element *b) {
    hover = true;
    refresh(v, b);
  }

  void scrollbar_indicator::on_mouse_leaves_element(view &v, element *b) {
    hover = false;
    if (!_tracking) {
      start_collapse(v, b);
      refresh(v, b);
    }
  }

  void scrollbar_indicator::request_expansion(view &v, element *el) {
    v.start_timer(el, SCROLLBAR_EXPANSION_TIMER_MS, SCROLLBAR_EXPANSION_TIMER_ID, INTERNAL_TIMER);
    //mode_progress = 1;
    //mode_progressing = +1;
    //refresh(v, el);
  }

  void scrollbar_indicator::start_expansion(view &v, element *el) {
    v.start_timer(el, SCROLLBAR_TIMER_MS, SCROLLBAR_TIMER_ID, INTERNAL_TIMER);
    mode_progress = 1;
    mode_progressing = +1;
    refresh(v, el);
  }

  void scrollbar_indicator::start_collapse(view &v, element *el) {
    if(mode_progress)
      v.start_timer(el, SCROLLBAR_INACTIVE_TIMER_MS, SCROLLBAR_INACTIVE_TIMER_ID, INTERNAL_TIMER);
  }


} // namespace html
