#include "html.h"

namespace html {

  element *find_first(view &v, element *root, wchars selector,
                      bool only_visible, bool deep) {
    if (root == 0 || selector.length == 0) return 0;

    assert(selector[0] != '<');

    /*while( root && selector[0] == '<' )
    {
      ++selector;
      root = root->parent;
    }*/
    if (selector.length == 0) return const_cast<element *>(root);

    selector_context     selctx(root, selector, only_visible, deep);
    element_iterator_ctx it(v, root, selctx);
    element *            bf = nullptr;
    if (it(bf)) return bf;
    return nullptr;
  }
  void find_all(view &v, array<helement> &r, element *root, wchars selector,
                bool only_visible) {
    selector_context     selctx(root, selector, only_visible);
    element_iterator_ctx it(v, root, selctx);
    for (element *bf; it(bf);)
      r.push(bf);
  }

  void find_all(view &v, element *root, wchars selector,
                const function<bool(element *)> &f, bool only_visible) {
    selector_context     selctx(root, selector, only_visible);
    element_iterator_ctx it(v, root, selctx);
    for (element *bf; it(bf);)
      if (f(bf)) break;
  }

  element *find_first_parent(view &v, element *root, element *b,
                             wchars selector, uint depth) {

    if(!root || !b)
      return nullptr;

    tool::array<handle<html::style_def>> sds;

    css_istream s(selector, string());
    style_bag dummy;
    html::style_def::parse_list(&dummy, s, sds);

    if (sds.size() == 0) {
#ifdef DEBUG
      dbg_printf("wrong selector:%S\n", ustring(selector).c_str());
      assert(0);
#endif // DEBUG
      return nullptr;
    }

    while (b) {
      if (b == root) return nullptr;
      int n = sds.size();
      for (int i = 0; i < n; ++i) {
        if (sds[i]->match(b, root,true)) goto DONE;
      }
      b = b->parent;
      if (--depth == 0) // 0 as intital value - unlimited search
      {
        b = nullptr;
        break;
      }
    }
  DONE:
    return const_cast<element *>(b);
  }

  element *find_first_parent_or_root(view &v, element *root, element *b,  wchars selector) {

    if (!root || !b)
      return nullptr;

    tool::array<handle<html::style_def>> sds;

    css_istream s(selector, string());
    style_bag dummy;
    html::style_def::parse_list(&dummy, s, sds);

    if (sds.size() == 0) {
      return nullptr;
    }

    while (b) {
      int n = sds.size();
      for (int i = 0; i < n; ++i) {
        if (sds[i]->match(b, root, true)) goto DONE;
      }
      if (b == root) return nullptr;
      b = b->parent;
    }
  DONE:
    return const_cast<element *>(b);
  }



  element *find_first_ui_parent(view &v, element *root, element *b,
                                wchars selector, uint depth) {
    tool::array<handle<html::style_def>> sds;

    css_istream s(selector, string());
    html::style_def::parse_list(nullptr, s, sds);

    if (sds.size() == 0) {
      assert(0);
      return 0;
    }

    while (b) {
      if (b == root) return nullptr;
      int n = sds.size();
      for (int i = 0; i < n; ++i) {
        if (sds[i]->match(b, root, true)) goto DONE;
      }
      b = b->ui_parent(v);
      if (--depth == 0) // 0 as intital value - unlimited search
      {
        b = nullptr;
        break;
      }
    }
  DONE:
    return const_cast<element *>(b);
  }

  element *find_first_parent(view &v, element *b, wchars selector, uint depth) {
    element *root = b->doc();
    if (!root) return 0;
    return find_first_parent(v, root, b, selector, depth);
  }

  void find_all_parents(view &v, array<helement> &r, element *b,
                        wchars selector) {
    tool::array<handle<html::style_def>> sds;

    css_istream s(selector, string());
    html::style_def::parse_list(nullptr, s, sds);

    const element *root = b->doc();
    if (!root) return;

    if (sds.size() == 0) {
      assert(0);
      return;
    }
    while (b) {
      int n = sds.size();
      for (int i = 0; i < n; ++i) {
        if (sds[i]->match(b, root)) r.push(b);
      }
      b = b->parent;
    }
  }

  element *find_first_ex(view &v, element *root, wchars selector,
                         wchars parent_selector, bool only_visible) {
    element *pb = const_cast<element *>(root);
    if (parent_selector.length) {
      pb = find_first_parent(v, root, parent_selector, 0);
    }
    if (selector.length)
      return find_first(v, pb, selector, only_visible, false);
    else if (parent_selector.length && pb != root)
      return pb;
    return 0;
  }

} // namespace html
