#include "html.h"

namespace html {
  block_vertical_wrap *block_vertical_wrap::setup_on(view &v, element *el) {
    block_vertical_wrap *tb = turn_element_to<block_vertical_wrap>(el);
    return tb;
  }

  /*inline const style* next_element_style( const element* b, view& v )
  {
    if( b->index == b->parent->subs.last_index() ) return element::null_style;
    b = b->parent->subs[b->index + 1];
    if( !b ) return block::null_style;
    return b->current_style(v);
  }
  inline const style* prev_element_style( const block* b, view& v )
  {
    if( b->index == 0 ) return block::null_style;
    if( !b || !b->parent) return block::null_style;
    b = b->parent->subs[b->index - 1];
    return b->current_style(v);
  }*/

  int known_height_of_parent(view &v, element *b);

  void block_vertical_wrap::do_layout(view &v) {

    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    // array<range> cols;
    ld->cols.clear();

    int subs_size = ld->blocks.size();
    if (subs_size == 0) {
      ld->dim_min.empty();
      ld->dim_max.empty();
      return;
    }

    // int col_spacing_left = 0;
    int col_spacing      = pixels(v, this, cs->border_spacing_x).width();
    int prev_col_spacing = 0;

    int container_height = known_height_of_parent(v, this);

    rect crect = client_rect(v);
    size inner = crect.size();
    if (inner.y == 0) {
      inner.y = limit<int>(this->declared_height(v, container_height),
                           this->declared_min_height(v, container_height),
                           this->declared_max_height(v, container_height));
    }

    bool rtl = cs->direction == direction_rtl;

    int yoff = ld->inner_borpad_top();

    int xpos = rtl ? (crect.right() - ld->inner_borpad_right()) : (crect.left() + ld->inner_borpad_left());
    int ypos = 0;
    int colstart = 0;
    int i        = 0;

    int mih = 0;
    int mah = 0;

    // int total_springs = 0;

    int pix  = 0;
    int spr  = 0;

    int colwidth = 0;

    helement prevb;

    hstyle prev_element_style = element::null_style;

    // simple flow layout
    for (i = 0; i < subs_size;) {
      helement b   = ld->blocks[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) {
        ++i;
        continue;
      }

      if (b->positioned(v)) b->check_positioned_containment(v);

      if (b->oof_positioned(v) || b->popup_positioned(v)) {
        ++i;
        premeasure(v, b, bcs, ld->dim);
        continue;
      }

      if (bcs->visibility == visibility_collapse) {
        premeasure(v, b, bcs, ld->dim);
        ++i;
        continue;
      }

      premeasure(v, b, bcs, ld->dim);

      h_layout_data bld = b->ldata;

      int w = b->min_width(v) + bld->outer_left() + bld->outer_right();

      int proposed_colwidth = colwidth;

      if (proposed_colwidth < w) proposed_colwidth = w;

      overlapping_y(v, this, prevb, b, pix, spr);
      ypos += pix;

      // b->set_width(v,colwidth);
      replace_h(v, b, proposed_colwidth, true, bcs->get_horizontal_align());

      int minheight = b->min_height(v) + bld->borpad_top() + bld->borpad_bottom();

      if ((colstart < i) &&
          ((ypos + minheight + bld->margin_width.bottom()) > inner.y
           //|| (total_springs > 100) // not anymore
           || (bcs->clears & clear_left) ||
           (prev_element_style->clears & clear_right))) {

        ld->cols.push(irange(colstart, i - 1));

        if (rtl) {
          xpos -= colwidth;
          layout_column(v, colstart, i, point(xpos + 1,yoff), colwidth);
          xpos -= col_spacing;
        }
        else {
          xpos += prev_col_spacing;
          layout_column(v, colstart, i, point(xpos, yoff), colwidth);
          xpos += colwidth;
        }

        colstart = i;
        ypos     = yoff;
        prev_col_spacing = col_spacing;
        prevb            = 0;
        // total_springs = 0;
        colwidth           = 0;
        prev_element_style = element::null_style;
        continue;
      }
      colwidth = proposed_colwidth;
      ypos += minheight;
      // col_spacing_left = max(col_spacing_left, bld->margin_width.left());
      // col_spacing_right = max(col_spacing_right,bld->margin_width.right());

      int block_outer_height = b->min_height(v, container_height) +
                               b->outer_int_y_extra(v, container_height);
      if (block_outer_height > mih) mih = block_outer_height;
      mah += minheight;

      prev_element_style = bcs;
      prevb              = b;
      ++i;
    }
    // adjust last col
    if (colstart < subs_size) {
      if( !rtl ) 
        xpos += prev_col_spacing;

      ld->cols.push(irange(colstart, i - 1));

      if (rtl) {
        xpos -= colwidth;
        layout_column(v, colstart, i, point(xpos + 1,yoff), colwidth);
      }
      else {
        layout_column(v, colstart, i, point(xpos,yoff), colwidth);
        xpos += colwidth;
      }

    }

    int extray = ld->inner_borpad_top() + ld->inner_borpad_bottom();
    
    ld->dim_min.x = ld->dim_max.x = (rtl ? crect.right() - xpos : xpos) + ld->inner_borpad_right();
    ld->dim_min.y                 = mih + extray;
    ld->dim_max.y                 = mah + extray;
  }

  void block_vertical_wrap::layout_column(view &v, int colstart, int colend,
                                          point pos, int colwidth) {
    // hstyle cs,

    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    // int i = 0;
    // const int subs_size = ld->blocks.size();

    int       i         = 0;
    const int subs_size = colend - colstart;
    if (subs_size == 0) return;

    rect crect = this->client_rect(v);
    size inner = crect.size();
    inner.x    = colwidth;

    flex::engine sc(subs_size * 6 + 1);
    helement    prevb = 0;
    int         pix = 0, spr = 0;
    for (i = colstart; i < colend; i++) {
      helement b   = ld->blocks[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) continue;
      if (b->oof_positioned(v)) continue;
      if (b->popup_positioned(v)) continue;

      /*if(b->flags.out_of_flow)
      {
        //b->measure(v,d->dim.x,d->dim.y);
        b->set_width(v,ld->dim.x);
        b->set_height(v,ld->dim.y);
        continue;
      }*/

      h_layout_data bld = b->ldata;

      int      bwidth = premeasure(v, b, bcs, inner);
      halign_e halign = cs->get_horizontal_align();
      //    bcs->direction == direction_rtl ? align_right : align_left;
      //if (cs->horizontal_align.is_defined())
      //  halign = cs->get_horizontal_align();
      {
        int width_to_align =
            inner.x - bwidth - bld->outer_left() - bld->outer_right();
        if (width_to_align < 0 && cs->overflow_x == overflow_none)
          width_to_align = 0;
        if (halign == align_left)
          b->set_x_pos(pos.x + bld->outer_left());
        else if (halign == align_right)
          b->set_x_pos(pos.x + bld->outer_left() + width_to_align);
        else if (halign == align_center)
          b->set_x_pos(pos.x + bld->outer_left() + width_to_align / 2);
      }

      b->set_width(v, bwidth);

      overlapping_y(v, this, prevb, b, pix, spr);
      sc.add(pix, int_v(), spr);

      // size_v bfs = b->current_style(v)->font_size;

      bcs->used_border_width(1).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);
      sc.add(pix, int_v(), spr);

      bcs->used_padding(1).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);
      sc.add(pix, int_v(), spr);

      int spring_height = bcs->height.flex1000();

      sc.add(spring_height ? b->min_height(v)
                           : b->computed_height(v, ld->dim.y),
             b->max_height(v, ld->dim.y), spring_height);

      bcs->used_padding(3).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);
      sc.add(pix, int_v(), spr);

      bcs->used_border_width(3).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);
      sc.add(pix, int_v(), spr);

      prevb = b;
    }

    if (!prevb) return;

    overlapping_y(v, this, prevb, 0, pix, spr);
    sc.add(pix, int_v(), spr);

    int content_height = sc.calc(inner.y);

    if (ld->dim_min.y > content_height) content_height = ld->dim_min.y;

    int freespace_a = inner.y - content_height;

    int freespace = min(sc.freespace, freespace_a);
    if (freespace < 0) freespace = 0;

    int posy = pos.y;

    auto valign = cs->get_block_vertical_align();
    if (cs->display == display_inline_block || cs->display == display_inline)
      valign = valign_top;

    switch (valign) {
    case valign_top: break;
    case valign_bottom: posy += freespace; break;
    case valign_middle: posy += freespace / 2; break;
    }

    int n = 0;
    for (i = colstart; i < colend; i++) {
      helement b   = ld->blocks[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) continue;

      h_layout_data bld = b->ldata;

      if (bcs->position > position_relative) {
        b->set_pos(bld->outer_left(), posy + bld->outer_top());
        continue;
      }

      int margin = sc.val(n);
      posy += margin;

      bld->margin_width.s.y = margin;
      posy += (bld->border_width.s.y = sc.val(++n));
      posy += (bld->padding_width.s.y = sc.val(++n));
      b->set_pos(pos.x + bld->outer_left(), posy);
      b->set_height(v, sc.val(++n));
      posy += bld->dim.y;
      posy += (bld->padding_width.e.y = sc.val(++n));
      posy += (bld->border_width.e.y = sc.val(++n));
      bld->margin_width.e.y = sc.val(++n);
    }
  }

  int block_vertical_wrap::n_rows() {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    inc_max<int>        nm;
    for (int c = 0; c < ld->cols.size(); ++c)
      nm <<= ld->cols[c].length();
    return nm;
  }
  int block_vertical_wrap::n_cols() {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    return ld->cols.size();
  }
  void block_vertical_wrap::get_row(int row, array<handle<element>> &els) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    for (int c = 0; c < ld->cols.size(); ++c) {
      auto col = ld->cols[c];
      if (row < col.length()) els.push(ld->blocks[col.l + row]);
    }
  }
  void block_vertical_wrap::get_col(int col, array<handle<element>> &els) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    if (col >= 0 && col < ld->cols.size()) {
      auto cd = ld->cols[col];
      els     = ld->blocks(cd.l, cd.h + 1);
    }
  }
  bool block_vertical_wrap::get_col_x(int col, gool::range &x) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    view *              pv = pview();
    if (!pv) return false;
    x = range();
    array<handle<element>> els;
    get_col(col, els);
    FOREACH(i, els)
    x |= els[i]->margin_box(*pv, TO_PARENT).x();
    return true;
  }
  bool block_vertical_wrap::get_row_y(int row, gool::range &y) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    view *              pv = pview();
    if (!pv) return false;
    y = range();
    array<handle<element>> els;
    get_row(row, els);
    FOREACH(i, els)
    y |= els[i]->margin_box(*pv, TO_PARENT).y();
    return true;
  }

  bool block_vertical_wrap::get_row_at(view &v, int y, int &row) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    point               pos(ld->dim.x / 2, y);
    element *           child = find_child_element(v, pos, false);
    for (; child; child = child->get_owner()) {
      if (child->get_owner() == this) {
        row = int(child->flags.ui_index);
        return true;
      }
    }
    return false;
  }
  bool block_vertical_wrap::get_col_at(view &v, int x, int &col) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    if (!ld->blocks.size()) return false;
    col = 0;
    return true;
  }
  element *block_vertical_wrap::at(int row, int col) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    if (col < 0 || col >= ld->cols.size()) return 0;
    int idx = ld->cols[col].l + row;
    return idx < ld->blocks.size() ? ld->blocks[idx] : 0;
    // return col > 0? 0 : ld->blocks[row];
  }

} // namespace html