#include "html.h"

namespace html {
  block_table *block_table::setup_on(view &v, element *el) {
    block_table *tb = turn_element_to<block_table>(el);
    return tb;
  }

  void block_table::fixup_layout(view &v) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    // if(ld->body)
    //  ld->body->fixup_layout(v);
  }

  bool is_row(view &v, element *el) {
    auto cs = el->get_style(v);
    return cs->display == display_table_row || cs->flow == flow_table_row;
  }

  bool is_tbody(view &v, element *el) {
    auto cs = el->get_style(v);
    return cs->display == display_table_body || cs->flow == flow_table_body;
  }

  int block_table::layout_data::get_tbody_index_for_insertion() {
    for (int n = blocks.size() - 1; n >= 0; --n) {
      if (blocks[n]->tag != tag::T_TFOOT) return n + 1;
    }
    return blocks.size();
  }
  void block_table::layout_data::insert_element(view &v, element *self,
                                                element *el, int index) {
    int blocks_size = blocks.size();
    if (index >= blocks_size) {
      index = blocks_size;
      blocks.push(el);
    } else
      blocks.insert(index, el);
    if (!el->parent) el->parent = self;
    assert(el->parent);
    el->owner          = self;
    el->flags.ui_index = index;
    el->get_style(v);
    el->check_layout(v);
    drop_minmax_dim();
  }

  void block_table::layout_data::drop_minmax_dim() {
    super::drop_minmax_dim();
    FOREACH(c, cols)
    cols[c].clear();
    blocks.each([](helement el) -> bool {
      el->drop_minmax_dim();
      return false;
    });
  }

  void block_table::layout_data::drop() {
    super::drop();
    cols.clear();
    // if(body && body->flags.is_synthetic) body->parent = 0;
    // body = 0;
    hoffsets.clear();
  }

  void block_table::layout_data::push(view &v, element *self, element *el) {
    el->get_style(v);
    //el->check_layout(v); -- fails on synthetic <tbody>
    if (is_tbody(v,el)) {
      if (el->tag == tag::T_THEAD)
        insert_element(v, self, el, limits<int>::max_value());
      else if (el->tag == tag::T_TFOOT)
        insert_element(v, self, el, limits<int>::max_value());
      else if (el->tag == tag::T_TBODY)
        insert_element(v, self, el, get_tbody_index_for_insertion());
      // body = 0;
    } else if (is_row(v, el)) {
      element *last = self->last_element();
      if (!last || !last->is_table_body()) {
        last = new block_table_body(tag::T_TBODY);
        last->flags.is_synthetic = 1;
        super::push(v, self, last);
        // body->ldata = new block_table_body::layout_data(body);
        // This: block_table_body::setup_on(v,body); does not work in release
        // due to is_type_of<>() bug?
        block_table_body::setup_on(v, last);
      }
      last->ldata->push(v, last, el);
      drop_minmax_dim();
    } else if (el->tag == tag::T_CAPTION) {
      super::push(v, self, el);
      // body = 0;
    } else {
      view::debug_printf(OT_DOM, OS_WARNING,
                         "<%s> element is not expected in <table>\n",
                         tag::symbol_name(el->tag).c_str());
      // assert(false);
      super::push(v, self, el);
      // body = 0;
    }
  }

  element *block_table::drop_layout(view *pv) {
    auto drop_child = [&](element *el) -> bool {
      el->drop_layout(pv);
      return false;
    };
    each_ui_child(drop_child);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    FOREACH(c, ld->cols)
    ld->cols[c].clear();
    return super::drop_layout(pv);
  }

    void block_table::drop_content_layout(view* pv)
    {
      if(!is_layout_valid())
        return;
      auto drop_child = [&](element *el) -> bool {
        el->drop_layout(pv);
        return false;
      };
      each_ui_child(drop_child);
      handle<layout_data> ld = ldata.ptr_of<layout_data>();
      FOREACH(c, ld->cols)
        ld->cols[c].clear();
      return super::drop_content_layout(pv);
    }

  void block_table::calc_intrinsic_widths(view &v) {

    check_layout_tree(v);

    super::calc_intrinsic_widths(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    range               mr;

    inc_max<int> ma;
    inc_max<int> mi;

    auto calc_offsets = [&v, &mr, &mi, &ma](element *el) -> bool {
      rect md = el->margin_distance(v);
      mr.s    = max(mr.s, md.s.x);
      mr.e    = max(mr.e, md.e.x);
      mi <<= el->min_content_width(v);
      ma <<= el->max_content_width(v);
      return false;
    };
    each_ui_child(calc_offsets);
    ld->hoffsets  = mr;
    ld->dim_min.x = max(mi, ld->dim_min.x);
    ld->dim_max.x = max(ma, ld->dim_max.x);
  }

  int block_table::layout_width(view &v, int width) {
    int r = super::layout_width(v, width);
    // layout_height(v, computed_height(v,0));
    return r;
  }
  int block_table::layout_height(view &v, int height) {
    return super::layout_height(v, height);
  }

  int cell_spacing_x(view &v, element *el, int width) {
    bool collapsed_model = el->c_style->border_collapse == border_collapse;
    return collapsed_model
               ? 0
               : pixels(v, el, el->c_style->border_spacing_x).width();
  }
  int cell_spacing_y(view &v, element *el, int height) {
    bool collapsed_model = el->c_style->border_collapse == border_collapse;
    return collapsed_model
               ? 0
               : pixels(v, el, el->c_style->border_spacing_y).width();
  }

  int div2d(int n);
  int div2u(int n);

  element::max_values block_table::measure_borders_x(view &v, size container_dim) {
    auto r = super::measure_borders_x(v, container_dim);
    if (c_style->border_collapse == border_collapse) {
      ldata->padding_width.s.x = -div2d(ldata->border_width.s.x);
      ldata->padding_width.e.x = -div2u(ldata->border_width.e.x);
    }
    return r;
  }
  element::max_values block_table::measure_borders_y(view &v, size container_dim) {
    auto r = super::measure_borders_y(v, container_dim);
    if (c_style->border_collapse == border_collapse) {
      ldata->padding_width.s.y = -div2d(ldata->border_width.s.y);
      ldata->padding_width.e.y = -div2u(ldata->border_width.e.y);
    }
    return r;
  }

  void block_table::layout_width_start(view &v, int width) {
    // setup column widhts and postions.
    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    rect crect     = client_rect(v);
    size inner_dim = crect.size();

    array<col_def> &cols = ld->cols;

    int n_cols = cols.size();

    if (ld->dim_min.x.is_undefined()) calc_intrinsic_widths(v);

    if (n_cols == 0) return;

    bool max_content_fits = cs->width.is_auto() && width >= ld->dim_max.x;

    // bool collapsed_model = cs->border_collapse == border_collapse;

    int inter_cell_x = cell_spacing_x(v, this, ld->dim.x);

    flex::engine se(cols.size());

    // inter_cell_x

    int max_total = 0;
    for (int n = 0; n < n_cols; ++n) {
      const col_def &cd = cols[n];
      max_total += cd.minmax.px_max;
    }

    if (!max_total) {
      calc_intrinsic_widths(v);
      // assert(false);
      for (int n = 0; n < n_cols; ++n)
        max_total += cols[n].minmax.px_max;
      // assert(max_total);
      if (!max_total) max_total = 1;
    }

    if (is_fixed())
      for (int n = 0; n < n_cols; ++n) {
        col_def &t = cols[n];
        t.pos      = 0;
        t.value    = 0;
        // se.add(t.minmax.px,int_v(),t.minmax.flex?t.minmax.flex*100:t.minmax.px_max*100/max_total,t.minmax.px_pref);
        se.add(t.minmax.px, int_v(), t.minmax.flex);
      }
    else
      for (int n = 0; n < n_cols; ++n) {
        col_def &t = cols[n];
        t.pos      = 0;
        t.value    = 0;
        se.add(max_content_fits ? t.minmax.px_max : t.minmax.px, int_v(),
               t.minmax.flex ? t.minmax.flex * 100
                             : t.minmax.px_max * 100 / max_total);
      }

    int width_to_distribute =
        max(ld->dim_min.x, ld->inner_dim.x) - (cols.size() - 1) * inter_cell_x;
    width_to_distribute -= ld->hoffsets.s;
    width_to_distribute -= ld->hoffsets.e;

    se.calc(width_to_distribute,false);

    // fill computed values

    if (cs->direction == direction_ltr) {
      int x = 0; // ld->hoffsets.l;
      for (int n = 0; n < n_cols; ++n) {
        col_def &t = cols[n];
        t.pos      = x;
        x += (t.value = se.val(n));
        x += inter_cell_x;
      }
    } else if (cs->direction == direction_rtl) {
      int x = inner_dim.x; //- ld->hoffsets.h;
      for (int n = 0; n < n_cols; ++n) {
        col_def &t = cols[n];
        x -= (t.value = se.val(n));
        t.pos = x;
        x -= inter_cell_x;
      }
    }
  }

  block_table_row *block_table_row::setup_on(view &v, element *el) {
    block_table_row *tb = turn_element_to<block_table_row>(el);
    /*if( el->layout_type() != flow_table_row )
      tb = turn_to<block_table_row>(el);
    else
    {
      tb = static_cast<block_table_row*>(el);
      if( !tb->ldata )
        tb->ldata = new layout_data;
      else
        return tb;
    }*/
    return tb;
  }

  /*void block_table_row::layout_data::push( view& v, element* self, element* el
)
  {
    el->get_style(v);
#pragma TODO("handle cells here")
    //assert(false);
    super::push(v,self,el);
  }*/

  extern element *parent_table(element *el);

  /*element* parent_table(element* el)
  {
     if(!el)
       return 0;
     if(!el->parent)
       return 0;
     if(el->parent->is_table())
       return el->parent;
     return parent_table(el->parent);
  }*/

  void block_table_row::commit_measure(view &v) {
    element *pt = parent_table(this);
    if (pt) pt->commit_measure(v);
  }

  void block_table_row::calc_intrinsic_widths(view &v) {
    super::calc_intrinsic_widths(v);
  }

  element *block_table_row::similar_neighbour(element *child) const {
    element *owner = get_owner();
    if (!owner || !owner->is_table_body()) return 0;

    int rn = this->index();
    if (rn == 0) return 0;
    element *nb = this->prev_element();
    {
      if (!nb) return 0;
      if (nb->tag != tag) return 0;
      if (nb->layout_type() != layout_type()) return 0;
      if (nb->c_style == null_style) return 0;
      if (a_style || nb->a_style) return 0;
      if (animator || nb->animator) return 0;
      if (!nb->state.similar(state)) return 0;
      if (nb->flags.disable_fast_css_match) return 0;
      if (behavior || nb->behavior) return 0;
      if (atts != nb->atts) return 0;
      if (nb->c_style->unique) return 0;
    }

    int cn = child->index();

    block_table_body *tbody = owner->cast<block_table_body>();
    return tbody->get_cell_at(rn - 1, cn);
  }

  bool block_table_row::is_caret_pos(view& v, const bookmark &bm) const {
    if (bm == end_pos() || bm == start_pos()) return true;
    return false;
  }

  block_table_fixed *block_table_fixed::setup_on(view &v, element *el) {
    block_table_fixed *tb = turn_element_to<block_table_fixed>(el);
    return tb;
  }

} // namespace html