#include "html.h"

namespace html {

  block_image *block_image::setup_on(view &v, element *el) {
    block_image *tb = turn_element_to<block_image>(el);
    tb->init(v);
    return tb;
  }

  void block_image::calc_intrinsic_widths(view &v) {
    // super::calc_intrinsic_widths(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    image *pimg = provide_fore_image(v);

    size content = pimg ? pimg->dim() : size(6000, 6000);
    content      = v.pixels_per_dip(content);
    // WTF ???? ld->dim = size(0);
    ld->dim_min = size(0);
    ld->dim_max = content;
  }

  int block_image::layout_width(view &v, int width) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    ld->dim.x              = width;
    return ld->dim.y;
  }

  int block_image::layout_height(view &v, int height) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    ld->dim.y              = height;
    return ld->dim.x;
  }

  int_v block_image::auto_width(view &v) {
    handle<layout_data> ld      = ldata.ptr_of<layout_data>();
    image *             pimg    = provide_fore_image(v);
    size                content = pimg ? pimg->dim() : size(16);
    content                     = v.pixels_per_dip(content);
    if( get_style(v)->height.undefined_or_auto() )
      return content.x;
    else 
      return (content.x * pixels(v,this, get_style(v)->height).height()) / max(1, content.y);
  }

  int_v block_image::auto_height(view &v) {
    handle<layout_data> ld      = ldata.ptr_of<layout_data>();
    image *             pimg    = provide_fore_image(v);
    size                content = pimg ? pimg->dim() : size(16);
    content                     = v.pixels_per_dip(content);
    if (content.x == ld->dim.x)
      return content.y;
    else
      return (content.y * ld->dim.x) / max(1, content.x);
  }

  image *block_image::provide_fore_image(view &v) const {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    if (ld->pimg) return ld->pimg;
    if (ld->ir.is_undefined()) const_cast<block_image *>(this)->init(v);
    if (ld->ir.img()) return ld->ir.img();
    return super::provide_fore_image(v);
  }

  void block_image::accept_image(view &v, const image_ref &ir) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    if (ld->pimg) return;
    if (ld->ir == ir) {
      if (state.busy() || state.incomplete()) {
        if(ld->ir.img())
          state_off(v, S_BUSY | S_INCOMPLETE);
        else
          state_off(v, S_BUSY);
      }
      // image changes intrinsic dimensions, so:
      if (get_style(v)->has_auto_dimensions())
        v.add_to_update(this, CHANGES_DIMENSION);
      else
        v.add_to_update(this, CHANGES_VISUAL);
      event_behavior evt(this,this, ld->ir.img() ? BEHAVIOR_EVENTS::LOAD_SUCCEEDED : BEHAVIOR_EVENTS::LOAD_FAILED,0);
      v.post_behavior_event(evt,true);
    }
  }

  void block_image::set_image(view &v, image *ptr) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    if (state.busy() || state.incomplete()) state_off(v, S_BUSY | S_INCOMPLETE);

    if (get_style(v)->has_auto_dimensions())
      v.add_to_update(this, CHANGES_DIMENSION);
    else
      v.add_to_update(this, CHANGES_VISUAL);

    ld->pimg = ptr;
  }

  bool block_image::default_set_value(view &v, const value &val, bool ignore_text_value) {
    if (val.is_bytes()) {
      bytes  data = val.get_bytes();
      string crc  = md5(data).to_string();
      himage img  = image::create(data, string::format("temp:%s", crc.c_str()), doc());
      if (img) {
        set_image(v, img);
        return true;
      }
    } else if (val.is_string()) {
      set_attr(v, attr::a_src, val.get_string());
      return true;
    }
    else if (val.is_resource())
    {
      himage img = val.get_resource<gool::image>();
      if (img) {
        set_image(v, img);
        return true;
      }
    }
    return false;
  }
  bool block_image::default_get_value(view &v, value &val, bool ignore_text_value) {
    image *pimg = provide_fore_image(v);
    if (pimg)
      val = value::wrap_resource(pimg); //pimg->get_url();
    else
      val = value();
    return true;
  }

  void block_image::stray(view &v) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    document *          pd = doc();
    if (pd) {
      pd->release_image(ld->ir);
      ld->pimg = nullptr;
      ld->used_src.clear();
    }
    super::stray(v);
  }

  void block_image::init(view &v) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    ustring src = atts.get_ustring(attr::a_src);
    if (src == ld->used_src) return;

    ld->used_src = src;

    document *pd = doc();
    if (!pd) return;

    string url = atts.get_url(pd->uri().src, attr::a_src);

    if (url.length() > 0) {
      if (ld->ir.img() && ld->ir.img()->get_url() == url) return;

      if (ld->ir.is_defined()) pd->release_image(ld->ir);

      ld->ir    = pd->register_image(url);
      bool busy = ld->ir.fetch(v, pd);

      uint64 state = 0;
      if (!ld->ir.img()) 
        state |= S_INCOMPLETE;
      if (busy) 
        state |= S_BUSY;
      if (state) 
        state_on(v, state);
      else {
        if (get_style(v)->has_auto_dimensions())
          v.add_to_update(this, CHANGES_DIMENSION);
        else
          v.add_to_update(this, CHANGES_VISUAL);
      }
    } else {
      if (ld->ir.is_defined()) pd->release_image(ld->ir);
      ld->ir.clear();
    }
  }

  bool block_image::on_set_attr(uint att_sym, const ustring &val) {
    if (att_sym == attr::a_src) {
      handle<layout_data> ld = ldata.ptr_of<layout_data>();
      document *          pd = doc();
      if (pd) {
        pd->release_image(ld->ir);
        ld->pimg = nullptr;
        ld->used_src.clear();
        if (view* pv = pd->pview())
          //state_on(*pv, STATE_BUSY | STATE_INCOMPLETE);
          init(*pv);
      }
      return true;
    }
    return super::on_set_attr(att_sym, val);
  }

  bool block_image::on_remove_attr(uint att_sym, const ustring &val) {
    if (att_sym == attr::a_src) {
      handle<layout_data> ld = ldata.ptr_of<layout_data>();
      document *          pd = doc();
      if (pd) {
        pd->release_image(ld->ir);
        ld->pimg = nullptr;
        ld->used_src.clear();
        if (view* pv = pd->pview())
          state_off(*pv, STATE_BUSY | STATE_INCOMPLETE);
      }
      return true;
    }
    return super::on_remove_attr(att_sym,val);
  }

} // namespace html