#include "html.h"

namespace html {
  block_horizontal_wrap *block_horizontal_wrap::setup_on(view &v, element *el) {
    block_horizontal_wrap *tb = turn_element_to<block_horizontal_wrap>(el);
    /*if( el->layout_type() != flow_h_flow )
      tb = turn_to<block_horizontal_wrap>(el);
    else
    {
      tb = static_cast<block_horizontal_wrap*>(el);
      if( tb->ldata->type() != flow_h_flow ) tb->ldata = new layout_data;
    }*/
    return tb;
  }

  void block_horizontal_wrap::calc_intrinsic_widths(view &v) {
    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    if (ld->dim_min.x.is_defined() && ld->dim_max.x.is_defined())
      return; // already measured

    ld->dim_min.y.clear();
    ld->dim_max.y.clear();

#ifdef _DEBUG
    if (is_id_test())
      ld = ld;
#endif // _DEBUG

    int extra = ld->inner_borpad_x();

    int miw = extra;
    int maw = extra;

    slice<helement> subs = ld->blocks();

    element *prevb = 0;
    int pix = 0, spr = 0;
    int cmiw = 0, cmaw = 0;

    for (uint i = 0; i < subs.length; ++i) {
      element *b   = subs[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;

      h_layout_data bld = b->ldata;

      if (b->oof_positioned(v) || b->floats(v)) {
        premeasure(v, b, bcs, ld->dim);
        continue;
      }

      b->measure_borders_x(v, ld->dim);
      b->measure_borders_y(v, ld->dim);
            
      overlapping_x(v, this, prevb, b, pix, spr);

      int borpad = bld->borpad_left() + bld->borpad_right();
      int ciw     = b->min_width(v) + borpad + pix;
      int caw     = b->max_width(v).val(b->max_content_width(v)) + borpad + pix;
      cmiw        = max(cmiw, ciw);
      cmaw        = max(cmaw, caw);
      miw         = max(miw, ciw);
      maw += caw;
      prevb = b;
    }

    overlapping_x(v, this, prevb, nullptr, pix, spr);

    ld->dim_min.x             = miw + pix;
    ld->dim_max.x             = maw + pix;
    ld->min_child_border_width = cmiw;
    ld->max_child_border_width = cmaw;
  }

  style *prev_element_style(view &v, element *el) {
    element *pel = el->prev_element(); // el->prev_ui_element();
    if (pel) return pel->get_style(v);
    return element::null_style;
  }

  inline void element_heights(view &v, int container_height, element *b,
                              inc_max<int> &mih, inc_max<int> &mah,
                              inc_max<int> &ascent, inc_max<int> &descent) {
    int h_extra = b->ldata->outer_top() + b->ldata->outer_bottom();
    int element_outer_height =
        b->computed_height(v, container_height) + h_extra;
    mih <<= element_outer_height;

    int_v mh = b->max_height(v);
    if (mh.is_defined()) {
      int element_max_outer_height = b->max_height(v) + h_extra;
      mah <<= max(mih, element_max_outer_height);
    }

    switch (b->get_style(v)->get_text_vertical_align()) {
    case valign_baseline: {
      int a = 0, d = 0, h = 0;
      b->get_inline_block_metrics(v, a, d, h);
      ascent <<= a;
      descent <<= d;
      break;
    }
    case valign_sub:
    case valign_super: {
      int a = 0, d = 0, h = 0;
      b->get_inline_block_metrics(v, a, d, h);
      int shift = b->get_baseline_shift(v, b->parent);
      ascent <<= a - shift;
      descent <<= d + shift;
    } break;
    }
  }

  void layout_row(view &v, block_horizontal_wrap *d, hstyle cs, int start,
                  int end, int &out_mih, int_v &out_mah, int_v &out_baseline, int_v& out_mahflex1000) {
    handle<block_horizontal_wrap::layout_data> ld = d->ldata.ptr_of<block_horizontal_wrap::layout_data>();
    if (cs->overflow_x < overflow_visible)
      ld->dim.x = max((int)ld->dim_min.x, ld->dim.x);

    //slice<helement> subs = ld->blocks(start, end);
    buffer<helement, 16> subs = ld->blocks(start, end);

    if (subs.length() == 0) return;

    flex::engine sc(subs.size() * 6 + 1);

    size inner = d->client_rect(v).size();

    inc_max<int> mih;
    inc_max<int> mah;
    inc_max<int> ascent;
    inc_max<int> descent;
    inc_max<int> mahflex1000;

    element *prevb = 0;
    int      pix = 0, spr = 0;

    each<helement> blocks(subs(), cs->direction == direction_rtl);

    for (helement b; blocks(b);) {
      style *bcs = b->get_style(v);
      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) continue;

      handle<layout_data> bld = b->ldata;

      if (b->oof_positioned(v)) {
        // WTF?: b->dim.x = max(b->max_width(v),d->dim.x);
        // b->set_width(v,b->computed_width(v,ld->dim.x));
        // b->set_height(v,b->computed_height(v,ld->dim.y));
        continue;
      }

      size_v bfs = bcs->font_size;
      
      auto maxes = b->measure_borders_x(v, ld->dim.x);

      overlapping_x(v, d, prevb, b, pix, spr);
      sc.add(pix, maxes.m1, spr);

      bcs->border_width[0].pixels_n_spring_w(v, b, ld->dim.x, pix, spr);
      sc.add(pix, maxes.b1, spr);

      bcs->used_padding(0).pixels_n_spring_w(v, b, ld->dim.x, pix, spr);
      sc.add(pix, maxes.p1, spr);

      int spring_width; // = bcs->width.is_undefined()? 100:
                        // bcs->width.flex1000();
      int pref_width;   // = bcs->width.preferred_pixels_width(v,b,ld->dim.x);

      int min_w = b->min_width(v, ld->dim.x);
      if (bcs->min_width.is_literal(size_v::special_values::$auto))
        min_w = ld->child_min_auto(v, b);

      int_v max_w = b->max_width(v, inner.x);

      if (bcs->width.is_defined()) {
        spring_width = bcs->width.flex1000();
        pref_width   = bcs->width.preferred_pixels_width(v, b, ld->dim.x);
      } else {
        min_w      = b->min_width(v, ld->dim.x);
        pref_width = b->max_content_width(v);
        max_w = b->max_width(v, ld->dim.x).val(pref_width); // shrink to fit
        spring_width = 1;
      }

      if (bcs->max_width.is_literal(size_v::special_values::$auto))
        max_w = ld->child_max_auto(v, b);
      // else if(bcs->max_width.is_literal(size_v::special_values::$max_content))
      //  max_w = b->max_width(v);
      // else if(bcs->max_width.is_literal(size_v::special_values::$min_content))
      //  max_w = b->min_width(v);

      sc.add(min_w, max_w, spring_width);

      bcs->used_padding(2).pixels_n_spring_w(v, b, ld->dim.x, pix, spr);
      sc.add(pix, maxes.p2, spr);

      bcs->border_width[2].pixels_n_spring_w(v, b, ld->dim.x, pix, spr);
      sc.add(pix, maxes.b2, spr);

      prevb = b;
    }

    overlapping_x(v, d, prevb, 0, pix, spr);
    sc.add(pix, int_v(), spr);

    sc.calc(inner.x);

    int posx = ld->inner_borpad_left();

    switch (cs->get_horizontal_align()) {
    case align_left: break;
    case align_right: posx += sc.freespace; break;
    case align_center: posx += sc.freespace / 2; break;
    }

    // bool  dummy;
    int n = 0;

    blocks.rewind();
    for (helement b; blocks(b);) {
      style *bcs = b->get_style(v);
      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) continue;

      handle<layout_data> bld = b->ldata;

      if (b->oof_positioned(v)) {
        b->set_pos(bld->outer_top(), posx + bld->outer_left());
        continue;
      }

      int margin = sc.val(n);
      posx += margin;

      bld->margin_width.s.x = margin;
      posx += (bld->border_width.s.x = sc.val(++n));
      posx += (bld->padding_width.s.x = sc.val(++n));
      
      b->set_x_pos(posx);
      int dimx   = sc.val(++n);

      b->set_width(v, dimx);
      element_heights(v, ld->dim.y, b, mih, mah, ascent, descent);

      mahflex1000 <<= b->c_style->height.flex1000();
      
      posx += dimx;
      
      posx += (bld->padding_width.e.x = sc.val(++n));

      posx += (bld->border_width.e.x = sc.val(++n));
      bld->margin_width.e.x = sc.val(++n);
    }

    if (ascent) {
      if ((ascent + descent) < mih)
        out_baseline = (ascent * mih) / (ascent + descent);
      else {
        mih <<= ascent + descent;
        out_baseline = ascent;
      }
    } else
      out_baseline.clear();

    out_mih = mih;
    if (mah > 0) {
      mah <<= mih;
      out_mah = mah;
    }
    if (mahflex1000 > 0)
      out_mahflex1000 = mahflex1000;
  }

  int block_horizontal_wrap::layout_width(view &v, int width) {
    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    ld->dim.x = width;

#ifdef _DEBUG
    if (is_id_test())
      ld = ld;
#endif // _DEBUG


    rect crect     = client_rect(v);
    size inner_dim = crect.size();

    if (ld->dim_min.x.is_defined() && ld->dim_min.y.is_defined() &&
        ld->inner_dim.x == inner_dim.x)
      return ld->dim_min.y; // already measured

    ld->inner_dim.x = inner_dim.x;
    ld->inner_dim.y = 0;
    ld->dim.y       = 0; // ?
    ld->dim_min.y.clear();
    ld->dim_max.y.clear();

    if (ld->dim_min.x.is_undefined() || flags.has_percent_widths)
      calc_intrinsic_widths(v);

    slice<helement> subs = ld->blocks();

    ld->rows.clear();

    if (subs.length == 0) { return 0; }

    int p_border_spacing_y = pixels(v, this, cs->border_spacing_y).width();

    int          ypos  = ld->inner_borpad_top();
    int          xpos  = 0;
    element *    prevb = 0;
    inc_max<int> miw;
    inc_max<int> maw;
    int          row_maw  = 0;
    uint         rowstart = 0;

    /*int total_springs = 0;*/

    int pix  = 0;
    int spr  = 0;

    // simple flow layout
    for (uint i = 0; i < subs.length; ++i) {
      element *b   = subs[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;

      if (bcs->visibility == visibility_collapse) {
        premeasure(v, b, bcs, ld->dim);
        continue;
      }
      if (b->state.moving() || b->state.copying()) continue;

      premeasure(v, b, bcs, ld->dim);

      if (b->positioned(v)) b->check_positioned_containment(v);
      if (b->oof_positioned(v)) continue;

      h_layout_data bld = b->ldata;

      pix = 0;
      spr = 0;
      overlapping_x(v, this, prevb, b, pix, spr);
      xpos += pix;

      int min_w = 0;
      if (bcs->min_width.is_literal(size_v::special_values::$auto))
        min_w = ld->child_min_auto(v, b);
      if (bcs->max_width.is_literal(size_v::special_values::$auto))
        min_w = max(min_w, ld->child_max_auto(v, b));
      if (!min_w) {
        int spring_width = bcs->width.is_undefined() ? 100 : bcs->width.flex1000();
        min_w = spring_width ? b->min_width(v, ld->dim.x)
                             : b->computed_width(v, ld->dim.x); //: bld->dim.x;
      }
      min_w += bld->borpad_left() + bld->borpad_right();

      if ((rowstart < i) &&
          ((xpos + min_w + bld->margin_width.right()) > inner_dim.x ||
           (bcs->clears & clear_left) ||
           (prev_element_style(v, b)->clears & clear_right))) {
        // if(rowstart != 0)
        //  ypos += p_border_spacing_y;

        row_def rd;
        rd.first = rowstart;
        rd.last  = i - 1;
        layout_row(v, this, cs, rowstart, i, rd.min_h, rd.max_h, rd.baseline, rd.max_hflex1000);
        ld->rows.push(rd);

        rowstart = i;
        xpos     = 0;
        ypos += rd.min_h;
        prevb   = 0;
        maw     = max(maw, row_maw);
        row_maw = 0;
        --i;
        continue;
      }
      xpos += min_w;
      // row_spacing_top = max(row_spacing_top, b->margin_width.top());
      // row_spacing_bottom = max(row_spacing_bottom,b->margin_width.bottom());

      int outer = b->outer_int_x_extra(v, width);

      miw <<= b->min_width(v, width) + outer;
      row_maw += b->max_width(v, width).val(b->max_content_width(v)) + outer;
      row_maw += pix;
      prevb = b;
    }

    // adjust last row
    if (rowstart < subs.length) {
      // ypos += p_border_spacing_y;
      row_def rd;
      rd.first = rowstart;
      rd.last  = uint(subs.length - 1);
      layout_row(v, this, cs, rowstart, subs.size(), rd.min_h, rd.max_h, rd.baseline, rd.max_hflex1000);
      ld->rows.push(rd);
      ypos += rd.min_h;
    }

    ypos += p_border_spacing_y * (ld->rows.size() - 1);
    ypos += ld->inner_borpad_bottom();

    maw <<= row_maw;
    ld->dim_min.y = ld->dim_max.y = ypos;

    int extra = ld->inner_borpad_x();

    ld->dim_min.x = miw + extra;
    ld->dim_max.x = maw + extra;
    return ypos;
  }

  int block_horizontal_wrap::layout_height(view &v, int height) {
    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    int i = 0;
    const int rows_size = ld->rows.size();

    ld->dim.y = height;

    size inner_dim = client_rect(v).size();

    if (rows_size == 0) {
      ld->inner_dim.y = inner_dim.y;
      ld->dim.y = height;
      return ld->dim.x;
    }

    if (ld->dim_min.y.is_defined() && ld->dim_max.y.is_defined() &&
      ld->inner_dim.y == inner_dim.y)
      return ld->dim.x;

    ld->inner_dim = inner_dim;

    flex::engine sc(rows_size * 2 + 3);
    element *   prevb = 0;
    int         pix = 0, spr = 0;

    cs->inner_used_border_width(1).pixels_n_spring_h(v, this, height, pix, spr);
    sc.add(pix, int_v(), spr);

    cs->inner_used_padding(1).pixels_n_spring_h(v, this, height, pix, spr);
    sc.add(pix, int_v(), spr);

    int border_spacing_pix = 0;
    int border_spacing_spr = 0;

    if (c_style->border_spacing_y.is_defined()) 
      c_style->border_spacing_y.pixels_n_spring_h(v, this, height, border_spacing_pix, border_spacing_spr);
   
    for (i = 0; i < rows_size; i++) {
      row_def& rd = ld->rows[i];
      if(i) sc.add(border_spacing_pix, int_v(), border_spacing_spr);
      sc.add(rd.min_h, rd.max_h, rd.max_hflex1000);
    }

    cs->inner_used_padding(3).pixels_n_spring_h(v, this, height, pix, spr);
    sc.add(pix, int_v(), spr);

    cs->inner_used_border_width(3).pixels_n_spring_h(v, this, height, pix, spr);
    sc.add(pix, int_v(), spr);

#ifdef _DEBUG
    if (is_id_test())
      height = height;
#endif // _DEBUG

    int content_height = sc.calc(height);

    if (ld->dim_min.y > content_height) content_height = ld->dim_min.y;

    int freespace_a = ld->dim.y - content_height;

    int freespace = min(sc.freespace, freespace_a);
    if (freespace < 0 && (cs->overflow_y != overflow_hidden && cs->overflow_y != overflow_visible))
      freespace = 0;

    int posy = 0;

    auto valign = cs->get_block_vertical_align();
    if (cs->display == display_inline_block || cs->display == display_inline)
      valign = valign_top;

    switch (valign) {
    case valign_top:
      break;
    case valign_bottom:
      posy += freespace;
      break;
    case valign_middle:
      posy += freespace / 2;
      break;
    }

    int n = 0;

    posy += (ld->inner_border_width.s.y = sc.val(n++));
    posy += (ld->inner_padding_width.s.y = sc.val(n));

    slice<helement> subs = ld->blocks();

    for (i = 0; i < rows_size; i++) {
      row_def& rd = ld->rows[i];
      int row_spacing = i ? sc.val(++n) : 0;
      posy += row_spacing;
      rd.y = posy;
      int row_height = sc.val(++n);
      rd.height = row_height;

      for (uint i = rd.first; i <= rd.last; ++i) {
        element *b = subs[i];
        style *  bcs = b->get_style(v);
        if (bcs->is_display_none()) continue;
        if (bcs->visibility == visibility_collapse) continue;
        if (b->state.moving() || b->state.copying()) continue;

        h_layout_data bld = b->ldata;

        if (b->oof_positioned(v)) {
          b->set_pos(bld->outer_left(), posy + bld->outer_top());
          continue;
        }
        replace_v(v, b, row_height, true, bcs->get_block_vertical_align(), rd.baseline);
        //bld->pos.y += ypos;
        b->set_y_pos(b->pos().y + posy);
      }
      posy += row_height;
    }

    posy += (ld->inner_padding_width.e.y = sc.val(++n));
    posy += (ld->inner_border_width.e.y = sc.val(++n));

    return ld->dim.x;
  }

  /*int block_horizontal_wrap::layout_height(view &v, int height) {
    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    slice<helement> subs = ld->blocks();

    ld->dim.y = height;

    size inner_dim = client_rect(v).size();

    if (subs.length == 0) {
      ld->inner_dim.y = inner_dim.y;
      ld->dim.y       = height;
      return ld->dim.x;
    }

    if (ld->dim_min.y.is_defined() && ld->dim_max.y.is_defined() &&
        ld->inner_dim.y == inner_dim.y)
      return ld->dim.x;

    ld->inner_dim = inner_dim;

    int ypos = ld->inner_borpad_top();
    int p_border_spacing_y = pixels(v, this, cs->border_spacing_y).width(); // % of width

    for (uint r = 0; r < ld->rows.length(); ++r) {
      row_def &rd = ld->rows[r];
      size     rdim(ld->dim.x, rd.min_h);
      rd.y = ypos;
      for (uint i = rd.first; i <= rd.last; ++i) {
        element *b   = subs[i];
        style *  bcs = b->get_style(v);
        if (bcs->is_display_none()) continue;
        if (bcs->visibility == visibility_collapse) continue;
        if (b->state.moving() || b->state.copying()) continue;

        h_layout_data bld = b->ldata;

        if (b->oof_positioned(v)) {
          b->set_pos(bld->outer_left(), ypos + bld->outer_top());
          continue;
        }
        replace_v(v, b, rdim.y, true, bcs->get_block_vertical_align(), rd.baseline);
        //bld->pos.y += ypos;
        b->set_y_pos(b->pos().y + ypos);
      }
      ypos += rd.min_h;
      ypos += p_border_spacing_y;
    }
    return ld->dim.x;
  }*/

  int block_horizontal_wrap::n_rows() {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    return ld->rows.size();
  }
  int block_horizontal_wrap::n_cols() {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    inc_max<int>        nm;
    for (int r = 0; r < ld->rows.size(); ++r)
      nm <<= int(ld->rows[r].last) - int(ld->rows[r].first) + 1;
    return nm;
  }

  void block_horizontal_wrap::get_row(int row, array<handle<element>> &els) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    if (row >= 0 && row < ld->rows.size()) {
      auto            r    = ld->rows[row];
      slice<helement> subs = ld->blocks();
      els                  = subs(r.first, r.last + 1);
    }
  }

  void block_horizontal_wrap::get_col(int col, array<handle<element>> &els) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    for (int r = 0; r < ld->rows.size(); ++r) {
      auto row = ld->rows[r];
      if (col < int(row.last) - int(row.first) + 1)
        els.push(ld->blocks[row.first + col]);
    }
  }
  bool block_horizontal_wrap::get_col_x(int col, gool::range &x) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    view *              pv = pview();
    if (!pv) return false;
    x = range();
    array<handle<element>> els;
    get_col(col, els);
    FOREACH(i, els)
    x |= ld->blocks[i]->margin_box(*pv, TO_PARENT).x();
    return true;
  }
  bool block_horizontal_wrap::get_row_y(int row, gool::range &y) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    if (row >= 0 && row < ld->rows.size()) {
      auto r = ld->rows[row];
      y      = gool::range(r.y, r.y + r.height - 1);
      return true;
    }
    return false;
  }

  bool block_horizontal_wrap::get_row_at(view &v, int y, int &row) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    int                 nr = n_rows();
    for (int r = 0; r < nr; ++r) {
      gool::range yr;
      if (get_row_y(r, yr) && yr.contains(y)) {
        row = r;
        return true;
      }
    }
    return false;
  }
  bool block_horizontal_wrap::get_col_at(view &v, int x, int &col) {
    return false;
  }
  element *block_horizontal_wrap::at(int row, int col) {
    handle<layout_data> ld = ldata.ptr_of<layout_data>();
    if (row < 0 || row >= ld->rows.size()) return nullptr;
    int idx = col + ld->rows[row].first;
    if (idx < ld->blocks.size()) return ld->blocks[idx];
    return 0;
  }

} // namespace html