#include "html.h"

namespace html {
  block_columns *block_columns::setup_on(view &v, element *el) {
    block_columns *tb = turn_element_to<block_columns>(el);
    return tb;
  }

  /*inline const style* next_element_style( const element* b, view& v )
  {
    if( b->index == b->parent->subs.last_index() ) return element::null_style;
    b = b->parent->subs[b->index + 1];
    if( !b ) return block::null_style;
    return b->current_style(v);
  }
  inline const style* prev_element_style( const block* b, view& v )
  {
    if( b->index == 0 ) return block::null_style;
    if( !b || !b->parent) return block::null_style;
    b = b->parent->subs[b->index - 1];
    return b->current_style(v);
  }*/

  void block_columns::do_layout(view &v) {
    array<range> cols;

    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    int subs_size = ld->blocks.size();
    if (subs_size == 0) {
      ld->dim_min.empty();
      ld->dim_max.empty();
      return;
    }

    int col_spacing_left       = 0;
    int col_spacing_right      = pixels(v, this, cs->border_spacing_x).width();
    int prev_col_spacing_right = 0;

    rect crect = client_rect(v);
    size inner = crect.size();

    int xpos     = crect.left();
    int ypos     = 0;
    int colstart = 0;
    int i        = 0;
    int mih      = 0;

    // int total_springs = 0;

    int pix  = 0;
    int spr  = 0;
    
    int colwidth = 0;

    helement prevb;

    hstyle prev_element_style = element::null_style;

    // simple flow layout
    for (i = 0; i < subs_size;) {
      helement b   = ld->blocks[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) {
        ++i;
        continue;
      }
      if (bcs->visibility == visibility_collapse) {
        premeasure(v, b, bcs, ld->dim);
        ++i;
        continue;
      }

      premeasure(v, b, bcs, ld->dim);

      h_layout_data bld = b->ldata;

      int w = b->min_width(v) + bld->borpad_left() + bld->borpad_right();
      if (colwidth < w) colwidth = w;

      overlapping_y(v, this, prevb, b, pix, spr);
      ypos += pix;

      b->set_width(v, colwidth);

      int minheight =
          b->min_height(v) + bld->borpad_top() + bld->borpad_bottom();

      /*total_springs += bcs->margin[1].flex1000();
      total_springs += bcs->margin[3].flex1000();
      total_springs += bcs->border_width[1].flex1000();
      total_springs += bcs->border_width[3].flex1000();
      total_springs += bcs->padding[1].flex1000();
      total_springs += bcs->padding[3].flex1000();
      total_springs += bcs->height.flex1000();*/

      if ((colstart < i) &&
          ((ypos + minheight + bld->margin_width.bottom()) > inner.y
           //|| (total_springs > 100) // not anymore
           || (bcs->clears & clear_left) ||
           (prev_element_style->clears & clear_right))) {
        xpos += max(col_spacing_left, prev_col_spacing_right);

        cols.push(range(colstart, i - 1));

        layout_column(v, colstart, i, xpos, colwidth);
        colstart = i;
        ypos     = 0;
        xpos += colwidth;
        prev_col_spacing_right = col_spacing_right;
        prevb                  = 0;
        // total_springs = 0;
        colwidth           = 0;
        prev_element_style = element::null_style;
        continue;
      }
      ypos += minheight;
      col_spacing_left  = max(col_spacing_left, bld->margin_width.left());
      col_spacing_right = max(col_spacing_right, bld->margin_width.right());

      int block_outer_height = b->min_height(v) + b->outer_int_y_extra(v);
      if (block_outer_height > mih) mih = block_outer_height;

      prev_element_style = bcs;
      prevb              = b;
      ++i;
    }
    // adjust last col
    if (colstart < subs_size) {
      xpos += max(col_spacing_left, prev_col_spacing_right);

      cols.push(range(colstart, i - 1));

      layout_column(v, colstart, i, xpos, colwidth);
      xpos += colwidth;
      xpos += col_spacing_right;
    }
    ld->dim_min.y = ld->dim_max.y = mih;
    ld->dim_min.x = ld->dim_max.x = xpos;
  }

  void block_columns::layout_column(view &v, int colstart, int colend, int xpos,
                                    int colwidth) {
    // hstyle cs,

    hstyle              cs = get_style(v);
    handle<layout_data> ld = ldata.ptr_of<layout_data>();

    // int i = 0;
    // const int subs_size = ld->blocks.size();

    int       i         = 0;
    const int subs_size = colend - colstart;
    if (subs_size == 0) return;

    rect crect = this->client_rect(v);
    size inner = crect.size();

    flex::engine sc(subs_size * 6 + 1);
    helement    prevb = 0;
    int         pix = 0, spr = 0;
    for (i = colstart; i < colend; i++) {
      helement b   = ld->blocks[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) continue;
      if (b->oof_positioned(v)) continue;

      overlapping_y(v, this, prevb, b, pix, spr);
      sc.add(pix, int_v(), spr);

      // size_v bfs = b->current_style(v)->font_size;

      bcs->used_border_width(1).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);

      sc.add(pix, int_v(), spr);

      bcs->used_padding(1).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);
      sc.add(pix, int_v(), spr);

      int spring_height = bcs->height.flex1000();

      sc.add(spring_height ? b->min_height(v)
                           : b->computed_height(v, ld->dim.y),
             b->max_height(v, ld->dim.y), spring_height);

      // sc.add(spring_height?
      //  b->min_height(v): b->computed_height(v,d->dim.y),
      //  b->max_defined_height(v) , spring_height, pref_height);

      bcs->used_padding(3).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);
      sc.add(pix, int_v(), spr);

      bcs->used_border_width(3).pixels_n_spring_h(v, b, ld->dim.y, pix, spr);
      sc.add(pix, int_v(), spr);

      prevb = b;
    }
    if (!prevb) return;

    overlapping_y(v, this, prevb, 0, pix, spr);
    sc.add(pix, int_v(), spr);

    int content_height = sc.calc(inner.y);

    if (ld->dim_min.y > content_height) content_height = ld->dim_min.y;

    int freespace_a = inner.y - content_height;

    int freespace = min(sc.freespace, freespace_a);
    if (freespace < 0) freespace = 0;

    int posy = 0;

    auto valign = cs->get_block_vertical_align();
    if (cs->display == display_inline_block || cs->display == display_inline)
      valign = valign_top;

    switch (valign) {
    case valign_top: break;
    case valign_bottom: posy += freespace; break;
    case valign_middle: posy += freespace / 2; break;
    }

    int n = 0;
    for (i = colstart; i < colend; i++) {
      helement b   = ld->blocks[i];
      hstyle   bcs = b->get_style(v);

      if (bcs->is_display_none()) continue;
      if (bcs->visibility == visibility_collapse) continue;

      h_layout_data bld = b->ldata;

      if (oof_positioned(v)) {
        b->set_pos(bld->outer_left(), posy + bld->outer_top());
        // reposition(v,b);
        continue;
      }

      int margin = sc.val(n);
      posy += margin;

      bld->margin_width.s.y = margin;
      posy += (bld->border_width.s.y = sc.val(++n));
      posy += (bld->padding_width.s.y = sc.val(++n));
      b->set_pos(xpos + bld->outer_left(), posy);
      b->set_height(v, sc.val(++n));
      posy += bld->dim.y;
      posy += (bld->padding_width.e.y = sc.val(++n));
      posy += (bld->border_width.e.y = sc.val(++n));
      bld->margin_width.e.y = sc.val(++n);
    }
  }

} // namespace html