#ifndef __html_layout_aux_h__
#define __html_layout_aux_h__

#include "tool/tool.h"
#include "gool/gool.h"
#include "html-view.h"
#include "html-dom.h"
#include "html-primitives.h"

namespace html {
  using namespace tool;
  using namespace gool;

  extern slice<hnode> scan_inlines(view &ctx, slice<hnode> &nodes,
                                   bool children_as_blocks = false);
  extern bool         is_space_seq(view &v, slice<hnode> inlines);

  inline bool is_collapsible_margin_root(view &v, element *b) {
    return !b->parent || !b->parent->get_style(v)->flow.is_default();
  }

  /*
  The top margin of an in-flow block-level element
  is adjoining to its first in-flow block-level child's top margin
  if the element has no top border, no top padding, and the child has no
  clearance. http://www.w3.org/TR/CSS21/box.html#collapsing-margins
  */
  inline bool collapse_top_container(view &v, element *b) {
    style *pcs = b->get_style(v);
    if (pcs->overflow_y <= overflow_visible && pcs->get_float() == float_none &&
        (pcs->display == display_block || pcs->display == display_list_item) &&
        (!pcs->has_border(1) && !pcs->has_padding(1)) &&
        !pcs->margin[1].is_spring()
        //&& pcs->margin[1].is_zero()
        && pcs->position < position_relative && pcs->clears == 0 &&
        pcs->flow.is_default() //|| (pcs->flow.ev == flow_vertical && b->tag ==
                               //tag::T_BODY))
        && !is_collapsible_margin_root(v, b))
      return true;
    return false;
  }
  inline bool collapse_top_child(view &v, element *b) {
    style *pcs = b->get_style(v);
    if (pcs->overflow_y <= overflow_visible &&
        pcs->get_float() == float_none
        && (!pcs->has_border(1) && !pcs->has_padding(1)) &&
        pcs->position < position_relative && pcs->clears == 0 &&
        (!pcs->flow.is_defined() || pcs->flow == flow_text))
      return true;
    return false;
  }

  inline bool collapse_bottom_container(view &v, element *b) {
    style *pcs = b->get_style(v);
    if (pcs->overflow_y <= overflow_visible && pcs->get_float() == float_none &&
        (pcs->display == display_block || pcs->display == display_list_item) &&
        (!pcs->has_border(3) && !pcs->has_padding(3)) &&
        !pcs->margin[3].is_spring()
        //&& pcs->margin[3].is_zero()
        && pcs->position < position_relative && pcs->clears == 0 &&
        pcs->flow.is_default() //|| (pcs->flow.ev == flow_vertical && b->tag ==
                               //tag::T_BODY))
        && !is_collapsible_margin_root(v, b))
      return true;
    return false;
  }
  inline bool collapse_bottom_child(view &v, element *b) {
    style *pcs = b->get_style(v);
    if (pcs->overflow_y <= overflow_visible &&
        pcs->get_float() == float_none
        //&& (pcs->display == display_block || pcs->display ==
        //display_list_item)
        && (!pcs->has_border(3) && !pcs->has_padding(3)) &&
        pcs->position < position_relative && pcs->clears == 0 &&
        (!pcs->flow.is_defined() || pcs->flow == flow_text))
      return true;
    return false;
  }

  inline bool collapse_left(view &v, element *b) {
    style *pcs = b->get_style(v);
    if (pcs->overflow_y <= overflow_visible && pcs->get_float() == float_none &&
        (pcs->display == display_block || pcs->display == display_list_item) &&
        (!pcs->has_border(0) && !pcs->has_padding(0)) &&
        !pcs->margin[0].is_spring() && pcs->position < position_relative &&
        pcs->clears == 0 &&
        !pcs->flow
             .is_defined() /*&& parent && parent_style(v)->flow == pcs->flow*/)
      return true;
    return false;
  }

  inline bool collapse_right(view &v, element *b) {
    style *pcs = b->get_style(v);
    if (pcs->overflow_y <= overflow_visible && pcs->get_float() == float_none &&
        (pcs->display == display_block || pcs->display == display_list_item) &&
        (!pcs->has_border(2) && !pcs->has_padding(2)) &&
        !pcs->margin[2].is_spring() && pcs->position < position_relative &&
        pcs->clears == 0 &&
        !pcs->flow
             .is_defined() /*&& parent && parent_style(v)->flow == pcs->flow*/)
      return true;
    return false;
  }
} // namespace html

#endif