#include "html.h"

namespace html {
  namespace tag {

    /*

    http://www.w3.org/TR/CSS2/sample.html
    http://lxr.mozilla.org/mozilla/source/layout/html/document/src/html.css
    http://www.richinstyle.com/test/

    ADDRESS,
    BLOCKQUOTE,
    BODY, DD, DIV,
    DL, DT,
    FIELDSET, FORM,
    FRAME, FRAMESET,
    H1, H2, H3, H4,
    H5, H6, IFRAME,
    NOFRAMES,
    OBJECT, OL, P,
    UL, APPLET,
    CENTER, DIR,
    HR, MENU, PRE   { display: block }
    LI              { display: list-item }
    HEAD            { display: none }
    TABLE           { display: table }
    TR              { display: table-row }
    THEAD           { display: table-header-group }
    TBODY           { display: table-row-group }
    TFOOT           { display: table-footer-group }
    COL             { display: table-column }
    COLGROUP        { display: table-column-group }
    TD, TH          { display: table-cell }
    CAPTION         { display: table-caption }
    TH              { font-weight: bolder; text-align: center }
    CAPTION         { text-align: center }
    BODY            { padding: 8px; line-height: 1.33 }
    H1              { font-size: 2em; margin: .67em 0 }
    H2              { font-size: 1.5em; margin: .83em 0 }
    H3              { font-size: 1.17em; margin: 1em 0 }
    H4, P,
    BLOCKQUOTE, UL,
    FIELDSET, FORM,
    OL, DL, DIR,
    MENU            { margin: 1.33em 0 }
    H5              { font-size: .83em; line-height: 1.17em; margin: 1.67em 0 }
    H6              { font-size: .67em; margin: 2.33em 0 }
    H1, H2, H3, H4,
    H5, H6, B,
    STRONG          { font-weight: bolder }
    BLOCKQUOTE      { margin-left: 40px; margin-right: 40px }
    I, CITE, EM,
    VAR, ADDRESS    { font-style: italic }
    PRE, TT, CODE,
    KBD, SAMP       { font-family: monospace }
    PRE             { white-space: pre }
    BIG             { font-size: 1.17em }
    SMALL, SUB, SUP { font-size: .83em }
    SUB             { vertical-align: sub }
    SUP             { vertical-align: super }
    S, STRIKE, DEL  { text-decoration: line-through }
    HR              { border: 1px inset }
    OL, UL, DIR,
    MENU, DD        { margin-left: 40px }
    OL              { list-style-type: decimal }
    OL UL, UL OL,
    UL UL, OL OL    { margin-top: 0; margin-bottom: 0 }
    U, INS          { text-decoration: underline }
    CENTER          { text-align: center }
    BR:before       { content: "\A" }

    // An example of style for HTML 4.0's ABBR/ACRONYM elements

    ABBR, ACRONYM   { font-variant: small-caps; letter-spacing: 0.1em }
    A[href]         { text-decoration: underline }
    :focus          { outline: thin dotted invert }

    */

    bool setup_tag_style(tag::TAG_TYPE tt, style_prop_list *ps) {
      //ps->set(cssa_color, value::inherit_val());
      switch (tt) {
      case tag::BLOCK_TAG: 
        ps->set(cssa_display, ENUMV(display_e)(display_block)); break;
      case tag::INLINE_BLOCK_TAG:
        ps->set(cssa_display, display_ev(display_inline_block));
        ps->set(cssa_width, value::make_literal_length(value::$max_content));
        break;
      case tag::INLINE_TAG: 
        ps->set(cssa_display, display_ev(display_inline)); 
        break;
      case tag::TABLE_TAG: ps->set(cssa_display, display_ev(display_table)); 
        break;
      case tag::TABLE_BODY_TAG:
        ps->set(cssa_display, display_ev(display_table_body));
        ps->set(cssa_flow, value("table-body"));
        break;
      case tag::TABLE_ROW_TAG:
        //ps->display = display_table_row;
        //ps->flow    = flow_table_row;
        ps->set(cssa_display, display_ev(display_table_row));
        ps->set(cssa_flow, value("table-row"));
        break;
      case tag::TABLE_CELL_TAG: 
        //ps->display = display_table_cell; 
        ps->set(cssa_display, display_ev(display_table_cell));
        break;
      case tag::UNKNOWN_TAG: 
        //ps->display = display_contents; 
        ps->set(cssa_display, display_ev(display_contents));
        break;
      case tag::INFO_TAG: 
        //ps->display = _display_none; 
        ps->set(cssa_display, display_ev(display_none));
        break;
      default: assert(false); return false;
      }
      return true;
    }

    void init_svg_child_style(style_prop_list *s) {
      s->set(cssa_flow, value("svg-element"));
      s->set(cssa_fill, value::inherit_val());
      s->set(cssa_fill_opacity, value(1.0));
      s->set(cssa_fill_rule, value::inherit_val());
      s->set(cssa_stroke, value::inherit_val());
      /*WRONG, breaks inheritance s->stroke_width      = size_v();
      s->stroke_linecap    = enum_v(0);
      s->stroke_linejoin   = enum_v(0);
      s->stroke_miterlimit = 4;
      s->stroke_dasharray  = string();
      s->stroke_dashoffset = size_v(0);
      s->stroke_opacity    = opacity_v(255);*/
    }

    void init_styles(hash_table<string, tag_def> &tbl) {
      for (int i = 0; i < tbl.size(); ++i) {
        style_prop_list *ps     = new style_prop_list();
        tbl(i).plist = ps;
        setup_tag_style(type(symbol_t(i)), ps);
      }

      // ustring sys_font_name = "system"; int sys_font_size; bool
      // sys_font_bold; bool sys_font_italic;
      // gool::get_system_font(sys_font_name,sys_font_size,sys_font_bold,sys_font_italic);

      //tbl(T__UNKNOWN).istyle->display = display_contents;

      tbl(T_B).plist->set(cssa_font_weight, value(700)); // bold
      tbl(T_STRONG).plist->set(cssa_font_weight, value(700));
      
      tbl(T_I).plist->set(cssa_font_style, font_style_ev(font_style_italic));
      tbl(T_EM).plist->set(cssa_font_style, font_style_ev(font_style_italic));
      tbl(T_DFN).plist->set(cssa_font_style, font_style_ev(font_style_italic));
      tbl(T_CITE).plist->set(cssa_font_style, font_style_ev(font_style_italic));

      tbl(T_NOBR).plist->set(cssa_white_space, white_space_ev(white_space_nowrap));
        
      tbl(T_SUB).plist->set(cssa_vertical_align, valign_ev(valign_sub));
      tbl(T_SUB).plist->set(cssa_font_size, value::make_length(0.83, value::em));

      tbl(T_SUP).plist->set(cssa_vertical_align, valign_ev(valign_super));
      tbl(T_SUP).plist->set(cssa_font_size, value::make_length(0.83, value::em));
            
      ustring monospace("monospace");
      tbl(T_TT).plist->set(cssa_font_family, value(monospace));
      tbl(T_CODE).plist->set(cssa_font_family, value(monospace));
      tbl(T_SAMP).plist->set(cssa_font_family, value(monospace));
      tbl(T_KBD).plist->set(cssa_font_family, value(monospace));
      
      tbl(T_S).plist->set(cssa_text_decoration_line, text_decoration_ev(text_decoration_linethrough));
      tbl(T_STRIKE).plist->set(cssa_text_decoration_line, text_decoration_ev(text_decoration_linethrough));
      tbl(T_DEL).plist->set(cssa_text_decoration_line, text_decoration_ev(text_decoration_linethrough));
    
      tbl(T_MARK).plist->set(cssa_background_color, value(argb(0xfc, 0xfc, 0x93)));

      tbl(T_U).plist->set(cssa_text_decoration_line, text_decoration_ev(text_decoration_underline));
      tbl(T_INS).plist->set(cssa_text_decoration_line, text_decoration_ev(text_decoration_underline));

      tbl(T_BIG).plist->set(cssa_font_size, value::make_length(1.17, value::em));
      tbl(T_SMALL).plist->set(cssa_font_size, value::make_length(0.83, value::em));

      tbl(T_PRE).plist->set(cssa_font_family, value(monospace));
      tbl(T_PRE).plist->set(cssa_margin_top, value::make_length(1, value::em));
      tbl(T_PRE).plist->set(cssa_margin_bottom, value::make_length(1, value::em));
      tbl(T_PRE).plist->set(cssa_white_space, white_space_ev(white_space_pre));

      tbl(T_STYLE).plist->set(cssa_white_space, white_space_ev(white_space_pre));
      tbl(T_SCRIPT).plist->set(cssa_white_space, white_space_ev(white_space_pre));

      tbl(T_P).plist->set(cssa_margin_top, value::make_length(1, value::em));
      tbl(T_P).plist->set(cssa_margin_bottom, value::make_length(1, value::em));

      //tbl(T_FONT).istyle->display = display_contents;

      tbl(T_IMG).plist->set(cssa_width, value::make_literal_length(value::$auto));
      tbl(T_IMG).plist->set(cssa_height, value::make_literal_length(value::$auto));
      tbl(T_IMG).plist->set(cssa_flow, flow_ev(flow_image));
      tbl(T_IMG).plist->set(cssa_foreground_repeat, image_repeat_ev(background_no_repeat)); // background_no_repeat?
      tbl(T_IMG).plist->set(cssa_foreground_clip, clip_ev(clip_content_box));
      tbl(T_IMG).plist->set(cssa_foreground_position_top, 50_pr);
      tbl(T_IMG).plist->set(cssa_foreground_position_left, 50_pr);
      tbl(T_IMG).plist->set(cssa_foreground_width, 100_pr);
      tbl(T_IMG).plist->set(cssa_foreground_height, 100_pr);

      tbl(T_PICTURE).plist->set(cssa_width, value::make_literal_length(value::$auto));
      tbl(T_PICTURE).plist->set(cssa_height, value::make_literal_length(value::$auto));
      tbl(T_PICTURE).plist->set(cssa_flow, flow_ev(flow_image));
      tbl(T_PICTURE).plist->set(cssa_foreground_repeat, image_repeat_ev(background_no_repeat)); // background_no_repeat?
      tbl(T_PICTURE).plist->set(cssa_foreground_clip, clip_ev(clip_content_box));
      tbl(T_PICTURE).plist->set(cssa_foreground_position_top, value::make_percent_length(50));
      tbl(T_PICTURE).plist->set(cssa_foreground_position_left, value::make_percent_length(50));
      tbl(T_PICTURE).plist->set(cssa_foreground_width, value::make_percent_length(100));
      tbl(T_PICTURE).plist->set(cssa_foreground_height, value::make_percent_length(100));

      tbl(T_POPUP).plist->set(cssa_background_color, value(rgb(255, 255, 255)));
      tbl(T_POPUP).plist->set(cssa_display, display_ev(display_none));

      //tbl(T_TEXT).istyle->margin[1] = 0;
      //tbl(T_TEXT).istyle->margin[3] = 0;
      tbl(T_TEXT).plist->set(cssa_flow, flow_ev(flow_text));

      tbl(T_CENTER).plist->set(cssa_text_align, halign_ev(align_center));

      tbl(T_H1).plist->set(cssa_margin_top, value::make_length(0.67, value::em));
      tbl(T_H1).plist->set(cssa_margin_bottom, value::make_length(0.67, value::em));
      tbl(T_H1).plist->set(cssa_font_size, value::make_length(2, value::em));
      tbl(T_H1).plist->set(cssa_font_weight, value(700)); // bold

      tbl(T_H2).plist->set(cssa_margin_top, value::make_length(0.83, value::em));
      tbl(T_H2).plist->set(cssa_margin_bottom, value::make_length(0.83, value::em));
      tbl(T_H2).plist->set(cssa_font_size, value::make_length(1.5, value::em));
      tbl(T_H2).plist->set(cssa_font_weight, value(700)); // bold

      tbl(T_H3).plist->set(cssa_margin_top, value::make_length(1, value::em));
      tbl(T_H3).plist->set(cssa_margin_bottom, value::make_length(1, value::em));
      tbl(T_H3).plist->set(cssa_font_size, value::make_length(1.17, value::em));
      tbl(T_H3).plist->set(cssa_font_weight, value(700)); // bold

      tbl(T_H4).plist->set(cssa_margin_top, value::make_length(1.33, value::em));
      tbl(T_H4).plist->set(cssa_margin_bottom, value::make_length(1.33, value::em));
      tbl(T_H4).plist->set(cssa_font_size, value::make_length(1, value::em));
      tbl(T_H4).plist->set(cssa_font_weight, value(700)); // bold

      tbl(T_H5).plist->set(cssa_margin_top, value::make_length(1.67, value::em));
      tbl(T_H5).plist->set(cssa_margin_bottom, value::make_length(1.67, value::em));
      tbl(T_H5).plist->set(cssa_font_size, value::make_length(0.83, value::em));
      tbl(T_H5).plist->set(cssa_font_weight, value(700)); // bold

      tbl(T_H6).plist->set(cssa_margin_top, value::make_length(2.33, value::em));
      tbl(T_H6).plist->set(cssa_margin_bottom, value::make_length(2.33, value::em));
      tbl(T_H6).plist->set(cssa_font_size, value::make_length(0.67, value::em));
      tbl(T_H6).plist->set(cssa_font_weight, value(700)); // bold

      tbl(T_HR).plist->set(cssa_margin_top, value::make_length(6, value::dip));
      tbl(T_HR).plist->set(cssa_margin_bottom, value::make_length(6, value::dip));
      tbl(T_HR).plist->set(cssa_height, value::make_length(0, value::dip));

      tbl(T_HR).plist->set(cssa_border_top_width, 1_dip);
      tbl(T_HR).plist->set(cssa_border_bottom_width, 1_dip);

      tbl(T_HR).plist->set(cssa_border_top_style, border_style_ev(border_solid));
      tbl(T_HR).plist->set(cssa_border_bottom_style, border_style_ev(border_solid));

      tbl(T_HR).plist->set(cssa_border_top_color, color_v(SC_DIALOG_SHADOW));
      tbl(T_HR).plist->set(cssa_border_bottom_style, color_v(SC_DIALOG_LIGHT));

      tbl(T_BODY).plist->set(cssa_margin, 8_dip);
      tbl(T_BODY).plist->set(cssa_overflow, overflow_ev(overflow_none));
      tbl(T_BODY).plist->set(cssa_width, 1_fx);
      tbl(T_BODY).plist->set(cssa_height, 1_fx);

      tbl(T_LEGEND).plist->set(cssa_margin_left, 6_dip);
      tbl(T_LEGEND).plist->set(cssa_margin_right, 1_fx);
      tbl(T_LEGEND).plist->set(cssa_padding_left, 4_dip);
      tbl(T_LEGEND).plist->set(cssa_padding_right, 4_dip);
      tbl(T_LEGEND).plist->set(cssa_max_width, length_max_content);
      tbl(T_LEGEND).plist->set(cssa_width, 1_fx);
      tbl(T_LEGEND).plist->set(cssa_color, color_v(SC_CAPTION));

      tbl(T_FIELDSET).plist->set(cssa_border_color, color_v(SC_DIALOG_DKSHADOW));
      tbl(T_FIELDSET).plist->set(cssa_border_width, 1_dip);
      tbl(T_FIELDSET).plist->set(cssa_border_style, border_style_ev(border_solid));
      tbl(T_FIELDSET).plist->set(cssa_padding, items_of({value::make_length(-0.7,value::em),4_dip,4_dip,4_dip }));
      tbl(T_FIELDSET).plist->set(cssa_margin_top, 0.7_em);
      tbl(T_FIELDSET).plist->set(cssa_margin_bottom, 1_dip);

      tbl(T_HTML).plist->set(cssa_color, color_v(SC_WINDOW_TEXT));
      tbl(T_HTML).plist->set(cssa_size, 1_fx);
      tbl(T_HTML).plist->set(cssa_background_color, color_v(SC_WINDOW));
      tbl(T_HTML).plist->set(cssa_text_selection_color, color_v(SC_SELECTION_TEXT));
      tbl(T_HTML).plist->set(cssa_text_selection_background_color, color_v(SC_SELECTION));
      tbl(T_HTML).plist->set(cssa_clear, clear_ev(clear_both));
    

      tbl(T_FRAME).plist->set(cssa_flow, flow_ev(flow_vertical));
      tbl(T_IFRAME).plist->set(cssa_flow, flow_ev(flow_vertical));

      tbl(T_FRAMESET).plist->set(cssa_overflow, overflow_ev(overflow_hidden));

      tbl(T_TOOLBAR).plist->set(cssa_flow, flow_ev(flow_horizontal));
      tbl(T_TOOLBAR).plist->set(cssa_background_color, color_v(SC_DIALOG_SURFACE));


      // TABLE->max_width.set_literal(size_v::special_values::$auto);

      tbl(T_TABLE).plist->set(cssa_border_color, color_v(SC_DIALOG_LIGHT));
      tbl(T_TABLE).plist->set(cssa_border_style, border_style_ev(border_solid));
      tbl(T_TABLE).plist->set(cssa_border_width, 0_dip);
      tbl(T_TABLE).plist->set(cssa_width, length_auto);
      tbl(T_TABLE).plist->set(cssa_border_spacing, 2_dip);
      tbl(T_TABLE).plist->set(cssa_padding, 2_dip);
      tbl(T_TABLE).plist->set(cssa_overflow, overflow_ev(overflow_none));

      tbl(T_TBODY).plist->set(cssa_width, 1_fx);
      tbl(T_TBODY).plist->set(cssa_overflow, overflow_ev(overflow_none));
      tbl(T_TBODY).plist->set(cssa_border_collapse, value::inherit_val());

      tbl(T_THEAD).plist->set(cssa_width, 1_fx);
      tbl(T_THEAD).plist->set(cssa_overflow, overflow_ev(overflow_none));
      tbl(T_THEAD).plist->set(cssa_border_collapse, value::inherit_val());

      tbl(T_TFOOT).plist->set(cssa_width, 1_fx);
      tbl(T_TFOOT).plist->set(cssa_overflow, overflow_ev(overflow_none));
      tbl(T_TFOOT).plist->set(cssa_border_collapse, value::inherit_val());

      tbl(T_TR).plist->set(cssa_border_collapse, value::inherit_val());

      //tbl(T_TD).istyle->width.clear(); ???
      tbl(T_TD).plist->set(cssa_border_color, color_v(SC_DIALOG_LIGHT));
      tbl(T_TD).plist->set(cssa_border_style, border_style_ev(border_solid));
      tbl(T_TD).plist->set(cssa_border_width, 0_dip);
      tbl(T_TD).plist->set(cssa_vertical_align, valign_ev(valign_middle));
      tbl(T_TD).plist->set(cssa_overflow, overflow_ev(overflow_none));
      tbl(T_TD).plist->set(cssa_border_collapse, value::inherit_val());

      tbl(T_TH).plist->set(cssa_border_color, color_v(SC_DIALOG_LIGHT));
      tbl(T_TH).plist->set(cssa_border_style, border_style_ev(border_solid));
      tbl(T_TH).plist->set(cssa_border_width, 0_dip);
      tbl(T_TH).plist->set(cssa_vertical_align, valign_ev(valign_middle));
      tbl(T_TH).plist->set(cssa_overflow, overflow_ev(overflow_none));
      tbl(T_TH).plist->set(cssa_border_collapse, value::inherit_val());

      tbl(T_CAPTION).plist->set(cssa_width, length_auto);

      tbl(T_BLOCKQUOTE).plist->set(cssa_margin, items_of({1_em,2_em}));

      tbl(T_UL).plist->set(cssa_margin_top, 1_em);
      tbl(T_UL).plist->set(cssa_margin_bottom, 1_em);
      tbl(T_UL).plist->set(cssa_padding_left, 2_em);
      tbl(T_UL).plist->set(cssa_list_style_type, list_style_type_ev(list_style_disc));

      tbl(T_OL).plist->set(cssa_margin_top, 1_em);
      tbl(T_OL).plist->set(cssa_margin_bottom, 1_em);
      tbl(T_OL).plist->set(cssa_padding_left, 2_em);
      tbl(T_OL).plist->set(cssa_list_style_type, list_style_type_ev(list_style_decimal));

      tbl(T_LI).plist->set(cssa_display, display_ev(display_list_item));

      tbl(T_DL).plist->set(cssa_margin_top, 1_em);
      tbl(T_DL).plist->set(cssa_margin_bottom, 1_em);

      tbl(T_DD).plist->set(cssa_padding_left, 2_em);

      tbl(T_DIR).plist->set(cssa_margin_top, 1_em);
      tbl(T_DIR).plist->set(cssa_margin_bottom, 1_em);
      tbl(T_DIR).plist->set(cssa_padding_left, 2_em);

      tbl(T_MENU).plist->set(cssa_margin_top, 1_em);
      tbl(T_MENU).plist->set(cssa_margin_bottom, 1_em);
      tbl(T_MENU).plist->set(cssa_padding_left, 2_em);

      tbl(T_STYLE).plist->set(cssa_behavior, value("style-bag"));

      tbl(T_REACTOR).plist->set(cssa_behavior, value("reactor"));
      tbl(T_REACTOR).plist->set(cssa_white_space, white_space_ev(white_space_pre));
      
      tbl(T_COMPONENT).plist->set(cssa_behavior, value("reactor"));
      
      tbl(T_INPUT).plist->set(cssa_width, length_min_content);
      tbl(T_SELECT).plist->set(cssa_width, length_min_content);
      tbl(T_TEXTAREA).plist->set(cssa_width, length_min_content);

      tbl(T_DETAILS).plist->set(cssa_behavior, value("details"));
      tbl(T_SUMMARY).plist->set(cssa_behavior, value("button"));

      tbl(T_OUTPUT).plist->set(cssa_behavior, value("output"));
      tbl(T_OUTPUT).plist->set(cssa_width, length_max_content);
      tbl(T_OUTPUT).plist->set(cssa_height, 1.2_em);

      tbl(T__BEFORE).plist->set(cssa_text_decoration_style, value::inherit_val());
      tbl(T__AFTER).plist->set(cssa_text_decoration_style, value::inherit_val());
      tbl(T__MARKER).plist->set(cssa_flow, flow_ev(flow_text));

      tbl(T_HTMLAREA).plist->set(cssa_behavior, value("htmlarea"));
      tbl(T_LABEL).plist->set(cssa_behavior, value("label"));

      tbl(T_VIDEO).plist->set(cssa_behavior, value("video"));
      tbl(T_VIDEO).plist->set(cssa_foreground_repeat, image_repeat_ev(background_no_repeat)); // background_no_repeat?
      tbl(T_VIDEO).plist->set(cssa_foreground_clip, clip_ev(clip_content_box));
      tbl(T_VIDEO).plist->set(cssa_foreground_position_top, 50_pr);
      tbl(T_VIDEO).plist->set(cssa_foreground_position_left, 50_pr);
      tbl(T_VIDEO).plist->set(cssa_foreground_width, length_contain);
      tbl(T_VIDEO).plist->set(cssa_foreground_height, length_contain);

      tbl(T_CANVAS).plist->set(cssa_behavior, value("graphics"));
      tbl(T_CANVAS).plist->set(cssa_stroke_width, 1_dip);
      tbl(T_CANVAS).plist->set(cssa_stroke, color_v::current_val());
      tbl(T_CANVAS).plist->set(cssa_fill, color_v::current_val());

      tbl(T_PAGEFRAME).plist->set(cssa_behavior, value("page-content-box"));
      tbl(T_PAGEBOX).plist->set(cssa_behavior, value("page-box"));

      tbl(T_SVG).plist->set(cssa_size, length_auto);
      tbl(T_SVG).plist->set(cssa_flow, flow_ev(flow_svg));
      tbl(T_SVG).plist->set(cssa_overflow, overflow_ev(overflow_hidden));
      tbl(T_SVG).plist->set(cssa_background_color, color_v(SC_WINDOW));
      tbl(T_SVG).plist->set(cssa_font_rendering_mode, font_rendering_mode_ev(font_rendering_mode_sub_pixel_scaled));

      init_svg_child_style(tbl(T_G).plist);
      init_svg_child_style(tbl(T_RECT).plist);
      init_svg_child_style(tbl(T_CIRCLE).plist);
      init_svg_child_style(tbl(T_ELLIPSE).plist);
      init_svg_child_style(tbl(T_LINE).plist);
      init_svg_child_style(tbl(T_POLYLINE).plist);
      init_svg_child_style(tbl(T_POLYGON).plist);
      init_svg_child_style(tbl(T_SWITCH).plist);
      init_svg_child_style(tbl(T_USE).plist);

      {
        style_prop_list *ps             = tbl(T_PATH).plist;
        ps->set(cssa_flow, flow_ev(flow_svg_element));
        ps->set(cssa_fill, value::inherit_val());
        ps->set(cssa_fill_opacity, value::inherit_val());
        ps->set(cssa_fill_rule, value::inherit_val());
        ps->set(cssa_stroke, value::inherit_val());
        ps->set(cssa_stroke_width, value::inherit_val());
        ps->set(cssa_stroke_linecap, value::inherit_val());
        ps->set(cssa_stroke_linejoin, value::inherit_val());
        ps->set(cssa_stroke_dasharray, value::inherit_val());
        ps->set(cssa_stroke_dashoffset, value::inherit_val());
        ps->set(cssa_stroke_opacity, value::inherit_val());
      }

      tbl(T_RADIALGRADIENT).plist->set(cssa_flow, flow_ev(flow_svg_element));
      tbl(T_LINEARGRADIENT).plist->set(cssa_flow, flow_ev(flow_svg_element));
      tbl(T_STOP).plist->set(cssa_flow, flow_ev(flow_svg_element));
    }

  } // namespace tag
} // namespace html
