#include "html.h"

namespace html {
  // floats_ctx

  floats_ctx::floats_ctx(view &v, element *parent) : sandbox(parent) {
    reset(v);
  }

  inline void drop_layout_until(element *sandbox, element *f) {
    element *t = f->get_owner();
    while (t) {
      if (t == sandbox) break;
      t->ldata->drop_minmax_dim();
      // t->min_content_width.clear();
      // t->min_content_height.clear();
      t = t->get_owner();
    }
  }

  void floats_ctx::reset(view &v) {
    xr.s = 0;
    xr.e = sandbox->ldata->dim.x;
    for (int l = 0; l < lefts.size(); l++) {
      element *b = lefts[l];
      drop_layout_until(sandbox, b);
    }
    for (int r = 0; r < rights.size(); r++) {
      element *b = rights[r];
      drop_layout_until(sandbox, b);
    }
    lefts.clear();
    rights.clear();
  }

  void floats_ctx::push_left(view &v, int y, element *blk) {
    remove(blk);
    if (blk->collapsed()) return;

    size dim = blk->margin_box(v).size();

    if (blk->get_style(v)->clears_left() && lefts.size())
      y = lefts.last()->margin_box(v, element::TO_LAYOUT_PARENT).bottom() + 1;
    if (lefts.size())
      y = max(y, lefts.last()->margin_box(v, element::TO_LAYOUT_PARENT).top());
    if (rights.size())
      y = max(y, rights.last()->margin_box(v, element::TO_LAYOUT_PARENT).top());

    gool::range rr = get_space_at(v, range(y, y + dim.y - 1), blk->get_owner());
    if (rr.length() < dim.x) {
      y  = find_free_space(v, range(y, y + dim.y - 1), dim.x, blk->get_owner());
      rr = get_space_at(v, range(y, y + dim.y - 1), blk->get_owner());
    }

    lefts.push(blk);

    blk->set_pos(rr.s + blk->ldata->outer_left(), y + blk->ldata->outer_top() );
  }
  void floats_ctx::push_right(view &v, int y, element *blk) {
    remove(blk);

    if (blk->collapsed()) return;

    size dim = blk->margin_box(v).size();

    if (blk->get_style(v)->clears_right() && rights.size())
      y = rights.last()->margin_box(v, element::TO_LAYOUT_PARENT).bottom() + 1;
    if (lefts.size())
      y = max(y, lefts.last()->margin_box(v, element::TO_LAYOUT_PARENT).top());
    if (rights.size())
      y = max(y, rights.last()->margin_box(v, element::TO_LAYOUT_PARENT).top());

    gool::range rr = get_space_at(v, range(y, y + dim.y - 1), blk->get_owner());
    if (rr.length() < dim.x) {
      y  = find_free_space(v, range(y, y + dim.y - 1), dim.x, blk->get_owner());
      rr = get_space_at(v, range(y, y + dim.y - 1), blk->get_owner());
    }

    rights.push(blk);

    blk->set_pos(rr.e - dim.x + blk->ldata->outer_left(), y + blk->ldata->outer_top());
  }

  range y_outer_range(view &v, element *b, element *sandbox) {
    range y = b->margin_box(v).y();
    y += // b->doc_pos(v).y - sandbox->doc_pos(v).y;
        b->rel_pos(v, sandbox).y;
    return y;
  }
  range x_outer_range(view &v, element *b, element *sandbox) {
    range x = b->margin_box(v).x();
    x += b->rel_pos(v, sandbox).x;
    return x;
  }

  range floats_ctx::get_space_at(view &v, range y, element *for_blk) {
    gool::range xx(xr);
    element *   p = for_blk;
    while (p && (p != sandbox)) {
      if (p->c_style->display != display_inline) {
        rect rcp(p->rel_pos(v, sandbox), p->dim());
        xx &= rcp.x();
      }
      p = p->get_owner();
    }
    if (xx.s > xx.e) xx.e = xx.s;

    for (int l = 0; l < lefts.size(); l++) {
      element *b = lefts[l];
      if (y_outer_range(v, b, sandbox).overlaps_with(y)) {
        gool::range xt = x_outer_range(v, b, sandbox);
        if (xx.s < xt.e) xx.s = xt.e;
      }
    }
    for (int r = 0; r < rights.size(); r++) {
      element *b = rights[r];
      if (y_outer_range(v, b, sandbox).overlaps_with(y)) {
        gool::range xt = x_outer_range(v, b, sandbox);
        if (xx.e > xt.s) xx.e = xt.s;
      }
    }
    // assert(xx.length() > 0);
    return xx;
  }

  void floats_ctx::remove(element *blk) {
    for (int l = 0; l < lefts.size(); l++) {
      if (lefts[l] == blk) {
        lefts.remove(l);
        return;
      }
    }
    for (int r = 0; r < rights.size(); r++) {
      if (rights[r] == blk) {
        rights.remove(r);
        return;
      }
    }
  }

  bool floats_ctx::has(element *blk) const {
    for (int l = 0; l < lefts.size(); l++) {
      if (lefts[l] == blk) { return true; }
    }
    for (int r = 0; r < rights.size(); r++) {
      if (rights[r] == blk) { return true; }
    }
    return false;
  }

  int floats_ctx::find_free_space(view &v, range y, int width,
                                  element *for_blk) {
    if (is_empty()) return y.s;

    array<int> points(lefts.size() + rights.size());
    points.size(0);

    for (int l = 0; l < lefts.size(); l++) {
      element *b  = lefts[l];
      range    yy = b->margin_box(v, element::TO_PARENT).y();
      if (yy.e > y.s) points.push(yy.e);
      if (yy.s > y.s) points.push(yy.s);
    }

    for (int r = 0; r < rights.size(); r++) {
      element *b  = rights[r];
      range    yy = b->margin_box(v, element::TO_PARENT).y();
      if (yy.e > y.s) points.push(yy.e);
      if (yy.s > y.s) points.push(yy.s);
    }

    if (points.size() == 0) return y.s;

    sort<int>(points.head(), points.size());
    int len = y.length();
    int ty  = y.s;

    for (int i = 0; i < points.size(); ++i) {
      ty = points[i] + 1;
      range ry(ty, ty + len);
      range xx = get_space_at(v, ry, for_blk);
      if (xx == xr) return ty;
      if (xx.length() >= width) return ty;
    }
    return ty;
  }

  int floats_ctx::get_next_y(view &v, int y, int clears) {
    if ((clears & clear_left) != 0)
      for (int l = 0; l < lefts.size(); l++) {
        element *b  = lefts[l];
        range    yy = b->margin_box(v, element::TO_PARENT).y();
        if (yy.contains(y)) {
          if (yy.e > y) y = yy.e;
        }
      }
    if ((clears & clear_right) != 0)
      for (int r = 0; r < rights.size(); r++) {
        element *b  = rights[r];
        range    yy = b->margin_box(v, element::TO_PARENT).y();
        if (yy.contains(y)) {
          if (yy.e > y) y = yy.e;
        }
      }
    return y;
  }

  int floats_ctx::get_max_y(view &v) {
    if (is_empty()) return 0;

    int y = 0;
    for (int l = 0; l < lefts.size(); l++) {
      element *b  = lefts[l];
      range    yy = b->margin_box(v, element::TO_PARENT).y();
      if (yy.e > y) y = yy.e;
    }
    for (int r = 0; r < rights.size(); r++) {
      element *b  = rights[r];
      range    yy = b->margin_box(v, element::TO_PARENT).y();
      if (yy.e > y) y = yy.e;
    }
    return y;
  }

  void floats_ctx::draw(view &v, graphics *sf, point p) {
    int i;
    for (i = 0; i < lefts.size(); i++) {
      element *b = lefts[i];
      if (!b->doc()) {
        lefts.remove(i);
        i--;
        continue;
      }
      gool::point pc = b->pos() + p;
      // if(!sf.is_dirty(rc))
      //  continue;
      if (b->positioned(v)) continue;
      if (!b->collapsed()) {
        b->draw(v, sf, pc);
        b->draw_outline(v, sf, pc);
      }
    }
    for (i = 0; i < rights.size(); i++) {
      element *b = rights[i];
      if (!b->doc()) {
        rights.remove(i);
        i--;
        continue;
      }
      // gool::rect rc = b->border_place();
      // rc += p;
      gool::point pc = b->pos() + p;
      // if(!sf.is_dirty(rc))
      //  continue;
      if (b->positioned(v)) continue;
      if (!b->collapsed()) {
        b->draw(v, sf, pc);
        b->draw_outline(v, sf, pc);
      }
    }
  }

  bookmark floats_ctx::find(view &v, gool::point docp) {
#if NOT_YET
    int      i;
    element *b;
    for (i = 0; i < lefts.size(); i++) {
      b = lefts[i];
      rect rc(b->pos, b->dim);
      if (rc && docp) goto IS_INSIDE;
    }
    for (i = 0; i < rights.size(); i++) {
      b = rights[i];
      rect rc(b->pos, b->dim);
      if (rc && docp) goto IS_INSIDE;
    }
    return bookmark();
  IS_INSIDE:
    return b->find(docp - b->pos, v);
#endif
    return bookmark();
  }

  element *floats_ctx::find_element(view &v, gool::point docp) {
    int      i;
    element *b = 0;
    for (i = 0; i < lefts.size(); i++) {
      b           = lefts[i];
      element *tb = b->find_element(v, docp - b->pos());
      if (tb) return tb;
    }
    for (i = 0; i < rights.size(); i++) {
      b           = rights[i];
      element *tb = b->find_element(v, docp - b->pos());
      if (tb) return tb;
    }
    return 0;
  }

  int floats_ctx::get_min_width(view &v) {
    int          i;
    element *    b;
    inc_max<int> miw;
    for (i = 0; i < lefts.size(); i++) {
      b     = lefts[i];
      int w = b->min_width(v) + b->outer_int_x_extra(v);
      miw <<= w;
    }
    for (i = 0; i < rights.size(); i++) {
      b     = rights[i];
      int w = b->min_width(v) + b->outer_int_x_extra(v);
      miw <<= w;
    }
    return miw;
  }

  int floats_ctx::get_max_width(view &v) {
    int          i;
    element *    b;
    inc_max<int> maw;
    for (i = 0; i < lefts.size(); i++) {
      b     = lefts[i];
      int w = b->max_width(v) + b->outer_int_x_extra(v);
      maw <<= w;
    }
    for (i = 0; i < rights.size(); i++) {
      b     = rights[i];
      int w = b->max_width(v).val(UNKNOWN_MAX_WIDTH) + b->outer_int_x_extra(v);
      maw <<= w;
    }
    return maw;
  }

} // namespace html