#ifndef __html_event_target_h__
#define __html_event_target_h__

#pragma once

#include "tool/tool.h"
#include "gool/gool.h"
#include "html-primitives.h"
#include <functional>

#if defined(SCITERJS)
#include "xdomjs/xjs.h"
#endif

namespace html 
{
  using namespace tool;
  using namespace gool;

  struct event;

  struct subscription : resource 
  {
    struct flags {
      uint capture : 1;
      uint once : 1;
      uint passive : 1;
      uint property : 1; // 1 if this reflects property like element.onclick = function() {} 
    };

    uint_v  event_group;
    uint_v  event_type;
    uint_v  event_reason;
    ustring event_name;
    ustring event_ns;
    ustring event_selector;
    ustring event_command;
    bool    sinking = false; // a.k.a. capture
    bool    once = false;
    bool    passive = false;
    bool    property = false;
    weak_handle<element> receiver;

#if defined(SCITER)
    typedef tis::value function_ref;
    function_ref fcn = 0;
#elif defined(SCITERJS)
    typedef qjs::hvalue function_ref;
    function_ref fcn;
#endif

    subscription() {}
    subscription(const ustring &full_name) { parse(full_name); }

    subscription(function_ref e_fcn, wchars full_name, wchars selector = wchars())
      : fcn(e_fcn), event_selector(selector) {
      parse(full_name);
    }

    ~subscription() {
      //fcn = fcn;
    }

    /*bool match(function_ref e_fcn, uint_v e_group, uint_v e_type, uint_v e_reason) {
      if (event_group.is_defined() && event_group != e_group) return false;
      if (event_type.is_defined() && event_type != e_type) return false;
      if (event_reason.is_defined() && event_reason != e_reason) return false;
      return fcn == e_fcn;
    }*/
    bool match(const event& evt) const;
    bool match(const subscription& other) const;

    bool match_click(const event& evt) const {
      auto et = evt.event_type();
      if (evt.event_group() == HANDLE_MOUSE && et == MOUSE_CLICK)
        return true;
      if (evt.event_group() == HANDLE_BEHAVIOR_EVENT) 
      {
        return et == BUTTON_CLICK ||
               et == HYPERLINK_CLICK ||
               et == MENU_ITEM_CLICK || 
               et == CLICK;
      }
      return false;
    }

    bool match_click(const subscription& other) const {
      if (other.event_group == HANDLE_MOUSE && other.event_type == MOUSE_CLICK)
        return true;
      if (other.event_group == HANDLE_BEHAVIOR_EVENT)
      {
        auto et = other.event_type;
        return et == BUTTON_CLICK ||
          et == HYPERLINK_CLICK ||
          et == MENU_ITEM_CLICK ||
          et == CLICK;
      }
      return false;
    }


    bool match_change(const event& evt) const {
      auto et = evt.event_type();
      if (evt.event_group() == HANDLE_BEHAVIOR_EVENT) {
        return /*et == BUTTON_STATE_CHANGED ||
               et == EDIT_VALUE_CHANGE ||
               et == SELECT_VALUE_CHANGED ||
               et == FORM_VALUE_CHANGED ||*/
               et == CHANGE;
      }
      return false;
    }

    bool match_change(const subscription& other) const {
      auto et = other.event_type;
      if (other.event_group == HANDLE_BEHAVIOR_EVENT) {
        return /*et == BUTTON_STATE_CHANGED ||
          et == EDIT_VALUE_CHANGE ||
          et == SELECT_VALUE_CHANGED ||
          et == FORM_VALUE_CHANGED ||*/
          et == CHANGE;
      }
      return false;
    }

    bool match_input(const event& evt) const {
      auto et = evt.event_type();
      if (evt.event_group() == HANDLE_BEHAVIOR_EVENT) {
        return et == BUTTON_STATE_CHANGED 
          || et == EDIT_VALUE_CHANGED 
          || et == SELECT_VALUE_CHANGED 
          || et == FORM_VALUE_CHANGED;
      }
      return false;
    }

    bool match_input(const subscription& other) const {
      auto et = other.event_type;
      if (other.event_group == HANDLE_BEHAVIOR_EVENT) {
        return et == BUTTON_STATE_CHANGED 
          || et == EDIT_VALUE_CHANGED 
          || et == SELECT_VALUE_CHANGED 
          || et == FORM_VALUE_CHANGED;
      }
      return false;
    }


    void parse(wchars full_name);
    //bool match(uint_v e_group, uint_v e_type, uint_v e_reason, wchars e_name, wchars e_ns, wchars e_command);
  };

  bool known_element_event_name(wchars eventname);
  
  struct event_target 
  {
#if defined(SCITERJS)
    array<handle<subscription>> subscriptions;

    event_target() {}
    event_target(NO_INIT ni) : subscriptions(ni) {}
    ~event_target() {
      if(subscriptions.length())
        subscriptions.destroy();
    }

    virtual bool get_expando(context& hc, script_expando& seo) = 0;

    void subscribe( qjs::hvalue fcn, ustring name, ustring selector, subscription::flags fs = subscription::flags())
    {
      wtokens z(name, WCHARS(" "));
      wchars ename;
      while(z.next(ename))
      {
        subscription *ps = new subscription(fcn, ename, selector);
        if(fs.capture)
          ps->sinking = true;
        ps->once = fs.once;
        ps->passive = fs.passive;
        ps->property = fs.property;
        subscriptions.push( ps );
      }
    }

    void subscribe(qjs::hvalue fcn, ustring name, element* receiver)
    {
      wtokens z(name, WCHARS(" "));
      wchars ename;
      while (z.next(ename))
      {
        subscription *ps = new subscription(fcn, ename);
        ps->receiver = receiver;
        subscriptions.push(ps);
      }
    }
    
    void unsubscribe(qjs::hvalue fcn, element* receiver = nullptr)
    {
      for (int n = subscriptions.last_index(); n >= 0; --n)
      {
        subscription* ps = subscriptions[n];
        if (receiver && (ps->receiver != receiver))
          continue;
        if( fcn == ps->fcn )
          subscriptions.remove(n);
      }
    }

    bool unsubscribe(ustring name, element* receiver = nullptr)
    {
      subscription other(name);
      int counter = 0;
      for (int n = subscriptions.last_index(); n >= 0; --n)
      {
        subscription* ps = subscriptions[n];
        if (receiver && (ps->receiver != receiver))
          continue;
        if (ps->match(other)) {
          ++counter;
          subscriptions.remove(n);
      }
    }
      return counter > 0;
    }

    void unsubscribe(element* reciver)
    {
      for (int n = subscriptions.last_index(); n >= 0; --n)
      {
        subscription* ps = subscriptions[n];
        if (ps->receiver == reciver)
          subscriptions.remove(n);
      }
    }

    void unsubscribe( ustring name, qjs::hvalue fcn, ustring selector, subscription::flags fs = subscription::flags())
    {
      auto remove = [&](wchars n1) {
        for(int n = subscriptions.last_index(); n >= 0; --n)
        {
          subscription other(name);
          subscription* ps = subscriptions[n];
          if(fcn && (fcn != ps->fcn))
            continue;
          if(!ps->match(other))
            continue;
          if (ps->sinking != fs.capture)
            continue;
          subscriptions.remove(n);
        }
      };
      wtokens z(name,WCHARS(" "));
      wchars ename;
      while(z.next(ename))
        remove(ename);
    }

    handle<subscription> get_prop_subscription(wchars eventname, bool create = false) {
      handle<html::subscription> proto = new html::subscription(eventname);
      proto->property = true;
      for( auto subs : subscriptions )
        if(subs->match(*proto))
          return subs;
      if (create) {
        subscriptions.push(proto);
        return proto;
      }
      return nullptr;
    }

    void set_prop_subscription(wchars eventname, subscription::function_ref fcn) {
      handle<subscription> subs = get_prop_subscription(eventname, true);
      if (subs)
        subs->fcn = fcn;
    }

    bool handle_event(context& ctx, event& evt);

    /*bool each_handler( view& v, event& evt, function<bool(subscription*,element*)> oneach ) const
    {
      bool handled = false;
      for(int n = subscriptions.last_index(); n >= 0; --n)
      {
        if( n >= subscriptions.size() ) {
          n = subscriptions.size();
          continue;
        }
        subscription* ps = subscriptions[n];

        if( ps->match(evt.event_group(), evt.event_type(),evt.event_reason(),evt.event_name(), evt.event_command_of()) )
        {
          element *self = const_cast<element*>(this);
          if( ps->event_selector.is_defined() )
          {
            element* target = evt.target;
            element *m = find_first_parent(v, const_cast<element*>(this), target, ps->event_selector);
            if( !m )
              continue;
            self = m;
          }
          if(oneach(ps,self))
            handled = true;
        }
      }
      return handled;
    }*/

    void each_subscription( function<bool(subscription*,bool&)> oneach)
    {
      for(int n = subscriptions.size() - 1; n >= 0; --n)
      {
        bool delete_it = false;
        bool r = oneach(subscriptions[n],delete_it);
        if( delete_it )
          subscriptions.remove(n);
        if( r )
          break;
      }
    }
#endif
  };

} // namespace html

#endif