#include "html.h"

namespace html 
{

  bool event::is_on_target(const event_target* pet) const { 
#if defined(SCITERJS)
    return pet == target.ptr(); 
#else
    return true;
#endif
  }
    
  int target_y_pos(element *b);
  int target_x_pos(element *b);

  event_behavior::event_behavior(wchars ename)
    : event(0,0), reason(0), internal(false), processed(false) 
  {
    subscription s;
    s.parse(ename);
    assert(s.event_group == event_behavior::EVENT_GROUP);
    cmd = s.event_type;
    name = s.event_name;
    ns = s.event_ns;
  }

  bool subscription::match(const event& evt) const
  {
    if (evt.is_handled()) return false;
    if (sinking != evt.is_sinking()) return false;

    if (event_type == CLICK && match_click(evt))
      goto CHECK_REST;
    else if (event_type == CHANGE && match_change(evt))
      goto CHECK_REST;
    else if (event_type == INPUT && match_input(evt))
      goto CHECK_REST;
    else {
      if (event_group != evt.event_group())
        return false;
      if (event_type != evt.event_type())
        return false;
    }
  CHECK_REST:
    if (event_command.is_defined() && (event_command != evt.event_command_of()))
      return false;
    if (event_reason.is_defined() && (event_reason != evt.event_reason())) 
      return false;
    if (event_name.is_defined() && (event_name != evt.event_type_name()))
      return false;
    if (event_ns.is_defined() && !match_lists(evt.event_namespace()(), event_ns(), WCHARS(".")) )
      return false;

    return true;
  }

  bool subscription::match(const subscription& other) const
  {
    if (other.property && !property)
      return false;
    if (other.event_type.is_defined()) {
      if (event_type == CLICK && match_click(other))
        goto CHECK_REST;
      else if (event_type == CHANGE && match_change(other))
        goto CHECK_REST;
      else if (event_type == INPUT && match_input(other))
        goto CHECK_REST;
      else {
        if (event_group != other.event_group)
          return false;
        if (event_type != other.event_type)
          return false;
      }
    }
  CHECK_REST:
    if (event_command.is_defined() && (event_command != other.event_command))
      return false;
    if (event_reason.is_defined() && (event_reason != other.event_reason))
      return false;
    if (event_name.is_defined() && other.event_name.is_defined() && (event_name != other.event_name))
      return false;
    if (other.event_ns.is_defined()) {
      if (!event_ns.is_defined())
      return false;
      if (!match_lists(other.event_ns(), event_ns(), WCHARS(".")))
        return false;
    }
    return true;
  }
  

  struct event_def {
    wchars  name;
    uint    group;
    uint    type;
    uint_v  reason;
  };

  // note : order matters
  static event_def event_def_list[] = {
    { WCHARS("mousemove")       ,HANDLE_MOUSE, MOUSE_MOVE },
    { WCHARS("mouseenter")      ,HANDLE_MOUSE, MOUSE_ENTER },
    { WCHARS("mouseleave")      ,HANDLE_MOUSE, MOUSE_LEAVE },
    { WCHARS("mouseidle")       ,HANDLE_MOUSE, MOUSE_IDLE },
    { WCHARS("mousetick")       ,HANDLE_MOUSE, MOUSE_TICK },
    { WCHARS("mousedown")       ,HANDLE_MOUSE, MOUSE_DOWN },
    { WCHARS("mouseup")         ,HANDLE_MOUSE, MOUSE_UP },
    { WCHARS("wheel")           ,HANDLE_MOUSE, MOUSE_WHEEL },
    { WCHARS("mousewheel")      ,HANDLE_MOUSE, MOUSE_WHEEL },
    { WCHARS("mousedragrequest")  ,HANDLE_MOUSE, MOUSE_DRAG_REQUEST },
    { WCHARS("dblclick")        ,HANDLE_MOUSE, MOUSE_DCLICK },
    { WCHARS("doubleclick")     ,HANDLE_MOUSE, MOUSE_DCLICK },
    { WCHARS("tripleclick")     ,HANDLE_MOUSE, MOUSE_TCLICK },

    { WCHARS("click")           ,HANDLE_BEHAVIOR_EVENT, CLICK },
    { WCHARS("click")           ,HANDLE_BEHAVIOR_EVENT, BUTTON_CLICK },
    { WCHARS("click")           ,HANDLE_BEHAVIOR_EVENT, HYPERLINK_CLICK },
    { WCHARS("click")           ,HANDLE_BEHAVIOR_EVENT, MENU_ITEM_CLICK },
    { WCHARS("click")           ,HANDLE_MOUSE, MOUSE_CLICK },
#ifdef SCITERJS
    //{ WCHARS("input")           ,HANDLE_BEHAVIOR_EVENT, CHANGE },
    { WCHARS("input")           ,HANDLE_BEHAVIOR_EVENT, INPUT },
    { WCHARS("input")           ,HANDLE_BEHAVIOR_EVENT, BUTTON_STATE_CHANGED },
    { WCHARS("input")           ,HANDLE_BEHAVIOR_EVENT, EDIT_VALUE_CHANGED },
    { WCHARS("input")           ,HANDLE_BEHAVIOR_EVENT, SELECT_VALUE_CHANGED },
    { WCHARS("input")           ,HANDLE_BEHAVIOR_EVENT, FORM_VALUE_CHANGED },

    { WCHARS("change")          ,HANDLE_BEHAVIOR_EVENT, CHANGE },
    //{ WCHARS("change")          ,HANDLE_BEHAVIOR_EVENT, BUTTON_STATE_CHANGED },
    //{ WCHARS("change")          ,HANDLE_BEHAVIOR_EVENT, SELECT_VALUE_CHANGED },
    //{ WCHARS("change")          ,HANDLE_BEHAVIOR_EVENT, FORM_VALUE_CHANGED },
    //{ WCHARS("change")          ,HANDLE_BEHAVIOR_EVENT, EDIT_VALUE_CHANGE },
#else 
    { WCHARS("change")          ,HANDLE_BEHAVIOR_EVENT, CHANGE },
    { WCHARS("change")          ,HANDLE_BEHAVIOR_EVENT, BUTTON_STATE_CHANGED },
    { WCHARS("change")          ,HANDLE_BEHAVIOR_EVENT, SELECT_VALUE_CHANGED },
    { WCHARS("change")          ,HANDLE_BEHAVIOR_EVENT, FORM_VALUE_CHANGED },
    { WCHARS("change")          ,HANDLE_BEHAVIOR_EVENT, EDIT_VALUE_CHANGED },
#endif
    { WCHARS("press")           ,HANDLE_BEHAVIOR_EVENT, BUTTON_PRESS },
    { WCHARS("changing")        ,HANDLE_BEHAVIOR_EVENT, EDIT_VALUE_CHANGING },
    { WCHARS("submit")          ,HANDLE_BEHAVIOR_EVENT, FORM_SUBMIT },
    { WCHARS("reset")           ,HANDLE_BEHAVIOR_EVENT, FORM_RESET },
    { WCHARS("expand")          ,HANDLE_BEHAVIOR_EVENT, ELEMENT_EXPANDED },
    { WCHARS("collapse")        ,HANDLE_BEHAVIOR_EVENT, ELEMENT_COLLAPSED },
    { WCHARS("statechange")     ,HANDLE_BEHAVIOR_EVENT, UI_STATE_CHANGED },
    { WCHARS("visualstatechange")   ,HANDLE_BEHAVIOR_EVENT, VISUAL_STATUS_CHANGED },
    { WCHARS("disabledstatechange") ,HANDLE_BEHAVIOR_EVENT, DISABLED_STATUS_CHANGED },
    { WCHARS("readonlystatechange") ,HANDLE_BEHAVIOR_EVENT, READONLY_STATUS_CHANGED },

    { WCHARS("contextmenu")      ,HANDLE_BEHAVIOR_EVENT, CONTEXT_MENU_REQUEST },
    { WCHARS("contextmenusetup") ,HANDLE_BEHAVIOR_EVENT, CONTEXT_MENU_SETUP },

    { WCHARS("animationend")     ,HANDLE_BEHAVIOR_EVENT, ANIMATION, 0 },
    { WCHARS("animationstart")   ,HANDLE_BEHAVIOR_EVENT, ANIMATION, 1 },
    { WCHARS("animationloop")    ,HANDLE_BEHAVIOR_EVENT, ANIMATION, 2 },

    { WCHARS("transitionend")     ,HANDLE_BEHAVIOR_EVENT, TRANSITION, 0 },
    { WCHARS("transitionstart")   ,HANDLE_BEHAVIOR_EVENT, TRANSITION, 1 },

    { WCHARS("mediachange")      ,HANDLE_BEHAVIOR_EVENT, MEDIA_CHANGED },
    { WCHARS("contentchange")    ,HANDLE_BEHAVIOR_EVENT, CONTENT_CHANGED },
    { WCHARS("inputlangchange")  ,HANDLE_BEHAVIOR_EVENT, INPUT_LANGUAGE_CHANGED },
    { WCHARS("pastehtml")        ,HANDLE_BEHAVIOR_EVENT, PASTE_HTML },
    { WCHARS("pastetext")        ,HANDLE_BEHAVIOR_EVENT, PASTE_TEXT },
    { WCHARS("pasteimage")       ,HANDLE_BEHAVIOR_EVENT, PASTE_IMAGE },
    { WCHARS("popuprequest")     ,HANDLE_BEHAVIOR_EVENT, POPUP_REQUEST },
    { WCHARS("popupready")       ,HANDLE_BEHAVIOR_EVENT, POPUP_READY },
    { WCHARS("popupdismissed")   ,HANDLE_BEHAVIOR_EVENT, POPUP_DISMISSED },
    { WCHARS("popupdismissing")  ,HANDLE_BEHAVIOR_EVENT, POPUP_DISMISSING },

    { WCHARS("tooltiprequest")   ,HANDLE_BEHAVIOR_EVENT, TOOLTIP_REQUEST },

    { WCHARS("focusin")      ,HANDLE_FOCUS, FOCUS_IN },
    { WCHARS("focusout")     ,HANDLE_FOCUS, FOCUS_OUT },
    { WCHARS("focus")        ,HANDLE_FOCUS, GOT_FOCUS },
    { WCHARS("blur")         ,HANDLE_FOCUS, LOST_FOCUS },

    { WCHARS("keydown")      ,HANDLE_KEY, KEY_DOWN },
    { WCHARS("keyup")        ,HANDLE_KEY, KEY_UP },
    { WCHARS("keypress")     ,HANDLE_KEY, KEY_CHAR },
    { WCHARS("compositionstart"), HANDLE_KEY, KEY_COMP_STRING },
    { WCHARS("compositionend")  , HANDLE_KEY, KEY_RESULT_STRING },

    { WCHARS("scroll")       ,HANDLE_SCROLL, SCROLL_POS },
    { WCHARS("scrollanimationstart") ,HANDLE_SCROLL, SCROLL_ANIMATION_START },
    { WCHARS("scrollanimationend")   ,HANDLE_SCROLL, SCROLL_ANIMATION_END },

    /*{ WCHARS("scroll-home")       ,HANDLE_SCROLL, SCROLL_HOME },
    { WCHARS("scroll-end")        ,HANDLE_SCROLL, SCROLL_END },
    { WCHARS("scroll-step-plus")  ,HANDLE_SCROLL, SCROLL_STEP_PLUS },
    { WCHARS("scroll-step-minus")  ,HANDLE_SCROLL, SCROLL_STEP_MINUS },
    { WCHARS("scroll-page-plus")  ,HANDLE_SCROLL, SCROLL_PAGE_PLUS },
    { WCHARS("scroll-page-minus")  ,HANDLE_SCROLL, SCROLL_PAGE_MINUS },
    { WCHARS("scroll-slider-press")  ,HANDLE_SCROLL, SCROLL_SLIDER_PRESSED },
    { WCHARS("scroll-slider-release")  ,HANDLE_SCROLL, SCROLL_SLIDER_RELEASED },*/

    { WCHARS("close")        ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_CLOSE },
    { WCHARS("unload")       ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_CLOSE },      // JS
    { WCHARS("beforeunload") ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_CLOSING },         // JS
    { WCHARS("closerequest") ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_CLOSE_REQUEST },
    { WCHARS("unloadequest") ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_CLOSE_REQUEST },

    { WCHARS("ready")               ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_READY },
    { WCHARS("DOMContentLoaded")    ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_READY },    // JS
    { WCHARS("parsed")              ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_PARSED },
    { WCHARS("complete")            ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_COMPLETE },

    //{ WCHARS("load")                ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_COMPLETE }, // JS
    { WCHARS("load")                ,HANDLE_BEHAVIOR_EVENT, LOAD_SUCCEEDED }, // JS
    { WCHARS("error")               ,HANDLE_BEHAVIOR_EVENT, LOAD_FAILED }, // JS    

    { WCHARS("paginationstart")     ,HANDLE_BEHAVIOR_EVENT, PAGINATION_STARTS },
    { WCHARS("paginationpage")      ,HANDLE_BEHAVIOR_EVENT, PAGINATION_PAGE },
    { WCHARS("paginationend")       ,HANDLE_BEHAVIOR_EVENT, PAGINATION_ENDS },

    { WCHARS("newdocument")         ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_CREATED },
    //{ WCHARS("reloaddocument")      ,HANDLE_BEHAVIOR_EVENT, DOCUMENT_RELOAD },

    { WCHARS("contentmodification") ,HANDLE_BEHAVIOR_EVENT, CONTENT_MODIFIED },
    { WCHARS("contentrequired")     ,HANDLE_BEHAVIOR_EVENT, CONTENT_REQUIRED },

    { WCHARS("drag")        ,HANDLE_EXCHANGE, X_DRAG },
    { WCHARS("dragenter")   ,HANDLE_EXCHANGE, X_DRAG_ENTER },
    { WCHARS("dragleave")   ,HANDLE_EXCHANGE, X_DRAG_LEAVE },
    { WCHARS("drop")        ,HANDLE_EXCHANGE, X_DROP },
    { WCHARS("dragcancel")  ,HANDLE_EXCHANGE, X_DRAG_CANCEL },
    { WCHARS("dragaccept")  ,HANDLE_EXCHANGE, X_WILL_ACCEPT_DROP },
    { WCHARS("willacceptdrop")     ,HANDLE_EXCHANGE, X_WILL_ACCEPT_DROP },
    { WCHARS("historystatechange") ,HANDLE_BEHAVIOR_EVENT, HISTORY_STATE_CHANGED },

    { WCHARS("start"), HANDLE_BEHAVIOR_EVENT, VIDEO_STARTED },
    { WCHARS("stop"), HANDLE_BEHAVIOR_EVENT, VIDEO_STOPPED },
    { WCHARS("ready"), HANDLE_BEHAVIOR_EVENT, VIDEO_INITIALIZED },

    { WCHARS("videocoordinate"), HANDLE_BEHAVIOR_EVENT, VIDEO_COORDINATE },
    { WCHARS("videoframeready"), HANDLE_BEHAVIOR_EVENT, VIDEO_FRAME },

};



  bool known_element_event_name(wchars eventname) {
    for (const event_def& d : items_of(event_def_list)) {
      if (lexical::ci::eq(d.name, eventname)) {
        return true;
      }
    }
    return false;
  }

  void subscription::parse(wchars fullname)
  {
    event_group.clear();
    event_type.clear();

    if (fullname[0] == '~' || fullname[0] == '^') {
      sinking = true;
      fullname.prune(1);
    }

    if (!fullname)
      return;
    
    wchars name;
    wchars ns;
    if (!fullname.split(WCHARS("."), name, ns))
      name = fullname;
    event_ns = ns;

    if (name.length) {
    for (const event_def& d : items_of(event_def_list)) {
        if (lexical::ci::eq(d.name, name)) {
        event_group = d.group;
        event_type = d.type;
        event_reason = d.reason;
        return;
      }
    }

    if (name.starts_with(WCHARS("exec:"))) {
      event_group = HANDLE_COMMAND;
      event_type = event_command::EXEC;
      event_command = name(5);
    }
    else if (name.starts_with(WCHARS("query:")) || name.starts_with(WCHARS("check:"))) {
      event_group = HANDLE_COMMAND;
      event_type = event_command::CHECK;
      event_command = name(6);
    }
    else {
      event_group = HANDLE_BEHAVIOR_EVENT;
      event_type = CUSTOM;
      event_name = name;
    }
  }
  }

  ustring  event::event_type_name() const {
    for (const event_def& d : items_of(event_def_list)) {
      if (d.group == event_group() && d.type == event_type()) 
      {
        if (d.reason.is_defined() && event_reason().is_defined())
        { 
          if (d.reason == event_reason())
            return d.name;
        } else 
          return d.name;
      }
    }
    return ustring();
  }

  ustring  event::event_full_name() const {
    ustring ns = event_namespace();
    ustring nt = event_type_name();
    const wchar* phase = is_sinking() ? W("~") : W("");
    if (ns.is_defined())
      return ustring::format(W("%s%s.%s"), phase, nt.c_str(), ns.c_str());
    else
      return ustring::format(W("%s%s"), phase, nt.c_str());
  }

///////////////////////////////////

  /*element *event::match(view &v, wchars name, wchars selector) const {
    wtokens z(name, WCHARS(" "));
    wchars  ename;
    while (z.next(ename)) {
      wchars  real_name = ename.head('.');
      uint_v  e_group;
      uint_v  e_type;
      uint_v  e_reason;
      ustring e_command;
      crack_event_group_type(real_name, e_group, e_type, e_reason, e_command);

      wchars e_ns   = name;
      wchars e_name = e_ns.chop('.');

      subscription s(subscription::function_ref(), e_group, e_type, e_reason, name, wchars(), selector);

      if (s.match(event_group(), event_type(), event_reason(), e_name, e_ns,
                  e_command)) {
        if (selector.length) {
          element *me = find_first_parent(v, target, selector);
          if (me) return me;
        } else
          return target;
      }
    }
    return nullptr;
  }*/

  bool event::match(view &v, subscription& s, helement &principal, element* root) const {
    if (!s.match(*this))
      return false;

    if (s.event_selector) {
      if (!target) return false;
      element *me = find_first_parent_or_root(v, root ? root : target->doc(), target, s.event_selector);
      if (me) {
        principal = me;
        return true;
      }
    } else {
      principal = target;
      return true;
    }
    return false;
  }

  element *event::get_parent(element *t) { return t ? t->parent.ptr() : nullptr; }
  element *event::get_logical_parent(element *t) {
    if (!t) return 0;
/*
    if (t->state.popup()) {
      view *pv = t->pview();
      if (pv) {
        element *pa = pv->popup_anchor(t);
        if (pa) return pa;
      }
    }
    return t->parent; // ATTN: this t->owner; is wrong here */
    return t->get_event_owner(); // ATTN: this t->owner; is wrong here */
  }

  bool is_disabled_by_style(element *el) {
    tool::value val;
    if (!el->c_style->get_custom_attr("-disabled", val)) return false;
    if (val.is_bool() && val.get(false) == false) return false;
    return true;
  }

  element *get_enabled(view &v, element *b) {
    element *topmost = 0;
    while (b) {
      if (!topmost) topmost = b;
      if (b->state.disabled() || is_disabled_by_style(b)) topmost = 0;
      b = b->ui_parent(v);
    }
    return topmost;
  }

  bool element::is_safe_to_wheel(view &v) {
    if (v.focus_element && v.focus_element->belongs_to(this, true))
      return true; // if it is in focus then it is safe to handle MOUSE_WHEEL
    element *p = this->ui_parent(v);
    while (p) {
      if (p->can_scroll_v(v)) return false; // not safe
      p = p->ui_parent(v);
    }
    return true; // safe - no scrollbales above it.
  }

  static SIDE side_hit_test(view &v, element* pel, point pos)
  {
    SIDE r = NO_SIDE;
    rect rc = pel->content_box(v);
    if (pos.x < rc.left()) r |= LEFT;
    else if (pos.x > rc.right()) r |= RIGHT;
    if (pos.y < rc.top()) r |= TOP;
    else if (pos.y > rc.bottom()) r |= BOTTOM;
    return r;
  }

  static uint64 side_hit_test_flags(view &v, element* pel, point pos)
  {
    SIDE r = side_hit_test(v, pel, pos);
    return side_to_state(r);
  }


  bool element::on(view &v, event_mouse &evt) {
    helement guard(this);
    helement focus_element = v.focus_element;
    bool     r             = false;

    if (ldata->sb.on(v, this, evt)) {
      if (evt.target == this) {
        if (evt.cmd == MOUSE_DOWN) {
          v.set_focus(this, BY_MOUSE);
          v.set_capture_strict(this);
        }
        r = true;
        goto DEF_HANDLER;
      }
    }

    if (evt.is_sinking() || evt.target == this) switch (evt.cmd & 0xFFF) {
      case MOUSE_DOWN:
      case MOUSE_IDLE:
      case MOUSE_ENTER:
      case MOUSE_MOVE:
      case MOUSE_DCLICK:
      case MOUSE_TICK:
      case MOUSE_UP:
      case DRAG_ENTER:
#ifdef USE_TOUCH
      case MOUSE_TOUCH_START:
      case MOUSE_TOUCH_END:
#endif
      case MOUSE_CHECK: {
        hstyle cs = get_style(v);
        if (cs->cursor.is_defined()) 
          evt.cursor = cs->cursor;
        if (evt.cmd == MOUSE_CHECK) {
          if (cs->cursor.is_defined()) 
           evt.cursor = cs->cursor;
        }

#ifdef _DEBUG
        if (this->tag == tag::T_OPTION && this->parent->is_id_test()) {
          //auto cu = cursor::system(0);
          cs = cs;
        }
#endif

        if (is_on_icon(v, evt.pos)) {
          if (cs->foreground_image_cursor.is_defined())
            evt.cursor = cs->foreground_image_cursor;
          evt.is_on_icon = this;
        }
      } break;
      }

    switch (evt.cmd) {
    case MOUSE_ENTER | EVENT_HANDLED:
    case MOUSE_ENTER: 
    {
#if DEBUG
      //if (is_id_test())
      //  evt.pos = evt.pos;
#endif
      uint64 flags = S_HOVER | side_hit_test_flags(v, this, evt.pos);
#ifdef USE_TOUCH
      if (evt.is_touch())
        flags |= S_ACTIVE;
#endif
      state_on(v, flags);
      hstyle cs = get_style(v);
#if 0
      if (cs->act_hover_on) {
        if (eval_action(v, evt, cs->act_hover_on)) evt.cmd |= EVENT_HANDLED;
      }
#endif

    } break;
    // case DRAGGING | MOUSE_MOVE:
    case MOUSE_MOVE:
    {
      uint64 side_flags = side_hit_test_flags(v, this, evt.pos);
      uint64 current_side_flags = state.data & S_HOVER_ALL_SIDES;
      uint64 d = side_flags ^ current_side_flags;
      if(auto t = d & side_flags) 
        state_on(v, t);
      if(auto t = d & current_side_flags) 
        state_off(v, t);
      break;
    }
    // case DRAGGING | MOUSE_LEAVE:
    case MOUSE_LEAVE | EVENT_HANDLED:
    case MOUSE_LEAVE: {
      state_off(v, S_HOVER | S_HOVER_ALL_SIDES | S_ACTIVE);
      state.pressed(false);
      // dbg_report("MOUSE_LEAVE\n");
      hstyle cs = get_style(v);
#if 0
      if (cs->act_hover_off && (evt.cmd == MOUSE_LEAVE)) {
        if (eval_action(v, evt, cs->act_hover_off)) evt.cmd |= EVENT_HANDLED;
      }
#endif
    } break;

    case MOUSE_UP:

      if (evt.is_point_button()) {
        state_off(v, S_ACTIVE);

        hstyle cs = get_style(v);

        bool r = v.on_element_event(this, evt);
        if (!doc())
          // element has gone, probably doc was reloaded
          return r;
        cs = get_style(v);
#if 0
        if (cs->act_active_off) {
          if (eval_action(v, evt, cs->act_active_off)) evt.cmd |= EVENT_HANDLED;
        }
#endif
        state.pressed(false);
        return r;
      }
      break;

    case MOUSE_DOWN:
    case MOUSE_DCLICK: {
      if (evt.is_point_button()) {
        hstyle cs = get_style(v);

#if 0
        if (cs->act_active_on) {
          if (eval_action(v, evt, cs->act_active_on)) evt.cmd |= EVENT_HANDLED;
        }
#endif

        state_on(v, S_ACTIVE);
        state.pressed(true);
#if 0
        {
          hstyle cs = get_style(v);
          if ((evt.cmd == MOUSE_DCLICK) && cs->act_double_click) {
            if (eval_action(v, evt, cs->act_double_click))
              evt.cmd |= EVENT_HANDLED;
          }
        }
#endif
        if (state.popup()) v.close_owned_popups(this);
      }

    } break;

    case MOUSE_DOWN | EVENT_HANDLED:
      if (evt.is_point_button()) { state.pressed(true); }
      break;

    case MOUSE_UP | EVENT_HANDLED:
      if (evt.is_point_button()) { state.pressed(false); }
      break;

    case MOUSE_WHEEL: {
      if (v.on_element_event(this, evt)) return true;
      if (evt.is_control()) return false; // zoom 
      hstyle st = get_style(v);

      scroll_data sd;
      get_scroll_data(v, sd);

      size delta = evt.wheel_delta_xy();

#ifdef USE_TOUCH
      if (v.is_touched) {;}
      else
#endif
      {
        delta.x = delta.x * this->dim().x / 120 / 8;
        delta.y = delta.y * this->dim().y / 120 / 8;

        if ((st->overflow_y <= overflow_hidden) && delta.y)
          swap(delta.y, delta.x);
      }

      if (st->overflow_y <= overflow_hidden) delta.y = 0;
      if (st->overflow_x <= overflow_hidden) delta.x = 0;

      if (delta == size(0, 0)) return false;

      if (!is_layout_valid())
        v.commit_update(); // it has to have valid layout at this point.

      if (!can_scroll_v(v)) delta.y = 0;
      if (!can_scroll_h(v)) delta.x = 0;

      if (delta == size(0, 0)) return false;

      if (sd.content_outline.width() < sd.dim_view.x) {
        sd.content_outline.s.x = 0;
        sd.content_outline.e.x = sd.dim_view.x;
      }
      if (sd.content_outline.height() < sd.dim_view.y) {
        sd.content_outline.s.y = 0;
        sd.content_outline.e.y = sd.dim_view.y;
      }

      point prev_pos = sd.pos;

      ENSURE_VISIBLE_MANNER manner = SCROLL;

#if defined(USE_ANIMATED_SCROLL)
      if (st->smooth_scroll_wheel(true)) {

        point target;
        
        target.y = target_y_pos(this);
        target.x = target_x_pos(this);

        /*if (!v.is_touched) 
        {
          int ny = target.y - int(delta.y);
          if (ny < sd.content_outline.top() && delta.y > 0) delta.y = 0;
          if (ny > (sd.content_outline.bottom() - sd.dim_view.y - 1) && delta.y < 0) delta.y = 0;
          int nx = target.x - int(delta.x);
          if (nx < sd.content_outline.left() && delta.x > 0) delta.x = 0;
          if (nx > (sd.content_outline.right() - sd.dim_view.x - 1) && delta.x < 0) delta.x = 0;
        }*/

        sd.pos.y = target.y - int(delta.y);
        sd.pos.x = target.x - int(delta.x);
        
        manner = SCROLL_SMOOTH;
        sd.pos.y = limit(sd.pos.y, sd.content_outline.top() - sd.dim_view.y / 2, sd.content_outline.bottom() - sd.dim_view.y + sd.dim_view.y / 2);
        sd.pos.x = limit(sd.pos.x, sd.content_outline.left() - sd.dim_view.x / 2, sd.content_outline.right() - sd.dim_view.x + sd.dim_view.x / 2);
      } else
#endif
      {
        //size wheel_advance = sd.dim_view / 4;
        //wheel_advance.x = pixels(v, this, st->wheel_step(false, size_v(wheel_advance.x))).width();
        //wheel_advance.y = pixels(v, this, st->wheel_step(true, size_v(wheel_advance.y))).height();
        //sd.pos.y -= int(delta.y * wheel_advance.x);
        //sd.pos.x -= int(delta.x * wheel_advance.y);
        sd.pos.y -= int(delta.y);
        sd.pos.x -= int(delta.x);

        sd.pos.y = limit(sd.pos.y, sd.content_outline.top(),
                         sd.content_outline.bottom() - sd.dim_view.y + 1);
        sd.pos.x = limit(sd.pos.x, sd.content_outline.left(),
                         sd.content_outline.right() - sd.dim_view.x + 1);
      }

      if (prev_pos == sd.pos) return popup_positioned(v);

      if (manner != SCROLL_SMOOTH) {
        if (delta.y) {
          event_scroll scroll_evt(this, SCROLL_POS, true, sd.pos.y, SCROLL_SOURCE_WHEEL, 0);
          this->on(v, scroll_evt);
        }
        if (delta.x) {
          event_scroll scroll_evt(this, SCROLL_POS, false, sd.pos.x, SCROLL_SOURCE_WHEEL, 0);
          this->on(v, scroll_evt);
        }
      }

      return v.scroll_window(sd.pos, this, manner) || popup_positioned(v);
      // return false;
    }
#if defined(USE_ANIMATED_SCROLL) & 0
    case MOUSE_TOUCH_END | EVENT_HANDLED:
    case MOUSE_TOUCH_END: {
      //return true;
      hstyle st = get_style(v);
      scroll_data sd;
      get_scroll_data(v, sd);
      if (sd.content_outline.width() < sd.dim_view.x) {
        sd.content_outline.s.x = 0;
        sd.content_outline.e.x = sd.dim_view.x - 1;
      }
      if (sd.content_outline.height() < sd.dim_view.y) {
        sd.content_outline.s.y = 0;
        sd.content_outline.e.y = sd.dim_view.y - 1;
      }
      rect sbox =  rect(sd.pos,sd.dim_view);
      if((sbox & sd.content_outline) == sbox)
        return false;
      ENSURE_VISIBLE_MANNER manner = SCROLL;
        sbox.inscribe(sd.content_outline);
      if (st->smooth_scroll_wheel(true))
        manner = SCROLL_SMOOTH;
      v.scroll_window(sbox.s, this, manner);
      return true;
    }
#endif
            
    case DRAG_ENTER:
      if (evt.target == this) { state_on(v, S_DRAG_OVER); }
      break;

    case DRAG_LEAVE:
      if (evt.target == this) { state_off(v, S_DRAG_OVER); }
      break;
    default: break;
    }
    r = v.on_element_event(this, evt);

  DEF_HANDLER:

    if (!r && evt.cmd == MOUSE_DOWN && evt.target == this && focus_element == v.focus_element)
      v.set_focus(this, BY_MOUSE);

    return r;
  }

  bool element::on(view &v, event_key &evt) {
    bool   r  = v.on_element_event(this, evt);
    hstyle cs = get_style(v);
#if 0
    switch (evt.cmd) {
    case KEY_DOWN:
      if (cs->act_key_on) {
        if (eval_action(v, evt, cs->act_key_on)) evt.cmd |= EVENT_HANDLED;
      }
      break;
    case KEY_UP:
      if (cs->act_key_off) {
        if (eval_action(v, evt, cs->act_key_off)) evt.cmd |= EVENT_HANDLED;
      }
      break;
    }
#endif

    if (evt.cmd == KEY_DOWN && !r && evt.target == this) switch (evt.key_code) {
      case KB_BACK:
        if (evt.alt_state == ALT_ALT)
          return exec_command(v, this, evt.target, event_command::EDIT_UNDO());
        else if (evt.alt_state == ALT_SHORTCUT)
          return exec_command(v, this, evt.target,
                              event_command::EDIT_DELETE_WORD_PREV());
        return exec_command(v, this, evt.target,
                            event_command::EDIT_DELETE_PREV());
      case KB_A:
        if (evt.alt_state == ALT_SHORTCUT)
          return exec_command(v, this, evt.target,
                              event_command::EDIT_SELECT_ALL());
        break;
      case KB_DELETE:
        if (evt.is_shift())
          return exec_command(v, this, evt.target, event_command::EDIT_CUT());
        else if (evt.is_shortcut())
          return exec_command(v, this, evt.target, event_command::EDIT_DELETE_WORD_NEXT());
        else if (evt.is_option()) // macOS Option-Delete
          return exec_command(v, this, evt.target, event_command::EDIT_DELETE_WORD_PREV());
        else if (evt.is_command()) // macOS Command-Delete
          return exec_command(v, this, evt.target, event_command::EDIT_DELETE_LINE_START());
        else
          return exec_command(v, this, evt.target,
                              event_command::EDIT_DELETE_NEXT());
        break;
      case KB_INSERT:
        if (evt.is_shift())
          return exec_command(v, this, evt.target, event_command::EDIT_PASTE());
        else if (evt.is_shortcut())
          return exec_command(v, this, evt.target, event_command::EDIT_COPY());
        break;
      case KB_C:
        if (evt.is_shortcut())
          return exec_command(v, this, evt.target, event_command::EDIT_COPY());
        break;
      case KB_X:
        if (evt.is_shortcut())
          return exec_command(v, this, evt.target, event_command::EDIT_CUT());
        break;
      case KB_V:
        if (evt.is_shortcut() && evt.is_shift())
          return exec_command(v, this, evt.target, event_command::EDIT_PASTE_TEXT());
        else if (evt.is_shortcut())
          return exec_command(v, this, evt.target, event_command::EDIT_PASTE());
        break;
      case KB_Z:
        if (evt.is_shortcut() && evt.is_shift())
          return exec_command(v, this, evt.target, event_command::EDIT_REDO());
        else if (evt.is_shortcut())
          return exec_command(v, this, evt.target, event_command::EDIT_UNDO());
        break;
      case KB_Y:
        if (evt.is_shortcut())
          return exec_command(v, this, evt.target, event_command::EDIT_REDO());
        break;

      default: break;
      }
    return r;
  }

  bool element::on(view &v, event_command &evt) {
    return v.on_element_event(this, evt);
  }

  bool element::on(view &v, event_exchange &evt) {
    return v.on_element_event(this, evt);
  }

  int target_y_pos(element *b) {
    scroll_animator *psa = b->get_animation_of_type<scroll_animator>();
    if (psa)
      return psa->final_scroll_pos.y;
    else
      return b->scroll_pos().y;
  }

  static inline void next_step_y(view &v, element *b, point &pos, size dim,
                                 const value &val) {
    int    ty  = target_y_pos(b);
    int    row = 0;
    range  y;
    size_v sz;

    if (is_auto_value(val) && b->get_row_at(v, ty, row))
      for (int n = 0; n < 2 && row < b->n_rows(); ++n, ++row) {
        if ((row < (b->n_rows() - 1)) && b->get_row_y(row + 1, y)) {
          if (y.s <= ty) continue;
          if (y.length() < dim.y) {
            pos.y = y.s;
            return;
          }
        } else if (b->get_row_y(row, y)) {
          if (y.length() < dim.y) {
            pos.y = y.e;
            return;
          }
        }
      }
    else if (length_value(sz, val)) {
      pos.y = ty + pixels(v, b, sz, dim).height();
      return;
    }
    pos.y = ty + dim.y / 10;
  }

  static inline void prev_step_y(view &v, element *b, point &pos, size dim,
                                 const value &val) {
    int    ty  = target_y_pos(b);
    int    row = 0;
    range  y;
    size_v sz;

    if (is_auto_value(val) && b->get_row_at(v, ty, row))
      for (int n = 0; n < 2 && row >= 0; ++n, --row) {
        if (b->get_row_y(row, y)) {
          if (y.s >= ty) continue;
          if (y.length() < dim.y) {
            pos.y = y.s;
            return;
          }
        }
      }
    else if (length_value(sz, val)) {
      pos.y = ty - pixels(v, b, sz, dim).height();
      return;
    }

    pos.y = ty - dim.y / 10;
  }

  static inline void next_page_y(view &v, element *b, point &pos, size dim,
                                 const value &val) {
    int    ty  = target_y_pos(b);
    int    row = 0;
    range  y;
    size_v sz;
    if (is_auto_value(val) && b->get_row_at(v, ty + dim.y - 1, row))
      for (int n = 0; n < 2 && row < b->n_rows(); ++n, ++row) {
        if ((row < (b->n_rows() - 1)) && b->get_row_y(row, y)) {
          if (y.s <= ty) continue;
          if (y.length() < dim.y) {
            pos.y = y.s;
            return;
          }
        } else if (b->get_row_y(row, y)) {
          if (y.length() < dim.y) {
            pos.y = y.e;
            return;
          }
        }
      }
    else if (length_value(sz, val)) {
      pos.y = ty + pixels(v, b, sz, dim).height();
      return;
    }
    pos.y = ty + dim.y;
  }

  static inline void prev_page_y(view &v, element *b, point &pos, size dim,
                                 const value &val) {
    int    ty  = target_y_pos(b);
    int    row = 0;
    range  y;
    size_v sz;
    if (is_auto_value(val) && b->get_row_at(v, ty - dim.y + 1, row))
      for (int n = 0; n < 2 && row >= 0; ++n, --row) {
        if (b->get_row_y(row, y)) {
          if (y.s >= ty) continue;
          if (y.length() < dim.y) {
            pos.y = y.s;
            return;
          }
        }
      }
    else if (length_value(sz, val)) {
      pos.y = ty - pixels(v, b, sz, dim).height();
      return;
    }
    pos.y = ty - dim.y;
  }

  int target_x_pos(element *b) {
    scroll_animator *psa = b->get_animation_of_type<scroll_animator>();
    if (psa)
      return psa->final_scroll_pos.x;
    else
      return b->scroll_pos().x;
  }

  static inline void next_step_x(view &v, element *b, point &pos, size dim,
                                 const value &val) {
    int    tx  = target_x_pos(b);
    int    col = 0;
    range  x;
    size_v sz;

    if (is_auto_value(val)) {
      if (b->get_col_at(v, tx, col))
        for (int n = 0; n < 2 && col < b->n_cols(); ++n, ++col) {
          if ((col < (b->n_cols() - 1)) && b->get_col_x(col + 1, x)) {
            if (x.s <= tx) continue;
            if (x.length() < dim.x) {
              pos.x = x.s;
              return;
            }
          } else if (b->get_col_x(col, x)) {
            if (x.length() < dim.x) {
              pos.x = x.e;
              return;
            }
          }
        }
    } else if (length_value(sz, val)) {
      pos.x = tx + pixels(v, b, sz, dim).width();
      return;
    }
    pos.x = tx + dim.x / 10;
  }

  static inline void prev_step_x(view &v, element *b, point &pos, size dim,
                                 const value &val) {
    int    tx  = target_x_pos(b);
    int    col = 0;
    range  x;
    size_v sz;

    if (is_auto_value(val)) {
      if (b->get_col_at(v, tx, col))
        for (int n = 0; n < 2 && col >= 0; ++n, --col) {
          if (b->get_col_x(col, x)) {
            if (x.s >= tx) continue;
            if (x.length() < dim.x) {
              pos.x = x.s;
              return;
            }
          }
        }
    } else if (length_value(sz, val)) {
      pos.x = tx - pixels(v, b, sz, dim).width();
      return;
    }
    pos.x = tx - dim.x / 10;
  }

  static inline void next_page_x(view &v, element *b, point &pos, size dim,
                                 const value &val) {
    int    tx  = target_x_pos(b);
    int    col = 0;
    range  x;
    size_v sz;
    if (is_auto_value(val)) {
      if (b->get_col_at(v, tx + dim.x - 1, col))
        for (int n = 0; n < 2 && col < b->n_cols(); ++n, ++col) {
          if ((col < (b->n_cols() - 1)) && b->get_col_x(col, x)) {
            if (x.s <= tx) continue;
            if (x.length() < dim.x) {
              pos.x = x.s;
              return;
            }
          } else if (b->get_col_x(col, x)) {
            if (x.length() < dim.x) {
              pos.x = x.e;
              return;
            }
          }
        }
    } else if (length_value(sz, val)) {
      pos.x = tx + pixels(v, b, sz, dim).width();
      return;
    }
    pos.x = tx + dim.x;
  }

  static inline void prev_page_x(view &v, element *b, point &pos, size dim,
                                 const value &val) {
    int    tx  = target_x_pos(b);
    int    col = 0;
    range  x;
    size_v sz;

    if (is_auto_value(val)) {
      if (b->get_col_at(v, tx - dim.x + 1, col))
        for (int n = 0; n < 2 && col >= 0; ++n, --col) {
          if (b->get_col_x(col, x)) {
            if (x.s >= tx) continue;
            if (x.length() < dim.x) {
              pos.x = x.s;
              return;
            }
          }
        }
    } else if (length_value(sz, val)) {
      pos.x = tx - pixels(v, b, sz, dim).width();
      return;
    }
    pos.x = tx - dim.x;
  }

  bool element::on(view &v, event_scroll &evt) {
    if (v.on_element_event(this, evt)) return true;

    if (evt.is_sinking()) return false;

    hstyle cs = get_style(v);
    if (cs->overflow() <= overflow_hidden) return false;

    scroll_data sd;
    get_scroll_data(v, sd);

    point prev_pos = sd.pos;

    ENSURE_VISIBLE_MANNER manner = SCROLL;

    if (evt.vertical && cs->overflow_y > overflow_hidden) switch (evt.cmd) {
      case SCROLL_HOME:
        sd.pos.y = sd.content_outline.top();
        manner   = cs->smooth_scroll_home(true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_END:
        sd.pos.y = sd.content_outline.bottom();
        manner   = cs->smooth_scroll_home(true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_STEP_PLUS:
        next_step_y(v, this, sd.pos, sd.dim_view, cs->scroll_step(true));
        manner = cs->smooth_scroll_step(true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_STEP_MINUS:
        prev_step_y(v, this, sd.pos, sd.dim_view, cs->scroll_step(true));
        manner = cs->smooth_scroll_step(true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_PAGE_PLUS: // sd.pos.y += sd.dim_view.y - 1;
        next_page_y(v, this, sd.pos, sd.dim_view, cs->scroll_page(true));
        manner = cs->smooth_scroll_page(true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_PAGE_MINUS: // sd.pos.y -= sd.dim_view.y - 1;
        prev_page_y(v, this, sd.pos, sd.dim_view, cs->scroll_page(true));
        manner = cs->smooth_scroll_page(true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_POS:
        sd.pos.y = evt.pos;
        break;
        // case SCROLL_SLIDER_RELEASED:
        //  sd.pos.y = evt.pos;
        //  break;
      }
    else if (!evt.vertical && cs->overflow_x > overflow_hidden)
      switch (evt.cmd) {
      case SCROLL_HOME:
        sd.pos.x = sd.content_outline.left();
        manner   = cs->smooth_scroll_home(false) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_END:
        sd.pos.x = sd.content_outline.right();
        manner   = cs->smooth_scroll_home(false) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_STEP_PLUS:
        next_step_x(v, this, sd.pos, sd.dim_view, cs->scroll_step(false));
        manner = cs->smooth_scroll_step(false) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_STEP_MINUS:
        prev_step_x(v, this, sd.pos, sd.dim_view, cs->scroll_step(false));
        manner = cs->smooth_scroll_step(false) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_PAGE_PLUS:
        next_page_x(v, this, sd.pos, sd.dim_view, cs->scroll_page(false));
        manner = cs->smooth_scroll_page(false) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_PAGE_MINUS:
        prev_page_x(v, this, sd.pos, sd.dim_view, cs->scroll_page(false));
        manner = cs->smooth_scroll_page(false) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_POS:
        sd.pos.x = evt.pos;
        break;
        // case SCROLL_SLIDER_RELEASED: sd.pos.x = evt.pos; break;
      }

    if (evt.cmd != SCROLL_POS) {
      sd.pos.x = limit(sd.pos.x, sd.content_outline.left(),
                       sd.content_outline.right() + 1 - sd.dim_view.x);
      sd.pos.y = limit(sd.pos.y, sd.content_outline.top(),
                       sd.content_outline.bottom() + 1 - sd.dim_view.y);
    }

    if (prev_pos == sd.pos) return false;

    return v.scroll_window(sd.pos, this, manner);
  }

  /*bool element::on(view& v, event_gesture& evt)
  {
    return v.on_element_event(this, evt);
  }*/

  bool element::on(view &v, event_gesture &evt) {
    if (v.on_element_event(this, evt)) return true;

    if (evt.is_sinking()) return false;

    hstyle cs = get_style(v);
    if (cs->overflow() <= overflow_hidden) return false;

    scroll_data sd;
    get_scroll_data(v, sd);

    switch (evt.cmd) {

    case GESTURE_REQUEST:
      evt.flags = 0;
      if (this->can_scroll_v(v)) evt.flags |= GESTURE_FLAG_PAN_VERTICAL;
      if (this->can_scroll_h(v)) evt.flags |= GESTURE_FLAG_PAN_HORIZONTAL;
      if (evt.flags) {
        evt.flags |= GESTURE_FLAG_PAN_WITH_GUTTER | GESTURE_FLAG_PAN_WITH_INERTIA;
        return true;
      }
      return false;

    case GESTURE_START:
      v.set_focus(this, BY_MOUSE);
      v.set_capture(this);
      return true;

    case GESTURE_PAN:
      if (evt.flags & GESTURE_STATE_BEGIN) {
        return true;
      } else if (evt.flags & GESTURE_STATE_END) {
        v.set_capture(nullptr);
        return true;
      } else {
        v.scroll_window(sd.pos += evt.delta_xy, this, SCROLL, true, false);
        return true;
      }
    }

    return false;

#if 0
    scroll_data sd;
    get_scroll_data(v, sd);

    point prev_pos = sd.pos;

    ENSURE_VISIBLE_MANNER manner = SCROLL;

    if (evt.vertical && cs->overflow_y > overflow_hidden)
      switch (evt.cmd)
      {
      case SCROLL_HOME:       sd.pos.y = sd.content_outline.top();
        manner = cs->smooth_scroll_home(true, true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_END:        sd.pos.y = sd.content_outline.bottom();
        manner = cs->smooth_scroll_home(true, true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_STEP_PLUS:
        next_step_y(v, this, sd.pos, sd.dim_view, cs->scroll_step(true));
        manner = cs->smooth_scroll_step(true, true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_STEP_MINUS: prev_step_y(v, this, sd.pos, sd.dim_view, cs->scroll_step(true));
        manner = cs->smooth_scroll_step(true, true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_PAGE_PLUS:  //sd.pos.y += sd.dim_view.y - 1;
        next_page_y(v, this, sd.pos, sd.dim_view, cs->scroll_page(true));
        manner = cs->smooth_scroll_page(true, true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_PAGE_MINUS: //sd.pos.y -= sd.dim_view.y - 1;
        prev_page_y(v, this, sd.pos, sd.dim_view, cs->scroll_page(true));
        manner = cs->smooth_scroll_page(true, true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_POS:
        sd.pos.y = evt.pos;
        break;
        //case SCROLL_SLIDER_RELEASED:
        //  sd.pos.y = evt.pos;
        //  break;

      }
    else if (!evt.vertical && cs->overflow_x > overflow_hidden)
      switch (evt.cmd)
      {
      case SCROLL_HOME:       sd.pos.x = sd.content_outline.left(); manner = cs->smooth_scroll_home(false, true) ? SCROLL_SMOOTH : SCROLL; break;
      case SCROLL_END:        sd.pos.x = sd.content_outline.right(); manner = cs->smooth_scroll_home(false, true) ? SCROLL_SMOOTH : SCROLL; break;
      case SCROLL_STEP_PLUS:  next_step_x(v, this, sd.pos, sd.dim_view, cs->scroll_step(false));
        manner = cs->smooth_scroll_step(false, true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_STEP_MINUS: prev_step_x(v, this, sd.pos, sd.dim_view, cs->scroll_step(false));
        manner = cs->smooth_scroll_step(false, true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_PAGE_PLUS:  next_page_x(v, this, sd.pos, sd.dim_view, cs->scroll_page(false));
        manner = cs->smooth_scroll_page(false, true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_PAGE_MINUS: prev_page_x(v, this, sd.pos, sd.dim_view, cs->scroll_page(false));
        manner = cs->smooth_scroll_page(false, true) ? SCROLL_SMOOTH : SCROLL;
        break;
      case SCROLL_POS:
        sd.pos.x = evt.pos;
        break;
        //case SCROLL_SLIDER_RELEASED: sd.pos.x = evt.pos; break;
      }

    if (evt.cmd != SCROLL_POS) {
      sd.pos.x = limit(sd.pos.x, sd.content_outline.left(), sd.content_outline.right() + 1 - sd.dim_view.x);
      sd.pos.y = limit(sd.pos.y, sd.content_outline.top(), sd.content_outline.bottom() + 1 - sd.dim_view.y);
    }

    if (prev_pos == sd.pos)
      return false;

    return v.scroll_window(sd.pos, this, manner);
#endif
  }

  bool element::on(view &v, event_behavior &evt) {
    bool found = false;
        
    /* Tried to set [NSView setWantsLayer: YES] on OSX, but it seems it does not support dynamic layer creation
    if(evt.cmd == ANIMATION || evt.cmd == (ANIMATION | EVENT_HANDLED))
    {
      if( !evt.processed ) {
        iwindow* pw = parent && state.popup()? window(v): &v;
        if( pw ) {
          pw->on_animation( evt.reason != 0 );
          evt.processed = true;
        }
      }
    }
    else*/ if (evt.cmd == CONTEXT_MENU_REQUEST) // menu popup request
    {
      hstyle cs = get_style(v);
      if (cs->context_menu_sel.length()) {
        if (cs->context_menu_sel == CHARS("none")) {
          found   = true;
          evt.cmd = CONTEXT_MENU_REQUEST | EVENT_HANDLED;
        } else {
          if (state.owns_popup()) return true;
          document *pd = doc();
          helement  cm = find_first(v, pd, ustring(cs->context_menu_sel));
          if (cm) {
            if (evt.source == 0) {
              //??? evt.target = this;
              evt.source = cm;
              found      = true;
              evt.cmd    = CONTEXT_MENU_REQUEST | EVENT_HANDLED;
            } else {
#pragma TODO("context menu modification!")
            }
          }
        }
      } else if (cs->context_menu_url.length()) {
        if (state.owns_popup()) return true;

        helement m = create_context_menu(v, cs->context_menu_url, evt);
        if (m) {
          //??? evt.target = this;
          evt.source = m;
          found      = true;
        } else {
#pragma TODO("context menu modification!")
        }
      }
    } else if (evt.cmd == CLOSE_POPUP) {
      if (this == evt.target.ptr() && state.popup()) {
        v.close_popup(this, false);
        return true;
      }
    }

    bool handled = v.on_element_event(this, evt);

    if (evt.cmd == POPUP_DISMISSED || evt.cmd == (POPUP_DISMISSED | EVENT_HANDLED))
    {
      if (evt.target == this)
        state_off(v, S_OWNS_POPUP);
    }

    if (handled)
      return true;


    switch (evt.cmd) {
    case MENU_ITEM_CLICK:
    case BUTTON_CLICK:
    case HYPERLINK_CLICK:
#if 0
      if (get_style(v)->act_click) {
        if (eval_action(v, evt, get_style(v)->act_click)) return true;
      }
#endif
      break;
    case BUTTON_STATE_CHANGED:
    case SELECT_SELECTION_CHANGED:
    case EDIT_VALUE_CHANGED:
#if 0
      if (get_style(v)->act_value_changed) {
        if (eval_action(v, evt, get_style(v)->act_value_changed))
          // evt.cmd |= EVENT_HANDLED;
          return true;
      }
#endif
      break;
    case CLOSE_POPUP_TREE:
      v.close_owned_popups(evt.target);
      return true;
      /* NOTE: this notification is meant only to children of element whose
         state.disabled changes, see notify_disabled_status_change() case
         DISABLED_STATUS_CHANGED: each_ui_child([&evt,&v](element* el)->bool {
                el->on(v,evt);
                return true;
              });*/
    }
    return found;
  }

  bool element::on(view &v, event_focus &evt) {
    switch (evt.cmd) {
    case GOT_FOCUS:
    case GOT_FOCUS | EVENT_HANDLED:
      if (v.focus_element == this) 
      {
        state_focus_on(v, evt.cause == BY_KEY_NEXT || evt.cause == BY_KEY_PREV);
#if 0
        if (get_style(v)->act_focus_on) {
          if (eval_action(v, evt, c_style->act_focus_on))
            evt.cmd |= EVENT_HANDLED;
        }
#endif
      }
      break;
    case LOST_FOCUS:
    case LOST_FOCUS | EVENT_HANDLED:
      if (v.focus_element == this) {
        state_focus_off(v);
#if 0
        if (get_style(v)->act_focus_off) {
          if (eval_action(v, evt, c_style->act_focus_off))
            evt.cmd |= EVENT_HANDLED;
        }
#endif
      }
      break;

    case FOCUS_IN:
    case FOCUS_IN | EVENT_HANDLED:
#ifdef _DEBUG
      if (this->tag == tag::T_INPUT) evt.cmd = evt.cmd;
#endif // _DEBUG

      if (!state.owns_focus()) { state_on(v, S_OWNS_FOCUS); }
      break;
    case FOCUS_OUT:
    case FOCUS_OUT | EVENT_HANDLED:
      if (state.owns_focus()) { state_off(v, S_OWNS_FOCUS); }
      break;
    }

    return v.on_element_event(this, evt);
  }

  bool element::on_internal(view &v, event_behavior &evt) {
    hstyle cs = get_style(v);
    switch (evt.cmd) {
    case DO_SET_FOCUS: {
      if (is_focusable(v)) {
        v.set_focus(this, BY_CODE);
        return true;
      }
    } break;
    }
    return false;
  }

  bool element::on_timer(view &v, timer_def& td) {
#if 0
    if (id == CSSS_TIMER_ID && kind == CSSS_TIMER) {
      hstyle cs = get_style(v);
      if (cs->act_timer) {
        event dummy(this, 0);
        if (eval_action(v, dummy, cs->act_timer)) v.stop_timer(this, id, kind);
        drop_styles(v);
        v.update_element(this);
        return true;
      }
      return false;
    } else 
#endif
           if ((td.id == SCROLLBAR_TIMER_ID
             || td.id == SCROLLBAR_INACTIVE_TIMER_ID
             || td.id == SCROLLBAR_EXPANSION_TIMER_ID) && td.kind == INTERNAL_TIMER) {
      return ldata->sb.on_timer_tick(v, this, td.id);
    } else if (td.id == DELAYED_MEASURE_TIMER_ID && td.kind == INTERNAL_TIMER) {
      do_delayed_measure(v);
      return false; // stop it
    }

    return v.on_element_timer(this, td);
  }

  /*element *block_element(view& v, element* b)
  {
    for(; b; b = b->owner ? b->owner: b->parent )
    {
      if(b->is_block_element(v))
         return b;
    }
    assert(0);
    return 0;
  }*/

  bool element::state_on(view &v, ui_state st) {
    state = get_state(false);

    if (state.is_set(st)) return true;

    helement self = this; 

    ui_state st_tosearch = st;

    if (st.collapsed())
      st_tosearch.data |= S_EXPANDED;
    else if (st.expanded())
      st_tosearch.data |= S_COLLAPSED;

    if (st.checked()) st_tosearch.data |= S_UNCHECKED;
    if (st.unchecked()) st_tosearch.data |= S_CHECKED;

    // NOTE: each behavior is responsible for setting :current properly
    if (st.current() && !state.current()) {
      v.reset_current_in(this->get_owner());
      event_behavior evt(this, this, CURRENT_ELEMENT_CHANGED, 0);
      v.post_behavior_event(evt, true);
    }

    if (st.disabled()) {
      element *owner = get_owner();
      if (owner && v.focus_element &&
          v.focus_element->belongs_to(v, this, true))
        v.post_set_focus(owner, BY_CODE);
    }

#ifdef _DEBUG
    if (st.busy())
      st = st;
    if (st.current())
      st = st;
    if (st.owns_popup())
      this->dbg_report("S_OWNS_POPUP on");
    if (st.owns_focus())
      this->dbg_report("S_OWNS_FOCUS ON");
    if(st.hover() && this->tag == tag::T_TR)
      st = st;
#endif // _DEBUG
    
    ui_state      prev_st    = state;
    handle<style> prev_style = c_style;

    state += st.data;

    document *d = doc();
    if (!d) {
      flags.state_initialized = 1;
      return false;
    }

    element *nsb = 0;

#if 0
    bool deep_style_check =
        n_children() < 32; // ATTN: heuristic a.k.a magic numbers!!!

    if (d->has_pseudo_classes_for(this, st_tosearch, deep_style_check)) 
#else
    if(style_state.is_set(st_tosearch))
#endif
    {
      helement b = nearest_box_or_row();
      v.refresh(b);
      if( flags.in_determine_style )
        drop_styles(v);
      else
        b->drop_layout_tree(&v,true);
      v.add_to_update(b, true);

      // -- 
      // -- get_style_no_cache(v);
      // -- resolve_styles(v);

      // selectors a + b

      if (flags.has_sibling_selector) {
        nsb = next_element();
        if (nsb) {
          v.drop_styles(nsb);
          v.add_to_update(nsb, true);
          // -- 
          // -- nsb->get_style_no_cache(v);
          // -- nsb->resolve_styles(v);
        }
      }

    } else if (st.disabled()) {
      v.refresh(this);
      //reset_styles(v);
      v.drop_styles(this);
    }

    if (st.disabled()) notify_disabled_status_change(v, true);

    //assert(get_state(false).is_set(st));
    return true;
  }

  bool element::state_off(view &v, ui_state st) {
    document *d = doc();
    if (!d) {
      state -= st.data;
      flags.state_initialized = 1;
      return false;
    }

    helement self = this;

    state = get_state(false);

#ifdef _DEBUG
    if (st.owns_focus()) {
       this->dbg_report("S_OWNS_FOCUS OFF");
    }
#endif

    if (st.owns_focus() && this == v.doc() && v.is_active())
      st.owns_focus(false);

    if (st.owns_popup()) {
#ifdef _DEBUG
      this->dbg_report("S_OWNS_POPUP off");
      bool op = state.owns_popup();
#endif
      if (v.popup_of_anchor(this)) // it owns other popups
        st.owns_popup(false);
    }

    if (state.is_clear(st.data)) return true;

    ui_state st_tosearch = st;

    if (st.collapsed() && st.expanded())
      st_tosearch.data |= S_EXPANDED | S_COLLAPSED;
    else if (st.collapsed())
      st_tosearch.data |= S_EXPANDED;
    else if (st.expanded())
      st_tosearch.data |= S_COLLAPSED;

    if (st.checked()) st_tosearch.data |= S_UNCHECKED;
    if (st.unchecked()) st_tosearch.data |= S_CHECKED;

    if (state.popup() && st.popup()) {
      v.close_popup(this, false);
      if (st.data == S_POPUP) return true; // done!
    }

    ui_state      prev_st    = state;
    handle<style> prev_style = c_style;

#if 0
    bool deep_style_check = n_children() < 32; // ATTN: heuristic!!!

    if (d->has_pseudo_classes_for(this, get_state(false).mask(st_tosearch),
                                  deep_style_check)) 
#else
    if (style_state.is_set(st_tosearch))
#endif
    {
      //hstyle cs = get_style(v);

      helement b = nearest_box_or_row();
      //v.drop_styles(b);--WRONG
      if (flags.in_determine_style)
        drop_styles(v);
      else
        b->drop_layout_tree(&v, true);
      v.add_to_update(b, true);

      state -= st.data;

      //-- 
      //-- get_style_no_cache(v);
      //-- resolve_styles(v);

      if (flags.has_sibling_selector) {
        element *nsb = next_element();
        if (nsb) {
          v.drop_styles(nsb);
          v.add_to_update(nsb, true);
          //-- 
          //-- nsb->get_style_no_cache(v);
          //-- nsb->resolve_styles(v);
        }
      }
    } else if (st.disabled()) {
      state -= st.data;
      v.drop_styles(this);
    } else
      state -= st.data;

    if (st.disabled()) notify_disabled_status_change(v, false);

    // v.render();
    return true;
  }

  bool element::state_focus_on(view &v, bool by_key) {

    helement self = this;

    state.focus(true);
    if (by_key) state.tabfocus(true);

    handle<document> d = doc();
    if (!d) return false;
#if 0
    if (d->has_pseudo_classes_for(this, state, true)) 
#else
    if (style_state.is_set(state))
#endif
    {
      helement b = nearest_box();
      v.drop_styles(b);
    } else
      v.drop_styles(this);

    if (flags.has_sibling_selector) {
      if (helement nsb = self->next_element()) 
        v.drop_styles(nsb);
    }
    return true;
  }

  bool element::state_focus_off(view &v) {

    helement self = this;

    handle<document> d = doc();
    if (!d) return false;

#if 0
    if (d->is_it_visible(v) && d->has_pseudo_classes_for(this, state, true)) 
#else
    if (d->is_it_visible(v) && style_state.is_set(state))
#endif
    {
      helement b = nearest_box();
      state.focus(false);
      state.tabfocus(false);
      state.active(false);
      v.drop_styles(b);
    } else {
      state.focus(false);
      state.tabfocus(false);
      state.active(false);
      v.drop_styles(this);
    }

    if (flags.has_sibling_selector) {
      if (helement nsb = self->next_element()) 
        nsb->drop_styles(v);
    }

    return true;
  }

  bool element::set_state(ui_state st, view *pv) {
    if (st.data == 0) return false;

    if (pv && st.focus()) {
      st.focus(false);
      pv->set_focus(this, BY_CODE);
    }

    flags.state_initialized = 1;

    /*if(pv) current_style(*pv);*/

    if (pv && (st.data & NOTIFICATION_STATES_BITMASK))
      for (element *t = this; t; t = t->get_owner()) {
        behavior_h pc = t->behavior;
        while (pc) {
          if (pc->set_child_state(*pv, t, this, st)) return true;
          pc = pc->next;
        }
      }

    if (pv) return state_on(*pv, st);

    state += st.data;

    return false;
  }

  bool element::reset_state(ui_state st, view *pv) {
    if (st.data == 0) return false;

    flags.state_initialized = 1;

    /*if(pv) current_style(*pv);*/

    if (pv && (st.data & NOTIFICATION_STATES_BITMASK))
      for (element *t = this; t; t = t->get_owner()) {
        behavior_h pc = t->behavior;
        while (pc) {
          if (pc->reset_child_state(*pv, t, this, st)) return true;
          pc = pc->next;
        }
      }

    if (pv) return state_off(*pv, st);
    state -= st.data;
    return false;
  }


  void element::notify_disabled_status_change(view &v, bool disabled) {
    // NOTE: this notification is meant only to children of element whose
    // state.disabled changes so we are not posting it upstream  event_behavior
    // evt(this, this, DISABLED_STATUS_CHANGED, disabled);
    // v.post_behavior_event(evt, true);
    handle<view>    pv   = &v;
    handle<element> self = this;
    v.post([pv, self, disabled]() -> bool {
      auto_state<hstyle> _1(self->c_style);
      auto_state<hstyle> _2(self->p_style);
      auto_state<hstyle> _3(self->d_style);
      event_behavior     evt(self, self, DISABLED_STATUS_CHANGED, disabled);
      self->on(*pv, evt);
      element_iterator it(*pv, self);
      for (element *child; it(child);)
        child->on(*pv, evt);
      return true;
    });

    if (iwindow* pw = window(v))
      pw->set_enabled(!disabled);

  }

  void element::notify_readonly_status_change(view &v, bool readonly) {
    // v.post( delegate(this, &element::_notify_disabled_status_change, &v,
    // disabled), true);
    v.post([&]() -> bool {
      auto_state<hstyle> _1(c_style);
      auto_state<hstyle> _2(p_style);
      auto_state<hstyle> _3(d_style);
      event_behavior     evt(this, this, READONLY_STATUS_CHANGED, readonly);
      on(v, evt);
      element_iterator it(v, this);
      for (element *child; it(child);)
        child->on(v, evt);
      return true;
    });
  }

  // view/element event thunks

  bool view::on_element_event(element *b, event_mouse &evt) {
    if (b->state.disabled()) return false;
    return traverse_element_event(b, evt);
  }

  bool view::on_element_event(element *b, event_gesture &evt) {
    return traverse_element_event(b, evt);
  }

  bool view::on_element_event(element *b, event_key &evt) {
    if (b->state.disabled()) return false;
    return traverse_element_event(b, evt);
  }
  bool view::on_element_event(element *b, event_focus &evt) {
    if (b->state.disabled()) return false;
    return traverse_element_event(b, evt);
  }
  bool view::on_element_event(element *b, event_scroll &evt) {
    if (b->state.disabled()) return false;
    return traverse_element_event(b, evt);
  }

  bool view::on_element_event(element *b, event_behavior &evt) 
  {
    if (evt.cmd == CONTENT_CHANGED)
    {
      if (auto al = b->get_a11y_live(*this)) {
        event_behavior sevt(b, b, ARIA_LIVE_AREA_CHANGED, al);
        post_behavior_event(sevt, true);
      }
    }
    else if (evt.cmd == CURRENT_ELEMENT_CHANGED)
      this->on_current_changed(evt.source);
    return traverse_element_event(b, evt);
  }
  bool view::on_element_event(element *b, event_command &evt) {
    if (b->state.disabled()) return false;
    return traverse_element_event(b, evt);
  }

  bool view::on_element_event(element *b, event_exchange &evt) {
    switch (evt.cmd) {
    case X_DRAG_ENTER:
      if (traverse_element_event(b, evt)) {
        b->state_on(*this, S_DRAG_OVER);
        return true;
      }
      return false;
    case X_DRAG_LEAVE:
    case X_DRAG_LEAVE | EVENT_SINKING:
    case X_DRAG_CANCEL:
    case X_DRAG_CANCEL | EVENT_SINKING:
      if (b->state.drag_over()) {
        b->state_off(*this, S_DRAG_OVER);
        refresh(b);
      }
      return traverse_element_event(b, evt);
    default: 
      return traverse_element_event(b, evt);
    }
  }

  bool view::on_element_timer(element *b, timer_def& td) {
    if (!b) 
      return false;

    helement   guard = b;
    behavior_h pc    = b->behavior;
    while (pc) {
      if (pc->will_handle(HANDLE_TIMER) && pc->on_timer(*this, b, td.id, td.kind))
        return true;
      behavior_h next = pc->next;
      pc              = next;
    }
    return false;
  }

  bool view::may_have_on_size_handler(element *b) {
    hstyle cs = b->get_style(*this);
#if 0
    if (cs->act_size_changed) return true;
#endif
    if (b->behavior) {
      behavior_h pc    = b->behavior;
      helement   guard = b;
      while (pc) {
        if (pc->will_handle(HANDLE_SIZE)) return true;
        pc = pc->next;
      }
    }
    return false;
  }

  void view::on_element_client_size_changed(element *b) {
    if (b->behavior) {
      behavior_h pc    = b->behavior;
      helement   guard = b;
      while (pc) {
        if (pc->will_handle(HANDLE_SIZE)) 
          pc->on_size_changed(*this, b);
        behavior_h next = pc->next;
        pc              = next;
      }
    }
  }

  bool view::get_element_native_value(helement el, value &v, bool ignore_text_value) {
    el->get_style(*this); // to force style to be resolved
    el->check_layout(*this);
    behavior_h pc = el->behavior;
    while (pc) {
      if (pc->get_value(*this, el, v)) return true;
      pc = pc->next;
    }
    ustring us;
    if (el->tag == tag::T_INPUT) {
      v = el->atts(attr::a_value);
      return true;
    } else if (el->get_attr_value(v))
      return true;
    else 
      return el->default_get_value(*this, v, ignore_text_value);
    return false;
  }

  bool view::set_element_native_value(helement el, const value &v, bool ignore_text_value) {
    el->get_style(*this); // to force style to be resolved
    el->check_layout(*this);
    behavior_h pc = el->behavior;
    while (pc) {
      if (pc->set_value(*this, el, v)) { return true; }
      pc = pc->next;
    }
    return el->default_set_value(*this, v, ignore_text_value);
  }

} // namespace html
