#include "html.h"

namespace html {

#if 1
  void ostream::xwrite(wchars str) {
    const wchar *ps = str.start;
    const wchar *po = ps;
    const wchar *pe = str.end();

    for (; ps < pe; ++ps)
      switch (*ps) {
      case '<':
        write(wchars::range(po, ps));
        po = ps + 1;
        write(CHARS("&lt;"));
        break;
      case '>':
        write(wchars::range(po, ps));
        po = ps + 1;
        write(CHARS("&gt;"));
        break;
      case '&':
        write(wchars::range(po, ps));
        po = ps + 1;
        write(CHARS("&amp;"));
        break;
      case '\"':
        write(wchars::range(po, ps));
        po = ps + 1;
        write(CHARS("&quot;"));
        break;
      case NBSP_CHAR:
        write(wchars::range(po, ps));
        po = ps + 1;
        write(CHARS("&nbsp;"));
        break;
        // case BR:   write(wchars::range(po,ps)); po = ps+1;
        // write(CHARS("<br/>")); break;
      }
    write(wchars::range(po, ps));
  }
#else
  void ostream::xwrite(wchars str) {
    const wchar *ps = str.start;
    const wchar *po = ps;
    const wchar *pe = str.end();

    for (; ps < pe; ++ps)
      switch (*ps) {
      case '<': write(CHARS("&lt;")); break;
      case '>': write(CHARS("&gt;")); break;
      case '&': write(CHARS("&amp;")); break;
      case '\"':
        write(CHARS("&quot;"));
        break;
        // case NBSP_CHAR: write(CHARS("&nbsp;")); break;
      default: {
        wchar c = *ps;
        write(wchars(c));
        break;
      }
      }
  }
#endif

  void attribute_bag::emit(ostream &os) {
    auto_state<bool> _(os.xlate, true);
    for (int i = 0; i < size(); i++) {
      ustring val = value(i);
      if(val.length())
        os << CHARS(" ") << name(i) << CHARS("=\"") << val << CHARS("\"");
      else
        os << CHARS(" ") << name(i);
    }
  }

  void text::emit(ostream &os, emit_ctx *pectx) {
    if (pectx && (pectx->anchor.node == this || pectx->caret.node == this)) {
      auto t = chars();
      for (int n = 0; n < t.size(); ++n) {
        if (pectx->caret.node == this && n == pectx->caret.pos &&
            !pectx->caret.after_it)
          pectx->at_caret();
        if (pectx->anchor.node == this && n == pectx->anchor.pos &&
            !pectx->anchor.after_it)
          pectx->at_anchor();
        os << t[n];
        if (pectx->caret.node == this && n == pectx->caret.pos &&
            pectx->caret.after_it)
          pectx->at_caret();
        if (pectx->anchor.node == this && n == pectx->anchor.pos &&
            pectx->anchor.after_it)
          pectx->at_anchor();
      }
    } else
      os << chars();
  }
  void comment::emit(ostream &os, emit_ctx *pectx) {
    auto_state<bool> _(os.xlate, true);
    os << CHARS("<!--") << chars() << CHARS("-->");
  }

  void element::emit(ostream &os, emit_ctx *pectx) {

    if (pectx) {
      if (pectx->anchor == this->start_pos()) 
        pectx->at_anchor();
      if (pectx->caret == this->start_pos()) 
        pectx->at_caret();
    }

    if (state.synthetic() || flags.is_synthetic) {
      // if( n_children() || flags.is_synthetic )
      emit_content(os);
    } else if (emit_head(os, pectx)) {
      emit_content(os, pectx);
      emit_tail(os, pectx);
    }

    if (pectx) {
      if (pectx->anchor == this->end_pos()) 
        pectx->at_anchor();
      if (pectx->caret == this->end_pos()) 
        pectx->at_caret();
    }
  }

  bool element::emit_head(ostream &os, emit_ctx *pectx) {
    /*if (pectx) {
      if (pectx->caret.node == this && pectx->caret.at_element_start())
        pectx->at_caret();
      if (pectx->anchor.node == this && pectx->anchor.at_element_start())
        pectx->at_anchor();
    }*/

    os << CHARS("<") << tag::symbol_name(tag);
    atts.emit(os);

    tag::PMODEL_TYPE pm = tag::parsing_model(tag);

    if (pm == tag::PMODEL_NO_TAIL) {
      os << CHARS("/>");
      return false;
    } else {
      os << CHARS(">");
      return true;
    }
  }

  void element::emit_tail(ostream &os, emit_ctx *pectx) {
    os << CHARS("</") << tag::symbol_name(tag) << CHARS(">");
    /*if (pectx) {
      if (pectx->caret.node == this && pectx->caret.at_element_end())
        pectx->at_caret();
      if (pectx->anchor.node == this && pectx->anchor.at_element_end())
        pectx->at_anchor();
    }*/
  }

  void element::emit_content(ostream &os, emit_ctx *pectx) {
    bool             xlate = tag::parsing_model(tag) != tag::PMODEL_CDATA;
    auto_state<bool> _(os.xlate, xlate);

/*    if (pectx && (pectx->anchor.node == this || pectx->caret.node == this)) {
      for (node *n = first_node(); n; n = n->next_node()) {
        if (pectx->caret.node == this &&
            int(n->node_index) == pectx->caret.pos && !pectx->caret.after_it)
          pectx->at_caret();
        if (pectx->anchor.node == this &&
            int(n->node_index) == pectx->anchor.pos && !pectx->anchor.after_it)
          pectx->at_anchor();
        n->emit(os, pectx);
        if (pectx->caret.node == this &&
            int(n->node_index) == pectx->caret.pos && pectx->caret.after_it)
          pectx->at_caret();
        if (pectx->anchor.node == this &&
            int(n->node_index) == pectx->anchor.pos && pectx->anchor.after_it)
          pectx->at_anchor();
      }
    } else */
      for (node *n = first_node(); n; n = n->next_node())
        n->emit(os, pectx);
  }

  /*void emit_element_start_until(element* b, element* p, ostream& out)
  {
  if(b == p) return;
  emit_element_start_until(b->parent, p, out);
  b->emit_head(out);
  }*/

  void emit_element_start(element *b, element *upto, ostream &out) {
    if (b == 0 || b->is_document()) return;
    if (b == upto) return;
    if (b->parent) emit_element_start(b->parent, upto, out);
    b->emit_head(out);
  }

  void emit_element_end(element *b, element *upto, ostream &out) {
    if (b == 0 || b->is_document()) return;
    if (b == upto) return;
    b->emit_tail(out);
    if (b->parent) emit_element_end(b->parent, upto, out);
  }

  element *element_of(node *n) {
    if (n->is_element()) return n->cast<element>();
    return n->parent;
  }

  void emit_cell_range_html(view &v, ostream &out, helement tbody,
                            slice<helement> cells) {
    out << CHARS("<table>");
    out << CHARS(MARKER_START_FRAGMENT);

    uint row_n = uint(-1);

    for (int n = 0; n < cells.size(); ++n) {
      helement cell = cells[n];
      if (cell->parent->node_index != row_n) {
        if (row_n != uint(-1)) out << CHARS("</tr>");
        row_n = cell->parent->node_index;
        out << CHARS("<tr>");
      }
      cell->emit(out);
    }

    if (row_n != uint(-1)) out << CHARS("</tr>");
    out << CHARS(MARKER_END_FRAGMENT);
    out << CHARS("</table>");
  }

  void emit_range_html(view &v, ostream &out, const bookmark &start,
                       const bookmark &end, element* root) {
    // int level = 0;

    pos_iterator it(start, end);

    bool emit_markers = root != nullptr;

    node *cpn = node::find_base(start.node, end.node);

    // if (emit_markers) out << CHARS("<html>"); - see html_cf

    if (!cpn->is_element()) {
      assert(cpn == start.node && cpn == end.node);
      if (emit_markers) out << CHARS(MARKER_START_FRAGMENT);
      for (bookmark bm; it(bm);) {
        if (it.char_code) out << it.char_code;
      }
      if (emit_markers) {
        out << CHARS(MARKER_END_FRAGMENT);
        out << CHARS("</html>");
      }
      return;
    }

    element *cp = cpn->cast<element>();
    bool cp_inside_root = cp->belongs_to(root, false);
#ifdef _DEBUG
    cp->dbg_report("cp");
#endif
    if (start.at_element_start() && start.node == cp) {
      if (emit_markers) out << CHARS(MARKER_START_FRAGMENT);
      // cp->emit_head(out);
    } else if (start.at_text_start()) {
      if (cp && cp_inside_root) cp->emit_head(out);
      if (emit_markers) out << CHARS(MARKER_START_FRAGMENT);
      emit_element_start(element_of(start.node), cp, out);
    } else if (start.at_element_start()) {
      if (cp && cp_inside_root) cp->emit_head(out);
      if (emit_markers) out << CHARS(MARKER_START_FRAGMENT);
      if (!element_of(start.node)->is_atomic_box())
        emit_element_start(element_of(start.node), cp, out);
    } else {
      if (cp && cp_inside_root) cp->emit_head(out);
      emit_element_start(element_of(start.node), cp, out);
      if (emit_markers) out << CHARS(MARKER_START_FRAGMENT);
    }

    for (bookmark bm; it(bm);) {
      if (it.char_code) out << it.char_code;

      if (bm.at_element_start())
        bm.node.ptr_of<element>()->emit_head(out);
      else if (bm.at_element_end())
        bm.node.ptr_of<element>()->emit_tail(out);
      else if (bm.at_comment_start())
        out << CHARS("<!--");
      else if (bm.at_comment_end())
        out << CHARS("-->");
    }

    if (end.at_element_end() && end.node == cp) {
      if (emit_markers) out << CHARS(MARKER_END_FRAGMENT);
    } else if (end.at_text_end()) {
      emit_element_end(element_of(end.node), cp, out);
      if (emit_markers) out << CHARS(MARKER_END_FRAGMENT);
      if (cp && cp_inside_root) cp->emit_tail(out);
    } else if (end.at_element_end()) {
      if (!element_of(end.node)->is_atomic_box())
        emit_element_end(element_of(end.node), cp, out);
      if (emit_markers) out << CHARS(MARKER_END_FRAGMENT);
      if (cp && cp_inside_root) cp->emit_tail(out);
    } else {
      if (emit_markers) out << CHARS(MARKER_END_FRAGMENT);
      emit_element_end(element_of(end.node), cp, out);
      if (cp && cp_inside_root) cp->emit_tail(out);
    }
    // if (emit_markers) out << CHARS("</html>");
  }

#if 0
  void emit_range_text(view& v, ostream& out, const bookmark& start, const bookmark& end)
  {
    //int level = 0;

    auto_state<bool> _(out.xlate, false);


    pos_ui_iterator it(v, start, end);

    node* cpn = node::find_common_parent(start.node, end.node);
    if (!cpn->is_element())
    {
      assert(cpn == start.node && cpn == end.node);
      for (bookmark bm; it(bm);)
      {
        out << it.char_buf();
        it.char_buf.clear();
      }
      return;
    }

    //text_block* ptb = 0;

    bool need_crlf = false;

    for (bookmark bm; it(bm);)
    {
      if (it.char_buf.size())
      {
        if (need_crlf) {
          out << CHARS("\r\n");
          need_crlf = false;
        }
        out << it.char_buf();
        it.char_buf.clear();
      }
      if (bm.at_element_start())
      {
        element* el = bm.node.ptr_of<element>();
        if (el->tag == tag::T_BR)
          out << CHARS("\r\n");
        else if (el->ctl_type(v) == CTL_IMAGE) {
          auto s = el->atts.get_ustring(attr::a_alt);
          out << s();
        }
      }
      else if (bm.at_element_end() && bm.node->get_element()->is_block_element(v))
      {
        //out << CHARS("\r\n");
        need_crlf = true;
      }
    }
  }
#else
  void emit_range_text(view &v, ostream &out, const bookmark &start,
                       const bookmark &end) {
    // int level = 0;

    auto_state<bool> _(out.xlate, false);

    // pos_ui_iterator it(v,start, end);

    pos_iterator it(start, end);

    bool is_visible  = true;
    bool collapse_ws = start.node->get_element()->get_style(v)->collapse_ws();
    bool last_ws     = true;
    int  counter = 0;

    auto write = [&](wchar c) {
      if (!is_visible) return;
      if (collapse_ws) {
        bool ws = is_space(c);
        if (ws && counter == 0) {
          out << c;
          last_ws = true;
        }
        else if (!ws) {
          out << c;
          last_ws = false;
        } else if (!last_ws) {
          out << ' ';
          last_ws = true;
        }
      } else {
        last_ws = false;
        if (c == '\n')
          out << CHARS("\r\n");
        else
          out << c;
      }
      ++counter;
    };

    auto write_chars = [&](wchars s) {
      while (!!s)
        write(s++);
    };

    node *cpn = node::find_common_parent(start.node, end.node);
    if (!cpn->is_element()) {
      assert(cpn == start.node && cpn == end.node);
      for (bookmark bm; it(bm);)
        if (it.char_code) write(it.char_code);
      write(it.char_code);
      return;
    }

    // text_block* ptb = 0;

    bool need_crlf = false;

    for (bookmark bm; it(bm);) {
      if (it.char_code && bm.node->is_text()) {
        if (need_crlf) {
          out << CHARS("\r\n");
          need_crlf = false;
        }
        write(it.char_code);
      }
      if (bm.at_element_start()) {
        element *el = bm.node.ptr_of<element>();
        collapse_ws = el->get_style(v)->collapse_ws();
        is_visible  = el->is_visible(v);
        last_ws     = true;
        if (el->tag == tag::T_BR)
          out << CHARS("\r\n");
        else if (el->ctl_type(v) == CTL_IMAGE) {
          auto s = el->atts.get_ustring(attr::a_alt);
          write_chars(s());
        }
      } else if (bm.at_element_end()) {
        if (need_crlf) {
          out << CHARS("\r\n");
          need_crlf = false;
        }
        element *el = bm.node.ptr_of<element>();
        if (el->is_block_element(v)) {
          if (bm.node->parent) {
            collapse_ws =
                bm.node->get_element()->parent->get_style(v)->collapse_ws();
            last_ws = true;
          }
          if (is_visible) need_crlf = true;
        }
        if (el->parent) is_visible = el->parent->is_visible(v);
      }
    }

    if (need_crlf) {
      out << CHARS("\r\n");
      need_crlf = false;
    }

    if (it.char_code) write(it.char_code);
  }

  void emit_cell_range_text(view &v, ostream &out, helement tbody,
                            slice<helement> cells) {
    for (int n = 0; n < cells.size(); ++n) {
      // cell->emit(out);
      emit_range_text(v, out, cells[n]->start_pos(), cells[n]->end_pos());
    }
  }

#endif
}