#include "html.h"

namespace html {
  namespace behavior {

    struct scrollbar_ctl_factory : ctl_factory {
      scrollbar_ctl_factory() : ctl_factory("scroll-bar") {}
      virtual ctl *create(element *el) override;
    };

    static scrollbar_ctl_factory *_scrollbar_ctl_factory = 0;

    /*struct scroll_value_params : method_params {
      int value;
      int min_value;
      int max_value;
      int page_value; // page increment
      int step_value; // step increment (arrow button click)
    };

    /*struct hosted_scrollbar : public scrollbar {
      weak_handle<element> host;

      hosted_scrollbar(element* ph) : host(ph) {}

      virtual bool is_external() const override {  return true;  }

      virtual void do_layout(view &v, element *b) override {
        scrollbar::do_layout(v, host);
      }

    };*/

    struct scrollbar_ctl : ctl, scrollbar
    {
      element* self = nullptr;
      bool allow_overscroll = false;
      bool processing_onscroll = false;
      handle<element> observable;

      virtual CTL_TYPE get_type() { return CTL_SCROLLBAR; }

      scrollbar_ctl() : self(nullptr), allow_overscroll(false) {
        subscription = uint(-1);
      }
      virtual const string &behavior_name() const override {
        return _scrollbar_ctl_factory->name;
      }
      virtual bool focusable(const element *self) override { return false; }

      virtual bool is_external() const override { return true; }

      virtual void detach(view &v, element *self) override {
        unobserve(v);
        self = nullptr;
      }
      virtual bool attach(view &v, element *self) override {
        if (this->self)
          return true;
        this->self = self;
        //sb = new hosted_scrollbar(self);
        scrollbar::vertical(self->atts(attr::a_type)() == WCHARS("vscrollbar"));
        helement ob = self->get_target(v, true);
        if (ob == self) ob = nullptr;
        if (ob)
          observe(v,ob);
        else {
          scrollbar::set_ranges(v, self, 0, 100, 25, 10);
          scrollbar::set_value(v, self, 0);
          scrollbar::place(rect(self->dim()));
          scrollbar::do_layout(v, self);
        } 

        return true;
      }

      void observe(view& v, element* ob);
      void unobserve(view& v);

      virtual void clear_style() override {
        scrollbar::clear_styling();
      }

      virtual void on_size_changed(view &v, element *self) override {
        update(v, self);
        if (observable)
          observable->refresh(v);
      }

      void update(view &v, element *self) {
        if (observable && !scrollbar::is_vertical() && observable->get_style(v)->overflow_x == overflow_hidden_scroll) {
          scroll_data scd;
          observable->get_scroll_data(v, scd);
          scrollbar::set_ranges(v, self, scd.content_outline.left(),
            scd.content_outline.right(), scd.dim_view.x,
            scd.dim_view.x / 10);
          scrollbar::set_value(v, self, scd.pos.x);
        }
        else if (observable && scrollbar::is_vertical() && observable->get_style(v)->overflow_y == overflow_hidden_scroll) {
          scroll_data scd;
          observable->get_scroll_data(v, scd);
          scrollbar::set_ranges(v, self, scd.content_outline.top(),
            scd.content_outline.bottom(), scd.dim_view.y,
            scd.dim_view.y / 10);
          scrollbar::set_value(v, self, scd.pos.y);
        }
        scrollbar::place(rect(self->dim()));
        scrollbar::do_layout(v, self);
      }


      void update_position(view &v) {
        update(v, self);
      }

      virtual bool draw_content(view &v, element *self, graphics *sf,
                                point pos) override {
        size sz = self->dim();
        scrollbar::place(rect(sz));
        scrollbar::do_layout(v, self);
        scrollbar::draw(v, sf, self, rect(pos, sz));
        return true;
      }


      virtual bool get_auto_width(view &v, element *self, int &value) override {
        if (scrollbar::is_vertical()) {
          value = v.get_window_metrics(value::$scrollbar_width);
          return true;
        }
        return false;
      }

      virtual bool get_auto_height(view &v, element *self,
                                   int &value) override {
        if (!scrollbar::is_vertical()) {
          value = v.get_window_metrics(value::$scrollbar_height);
          return true;
        }
        return false;
      }

      virtual bool on(view &v, element *self, event_mouse &evt) override {
        return scrollbar::on(v, self, evt);
      }

      virtual bool on(view &v, element *self, event_scroll &evt) override 
      {
        if (observable && observable->on(v, evt))
        {
          on_size_changed(v, self); // update sb values;
          return true;
        }

        if (processing_onscroll) // preventing recursion
          return false;

        auto_state<bool> _(processing_onscroll, true);
        
        if (self) {
          traverser<event_scroll> trv(v);
          return trv.traverse(self, evt);
        }
        return false;
      }

      virtual bool set_value(view &v, element *self,
                             const value &val) override {
        int iv = val.get(0);
        scrollbar::set_value(v, self, iv);
        scrollbar::do_layout(v, self);
        scrollbar::refresh(v, self);
        return true;
      }
      virtual bool get_value(view &v, element *self, value &val) override {
        val = value(scrollbar::get_value());
        return true;
      }

/*
      virtual bool on_method_call(view &v, element *self,
                                  method_params *p) override {
        switch (p->method_id) {
        case SCROLL_BAR_GET_VALUE: {
          scroll_value_params *sp = (scroll_value_params *)p;
          sp->max_value           = scrollbar::get_max();
          sp->min_value           = scrollbar::get_min();
          sp->page_value          = scrollbar::get_page();
          sp->step_value          = scrollbar::get_step();
          sp->value               = scrollbar::get_value();
          return true;
        }
        case SCROLL_BAR_SET_VALUE: {
          scroll_value_params *sp = (scroll_value_params *)p;
          scrollbar::set_ranges(v, self, sp->min_value, sp->max_value, sp->page_value,
                         sp->step_value);
          scrollbar::set_value(v, self, sp->value);
          scrollbar::do_layout(v, self);
          scrollbar::refresh(v, self);
          return true;
        }
        }
        return false;
      }

      OBSOLETE virtual bool on_x_method_call(view &v, element *self, const char *name,
                                    const value *argv, size_t argc,
                                    value &retval) override {
        if (streqi(name, "setValues")) {
          if (argc != 5) return false;
          // sp->value, sp->min_value, sp->max_value, sp->page_value,
          // sp->step_value
          scrollbar::set_ranges(v, self, argv[1].get(0), argv[2].get(100),
                         argv[3].get(25), argv[4].get(10));
          scrollbar::set_value(v, self, argv[0].get(0));
          scrollbar::do_layout(v, self);
          v.refresh(self);
          return true;
        } else if (streqi(name, "position")) {
          retval = value(scrollbar::get_value());
          return true;
        } else if (streqi(name, "min")) {
          retval = value(scrollbar::get_min());
          return true;
        } else if (streqi(name, "max")) {
          retval = value(scrollbar::get_max());
          return true;
        } else if (streqi(name, "page")) {
          retval = value(scrollbar::get_page());
          return true;
        } else if (streqi(name, "step")) {
          retval = value(scrollbar::get_step());
          return true;
        }
        return false;
      }
*/

      int get_min() { return scrollbar::get_min(); }
      int get_max() { return scrollbar::get_max(); }
      int get_page() { return scrollbar::get_page(); }
      int get_step() { return scrollbar::get_step(); }

      bool set_values(int v,int vmin, int vmax, int vpage, int vstep) {
        if (!self) return false;
        if (view* pv = self->pview()) 
        {
          scrollbar::set_ranges(*pv, self, vmin, vmax, vpage, vstep);
          scrollbar::set_value(*pv, self, v, allow_overscroll);
          scrollbar::do_layout(*pv, self);
          pv->refresh(self);
          return true;
        }
        return false;
      }

      int get_position() { return scrollbar::get_value(); }

      bool set_position(int v) {
        if (!self) return false;
        if (view* pv = self->pview()) 
        {
          scrollbar::set_value(*pv, self, v, allow_overscroll);
          scrollbar::do_layout(*pv, self);
          pv->refresh(self);
          return true;
        }
        return false;
      }

      bool get_overscroll() { return allow_overscroll; }
      bool set_overscroll(bool v) { allow_overscroll = v; return true; }
      
      SOM_PASSPORT_BEGIN_EX(scrollbar, scrollbar_ctl)
        SOM_FUNCS(
          SOM_FUNC_EX(values, set_values)
        )
        SOM_PROPS(
          SOM_VIRTUAL_PROP(position, get_position, set_position),
          SOM_VIRTUAL_PROP(overscroll, get_overscroll, set_overscroll),
          SOM_RO_VIRTUAL_PROP(min, get_min),
          SOM_RO_VIRTUAL_PROP(max, get_max),
          SOM_RO_VIRTUAL_PROP(page, get_page),
          SOM_RO_VIRTUAL_PROP(step, get_step)
        )
      SOM_PASSPORT_END

    };

    void scrollbar_ctl::observe(view& v, element* ob) {
      observable = ob;
      observable->check_layout(v);
      if (scrollbar::is_vertical())
        observable->ldata->sb._vsb = this;
      else
        observable->ldata->sb._hsb = this;
    }

    void scrollbar_ctl::unobserve(view& v) {
      if (observable) {
        if (scrollbar::is_vertical()) {
          assert(observable->ldata->sb._vsb == this);
          observable->ldata->sb._vsb = nullptr;
        }
        else {
          assert(observable->ldata->sb._hsb == this);
          observable->ldata->sb._hsb = nullptr;
        }
      }
    }


    ctl *scrollbar_ctl_factory::create(element *) {
      return new scrollbar_ctl();
    }

    void init_scrollbar() {
      ctl_factory::add(_scrollbar_ctl_factory = new scrollbar_ctl_factory());
    }

  } // namespace behavior
} // namespace html
