#include "html.h"
#include "html-behaviors.h"

namespace html {

  namespace behavior {

    const string &highlighted_ctl::behavior_name() const {
      static string _name = "highlighter";
      return _name;
    }

    bool highlighted_ctl::attach(view &v, element *self) {
      ctl::attach(v, self);
      el = self;
      return true;
    }

    void highlighted_ctl::detach(view &v, element *self) {
      ctl::detach(v, self);
      el = 0;
    }

    image *highlighted_ctl::get_fore() {
      if (!fore) {
        bytes data = app()->get_resource(W("highlight.png"));
        assert(data.length);
        fore = image::create(data, "highlight.png");
        assert(fore);
      }
      return fore;
    }

    bool highlighted_ctl::draw_foreground(view &v, element *self, graphics *sf,
                                          point pos) {
      rect r = self->border_box(v) + pos;
      sf->fill(get_fore(), r, point(0, 0));
      return false;
    }

  } // namespace behavior

  bool view::set_highlighted(element *el) {
    if (!highlighted_ctl) highlighted_ctl = new behavior::highlighted_ctl();
    if (highlighted_ctl->el) {
      this->refresh(highlighted_ctl->el);
      highlighted_ctl->el->detach_behavior(*this, highlighted_ctl);
      highlighted_ctl->el = nullptr;
    }
    if (el && el->pview() == this) {
      el->attach_behavior(*this, highlighted_ctl);
      this->refresh(el);
      return true;
    }
    return false;
  }

  element *view::get_highlighted() const {
    return highlighted_ctl ? highlighted_ctl->el : 0;
  }

} // namespace html