#include "html.h"

namespace html {
  namespace behavior {

    struct dd_select_ctl_factory : public ctl_factory {
      dd_select_ctl_factory() : ctl_factory("dropdown-select") {}
      virtual ctl *create(element *el);
    };

    static dd_select_ctl_factory *_dd_select_ctl = 0;

    const string &dd_select_ctl::behavior_name() const {
      return _dd_select_ctl->name;
    }

    bool dd_select_ctl::attach(view &v, element *self) {
      _self = self;
      _is_nullable = self->attr_novalue().is_defined();

      ustring as = self->atts(attr::a_as);

      if (as == WCHARS("string"))
        _coerce = value::parse_string;
      else if (as == WCHARS("integer"))
        _coerce = value::parse_integer;
      else if (as == WCHARS("float"))
        _coerce = value::parse_float;
      else if (as == WCHARS("numeric"))
        _coerce = value::parse_numeric;
      else if (as == WCHARS("auto"))
        _coerce = value::parse;
      else
#if defined(SCITERJS) 
        _coerce = value::parse_string;
#else
        _coerce = value::parse;
#endif

      _caption = find_first(v, self, WCHARS("caption"));
      _button  = find_first(v, self, WCHARS("[role='dropdown']"));

      ustring popup_id = self->atts("popup");
      if (popup_id.is_defined())
        _popup = self->doc()->get_element_by_id(popup_id);

      if(!_popup)
        _popup = find_first(v, self, WCHARS("popup.list,[type='select']"));

      if (!_caption || !_button || !_popup) {
        self->drop_styles(v);
        self->drop_layout();
        // init structure:
        if (!_popup) {
          _popup = new element(tag::T_POPUP);
          _popup->nodes.swap(self->nodes);
          _popup->atts.set(attr::a_class, W("list"));
          _popup->state.synthetic(true);
          FOREACH(n, _popup->nodes) {
            hnode hn = _popup->nodes[n];
            hn->parent = _popup;
            hn->owner = _popup;
            // hn->drop
          }
          self->append(_popup);
        }

        _caption = new element(tag::T_CAPTION);
        _caption->state.synthetic(true);
        _button = new element(tag::T_BUTTON);
        _button->state.synthetic(true);
        _button->atts.set(attr::a_role, W("dropdown"));
        self->append(_caption);
        self->append(_button);

        update_model(v, self);

        set_caption(v, self);
        v.add_to_update(self, CHANGES_MODEL);
      }

      return true;
    }
    void dd_select_ctl::detach(view &v, element *self) {
      _self                   = nullptr;
      _caption                = 0;
      _button                 = 0;
      _popup                  = 0;
      _value_option           = 0;
      _confirmed_value_option = 0;
    }

    bool dd_select_ctl::on_x_method_call(view &v, element *self, const char *name,
      const value *argv, size_t argc,
      value &retval)
    {
      chars fname = chars_of(name);
#define ACTION(ARGC, NAME) if (argc == ARGC && fname == CHARS(#NAME))
      ACTION(0, showPopup) {
        show_popup(v, self);
        return true;
      }
      ACTION(1, showPopup) {
        if(argv[0].get_bool())
          show_popup(v, self);
        else
          close_popup(v, self);
        return true;
      }
#undef ACTION
      return ctl::on_x_method_call(v, self, name, argv, argc, retval);
    }

    bool dd_select_ctl::set_value(view &v, element *self, const value &val) {
      if (_popup) {
        _popup->set_value(v, val);
        set_caption(v, self);
        if (is_editable(self) && !_value_option) {
          _caption->set_value(v, val);
        }
      }
      return true;
    }

    bool dd_select_ctl::on(view &v, element *self, event_command &evt) {
      if (evt.command == WCHARS("set-current") &&
          evt.cmd == (event_command::EXEC | EVENT_HANDLED)) {
        set_caption(v, self);
        return true;
      }
      return false;
    }

    value option_value(view &v, function<value(const ustring &)> coerce,
                       element *opt);

    bool dd_select_ctl::get_value(view &v, element *self, value &val) {
      if (is_editable(self) && _caption) {
        /*if(_value_option) -- wrong, value of select[editable] is *always*
        value of its caption.
        {
          val = option_value(v,_value_option);
          return true;
        }
        else*/
        return _caption->get_value(v, val);
      }

      if (_value_option) {
        val = option_value(v, _coerce, _value_option);
        return true;
      } else if (_popup)
        return _popup->get_value(v, val);
      return true;
    }

    // bool only_option_caption(view& v, element* el)
    //{
    //
    //}
    extern ustring role_option;
    bool is_select_option(view &v, element *b) // option disabled or enabled
    {
      return b->tag == tag::T_OPTION || b->attr_role() == role_option;
    }
    element *get_option_caption(view &v, element *opt);

    element *get_selected_opt(view &v, element *popup, bool noval_to_null) {
      element *        first   = 0;
      element *        current = 0;
      element *        checked = 0;
      element_iterator it(v, popup, is_select_option);
      for (element *b; it(b);) {
        if (!first) first = b;
        if (!current && b->state.current()) current = b;
        if (!checked && b->state.checked()) checked = b;
        if (first && current && checked) break;
      }
      if (checked) return checked;
      if (noval_to_null) return 0;
      return current ? current : first;
    }

    /*element *get_selected_opt_multy(view& v, element* popup, bool
    noval_to_null)
    {
      element* first = 0;
      element_iterator it(v, popup, is_select_option);
      for(element *b; it(b); )
      {
        if(!first)
          first = b;
        if( b->state.checked() )
          return b;
      }
      //return get_option_caption(v,selected);
      if( noval_to_null )
        return 0;
      return first;
    }*/

    bool dd_select_ctl::is_empty(const element *self, bool &yes) {
      yes = _value_option == 0;
      return true;
    }

    bool dd_select_ctl::set_caption(view &v, element *self) {
      // ensure that all needed behavariors are in place.
      _caption->get_style(v);
      if(_popup)
        _popup->get_style(v);

      //ustring novalue = self->attr_novalue();//get_attr(self, "-novalue");

      element *opt = nullptr;
      if(_popup)
          opt = get_selected_opt(v, _popup, is_multy() || is_nullable() || is_editable(self));
      element *cap = opt ? get_option_caption(v, opt) : 0;

      if (is_editable(self)) {
        ustring t = opt ? opt->get_text(v) : ustring();
        _caption->state.current(true);
        _caption->set_value(v, value(t));
        value rv;
        v.call_behavior_method(_caption, "doSelectAll", 0, 0, rv);
      } else {
        if (cap) {

          /*        if(is_nullable() && opt == _value_option)
                  {
                    opt = 0;
                    goto NOVALUE;
                  } */

          auto attr_filter = [](element *el) -> bool {
            el->atts.remove(attr::a_name); // these should not be there as names
                                           // should be unique.
            el->atts.remove(attr::a_id);
            return true;
          };

          _caption->copy_content_from(v, cap);
          _caption->atts = cap->atts;
          _caption->each_child(attr_filter);
          attr_filter(_caption);
          _caption->drop_styles(v);
          //_caption
        } else {
          // NOVALUE:
          //if (novalue.length()) -- logic moved to CSS
          //  _caption->set_text(v, novalue);
          //else
          _caption->set_text(v, WCHARS(" "));
        }
      }
      bool changed = false;
      if (opt) {
        // if(opt)
        //  _caption->atts = opt->atts; //????
        changed = _value_option != opt;
        _value_option = opt;
        if (!is_multy()) opt->state.current(true);
      } else {
        if (cap) cap->atts.clear();
        changed       = _value_option != 0;
        _value_option = 0;
      }
      // v.refresh(_caption);
      v.refresh(self);
      // v.add_to_update(_caption,CHANGES_DIMENSION);
      self->measure_inplace(v);
      // self->drop_minmax_dim();
      // self->commit_measure(v);

      // if( self->state.owns_popup() )
      //    v.close_owned_popups(self);
      return changed;
    }

    void dd_select_ctl::show_popup(view &v, element *self, bool set_focus) {
      if (!_popup) return;
      if (_popup->state.popup()) {
        close_popup(v, self, true);
        return;
      }
      _closed_at = 0;
      self->state_on(v, S_EXPANDED);
      v.show_popup(_popup, self, POPUP_WINDOW, 0x12);
      _prepopup_value_option  = _value_option;
      _confirmed_value_option = _value_option;
      if (_value_option)
        exec_command(v, _popup, _value_option, WCHARS("set-current"));

      if (set_focus)
        v.set_focus(_popup, BY_CODE);
    }

    void dd_select_ctl::close_popup(view &v, element *self, bool set_focus) {
      if (!_popup || !_popup->state.popup()) return;
      v.close_popup(_popup, false);
      if (set_focus) {
        if (is_editable(self) && _caption)
          v.set_focus(_caption, BY_CODE);
        else
          v.set_focus(self, BY_CODE);
      }
    }

    bool dd_select_ctl::get_auto_height(view &v, element *self, int &value) {
      return false;
    }
    bool dd_select_ctl::get_auto_width(view &v, element *self, int &value) {
      if (_caption && _button && _popup) {
        //_popup->check_layout(v);
        //_popup->drop_layout(&v);
        _popup->check_layout(v);
        if(!_popup->is_layout_valid())
          _popup->calc_intrinsic_widths(v);
        value = _popup->max_content_width(v) + _popup->outer_int_x_extra(v);
        value += _button->max_width(v) + _button->outer_int_x_extra(v);
        rect md = _caption->margin_distance(v);
        value += max(md.right(), md.left());
        value = max(value, self->max_content_width(v));
      }
      return true;
    }

    bool dd_select_ctl::is_dropdown_button(view &v, element *self,
                                           element *target) {
      return target->belongs_to(_button, true) ||
             target->belongs_to(_caption, true);
    }

    bool dd_select_ctl::on(view &v, element *self, event_behavior &evt) {
      switch (evt.cmd) {
      case CONTENT_CHANGED: {
        if(evt.target->belongs_to(_popup,true))
        {
          const style* cs = self->get_style(v);
          if (cs->width_depends_on_intrinsic() || cs->width.is_auto()) {
            self->drop_layout(&v);
            v.add_to_update(self, CHANGES_DIMENSION);
          }
          /*if (_popup->state.popup()) { blinking :(((
            close_popup(v, self);
            show_popup(v, self);
          }*/
        }
        else if (evt.target == self) { // we need to reset behavior in this case
          attach(v, self);
          v.add_to_update(self, CHANGES_MODEL);
        }
      } break;

      case BUTTON_PRESS:
        // if( evt.target->belongs_to(_button,true) ||
        // evt.target->belongs_to(_caption,true))
        if (is_dropdown_button(v, self, evt.target)) {
          event_behavior e(self, self, SHOW_POPUP, 0);
          v.post_behavior_event(e, true);
          return true;
        }
        break;

      case ACTIVATE_CHILD:
        if (evt.target == self) {
          if(owns_popup_list(v, self))
            close_popup(v, self, true);
          else {
            event_behavior e(self, self, SHOW_POPUP, 0);
            v.post_behavior_event(e, true);
          }
          return true;
        }
        return false;

      case SHOW_POPUP:
        if (evt.target == self
          && !owns_popup_list(v, self)
          && ((v.get_ticks() - _closed_at) > MOUSE_IDLE_TIMER_MS)) {
          show_popup(v, self);
          return true;
        }
        return false;

      case SELECT_SELECTION_CHANGING | EVENT_SINKING:
        if (evt.target == _popup) {
          set_caption(v, self);
          _confirmed_value_option = evt.source;
          if (!owns_popup_list(v, self)) {
            notify_change(v, self, _confirmed_value_option, uint(evt.reason));
            //event_behavior evt2(this->_caption, self, CURRENT_ELEMENT_CHANGED, 0); // see below
            event_behavior evt2(evt.source, self, CURRENT_ELEMENT_CHANGED, 0); // a11y requirement
            v.post_behavior_event(evt2, true);
          }
          else {
            event_behavior evt2(evt.source, self, CURRENT_ELEMENT_CHANGED, 0);
            v.post_behavior_event(evt2, true);
          }
          return true;
        }
        break;

      case POPUP_SELECT_VALUE_CHANGED | EVENT_SINKING:
        if (evt.target == _popup) {
          set_caption(v, self);
          //if( is_multy() )
          notify_change(v, self, evt.target, uint(evt.reason));
          return true;
        }
        break;


      case EDIT_VALUE_CHANGED | EVENT_SINKING:
        if (is_editable(self) && evt.target == _caption) {
          _value_option           = 0;
          _confirmed_value_option = 0;
          if (_popup) {
            value val;
            _caption->get_value(v, val);
            _popup->set_value(v, val);
          }
          notify_change(v, self, evt.target, uint(evt.reason));
          return true;
        }
        break;

      case POPUP_DISMISSED:
      case POPUP_DISMISSED | EVENT_HANDLED:
        if (evt.source == _popup) {
          _closed_at = v.get_ticks();
          self->state_on(v, S_COLLAPSED);
          if (_confirmed_value_option && (_confirmed_value_option != _prepopup_value_option)) {
            notify_change(v, self, _confirmed_value_option, uint(evt.reason));
          }
        }
        break;
      case POPUP_READY:
        if (evt.target == _popup) {
          if (_popup && _value_option)
            _popup->scroll_to_view(v, _value_option, false, SCROLL);
        }
        break;

      }

      return false;
    }

    bool dd_select_ctl::owns_popup_list(view &v, element *self) {
      if (!_popup) return false;
      return self->state.owns_popup() || _popup->state.popup();
    }

    bool dd_select_ctl::on(view &v, element *self, event_mouse &evt) {
      if (!_popup) return false;

      if (evt.cmd == (MOUSE_DOWN | EVENT_SINKING)
          && owns_popup_list(v, self)
          && !evt.target->belongs_to(_popup, true)) {
        close_popup(v, self, true);
        return true;
      }

      /*if ((evt.cmd == MOUSE_WHEEL) && !_popup->state.popup() && self->is_safe_to_wheel(v))
      {
        event_key ke(_popup, KEY_DOWN,
                     (evt.get_wheel_delta() < 0 ? KB_DOWN : KB_UP), 0);
        _popup->on(v, ke);
        return true;
      } - more problems than solutions*/

      if (evt.cmd == MOUSE_UP && owns_popup_list(v, self) &&
          v.mouse_down_element &&
          v.mouse_down_element->belongs_to(_popup, true) &&
          evt.target->belongs_to(_popup, true))
      {
        if (is_multy() && evt.is_on_icon && is_select_option(v, evt.is_on_icon))
          ;
        else
          close_popup(v, self, true);
        return true;
      }

      return false;
    }

    bool dd_select_ctl::on(view &v, element *self, event_key &evt) {
      if (!_caption || !_button || !_popup) return false;

      if (evt.cmd == (KEY_DOWN /* | EVENT_SINKING*/)) goto KEY_DOWN;
      if (evt.cmd == (KEY_CHAR /* | EVENT_SINKING*/)) goto KEY_CHAR;

      return false;

    KEY_DOWN : {
      if (!_popup->state.popup()) {
        if (evt.has_modifiers() && evt.key_code == KB_DOWN) {
          show_popup(v, self);
          return true;
        }

        if (evt.has_no_modifiers() &&
            (evt.key_code == KB_DOWN || evt.key_code == KB_UP ||
             evt.key_code == KB_PRIOR || evt.key_code == KB_NEXT ||
             evt.key_code == KB_HOME || evt.key_code == KB_END))
          return _popup->on(v, evt);
      } else {
        /*if((evt.key_code == KB_SPACE && evt.alt_state == 0))
        {
          if(set_caption(v,self))
            notify_change(v,self,_value_option,BY_KEY_CLICK);
          close_popup(v,self,evt.key_code != KB_TAB);
          return true;
        }
        else */
        if (evt.key_code == KB_TAB ||
            (evt.key_code == KB_RETURN && evt.has_no_modifiers())) {
          // if(set_caption(v,self))
          //  notify_change(v,self,_value_option,BY_KEY_CLICK);
          close_popup(v, self, evt.key_code != KB_TAB);
          return true;
        } else if (evt.key_code == KB_ESCAPE && evt.has_no_modifiers()) {
          select_ctl *list =
              static_cast<select_ctl *>(_popup->get_named_behavior("select"));
          if (list) {
            list->select_option(v, _popup, _prepopup_value_option, 0);
            set_caption(v, self);
            _confirmed_value_option = nullptr;
          }
          close_popup(v, self, true);
          return true;
        }
        return _popup->on(v, evt);
      }
    }
      return false;

    KEY_CHAR:
      if (!_popup->state.popup() && evt.has_no_modifiers()) {
        if (_popup->on(v, evt)) {
          set_caption(v, self);
          return true;
        }
      }
      return false;
    }

    bool dd_select_ctl::on(view &v, element *self, event_focus &evt) {
      if (!_caption || !_button) return false;

      if (evt.cmd == FOCUS_IN) {
        if (v.focus_element == _caption) {
          self->state_focus_on(v, evt.cause == BY_KEY_NEXT ||
                                      evt.cause == BY_KEY_PREV);
        } else {
          _caption->clear_style();
          _caption->state.current(true);
          _caption->get_style(v);
        }
      } else if (evt.cmd == FOCUS_OUT) {
        if (v.focus_element == _caption) {
          self->state_focus_off(v);
        } else {
          _caption->clear_style();
          _caption->state.current(true);
          _caption->get_style(v);
        }
      }
      // ??? popup window will close itself
      else if (evt.cmd == (FOCUS_OUT | EVENT_SINKING)) {
        if (!evt.target || !evt.target->belongs_to(self, true))
          close_popup(v, self, false);
      } else
        return false;
      v.refresh(self);
      return true;
    }

    void dd_select_ctl::notify_change(view &v, element *self, element *src,
                                      uint reason) {
      event_behavior evt(src, self, SELECT_VALUE_CHANGED, reason);
      v.post_behavior_event(evt, true);
    }

    ctl *dd_select_ctl_factory::create(element *el) {
      return new dd_select_ctl();
    }

    struct dd_multi_select_ctl_factory : public ctl_factory {
      dd_multi_select_ctl_factory() : ctl_factory("dropdown-multi-select") {}
      virtual ctl *create(element *el);
    };

    static dd_multi_select_ctl_factory *_dd_multi_select_ctl = 0;

    const string &dd_multi_select_ctl::behavior_name() const {
      return _dd_multi_select_ctl->name;
    }

    void dd_multi_select_ctl::update_model(view &v, element *self) {
      _total = new element(tag::T_VAR);
      //_total->state.synthetic(true);
      //_total->atts.set(attr::a_class, W("count"));
      self->insert(2, _total);
    }

    bool dd_multi_select_ctl::is_dropdown_button(view &v, element *self,
                                                 element *target) {
      return super::is_dropdown_button(v, self, target) ||
             target->belongs_to(_total, true);
    }

    bool dd_multi_select_ctl::set_caption(view &v, element *self) {
      bool r = super::set_caption(v, self);
      if (!_total) return r;

      int              total = 0;
      element_iterator it(v, _popup, is_select_option);
      for (element *b; it(b);) {
        if (b->state.checked()) ++total;
      }
      if (total > 1)
        _total->set_text_value(v, ustring::format(W("+%d"), total - 1));
      else
        _total->set_text_value(v, WCHARS(" "));
      return r;
    }

    bool dd_multi_select_ctl::get_auto_width(view &v, element *self,
                                             int &value) {
      if (!_total)
        return super::get_auto_width(v, self, value);
      
      if (_caption && _button && _popup) {
        _popup->check_layout(v);
        if (!_popup->is_layout_valid())
          _popup->calc_intrinsic_widths(v);
        value = _popup->max_content_width(v) + _popup->outer_int_x_extra(v);
        value += _button->max_width(v) + _button->outer_int_x_extra(v);
        rect md = _caption->margin_distance(v);
        value += max(md.right(), md.left());
        // --- value = max(value, self->max_content_width(v));
        rect mr = _total->border_distance(v);
        value += _total->computed_width(v, 0) + mr.left() + mr.right();
        // --- value -= v.get_window_metrics(value::$scrollbar_width);
      }

      //dbg_printf("auto width %d %d\n",ov,value);
      return true;
    }

    bool dd_multi_select_ctl::set_value(view &v, element *self,
                                        const value &val) {
      return super::set_value(v, self, val);
    }
    bool dd_multi_select_ctl::get_value(view &v, element *self, value &val) {
      if (_popup) return _popup->get_value(v, val);
      return super::get_value(v, self, val);
    }

    ctl *dd_multi_select_ctl_factory::create(element *el) {
      return new dd_multi_select_ctl();
    }

    void init_dd_selects() {
      ctl_factory::add(_dd_select_ctl = new dd_select_ctl_factory());
      ctl_factory::add(_dd_multi_select_ctl =
                           new dd_multi_select_ctl_factory());
    }

  } // namespace behavior
} // namespace html
