#include "html.h"
#include "math.h"

namespace html {
  using namespace tool;
  using namespace gool;

  // evaluates CSSS! event handler
#if 0
  bool element::eval_action(view &v, event &evt, eval::conduit *code,
                            value *prv) {
    handle<document> pd = doc();
    if (!pd) return false;

    handle<eval::conduit> prg = code;

    if (!pd->start_eval(this, prg)) return false;

    csss::exec_env          xenv(v, this);
    handle<csss::eval_env>  env  = new csss::eval_env(xenv, evt);
    handle<csss::element_1> self = new csss::element_1(xenv, this);
    eval::vm                vm(prg, env, self);
    xenv.pvm = &vm;

    try {
      // Evaluate expr.
      vm.eval();
      pd->stop_eval(this, prg);
      if (vm.val.is_cancel()) {
        clear_style();
        return true;
      }
      if (prv) *prv = vm.val;
      return false;
    } catch (eval::runtime_error &er) {
      view::debug_printf(OT_CSSS, OS_ERROR, "%s at (%s(%d))\n", er.msg.c_str(),
                         er.url.c_str(), er.line_no);
    }
    pd->stop_eval(this, prg);
    return false;
  }
#endif

  // evaluates calc() thing
  value element::eval_calc(eval::conduit *code, bool horizontal, pixels& pxc) {
    handle<document> pd = doc();
    if (!pd) return value();

    view *pv = pd->pview();
    if (!pv) return value();

    handle<eval::conduit> prg = code;

    if (!pd->start_eval(this, prg)) return value();

    csss::calc_env cenv(*pv, const_cast<element *>(this), horizontal, pxc);
    eval::vm       vm(prg, &cenv, &cenv);

    try {
      // Evaluate expr.
      vm.eval();
      pd->stop_eval(this, prg);
      if (vm.val.is_length()) {
        int px = 0;
        if (cenv.to_pixels(vm.val, px))
          vm.val = value::make_length(px, size_v::unit_type::ppx);
      } else
        vm.val = vm.val.to_int();
      return vm.val;
    } catch (eval::eval_runtime_error &er) {
      view::debug_printf(OT_CSSS, OS_ERROR, "%s at (%s(%d))\n", er.msg.c_str(),
                         er.url.c_str(), er.line_no);
    }
    pd->stop_eval(this, prg);
    return value(0);
  }

  namespace ease {
    const float PI = 3.14159265359f;

    float none(ease_params&, float t, float b, float c, float d) { return c + b; }
    
    float linear(ease_params&, float t, float b, float c, float d) { return (t / d) * c + b; }
    float in_quad(ease_params&, float t, float b, float c, float d) {
      return c * (t /= d) * t + b;
    }
    float out_quad(ease_params&, float t, float b, float c, float d) {
      return -c * (t /= d) * (t - 2) + b;
    }
    float in_out_quad(ease_params&, float t, float b, float c, float d) {
      if ((t /= d / 2) < 1) return c / 2 * t * t + b;
      return -c / 2 * ((--t) * (t - 2) - 1) + b;
    }
    float in_cubic(ease_params&, float t, float b, float c, float d) {
      return c * (t /= d) * t * t + b;
    }
    float out_cubic(ease_params&, float t, float b, float c, float d) {
      return c * ((t = t / d - 1) * t * t + 1) + b;
    }
    float in_out_cubic(ease_params&, float t, float b, float c, float d) {
      if ((t /= d / 2) < 1) return c / 2 * t * t * t + b;
      return c / 2 * ((t -= 2) * t * t + 2) + b;
    }
    float in_quart(ease_params&, float t, float b, float c, float d) {
      return c * (t /= d) * t * t * t + b;
    }
    float out_quart(ease_params&, float t, float b, float c, float d) {
      return -c * ((t = t / d - 1) * t * t * t - 1) + b;
    }
    float in_out_quart(ease_params&, float t, float b, float c, float d) {
      if ((t /= d / 2) < 1) return c / 2 * t * t * t * t + b;
      return -c / 2 * ((t -= 2) * t * t * t - 2) + b;
    }
    float in_quint(ease_params&, float t, float b, float c, float d) {
      return c * (t /= d) * t * t * t * t + b;
    }
    float out_quint(ease_params&, float t, float b, float c, float d) {
      return c * ((t = t / d - 1) * t * t * t * t + 1) + b;
    }
    float in_out_quint(ease_params&, float t, float b, float c, float d) {
      if ((t /= d / 2) < 1) return c / 2 * t * t * t * t * t + b;
      return c / 2 * ((t -= 2) * t * t * t * t + 2) + b;
    }
    float in_sine(ease_params&, float t, float b, float c, float d) {
      return -c * cos(t / d * (PI / 2)) + c + b;
    }
    float out_sine(ease_params&, float t, float b, float c, float d) {
      return c * sin(t / d * (PI / 2)) + b;
    }
    float in_out_sine(ease_params&, float t, float b, float c, float d) {
      return -c / 2 * (cos(PI * t / d) - 1) + b;
    }
    float in_expo(ease_params&, float t, float b, float c, float d) {
      return (t == 0) ? b : c * powf(2, 10 * (t / d - 1)) + b;
    }
    float out_expo(ease_params&, float t, float b, float c, float d) {
      return (t == d) ? b + c : c * (-powf(2, -10 * t / d) + 1) + b;
    }
    float in_out_expo(ease_params&, float t, float b, float c, float d) {
      if (t == 0) return b;
      if (t == d) return b + c;
      if ((t /= d / 2) < 1) return c / 2 * powf(2, 10 * (t - 1)) + b;
      return c / 2 * (-powf(2, -10 * --t) + 2) + b;
    }
    float in_circ(ease_params&, float t, float b, float c, float d) {
      return -c * (sqrtf(1 - (t /= d) * t) - 1) + b;
    }
    float out_circ(ease_params&, float t, float b, float c, float d) {
      return c * sqrtf(1 - (t = t / d - 1) * t) + b;
    }
    float in_out_circ(ease_params&, float t, float b, float c, float d) {
      if ((t /= d / 2) < 1) return -c / 2 * (sqrt(1 - t * t) - 1) + b;
      return c / 2 * (sqrtf(1 - (t -= 2) * t) + 1) + b;
    }
    float in_elastic(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f;
      float p = 0;
      float a = c;
      if (t == 0) return b;
      if ((t /= d) == 1) return b + c;
      if (!p) p = d * .3f;
      if (a < abs(c)) {
        a = c;
        s = p / 4;
      } else
        s = p / (2 * PI) * asinf(c / a);
      return -(a * powf(2, 10 * (t -= 1)) * sinf((t * d - s) * (2 * PI) / p)) +
             b;
    }
    float out_elastic(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f;
      float p = 0;
      float a = c;
      if (t == 0) return b;
      if ((t /= d) == 1) return b + c;
      if (!p) p = d * .3f;
      if (a < fabs(c)) {
        a = c;
        s = p / 4;
      } else
        s = p / (2 * PI) * asinf(c / a);
      return a * powf(2, -10 * t) * sinf((t * d - s) * (2 * PI) / p) + c + b;
    }
    float in_out_elastic(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f;
      float p = 0;
      float a = c;
      if (t == 0) return b;
      if ((t /= d / 2) == 2) return b + c;
      if (!p) p = d * (.3f * 1.5f);
      if (a < fabs(c)) {
        a = c;
        s = p / 4;
      } else
        s = p / (2 * PI) * asinf(c / a);
      if (t < 1)
        return -.5f * (a * powf(2, 10 * (t -= 1)) *
                       sinf((t * d - s) * (2 * PI) / p)) +
               b;
      return a * powf(2, -10 * (t -= 1)) * sinf((t * d - s) * (2 * PI) / p) *
                 .5f +
             c + b;
    }
    float in_back(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f;
      return c * (t /= d) * t * ((s + 1) * t - s) + b;
    }
    float out_back(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f;
      return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
    }
    float in_out_back(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f;
      if ((t /= d / 2) < 1)
        return c / 2 * (t * t * (((s *= (1.525f)) + 1) * t - s)) + b;
      return c / 2 * ((t -= 2) * t * (((s *= (1.525f)) + 1) * t + s) + 2) + b;
    }

    float in_back_x(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f * 2;
      return c * (t /= d) * t * ((s + 1) * t - s) + b;
    }
    float out_back_x(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f * 2;
      return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
    }
    float in_out_back_x(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f * 2;
      if ((t /= d / 2) < 1)
        return c / 2 * (t * t * (((s *= (1.525f)) + 1) * t - s)) + b;
      return c / 2 * ((t -= 2) * t * (((s *= (1.525f)) + 1) * t + s) + 2) + b;
    }

    float in_back_xx(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f * 3;
      return c * (t /= d) * t * ((s + 1) * t - s) + b;
    }
    float out_back_xx(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f * 3;
      return c * ((t = t / d - 1) * t * ((s + 1) * t + s) + 1) + b;
    }
    float in_out_back_xx(ease_params&, float t, float b, float c, float d) {
      float s = 1.70158f * 3;
      if ((t /= d / 2) < 1)
        return c / 2 * (t * t * (((s *= (1.525f)) + 1) * t - s)) + b;
      return c / 2 * ((t -= 2) * t * (((s *= (1.525f)) + 1) * t + s) + 2) + b;
    }

    float out_bounce(ease_params&, float t, float b, float c, float d) {
      if ((t /= d) < (1 / 2.75f))
        return c * (7.5625f * t * t) + b;
      else if (t < (2 / 2.75f))
        return c * (7.5625f * (t -= (1.5f / 2.75f)) * t + .75f) + b;
      else if (t < (2.5 / 2.75f))
        return c * (7.5625f * (t -= (2.25f / 2.75f)) * t + .9375f) + b;
      else
        return c * (7.5625f * (t -= (2.625f / 2.75f)) * t + .984375f) + b;
    }
    float in_bounce(ease_params& p, float t, float b, float c, float d) {
      return c - out_bounce(p, d - t, 0, c, d) + b;
    }
    float in_out_bounce(ease_params& p, float t, float b, float c, float d) {
      if (t < d / 2) return in_bounce(p,t * 2, 0, c, d) * .5f + b;
      return out_bounce(p,t * 2 - d, 0, c, d) * .5f + c * .5f + b;
    }

    float inherit(ease_params&, float t, float b, float c, float d) {
      return c + b;
    }

    float cubic_bezier(ease_params& p, float t, float b, float c, float d)
    {
      if (p.x1 == p.y1 && p.x2 == p.y2) return (t / d) * c + b; // linear

      auto A = [](float aA1, float aA2) { return 1.0f - 3.0f * aA2 + 3.0f * aA1; };
      auto B = [](float aA1, float aA2) { return 3.0f * aA2 - 6.0f * aA1; };
      auto C = [](float aA1) { return 3.0f * aA1; };

      // returns x(t) given t, x1, and x2, or y(t) given t, y1, and y2.
      auto calc_bezier = [A, B, C](float aT, float aA1, float aA2) {
        return ((A(aA1, aA2)*aT + B(aA1, aA2))*aT + C(aA1))*aT;
      };

      // returns dx/dt given t, x1, and x2, or dy/dt given t, y1, and y2.
      auto slope = [A, B, C](float aT, float aA1, float aA2) {
        return 3.0f * A(aA1, aA2)*aT*aT + 2.0f * B(aA1, aA2) * aT + C(aA1);
      };

      auto get_t_for_x = [calc_bezier, slope, p](float aX) -> float {
        // Newton approximation
        float aGuessT = aX;
        for (int i = 0; i < 4; ++i) {
          float current_slope = slope(aGuessT, p.x1, p.x2);
          if (current_slope == 0.0f) return aGuessT;
          float currentX = calc_bezier(aGuessT, p.x1, p.x2) - aX;
          aGuessT -= currentX / current_slope;
        }
        return aGuessT;
      };
      return (calc_bezier(get_t_for_x(t), p.y1, p.y2) / d) * c + b;
    }

    function::function(const ease_params& pars) :pf(&cubic_bezier), inversed(false), params(pars) {}
            
    bool function::is_inherit() const { return pf == &ease::inherit; }

    function function::val() const {
      if (is_undefined() || is_inherit() ) return function(&in_out_quad);
      return *this;
    }

    function get_ease_func(const value &efdef) {
      static hash_table<ustring, function_t *> tbl;
      if (tbl.size() == 0) {
        tbl[WCHARS("none")]           = &none;
        tbl[WCHARS("inherit")]        = &inherit;
        tbl[WCHARS("linear")]         = &linear;

        tbl[WCHARS("ease")] = &in_out_quad;

        tbl[WCHARS("ease-in")] = &in_cubic;
        tbl[WCHARS("ease-in-out")] = &in_out_cubic;
        tbl[WCHARS("ease-out")] = &out_cubic;

        tbl[WCHARS("quad-in")]        = &in_quad;
        tbl[WCHARS("quad-out")]       = &out_quad;
        tbl[WCHARS("quad-in-out")]    = &in_out_quad;
        tbl[WCHARS("cubic-in")]       = &in_cubic;
        tbl[WCHARS("cubic-out")]      = &out_cubic;
        tbl[WCHARS("cubic-in-out")]   = &in_out_cubic;
        tbl[WCHARS("quart-in")]       = &in_quart;
        tbl[WCHARS("quart-out")]      = &out_quart;
        tbl[WCHARS("quart-in-out")]   = &in_out_quart;
        tbl[WCHARS("quint-in")]       = &in_quint;
        tbl[WCHARS("quint-out")]      = &out_quint;
        tbl[WCHARS("quint-in-out")]   = &in_out_quint;
        tbl[WCHARS("sine-in")]        = &in_sine;
        tbl[WCHARS("sine-out")]       = &out_sine;
        tbl[WCHARS("sine-in-out")]    = &in_out_sine;
        tbl[WCHARS("expo-in")]        = &in_expo;
        tbl[WCHARS("expo-out")]       = &out_expo;
        tbl[WCHARS("expo-in-out")]    = &in_out_expo;
        tbl[WCHARS("circ-in")]        = &in_circ;
        tbl[WCHARS("circ-out")]       = &out_circ;
        tbl[WCHARS("circ-in-out")]    = &in_out_circ;
        tbl[WCHARS("elastic-in")]     = &in_elastic;
        tbl[WCHARS("elastic-out")]    = &out_elastic;
        tbl[WCHARS("elastic-in-out")] = &in_out_elastic;
        tbl[WCHARS("back-in")]        = &in_back;
        tbl[WCHARS("back-out")]       = &out_back;
        tbl[WCHARS("back-in-out")]    = &in_out_back;
        tbl[WCHARS("x-back-in")]      = &in_back_x;
        tbl[WCHARS("x-back-out")]     = &out_back_x;
        tbl[WCHARS("x-back-in-out")]  = &in_out_back_x;
        tbl[WCHARS("xx-back-in")]     = &in_back_xx;
        tbl[WCHARS("xx-back-out")]    = &out_back_xx;
        tbl[WCHARS("xx-back-in-out")] = &in_out_back_xx;
        tbl[WCHARS("bounce-in")]      = &out_bounce;
        tbl[WCHARS("bounce-out")]     = &in_bounce;
        tbl[WCHARS("bounce-in-out")]  = &in_out_bounce;
      }

      if (efdef.is_none())
        return function();
      if (efdef.is_string()) {
        function_t *pf = 0;
        tbl.find(efdef.get<ustring>(), pf);
        return pf;
      }
      if (efdef.is_function(WCHARS("cubic-bezier"))) {
        auto pf = efdef.get_function();
        if (pf->params.size() == 4) {
          ease::ease_params params;
          auto getf = [](const value& v, float& t) -> bool { 
            if (!v.is_number()) return false;
            t = v.get<float>();
            return t >= 0.0f && t <= 1.0f; 
          };
          if (!getf(pf->params.value(0), params.x1)) return function();
          if (!getf(pf->params.value(1), params.y1)) return function();
          if (!getf(pf->params.value(2), params.x2)) return function();
          if (!getf(pf->params.value(3), params.y2)) return function();
          return function(params);
        }
      }

      return function();

    }

    function get_default_ease_func() {
      return function(out_quad);
    }

  } // namespace ease

#if 0
  value csss::eval_env::morph_value(const ustring &ease_f_name,
                                    const value &start, const value &end,
                                    uint start_time, uint current_time,
                                    uint end_time) {
    ease::function pf = ease::get_ease_func(ease_f_name);
    if (!pf) return value();
    if (end_time <= start_time) return value();
    if (start.is_length() || end.is_length()) {
      uint u = 0;
      if (start.is_length())
        u = start.units();
      else
        u = end.units();
      float r_start = (float)start.get_double();
      float r_end   = (float)end.get_double();
      float progress =
          float(current_time - start_time) / float(end_time - start_time);
      float r_next = pf(progress, r_start, r_end - r_start, 1);
      return value::make_length(r_next, u);
      // morph length value
    } else if (start.is_color() && end.is_color()) {
      // morph color value
    } else {
      float r_start = (float)start.get_double();
      float r_end   = (float)end.get_double();
      float progress =
          float(current_time - start_time) / float(end_time - start_time);
      float r_next = pf(progress, r_start, r_end - r_start, 1);
      return value(r_next);
    }

    return value();
  }
#endif

} // namespace html