#include "html.h"

namespace html {

  void animation::finalize(view &v, element *b) {
    // assert( b->animator != 0 );

    while (b->animator) {
      handle<animation> an = b->animator;
      b->animator          = an->next;
      an->stop(v, b);

      event_behavior evt(b, b, an->event_type(), 0);
      evt.data = value(an->name());
      v.post_behavior_event(evt, true);

      // b->on_animation_end(v);
    }
    b->state.animating(false);
    v.refresh(b);
  }

  void animation::finalize_finite(view &v, element *b) {
    auto filter = [&](handle<animation> an) -> bool {
      return an->is_finite(v, b);
    };
    v.remove_animations(b, filter);
  }

  void view::remove_animation(handle<element> b, animation *pa) {
    array<handle<animation>> animations_to_stop;
    array<handle<animation>> animations_to_keep;
    if (!pa) {
      for (handle<animation> t = b->animator; t; t = t->next)
        animations_to_stop.push(t);
      b->animator = nullptr;
    } else {
      for (handle<animation> t = b->animator; t; t = t->next)
        if (t == pa)
          animations_to_stop.push(t);
        else
          animations_to_keep.push(t);
    }

    handle<animation> prev;
    for (int k = animations_to_keep.last_index(); k >= 0; --k) {
      animations_to_keep[k]->next = prev;
      prev                        = animations_to_keep[k];
    }
    b->animator = prev;

    FOREACH(i, animations_to_stop) {
      handle<animation> ta = animations_to_stop[i];
      ta->stop(*this, b);
      //this->refresh(b);
      event_behavior evt(b, b, ta->event_type(), 0);
      evt.data = value(ta->name());
      this->post_behavior_event(evt, true);
    }

    if (!b->animator) {
      b->state.animating(false);
      animating.remove_by_value(b);
      b->c_style = b->d_style;
    }
    b->drop_styles(*this);
  }

  void view::remove_animations(handle<element>                   pb,
                               function<bool(handle<animation>)> filter) {
    // handle<animation> pan;
    array<handle<animation>> animations_to_stop;
    array<handle<animation>> animations_to_keep;

    for (handle<animation> t = pb->animator; t; t = t->next)
      if (filter(t))
        animations_to_stop.push(t);
      else
        animations_to_keep.push(t);

    handle<animation> prev;
    for (int k = animations_to_keep.last_index(); k >= 0; --k) {
      animations_to_keep[k]->next = prev;
      prev                        = animations_to_keep[k];
    }
    pb->animator = prev;

    FOREACH(i, animations_to_stop) {
      handle<animation> ta = animations_to_stop[i];
      ta->stop(*this, pb);
      this->refresh(pb);
      event_behavior evt(pb, pb, ta->event_type(), 0);
      evt.data = value(ta->name());
      this->post_behavior_event(evt, true);
    }

    if (!pb->animator) {
      pb->state.animating(false);
      animating.remove_by_value(pb);
      pb->c_style = pb->d_style;
    }

    if (animations_to_stop.length())
      pb->drop_styles(*this);
  }

  bool view::add_animation(element *b, animation *pa, const style *new_style_,
                           const style *old_style_) {
    // WRONG: animation can be requested when window is not yet visible
    // WRONG: if(!check_visibility())
    // WRONG:   return false; // animation on invisible window...

    //return false;

    //assert(b->c_style != element::null_style);

    handle<style> new_style = new_style_;
    handle<style> old_style = old_style_;

    b->check_layout(*this);
    //assert(b->c_style != element::null_style);
    handle<animation> pba = pa;
    handle<element>   pb  = b;

    /*for (handle<animation> ta = b->animator; ta; ta = ta->next)
      if (ta->type_id() == pba->type_id()) {
        remove_animation(pb, ta);
        break;
      }*/
    pba->start_clock = get_animation_ticks();

    animating.push(b);
    pba->next   = b->animator;
    b->animator = pba;

    assert(pba->next != pba);

#if 1
    b->state.animating(true);
#else 
    -- wrong 
    if (!b->state.animating()) {
      b->state.animating(true);
      b->reset_style(*this);
      new_style = b->d_style;
    }
#endif

    uint delta = pba->start(*this, b, new_style, old_style);

    //assert(b->c_style != element::null_style);

    pba->next_clock = pba->start_clock + delta;

    if (0 == delta) {
      remove_animation(b, pa);
      //assert(b->c_style != element::null_style);
      return false;
    }

    event_behavior evt(b, b, pba->event_type(), 1);
    evt.data = value(pa->name());
    post_behavior_event(evt);

    // if( !has_invalid_areas() )
    //  refresh(); // we need paint to be generated

    request_animation_frame(delta);

    return true;
  }

  void view::remove_all_animations() {
    stop_animation_frames();
    while (animating.size()) {
      helement pb = animating.pop();
      animation::finalize(*this, pb);
    }
  }

  void view::remove_finite_animations() {

    for (int n = animating.last_index(); n >= 0; --n) {
      helement pb = animating[n];
      animation::finalize_finite(*this, pb);
    }
  }

  uint view::do_animation(uint ticks) {

    handle<view> holder = this;

    auto_state<tristate_v> _(inside_animation_frame, tristate_v(true));

    uint total_period = 0xFFFFFFFF;
    if (animating.size()) {
      for (int n = animating.size() - 1; n >= 0; --n) {
        if (n >= animating.size()) continue;
        helement          pb = animating[n];
        handle<animation> pa = pb->animator;

        tool::array<handle<animation>> to_remove;

        if (!pa)
          to_remove.push(pa);

        else
          for (; pa; pa = pa->next) {
            if (pb->pview()) // check if it is still in the DOM
            {
              if (pa->next_clock > ticks + ANIMATION_TIMER_SPAN / 2) {
                uint period = pa->next_clock - ticks;
                if (period < total_period) total_period = period;
                assert(period);
                continue;
              }
              pb->check_layout(*this);
              if (pb->has_animation(pa)) // someone deleted the element in animator?
              {
                uint period = pa->step(*this, pb, ticks);
                if (period) {
                  //assert(period >= ANIMATION_TIMER_SPAN);
                  pa->next_clock = ticks + period;
                  if (period < total_period) total_period = period;
                  assert(period);
                  continue;
                }
              }
              to_remove.push(pa);
            }
          }
        for (int n = to_remove.size() - 1; n >= 0; --n)
          remove_animation(pb, to_remove[n]);
        /*
        if( n < animating.size()  ) // someone already removed the animation
        inside pa->step()? How come?
        {
          remove_animation(pb,pa);
        }*/
      }
    } else
      return 0;

    if (!get_hwnd()) return 0;

#ifndef OSX
    on_idle();
#endif
      
    commit_update(false); // do not force update, this will give a chance for
                          // other messages to be handled.

    return ANIMATION_TIMER_SPAN;
  }

  void view::on_animation_tick() {
    uint ticks;
    uint delay;

    if (!check_visibility()) {
      stop_animation_frames();
      return;
    }

    auto pd = tool::async::dispatch::current(false);
    if(pd) pd->run_once();

    ticks = get_animation_ticks();

#if 1 // redundant, do_animation does it by its nature already
    const uint ANIMATION_FRAME_GRANULARITY = ANIMATION_TIMER_SPAN / 2;
    uint animation_frame_no = ticks / ANIMATION_FRAME_GRANULARITY;

    if (animation_frame_no == this->animation_frame_no) {
      request_animation_frame(ANIMATION_FRAME_GRANULARITY);
      return;
    }
    this->animation_frame_no = animation_frame_no;
#endif

    if (animating.size() == 0) goto STOP;

    delay = do_animation(ticks);

    if (animating.size() == 0 || delay == 0) goto STOP;

    {
      uint new_ticks = get_animation_ticks();
      delay -= new_ticks - ticks;
    }

    request_animation_frame(delay);

    return;
  STOP:
    remove_all_animations();
  }

  handle<animation> element::animated_update(
        view &v,
        const function<bool(view &, element *)> &state_changer,
        animated_effect* paeff,
        effect_animator::STATE st )
  {
    if (!v.animations_disabled && (get_style(v)->has_transition_effect() || paeff)) {
      handle<effect_animator_worker> ea = new effect_animator_worker(state_changer, paeff,st);
      v.add_animation(this, ea);
      return ea;
    } else {
      handle<view> pv   = &v;
      helement     self = this;
      {
        mutator_ctx  _(this, pv);
        state_changer(*pv, this);
      }
      v.commit_update();
      return nullptr;
    }
  }

#if !defined(SCITER)
  uint script_animator::start(view &v, element *b, const style *nst, const style *ost) { 
    return step(v, b, v.get_animation_ticks()); 
  }
  uint script_animator::step(view &v, element *b, uint current_clock)
  {
    double p;
    if (duration.is_defined() && ((current_clock - start_clock) >= duration.val(0))) {
      p = 1.0;
      if (easef) p = easef(float(p), 0, 1, 1);
      cbf && cbf(v, b, p); return 0;
    }
    else {
      p = progress(current_clock);
      if (easef) p = easef(float(p), 0, 1, 1);
      return cbf && cbf(v, b, p) ? frame_duration.val(ANIMATION_TIMER_SPAN) : 0;
    }
  }
  void script_animator::script_animator::stop(view &v, element *b)  {
    super::stop(v, b);
  }
#endif

} // namespace html
