#include "html.h"

namespace html {

  uint effect_animator::start(view &v, element *el, const style *nst,
                              const style *ost) {
    //return 0;

    if (is_worker() && effect_def)
    {
      //state = effect_animator::FORWARD;
      easef = effect_def->easef;
      delay = effect_def->delay;
      duration = effect_def->duration;
    }
    else if (state.is_defined()) {
      if (state == effect_animator::FORWARD)
      {
        effect_def = nst->transition_effect;
        easef = effect_def->easef;
        delay = effect_def->delay;
        duration = effect_def->duration;
      }
      else {
        effect_def = ost->transition_effect;
        easef = effect_def->reverse_easef;
        delay = effect_def->reverse_delay.val(effect_def->delay);
        duration = effect_def->reverse_duration.val(effect_def->duration);
      }
    }
    else {
      if (nst->transition_effect) {
        state = effect_animator::FORWARD;
        effect_def = nst->transition_effect;
        easef = effect_def->easef;
        delay = effect_def->delay;
        duration = effect_def->duration;
      }
      else {
        state = effect_animator::BACKWARD;
        effect_def = ost->transition_effect;
        easef = effect_def->reverse_easef;
        delay = effect_def->reverse_delay.val(effect_def->delay);
        duration = effect_def->reverse_duration.val(effect_def->duration);
      }
    }

    clock = start_clock = v.get_animation_ticks();
    end_clock = start_clock + duration;

    s_initial = ost;
    s_final   = nst;

    // WRONG: may lead to recursive add add_animation gets called from on_style_changed
    // this function is probably need to be delayed until first draw. 
    // ---- el->doc()->commit_measure(v); ----

    element *w = el->get_windowed_container(v, true);
    if (!w) return 0; // stop it

    iwindow *pwnd = w->get_window(v, true);
    if (!pwnd) return 0;

    switch (effect_def->etype) {
      case transition_blend:
      case transition_blend_atop: init_full(v, el, nst, ost, pwnd); break;
      case transition_slide_top:
      case transition_slide_bottom:
      case transition_slide_left:
      case transition_slide_right:

      case transition_slide_over_top:
      case transition_slide_over_bottom:
      case transition_slide_over_left:
      case transition_slide_over_right:

      case transition_remove_top:
      case transition_remove_bottom:
      case transition_remove_left:
      case transition_remove_right:

      case transition_scroll_top:
      case transition_scroll_bottom:
      case transition_scroll_left:
      case transition_scroll_right: init_content(v, el, nst, ost, pwnd); break;
    }

    //return ANIMATION_TIMER_SPAN;
    return step(v, el, clock);
  }

  bool effect_animator::prepare_initial(view &v, element *el) {
    el->c_style = s_initial;
    return true;
  }
  bool effect_animator::prepare_final(view &v, element *el) {
    el->c_style = s_final;
    el->reset_styles(v);
#if 0
    el->exec_assigned(v);
#endif
    el->resolve_styles(v);
    el->check_layout(v);
    //el->commit_measure(v);
    v.commit_update();

    return true;
  }

  void effect_animator::init_full(view &v, element *el, const style *nst,
                                  const style *ost, iwindow *pwnd) {
    content_only = false;

    point elvp = el->view_pos(v);
    rect  area = el->rendering_box(v) + elvp;

    if(area.empty())
      return;

    // render it first with initial styling
    prepare_initial(v, el);

    rect narea = el->rendering_box(v) + el->view_pos(v);
    area |= narea;

    size csz = area.size();

    area_off = area.s - elvp;
    area_dim = area.size();

    initial = new bitmap(csz, true, false);
    final   = new bitmap(csz, true, false);

    point vp = elvp - area_off; //-area_off;// = area.s - w->view_pos(v);

    /*auto_state<element_flags> _flags(el->flags);
    el->flags.script_draws_background = 0;
    el->flags.script_draws_foreground = 0;
    el->flags.script_draws_content = 0;
    el->flags.script_draws_outline = 0;*/

    {
      handle<graphics> sfi =
          app()->create_bitmap_bits_graphics(initial, argb(0, 0, 0, 0));
      if (!sfi) {
        initial = nullptr;
        final   = nullptr;
        return;
      }
      sfi->offset(-elvp);
      sfi->set_clip_rc(area);
      auto_state<graphics *> _(v.drawing_surface, sfi);

      el->draw(v, sfi, vp, false);
      el->draw_outlines(v, sfi, vp, true, true);
      v.commit_drawing_buffers();
    }

    // now render it with final styling
    // el->c_style = s_final;
    prepare_final(v, el);
    s_final = el->get_style(v);
    {
      handle<graphics> sff =
          app()->create_bitmap_bits_graphics(final, argb(0, 0, 0, 0));
      if (!sff) {
        initial = nullptr;
        final   = nullptr;
        return;
      }
      auto_state<graphics *> _(v.drawing_surface, sff);
      sff->offset(-elvp);
      sff->set_clip_rc(area);
      el->draw(v, sff, vp, false);
      // el->draw_outline(v,sff,vp);
      el->draw_outlines(v, sff, vp, true, true);
      v.commit_drawing_buffers();
    }
  }
  void effect_animator::init_content(view &v, element *el, const style *nst,
                                     const style *ost, iwindow *pwnd) {
    content_only = true;

    point elvp = el->view_pos(v);
    rect  area = el->content_box(v) + elvp;

    // render it first with initial styling
    prepare_initial(v, el);

    rect narea = el->content_box(v) + el->view_pos(v);
    area |= narea;
    // el->c_style = prev_style;

    size csz = area.size();

    area_off = area.s - elvp;
    area_dim = area.size();

    initial = new bitmap(csz, true, false);
    final   = new bitmap(csz, true, false);

    point vp = elvp - area_off;

    /*auto_state<element_flags> _flags(el->flags);
    el->flags.script_draws_background = 0;
    el->flags.script_draws_foreground = 0;
    el->flags.script_draws_content = 0;
    el->flags.script_draws_outline = 0;*/

    {
      handle<graphics> sfi =
          app()->create_bitmap_bits_graphics(initial, argb(0, 0, 0, 0));
      if (!sfi) {
        initial = nullptr;
        final   = nullptr;
        return;
      }
      auto_state<graphics *> _(v.drawing_surface, sfi);
      sfi->offset(-elvp);
      el->do_draw_content(v, sfi, vp, false);
      // el->draw_outline(v,&sf,vp);
      el->draw_outlines(v, sfi, vp, true, false);
      v.commit_drawing_buffers();
    }

    // now render it with final styling
    prepare_final(v, el);
    s_final = el->get_style(v);

    {
      handle<graphics> sff =
          app()->create_bitmap_bits_graphics(final, argb(0, 0, 0, 0));
      if (!sff) {
        initial = nullptr;
        final   = nullptr;
        return;
      }
      auto_state<html::graphics *> _(v.drawing_surface, sff);
      sff->offset(-elvp);
      el->do_draw_content(v, sff, vp, false);
      // el->draw_outline(v,&sf,vp);
      el->draw_outlines(v, sff, vp, true, false);
      v.commit_drawing_buffers();
    }
  }

  uint effect_animator::step(view &v, element *el, uint current_clock) {
    if (!initial || !final) 
      return 0;
    clock = current_clock;
    rect r(area_off, area_dim);
    v.refresh(el, r);
    if (clock > end_clock)
      return 0;
    else
      return ANIMATION_TIMER_SPAN;
  }

  bool styles_are_different(const style *s1, const style *s2);

  bool effect_animator::reverse(view &v, element *b, const style *new_style,
                                const style *old_style) {
    //?? if( new_style != s_initial )
    //??   return false;

    // rolling back by switching direction
    switch (state) {
    case FORWARD:
      state = ROLLBACK_FORWARD;
      if (styles_are_different(new_style, s_initial)) return false;
      break;
    case BACKWARD:
      state = ROLLBACK_BACKWARD;
      if (styles_are_different(new_style, s_initial)) return false;
      break;
    case ROLLBACK_FORWARD:
      state = FORWARD;
      if (styles_are_different(new_style, s_final)) return false;
      break;
    case ROLLBACK_BACKWARD:
      state = BACKWARD;
      if (styles_are_different(new_style, s_final)) return false;
      break;
    default: return false;
    }
    // forward = false;

    uint time_passed = clock - start_clock;
    uint time_left   = end_clock - clock;

    start_clock = clock - time_left;
    end_clock   = clock + time_passed;

    rect r(area_off, area_dim);
    v.refresh(b, r);

    return true;
  }

  bool effect_animator::_draw(view &v, graphics *pg, element *b, point pos,
                              bool content_layer) {
    if (content_only != content_layer) return false;

    if (!initial || !final || clock >= end_clock || !easef) return false;

    uint  total  = end_clock - start_clock;
    uint  passed = clock - start_clock;
    float progress;

    if (state == FORWARD || state == BACKWARD) {
      if (*b->get_style(v) != *s_final) 
        return false;
      progress = easef(float(passed) / float(total), 0, 1, 1);
    } else {
      if (*b->get_style(v) != *s_initial) 
        return false;
      progress = easef(float(total - passed) / float(total), 0, 1, 1);
    }

    switch (effect_def->etype) {
    case transition_blend:
      progress = limit(progress, 0.f, 1.0f);
      return draw_blend(v, pg, b, pos, progress);
    case transition_blend_atop:
      progress = limit(progress, 0.f, 1.0f);
      return draw_blend_atop(v, pg, b, pos, progress);

    case transition_slide_top:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_slide_bottom(v, pg, b, pos, progress);
      else
        return draw_slide_top(v, pg, b, pos, progress);
    case transition_slide_bottom:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_slide_top(v, pg, b, pos, progress);
      else
        return draw_slide_bottom(v, pg, b, pos, progress);
    case transition_slide_left:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_slide_right(v, pg, b, pos, progress);
      else
        return draw_slide_left(v, pg, b, pos, progress);
    case transition_slide_right:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_slide_left(v, pg, b, pos, progress);
      else
        return draw_slide_right(v, pg, b, pos, progress);

    case transition_slide_over_top:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_slide_over_bottom(v, pg, b, pos, progress);
      else
        return draw_slide_over_top(v, pg, b, pos, progress);
    case transition_slide_over_bottom:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_slide_over_top(v, pg, b, pos, progress);
      else
        return draw_slide_over_bottom(v, pg, b, pos, progress);
    case transition_slide_over_left:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_slide_over_right(v, pg, b, pos, progress);
      else
        return draw_slide_over_left(v, pg, b, pos, progress);
    case transition_slide_over_right:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_slide_over_left(v, pg, b, pos, progress);
      else
        return draw_slide_over_right(v, pg, b, pos, progress);

    case transition_remove_top:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_remove_bottom(v, pg, b, pos, progress);
      else
        return draw_remove_top(v, pg, b, pos, progress);
    case transition_remove_bottom:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_remove_top(v, pg, b, pos, progress);
      else
        return draw_remove_bottom(v, pg, b, pos, progress);
    case transition_remove_left:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_remove_right(v, pg, b, pos, progress);
      else
        return draw_remove_left(v, pg, b, pos, progress);
    case transition_remove_right:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_remove_left(v, pg, b, pos, progress);
      else
        return draw_remove_right(v, pg, b, pos, progress);

    case transition_scroll_top:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_scroll_bottom(v, pg, b, pos, progress);
      else
        return draw_scroll_top(v, pg, b, pos, progress);
    case transition_scroll_bottom:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_scroll_top(v, pg, b, pos, progress);
      else
        return draw_scroll_bottom(v, pg, b, pos, progress);
    case transition_scroll_left:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_scroll_right(v, pg, b, pos, progress);
      else
        return draw_scroll_left(v, pg, b, pos, progress);
    case transition_scroll_right:
      if (state == BACKWARD || state == ROLLBACK_BACKWARD)
        return draw_scroll_left(v, pg, b, pos, progress);
      else
        return draw_scroll_right(v, pg, b, pos, progress);
    default: assert(false); break;
    }

    return false;
  }

  bool effect_animator::draw_blend(view &v, graphics *pg, element *b, point pos,
                                   float progress) {
    byte opacity_f = byte(progress * 255.f);
    byte opacity_i = byte(255) - opacity_f;
    pg->draw(initial, pos + area_off, opacity_i);
    pg->draw(final, pos + area_off, opacity_f);
    return true;
  }
  bool effect_animator::draw_blend_atop(view &v, graphics *pg, element *b,
                                        point pos, float progress) {
    byte opacity_f = byte(progress * 255.f);
    // byte opacity_i = byte(255)-opacity_f;
    pg->draw(initial, pos + area_off, 255);
    pg->draw(final, pos + area_off, opacity_f);
    return true;
  }
  bool effect_animator::draw_slide_top(view &v, graphics *pg, element *b,
                                       point pos, float progress) {
    float   y = (1.0f - progress) * area_dim.y;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(initial, pos + area_off, byte((1.f - progress) * 255));
    pointf dst(0.f, y);
    dst += pos + area_off;
    pg->draw(final, dst);
    return true;
  }
  bool effect_animator::draw_slide_bottom(view &v, graphics *pg, element *b,
                                          point pos, float progress) {
    float   y = (1.0f - progress) * area_dim.y;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(initial, pos + area_off, byte((1.f - progress) * 255));
    pointf dst(0.f, -y);
    dst += pos + area_off;
    pg->draw(final, dst);
    return true;
  }
  bool effect_animator::draw_slide_left(view &v, graphics *pg, element *b,
                                        point pos, float progress) {
    float   x = (1.0f - progress) * area_dim.x;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(initial, pos + area_off, byte((1.f - progress) * 255));
    pointf dst(x, 0.f);
    dst += pos + area_off;
    pg->draw(final, dst);
    return true;
  }
  bool effect_animator::draw_slide_right(view &v, graphics *pg, element *b,
                                         point pos, float progress) {
    float   x = (1.0f - progress) * area_dim.x;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(initial, pos + area_off, byte((1.f - progress) * 255));
    pointf dst(-x, 0.f);
    dst += pos + area_off;
    pg->draw(final, dst);
    return true;
  }

  bool effect_animator::draw_slide_over_top(view &v, graphics *pg, element *b,
                                            point pos, float progress) {
    float   y = (1.0f - progress) * area_dim.y;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(initial, pos + area_off /*,byte((1.f-progress)*255)*/);
    pointf dst(0.f, y);
    dst += pos + area_off;
    pg->draw(final, dst);
    return true;
  }
  bool effect_animator::draw_slide_over_bottom(view &v, graphics *pg,
                                               element *b, point pos,
                                               float progress) {
    float   y = (1.0f - progress) * area_dim.y;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(initial, pos + area_off /*,byte((1.f-progress)*255)*/);
    pointf dst(0.f, -y);
    dst += pos + area_off;
    pg->draw(final, dst);
    return true;
  }
  bool effect_animator::draw_slide_over_left(view &v, graphics *pg, element *b,
                                             point pos, float progress) {
    float   x = (1.0f - progress) * area_dim.x;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(initial, pos + area_off /*,byte((1.f-progress)*255)*/);
    pointf dst(x, 0.f);
    dst += pos + area_off;
    pg->draw(final, dst);
    return true;
  }
  bool effect_animator::draw_slide_over_right(view &v, graphics *pg, element *b,
                                              point pos, float progress) {
    float   x = (1.0f - progress) * area_dim.x;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(initial, pos + area_off /*,byte((1.f-progress)*255)*/);
    pointf dst(-x, 0.f);
    dst += pos + area_off;
    pg->draw(final, dst);
    return true;
  }

//////
  bool effect_animator::draw_remove_top(view &v, graphics *pg, element *b,
    point pos, float progress) {
    float   y = -progress * area_dim.y;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(final, pos + area_off /*,byte((1.f-progress)*255)*/);
    pointf dst(0.f, y);
    dst += pos + area_off;
    pg->draw(initial, dst);
    return true;
  }
  bool effect_animator::draw_remove_bottom(view &v, graphics *pg,
    element *b, point pos,
    float progress) {
    float   y = -progress * area_dim.y;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(final, pos + area_off /*,byte((1.f-progress)*255)*/);
    pointf dst(0.f, -y);
    dst += pos + area_off;
    pg->draw(initial, dst);
    return true;
  }
  bool effect_animator::draw_remove_left(view &v, graphics *pg, element *b,
    point pos, float progress) {
    float   x = -progress * area_dim.x;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(final, pos + area_off /*,byte((1.f-progress)*255)*/);
    pointf dst(x, 0.f);
    dst += pos + area_off;
    pg->draw(initial, dst);
    return true;
  }
  bool effect_animator::draw_remove_right(view &v, graphics *pg, element *b,
    point pos, float progress) {
    float   x = -progress * area_dim.x;
    clipper _c(pg, rect(pos, area_dim));
    pg->draw(final, pos + area_off /*,byte((1.f-progress)*255)*/);
    pointf dst(-x, 0.f);
    dst += pos + area_off;
    pg->draw(initial, dst);
    return true;
  }

//////

  bool effect_animator::draw_scroll_top(view &v, graphics *pg, element *b,
                                        point pos, float progress) {
    float   y = (1.0f - progress) * area_dim.y;
    clipper _c(pg, rect(pos, area_dim));
    pointf  dst(0.f, y);
    pointf  src(0.f, y - area_dim.y);
    src += pos + area_off;
    dst += pos + area_off;
    pg->draw(initial, src);
    pg->draw(final, dst);
    return true;
  }
  bool effect_animator::draw_scroll_bottom(view &v, graphics *pg, element *b,
                                           point pos, float progress) {
    float   y = (1.0f - progress) * area_dim.y;
    clipper _c(pg, rect(pos, area_dim));
    pointf  dst(0.f, -y);
    pointf  src(0.f, area_dim.y - y);
    src += pos + area_off;
    dst += pos + area_off;
    pg->draw(initial, src);
    pg->draw(final, dst);
    return true;
  }
  bool effect_animator::draw_scroll_left(view &v, graphics *pg, element *b,
                                         point pos, float progress) {
    float   x = (1.0f - progress) * area_dim.x;
    clipper _c(pg, rect(pos, area_dim));
    pointf  dst(x, 0.f);
    pointf  src(x - area_dim.x, 0.f);
    src += pos + area_off;
    dst += pos + area_off;
    pg->draw(initial, src);
    pg->draw(final, dst);
    return true;
  }
  bool effect_animator::draw_scroll_right(view &v, graphics *pg, element *b,
                                          point pos, float progress) {
    float   x = (1.0f - progress) * area_dim.x;
    clipper _c(pg, rect(pos, area_dim));
    pointf  dst(-x, 0.f);
    pointf  src(area_dim.x - x, 0.f);
    src += pos + area_off;
    dst += pos + area_off;
    pg->draw(initial, src);
    pg->draw(final, dst);
    return true;
  }

  bool effect_animator_worker::prepare_initial(view& v, element * /*el*/) {
    //v.commit_update();
    return true;
  }

  bool effect_animator_worker::prepare_final(view &v, element *el) {
    size dim = el->ldata->dim;
    if (state_changer(v, el)) {
      el->reset_styles(v);
#if 0
      el->exec_assigned(v);
#endif
      el->resolve_styles(v);
      el->check_layout(v);
      el->ldata->dim = dim;
      //el->commit_measure(v);
      v.commit_update();
      return true;
    }
    return false;
  }

} // namespace html
