#ifndef __html_actions_stack_h__
#define __html_actions_stack_h__

#include "html-behavior.h"
#include "html-dom.h"

namespace html {

  extern bool is_collapsible_space(wchar c);
  extern bool is_non_collapsible_space(wchar c);

  namespace behavior {

    struct editing_ctx {
      virtual element *root()                                               = 0;
      virtual element *root_at(view &v, bookmark bm)                        = 0;
      virtual element *root_at(view &v, element *el)                        = 0;
      virtual bool     select(view &v, bookmark c, bookmark a = bookmark()) = 0;
      virtual bool     advance(view &v, bookmark &bm, ADVANCE_DIR cmd,
                               point vpt = point()) {
        return root()->advance(v, bm, cmd, vpt);
      }
      virtual bookmark get_caret()  = 0;
      virtual bookmark get_anchor() = 0;
      virtual void     node_expand(node *n, int at, int nitems) {}
      virtual void     node_shrink(node *n, int at, int nitems) {}
    };


    /*struct range {
      bookmark start;
      bookmark end;
      range( bookmark bm1,bookmark bm2 );

      helement isolate(view& v, element* self); // returns
      bool     apply_span(view& v, element* self, tag::symbol_t t, const
    attribute_bag& atts = attribute_bag());
    };*/

    struct insert_text;
    struct action;

    struct atomic_action : resource {
      handle<atomic_action> prev;

      virtual void undo(view &v, editing_ctx *ectx) = 0;
      virtual void redo(view &v, editing_ctx *ectx) = 0;

      virtual bool is_insert_text() const { return false; }
      virtual bool is_remove_char_forward() const { return false; }
      virtual bool is_remove_char_backward() const { return false; }
    };

    typedef handle<atomic_action> h_atomic_action;

    struct split_node : public atomic_action {
      int   pos;
      hnode n;

      static node *exec(view &v, editing_ctx *ectx, action *group, hnode pn,
                        int pos, bool force = false); // returns new node
      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);
    };

    struct wrap_nodes : public atomic_action {
      int      start;
      int      end;
      helement base;
      helement wrapper;

      static element *
                      exec(view &v, editing_ctx *ectx, action *group, helement el, int start,
                           int end, tag::symbol_t t,
                           const attribute_bag &atts); // returns new element created
      static element *exec(view &v, editing_ctx *ectx, action *group,
                           helement el, int start, int end,
                           element *wrapper); // returns new element created
      virtual void    undo(view &v, editing_ctx *ectx);
      virtual void    redo(view &v, editing_ctx *ectx);
    };

    struct unwrap_element : public atomic_action {
      int          pos;
      helement     pel;
      helement     el;
      array<hnode> nodes;

      static pair<bookmark, bookmark> exec(view &v, editing_ctx *ectx,
                                           action *group, helement el);
      virtual void                    undo(view &v, editing_ctx *ectx);
      virtual void                    redo(view &v, editing_ctx *ectx);
    };

    struct delete_text_range : public atomic_action {
      handle<text>    n;
      array<wchar>    chars;
      int             start;
      int             end;
      int_v           nbsp_replacement_pos;
      static bookmark exec(view &v, editing_ctx *ectx, action *group, text *te,
                           int start, int end = -1);
      virtual void    undo(view &v, editing_ctx *ectx);
      virtual void    redo(view &v, editing_ctx *ectx);
    };

    struct delete_nodes_range : public atomic_action {
      handle<element> el;
      array<hnode>    nodes;
      int             start;
      int             end;
      static bookmark exec(view &v, editing_ctx *ectx, action *group,
                           element *pel, int start, int end);
      virtual void    undo(view &v, editing_ctx *ectx);
      virtual void    redo(view &v, editing_ctx *ectx);
    };

    struct delete_node : public atomic_action {
      hnode    n;
      helement parent;
      int      pos;
      int_v    glued_at;
      delete_node() : pos(0) {}
      static bookmark exec(view &v, editing_ctx *ectx, action *group, node *pn);
      virtual void    undo(view &v, editing_ctx *ectx);
      virtual void    redo(view &v, editing_ctx *ectx);
    };

    struct insert_text : public atomic_action {
      int          pos;
      handle<text> n;
      array<wchar> chars;

      static bool exec(view &v, editing_ctx *ectx, action *group, bookmark &bm,
                       wchars chars); // returns new node
      bool        append(view &v, editing_ctx *ectx, action *group, bookmark &bm, wchars txt);

      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);

      virtual bool is_insert_text() const { return true; }
    };

    struct replace_text : public atomic_action {
      handle<text> n;
      array<wchar> chars;

      static bool exec(view &v, editing_ctx *ectx, action *group, text* pt,wchars chars); // returns new node

      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);
    };

    struct nbspify_text : public replace_text {
      typedef replace_text super;
      static bool exec(view &v, editing_ctx *ectx, action *group, text* pt); // returns new node
    };


    // replaces spaces by nbsp's
    /*struct normalize_text: public atomic_action
    {
       int          pos;
       handle<text> n;
       array<wchar> chars;

       static  bool  exec(view& v, editing_ctx *ectx, action* group, text* pt,
    int pos); // returns new node

       virtual void  undo(view& v, editing_ctx *ectx);
       virtual void  redo(view& v, editing_ctx *ectx);

    };*/

    struct insert_node : public atomic_action {
      handle<element> parent;
      int             pos;
      handle<node>    n;

      static bool exec(view &v, editing_ctx *ectx, action *group, element *p,
                       int idx, node *n);

      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);
    };

    struct insert_nodes : public atomic_action {
      handle<element>     parent;
      int                 pos;
      array<handle<node>> nodes;

      static insert_nodes *exec(view &v, editing_ctx *ectx, action *group,
                                element *p, int idx, slice<hnode> n);
      static insert_nodes *exec_postfactum(view &v, editing_ctx *ectx,
                                           action *group, element *p, int idx,
                                           slice<hnode> n);

      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);
    };

    struct remove_char_forward : public atomic_action {
      int          pos;
      handle<text> n;
      array<wchar> chars;
      bool         nbsp_injection;

      remove_char_forward() : pos(0), nbsp_injection(false) {}

      static bookmark exec(view &v, editing_ctx *ectx, action *group, text *pt,
                           int start, int end);
      bool append(view &v, editing_ctx *ectx, action *group, text *pt,
                      int start, int end, bookmark& bm);

      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);

      virtual bool is_remove_char_forward() const { return true; }

      virtual bool is_compatible(text *pt, int start, int end) const {
        return pt == n && (end - start) == 1 && pos == start && !nbsp_injection;
      }
    };

    struct remove_char_backward : public atomic_action {
      int          pos;
      handle<text> n;
      array<wchar> chars;
      bool         nbsp_injection;

      remove_char_backward() : pos(0), nbsp_injection(false) {}

      static bookmark exec(view &v, editing_ctx *ectx, action *group, text *pt,
                           int start, int end);
      bool append(view &v, editing_ctx *ectx, action *group, text *pt, int start, int end, bookmark& bm);

      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);

      virtual bool is_remove_char_backward() const { return true; }

      virtual bool is_compatible(text *pt, int start, int end) const {
        return pt == n && (end - start) == 1 && pos == end && !nbsp_injection;
      }
    };

    struct morph_element : public atomic_action {
      handle<element> el;
      tag::symbol_t   old_tag;
      tag::symbol_t   new_tag;

      static bool exec(view &v, editing_ctx *ectx, action *group, helement pel,
                       tag::symbol_t tag);

      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);
    };

    extern slice<hnode> insert_html_at(view &v, editing_ctx *ectx,
                                       action *group, bookmark &at /*in-out*/,
                                       const string &source_url, bytes html);
    extern bookmark     remove_range(view &v, editing_ctx *ectx, action *group, bookmark start, bookmark end, bool is_richtext, bool forward);

    struct change_attr : public atomic_action {
      handle<element> el;
      string          name;
      ustring         new_val, old_val;
      bool            new_val_exist, old_val_exist;

      static bool set(view &v, editing_ctx *ectx, action *group, helement pel,
                      const string &name, const ustring &val);
      static bool del(view &v, editing_ctx *ectx, action *group, helement pel,
                      const string &name);

      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);
    };

    struct attributes_changed : public atomic_action {
      handle<element> el;

      attribute_bag old_atts;
      attribute_bag new_atts;

      static void record(view &v, editing_ctx *ectx, action *group,
                         helement pel, const attribute_bag &oa,
                         const attribute_bag &na);

      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);
    };

    struct node_deleted : public atomic_action {
      hnode    n;
      helement parent;
      int      pos;
      node_deleted() : pos(0) {}
      static void  record(view &v, editing_ctx *ectx, action *group, node *pn,
                          int index);
      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);
    };

    struct node_added : public atomic_action {
      hnode    n;
      helement parent;
      int      pos;
      node_added() : pos(0) {}
      static void  record(view &v, editing_ctx *ectx, action *group, node *pn,
                          int index);
      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);
    };
    struct node_replaced : public atomic_action {
      hnode    nn;
      hnode    on;
      helement parent;
      int      pos;
      node_replaced() : pos(0) {}
      static void  record(view &v, editing_ctx *ectx, action *group, node *on,
                          node *nn, int index);
      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);
    };

    struct action : resource {
      handle<atomic_action> chain;
      ustring               caption;
      bookmark_p            caret_before;
      bookmark_p            caret_after;

      uint_v change_reason;

      virtual void undo(view &v, editing_ctx *ectx);
      virtual void redo(view &v, editing_ctx *ectx);

      virtual bool is_placeholder_action() const { return false; }

      action(editing_ctx *ectx, const ustring &c);
      virtual ~action() { /*delete chain;*/
      }
      virtual void close(editing_ctx *ectx);

      template <class AA> AA *add(AA *atomic_action) {
        atomic_action->prev = chain;
        chain               = atomic_action;
        return atomic_action;
      }

    private:
      action();
      action &operator=(const action &);
    };

    struct placeholder_action : public action {
      virtual bool is_placeholder_action() const { return true; }

      placeholder_action(editing_ctx *ectx) : action(ectx, ustring()) {}

      node *placeholder() const;
    };

    struct range_action : public action {
      typedef action super;

      bookmark_p anchor_before;
      bookmark_p anchor_after;

      range_action(editing_ctx *ectx, const ustring &c);
      virtual ~range_action() {}
      virtual void close(editing_ctx *ectx);

      virtual void undo(view &v, editing_ctx *ectx) override;
      virtual void redo(view &v, editing_ctx *ectx) override;

    private:
      range_action();
      range_action &operator=(const range_action &);
    };

    bool do_apply_list(view &v, editing_ctx *ectx, action *act, bookmark start,
                       bookmark end, tag::symbol_t t,
                       const attribute_bag &atts);
    bool do_remove_list(view &v, editing_ctx *ectx, action *act, bookmark start,
                        bookmark end, tag::symbol_t t,
                        const attribute_bag &atts);
    bool wrap_into(view &v, editing_ctx *ectx, range_action *ra,
                   bookmark &start, bookmark &end, element *el);

  } // namespace behavior
} // namespace html

#endif