#include "gool.h"

namespace gool {

/*  int scrollbar_width() { return GetSystemMetrics(SM_CXVSCROLL); }
  int scrollbar_height() { return GetSystemMetrics(SM_CYHSCROLL); }
  int small_icon_width() {
    return GetSystemMetrics(SM_CXSMICON) + GetSystemMetrics(SM_CXEDGE) * 2;
  }
  int small_icon_height() {
    return GetSystemMetrics(SM_CYSMICON) + GetSystemMetrics(SM_CYEDGE) * 2;
  }
  int border_width() { return 1; }
  int border_3d_width() { return 2; }
*/

  struct _resolution_provider : public resolution_provider {
    size _pixels_per_inch;

    _resolution_provider() : _pixels_per_inch(0) {}

    void reset_resolution() {

      HDC h              = GetDC(0);
      _pixels_per_inch.x = GetDeviceCaps(h, LOGPIXELSX);
      _pixels_per_inch.y = GetDeviceCaps(h, LOGPIXELSY);
      ReleaseDC(0, h);

      if (!_pixels_per_inch.x) _pixels_per_inch = size(96, 96);
    }

    size pixels_per_inch() {
      if (!_pixels_per_inch.x) reset_resolution();
      return _pixels_per_inch;
    }

    void pixels_per_inch(size sz) {
      assert(false); // not used in default provider
      _pixels_per_inch = sz;
    }
  };

  resolution_provider &resolution_provider::desktop() {
    static _resolution_provider provider;
    return provider;
  }

  bool is_sys_color(color cs) {
    if ((0xFF000000 & cs) != 0xFF000000) return false;
    uint idx = cs & 0xFF;
    if (idx > 0x30) return false;
    return true;
  }

  color xcolor(SYSTEM_COLORS cs) {
    // uint idx = cs & 0xFF;

    // if( idx > 0x30 )
    //  return cs;

    switch (cs) {
    case SC_WINDOW: return GetSysColor(COLOR_WINDOW);
    case SC_WINDOW_TEXT: return GetSysColor(COLOR_WINDOWTEXT);
    case SC_DIALOG_BRIGHT: return GetSysColor(COLOR_3DHILIGHT);
    case SC_DIALOG_LIGHT: return GetSysColor(COLOR_3DLIGHT);
    case SC_DIALOG_SURFACE: return GetSysColor(COLOR_3DFACE);
    case SC_DIALOG_SHADOW: return GetSysColor(COLOR_3DSHADOW);
    case SC_DIALOG_DKSHADOW: return GetSysColor(COLOR_3DDKSHADOW);
    case SC_ACCENT: return GetSysColor(COLOR_HIGHLIGHT);
    case SC_ACCENT_TEXT: return GetSysColor(COLOR_HIGHLIGHTTEXT);
    case SC_SELECTION: return GetSysColor(COLOR_HIGHLIGHT);
    case SC_SELECTION_TEXT: return GetSysColor(COLOR_HIGHLIGHTTEXT);
    case SC_MENU_SELECTION: return GetSysColor(COLOR_3DFACE);
    case SC_MENU_SELECTION_TEXT: return GetSysColor(COLOR_BTNTEXT);
    case SC_WORKSPACE: return GetSysColor(COLOR_APPWORKSPACE);
    case SC_CAPTION: return GetSysColor(COLOR_GRADIENTINACTIVECAPTION);
    case SC_CAPTION_TEXT: return GetSysColor(COLOR_INACTIVECAPTIONTEXT);
    case SC_ACTIVE_CAPTION: return GetSysColor(COLOR_ACTIVECAPTION);
    case SC_ACTIVE_CAPTION_TEXT: return GetSysColor(COLOR_CAPTIONTEXT);
    case SC_INFO: return GetSysColor(COLOR_INFOBK);
    case SC_INFO_TEXT: return GetSysColor(COLOR_INFOTEXT);
    case SC_DIALOG_TEXT: return GetSysColor(COLOR_BTNTEXT);
    case SC_SCROLLBAR: return mcolor(GetSysColor(COLOR_3DHILIGHT), GetSysColor(COLOR_3DFACE));
    case SC_DESKTOP: return GetSysColor(COLOR_DESKTOP);
    case SC_GRAY_TEXT: return GetSysColor(COLOR_GRAYTEXT);
    case SC_WINDOW_BORDER: return GetSysColor(COLOR_WINDOWFRAME);
    case SC_BORDER: return GetSysColor(COLOR_3DSHADOW);
    case SC_DIALOG_LIGHTSHADOW: return mcolor(GetSysColor(COLOR_3DLIGHT), GetSysColor(COLOR_3DFACE));
    }
    return cs;
  }

  bool install_font(const string &name, tool::bytes data) {
#ifndef UNDER_CE
    critical_section _(lock);

    static hash_table<string, bool> _installed;

    if (_installed.exists(name)) return true;

    DWORD  n = 0;
    HANDLE h =
        AddFontMemResourceEx((LPVOID)data.start, DWORD(data.length), 0, &n);
    if (h && n) {
      _installed[name] = true;
      return true;
    }
#endif
    return false;
  }

} // namespace gool
