#include "gool.h"
#include <math.h>

// perfect-hash table
#include "gool-color-names-ph.h"

namespace tool {
#if defined(SCITER) || defined(SCITERJS)
  ustring color_to_string(const value& val) {
    gool::color_v cv = val;
    return cv.to_string();
  }
}
#endif


namespace gool {
  using namespace tool;

  bool treat_px_as_dip = CSS_PX_LOGICAL_BY_DEFAULT;

  int resolution_provider::get_window_metrics(tool::value::length_special_values what)
  {
    assert(false);
    return 10;
  }

  argb _get_current_system_color(SYSTEM_COLORS sc) { return argb(xcolor(sc)); }

  get_current_system_color_t  get_current_system_color = &_get_current_system_color;

  namespace name {
    static tool::lookup_tbl<string, true> symtab;

    symbol_t symbol(const char *name) {
      critical_section cs(lock);
      return symtab[name] - 1;
    }

    symbol_t symbol(chars name) {
      critical_section cs(lock);
      assert(name.start[name.length] == 0); // it has to be zstring
      return symtab[name.start] - 1;
    }

    symbol_t symbol(const tool::string &name) {
      critical_section cs(lock);
      return symtab[name] - 1;
    }
    string symbol_name(symbol_t sym) {
      critical_section cs(lock);
      uint             n = sym + 1;
      if (n > symtab.size()) n = 1;
      return symtab(n);
    }
  } // namespace attr


  color mcolor(color c1, color c2);
  color mcolor(color_v c1, color_v c2);

  static bool is_sys_color(uint cs) {
    if ((0xFF000000 & cs) != 0xFF000000) return false;
    uint idx = cs & 0xFF;
    if (idx > 0x30) return false;
    return true;
  }

  bool find_named_color(tool::chars name, color_v &cv) {
#ifdef _DEBUG
    if (name == CHARS("transparent")) 
      name = name;
#endif

    const color_def *pcd = color_names::find_def(name.start, uint(name.length));
    if (pcd) {
      if (is_sys_color(pcd->value))
        cv = color_v(SYSTEM_COLORS(pcd->value));
      else
        cv = color_v(color(pcd->value));
      return true;
    }
    return false;
  }

  argb color_v::to_argb() const 
  {
    switch (_type()) {
      case SYST: 
        /*if (_syst() == CURRENT_COLOR) {
          color_v t;
          if (pr && pr->resolve_current_color(t)) 
            return t.to_argb(pr);
        }*/
        return _syst() == NO_COLOR ? argb::no_color_white() : argb(SYSTEM_COLORS(0xFF000000 | _syst()));
      case RGBT: return argb(_color());
      default: 
        assert(false);
        return argb::no_color();
    }
  }
  rgb color_v::to_rgb() const {
    return to_argb();
  }
  
#pragma warning(push)
#pragma warning(disable:4706) // assignment within conditional expression


#pragma warning(pop)        

  color_v parse_color(tool::chars ss) {
    color_v c;
    if (ss.length == 0) return c;
    if (ss[0] == '#') {
      ss.prune(1);
      uint R = 0, G = 0, B = 0, T = 255;
      switch (ss.length) {
#ifdef WINDOWS
      case 3:
        sscanf_s(ss.start, "%1x%1x%1x", &R, &G, &B);
        R = R << 4 | R;
        G = G << 4 | G;
        B = B << 4 | B;
        break;
      case 4:
        sscanf_s(ss.start, "%1x%1x%1x%1x", &R, &G, &B, &T);
        R = R << 4 | R;
        G = G << 4 | G;
        B = B << 4 | B;
        T = T << 4 | T;
        break;
      case 6: 
        sscanf_s(ss.start, "%2x%2x%2x", &R, &G, &B); 
        break;
      case 8: 
        sscanf_s(ss.start, "%2x%2x%2x%2x", &R, &G, &B, &T); 
        break;
#else
      case 3:
        sscanf(ss.start, "%1x%1x%1x", &R, &G, &B);
        R = R << 4 | R;
        G = G << 4 | G;
        B = B << 4 | B;
        break;
      case 4:
        sscanf(ss.start, "%1x%1x%1x%1x", &R, &G, &B, &T);
        R = R << 4 | R;
        G = G << 4 | G;
        B = B << 4 | B;
        T = T << 4 | T;
        break;
      case 6: sscanf(ss.start, "%2x%2x%2x", &R, &G, &B); break;
      case 8: sscanf(ss.start, "%2x%2x%2x%2x", &R, &G, &B, &T); break;
#endif
      default: return c;
      }
      return color_v(((255 - T) << 24) | (B << 16) | (G << 8) | R);
      /*

      int R = 0, G = 0, B = 0;
      if(ss.length == 4)
      {
        sscanf( ss.start+1 ,"%1x%1x%1x",&R,&G,&B);
        R = R << 4 | R; G = G << 4 | G; B = B << 4 | B;
      }
      else
        sscanf( ss.start+1,"%2x%2x%2x",&R,&G,&B);
      c = (B << 16) | (G << 8) | R;//RGB( R, G, B );
      return c;
      */
    } else if (tool::is_like(ss, "rgba(*,*,*,*)")) {
      ss.start += 5;
      ss.length -= 6;
      int                ca[4] = {0};
      tool::chars        t;
      tool::tokens<char> ts(ss, CHARS(","));
      for (int n = 0; n < 3; ++n) {
        if (!ts.next(t)) return c;
        ca[n] = tool::to_uint(t);
        if (t.starts_with(CHARS("%"))) ca[n] = (ca[n] * 255) / 100;
      }
      if (!ts.next(t)) return c;

      float opacity = str_to_f(t, 1.0f);
      if (t.starts_with(CHARS("%")))
        ca[3] = int((opacity * 255) / 100);
      else
        ca[3] = int(255 * opacity);

      argb lc;
      lc.red   = argb::channel_t(limit(ca[0], 0, 255));
      lc.green = argb::channel_t(limit(ca[1], 0, 255));
      lc.blue  = argb::channel_t(limit(ca[2], 0, 255));
      lc.alfa  = argb::channel_t(limit(ca[3], 0, 255));
      return color_v(lc);
    } /*else if (tool::is_like(ss, "rgba(*,*)")) {
      ss.start += 5;
      ss.length -= 6;
      chars color_name = ss.chop(',');

      float opacity = str_to_f(ss, 1.0f);
      if (ss.length && ss[0] == '%') opacity = opacity / 100.f;

      if (find_named_color(color_name, c)) {
        argb tc = c;
        tc.alfa = (argb::channel_t)limit(uint(255 * opacity), 0u, 255u);
        return color_v(tc);
      }
      return c;
    }*/ else if (tool::is_like(ss, "rgb(*,*,*)")) {
      ss.start += 4;
      ss.length -= 5;
      int                ca[3] = {0};
      tool::chars        t;
      tool::tokens<char> ts(ss, CHARS(","));
      for (int n = 0; n < 3; ++n) {
        if (!ts.next(t)) return c;
        ca[n] = tool::to_uint(t);
        if (t.index_of('%') == 0) ca[n] = (ca[n] * 255) / 100;
      }
      argb lc;
      lc.red   = argb::channel_t(limit(ca[0], 0, 255));
      lc.green = argb::channel_t(limit(ca[1], 0, 255));
      lc.blue  = argb::channel_t(limit(ca[2], 0, 255));
      lc.alfa  = 255;
      return color_v(lc);
    } else if (tool::is_like(ss, "hsl(*,*,*)")) {
      ss.start += 4;
      ss.length -= 5;
      int                ca[3] = {0};
      tool::chars        t;
      tool::tokens<char> ts(ss, CHARS(","));
      for (int n = 0; n < 3; ++n) {
        if (!ts.next(t)) return c;
        ca[n] = tool::to_uint(t);
      }
      hsl z(float(tool::limit(ca[0], 0, 360)),
            tool::limit(ca[1], 0, 100) / 100.0f,
            tool::limit(ca[2], 0, 100) / 100.0f);
      return color_v((color)rgb(z));
    } else if (tool::is_like(ss, "hsv(*,*,*)")) {
      ss.start += 4;
      ss.length -= 5;
      int                ca[3] = {0};
      tool::chars        t;
      tool::tokens<char> ts(ss, CHARS(","));
      for (int n = 0; n < 3; ++n) {
        if (!ts.next(t)) return c;
        ca[n] = tool::to_uint(t);
      }
      hsv z(float(tool::limit(ca[0], 0, 360)),
            tool::limit(ca[1], 0, 100) / 100.0f,
            tool::limit(ca[2], 0, 100) / 100.0f);
      return color_v((color)rgb(z));
    }
    find_named_color(ss, c);
    return c;
  }

  rgb::rgb(cmyk z) { z.get_rgb(*this); }

#define v256(a) byte(a * 255)

  void hsv::get(byte &red, byte &green, byte &blue) {
    int   i;
    float f, p, q, t, hTemp;

    if (s == 0.0f /*|| h == -1.0f*/) // s==0? Totally unsaturated = grey so R,G
                                     // and B all equal value
    {
      red = green = blue = v256(v);
      return;
    }

    h -= floorf(h / 360.0f) * 360.0f;

    hTemp = h / 60.0f;
    i     = (int)floorf(hTemp); // which sector
    f     = hTemp - i;          // how far through sector
    p     = v * (1 - s);
    q     = v * (1 - s * f);
    t     = v * (1 - s * (1 - f));

    switch (i) {
    case 0: {
      red   = v256(v);
      green = v256(t);
      blue  = v256(p);
      break;
    }
    case 1: {
      red   = v256(q);
      green = v256(v);
      blue  = v256(p);
      break;
    }
    case 2: {
      red   = v256(p);
      green = v256(v);
      blue  = v256(t);
      break;
    }
    case 3: {
      red   = v256(p);
      green = v256(q);
      blue  = v256(v);
      break;
    }
    case 4: {
      red   = v256(t);
      green = v256(p);
      blue  = v256(v);
      break;
    }
    case 5: {
      red   = v256(v);
      green = v256(p);
      blue  = v256(q);
      break;
    }
    }
  }

  void hsv::set(byte red, byte green, byte blue) {
    float mn = float(red), mx = float(red);
    int   maxVal = 0;

    if (green > mx) {
      mx     = green;
      maxVal = 1;
    }
    if (blue > mx) {
      mx     = blue;
      maxVal = 2;
    }
    if (green < mn) mn = green;
    if (blue < mn) mn = blue;

    float delta = mx - mn;

    v = mx / 256.0f;
    if (mx != 0.0f)
      s = delta / mx;
    else {
      s = 0.0f;
      h = 0.0f;
      return;
    }
    if (s == 0.0f) {
      h = 0;
      return;
    } else {
      switch (maxVal) {
      case 0: {
        h = (green - blue) / delta;
        break;
      } // yel < h < mag
      case 1: {
        h = 2 + (blue - red) / delta;
        break;
      } // cyan < h < yel
      case 2: {
        h = 4 + (red - green) / delta;
        break;
      } // mag < h < cyan
      }
    }
    h *= 60;
    if (h < 0) h += 360;
  }

  static rgb HSL2RGB(double h, double s, double l) {
    double v;
    double r = 0, g = 0, b = 0;
    h = h / 360.0;
    assert(h >= 0 && h < 1);
    v = (l <= 0.5) ? (l * (1.0 + s)) : (l + s - l * s);
    if (v > 0) {
      double m;
      double sv;
      int    sextant;
      double fract, vsf, mid1, mid2;
      m  = l + l - v;
      sv = (v - m) / v;
      h *= 6.0;
      sextant = (int)h;
      fract   = h - sextant;
      vsf     = v * sv * fract;
      mid1    = m + vsf;
      mid2    = v - vsf;
      switch (sextant) {
      case 0:
        r = v;
        g = mid1;
        b = m;
        break;
      case 1:
        r = mid2;
        g = v;
        b = m;
        break;
      case 2:
        r = m;
        g = v;
        b = mid1;
        break;
      case 3:
        r = m;
        g = mid2;
        b = v;
        break;
      case 4:
        r = mid1;
        g = m;
        b = v;
        break;
      case 5:
        r = v;
        g = m;
        b = mid2;
        break;
      }
    }
    return rgb(byte(r * 255.0), byte(g * 255.0), byte(b * 255.0));
  }

  rgb::rgb(hsl z) { *this = HSL2RGB(z.h, z.s, z.l); }

  hsl::hsl(const argb &z) : hsl(rgb(z)) {}

  hsl::hsl(const rgb &z) {
    float mn = z.red, mx = z.red;
    int   maxVal = 0;

    if (z.green > mx) {
      mx     = z.green;
      maxVal = 1;
    }
    if (z.blue > mx) {
      mx     = z.blue;
      maxVal = 2;
    }
    if (z.green < mn) mn = z.green;
    if (z.blue < mn) mn = z.blue;

    int il = int((mx + mn) / 2);

    if (mx == mn) {
      l = il / 255.0f;
      s = 0;
      h = 0;
      return;
    }

    float delta = mx - mn;
    if (il < 128)
      s = delta / float(mx + mn);
    else
      s = delta / float(512 - mx - mn);

    switch (maxVal) {
    case 0: {
      h = (z.green - z.blue) / delta;
      break;
    } // yel < h < mag
    case 1: {
      h = 2 + (z.blue - z.red) / delta;
      break;
    } // cyan < h < yel
    case 2: {
      h = 4 + (z.red - z.green) / delta;
      break;
    } // mag < h < cyan
    }
    h *= 60;
    if (h < 0) h += 360;
    l = float(il) / 255.0f;
  }

  void gradient_brush::generate_stops(argb c1, argb c2, float profile) {
    int start_gradient = 128 - int(profile * 128.0f);
    int end_gradient   = 128 + int(profile * 127.0f);
    if (end_gradient <= start_gradient) end_gradient = start_gradient + 1;
    float k = 1.0f / float(end_gradient - start_gradient);
    int   i;
    for (i = 0; i < start_gradient; i++)
      add_stop(float(i) / 255.0f, c1);
    for (; i < end_gradient; i++)
      add_stop(float(i) / 255.0f,
               c1.gradient(c2, float(i - start_gradient) * k));
    for (; i < 256; i++)
      add_stop(float(i) / 255.0f, c2);
  }

} // namespace gool
